/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Map;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableNetwork;
import org.mandas.docker.client.messages.Ipam;

@JsonDeserialize(builder=ImmutableNetwork.Builder.class)
@Value.Immutable
@Value.Enclosing
public interface Network {
    @JsonProperty(value="Name")
    public String name();

    @JsonProperty(value="Id")
    public String id();

    @JsonProperty(value="Scope")
    public String scope();

    @JsonProperty(value="Driver")
    public String driver();

    @JsonProperty(value="IPAM")
    public Ipam ipam();

    @JsonProperty(value="Containers")
    @Nullable
    public Map<String, Container> containers();

    @JsonProperty(value="Options")
    @Nullable
    public Map<String, String> options();

    @JsonProperty(value="Internal")
    @Nullable
    public Boolean internal();

    @JsonProperty(value="EnableIPv6")
    @Nullable
    public Boolean enableIPv6();

    @JsonProperty(value="Labels")
    @Nullable
    public Map<String, String> labels();

    @JsonProperty(value="Attachable")
    @Nullable
    public Boolean attachable();

    @JsonDeserialize(builder=ImmutableNetwork.Container.Builder.class)
    @Value.Immutable
    public static interface Container {
        @JsonProperty(value="Name")
        @Nullable
        public String name();

        @JsonProperty(value="EndpointID")
        public String endpointId();

        @JsonProperty(value="MacAddress")
        public String macAddress();

        @JsonProperty(value="IPv4Address")
        public String ipv4Address();

        @JsonProperty(value="IPv6Address")
        public String ipv6Address();
    }

    public static enum Type {
        BUILTIN("builtin"),
        CUSTOM("custom");

        private final String name;

        @JsonCreator
        private Type(String name) {
            this.name = name;
        }

        @JsonValue
        public String getName() {
            return this.name;
        }
    }
}

