/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages.swarm;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Objects;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.swarm.IpamConfig;

final class ImmutableIpamConfig
implements IpamConfig {
    private final String subnet;
    @Nullable
    private final String range;
    private final String gateway;

    private ImmutableIpamConfig(String subnet, @Nullable String range, String gateway) {
        this.subnet = subnet;
        this.range = range;
        this.gateway = gateway;
    }

    @Override
    @JsonProperty(value="Subnet")
    public String subnet() {
        return this.subnet;
    }

    @Override
    @JsonProperty(value="Range")
    @Nullable
    public String range() {
        return this.range;
    }

    @Override
    @JsonProperty(value="Gateway")
    public String gateway() {
        return this.gateway;
    }

    public final ImmutableIpamConfig withSubnet(String value) {
        String newValue = Objects.requireNonNull(value, "subnet");
        if (this.subnet.equals(newValue)) {
            return this;
        }
        return new ImmutableIpamConfig(newValue, this.range, this.gateway);
    }

    public final ImmutableIpamConfig withRange(@Nullable String value) {
        if (Objects.equals(this.range, value)) {
            return this;
        }
        return new ImmutableIpamConfig(this.subnet, value, this.gateway);
    }

    public final ImmutableIpamConfig withGateway(String value) {
        String newValue = Objects.requireNonNull(value, "gateway");
        if (this.gateway.equals(newValue)) {
            return this;
        }
        return new ImmutableIpamConfig(this.subnet, this.range, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableIpamConfig && this.equalTo((ImmutableIpamConfig)another);
    }

    private boolean equalTo(ImmutableIpamConfig another) {
        return this.subnet.equals(another.subnet) && Objects.equals(this.range, another.range) && this.gateway.equals(another.gateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.subnet.hashCode();
        h += (h << 5) + Objects.hashCode(this.range);
        h += (h << 5) + this.gateway.hashCode();
        return h;
    }

    public String toString() {
        return "IpamConfig{subnet=" + this.subnet + ", range=" + this.range + ", gateway=" + this.gateway + "}";
    }

    public static ImmutableIpamConfig copyOf(IpamConfig instance) {
        if (instance instanceof ImmutableIpamConfig) {
            return (ImmutableIpamConfig)instance;
        }
        return ImmutableIpamConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private static final long INIT_BIT_SUBNET = 1L;
        private static final long INIT_BIT_GATEWAY = 2L;
        private long initBits = 3L;
        private String subnet;
        private String range;
        private String gateway;

        private Builder() {
        }

        public final Builder from(IpamConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.subnet(instance.subnet());
            String rangeValue = instance.range();
            if (rangeValue != null) {
                this.range(rangeValue);
            }
            this.gateway(instance.gateway());
            return this;
        }

        @JsonProperty(value="Subnet")
        public final Builder subnet(String subnet) {
            this.subnet = Objects.requireNonNull(subnet, "subnet");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="Range")
        public final Builder range(@Nullable String range) {
            this.range = range;
            return this;
        }

        @JsonProperty(value="Gateway")
        public final Builder gateway(String gateway) {
            this.gateway = Objects.requireNonNull(gateway, "gateway");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableIpamConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableIpamConfig(this.subnet, this.range, this.gateway);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("subnet");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("gateway");
            }
            return "Cannot build IpamConfig, some of required attributes are not set " + attributes;
        }
    }
}

