/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.adapters.InsertionAdapter;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.Messages;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ModelSubclassSelectionDialog;
import org.eclipse.bpmn2.modeler.core.merrimac.dialogs.ObjectEditingDialog;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.graphiti.ui.editor.DiagramEditor;
import org.eclipse.osgi.util.NLS;

public class FeatureEditingDialog
extends ObjectEditingDialog {
    protected EStructuralFeature feature;
    protected EObject newObject;
    protected boolean createNew = false;

    public FeatureEditingDialog(DiagramEditor editor, EObject object, EStructuralFeature feature, EObject value) {
        super(editor, object, (EClass)feature.getEType());
        this.feature = feature;
        this.newObject = value;
    }

    public FeatureEditingDialog(DiagramEditor editor, EObject object, EStructuralFeature feature) {
        super(editor, object, (EClass)feature.getEType());
        this.feature = feature;
        this.newObject = (EObject)object.eGet(feature);
    }

    @Override
    public void create() {
        InsertionAdapter.executeIfNeeded(this.newObject);
        this.startTransaction();
        if (this.newObject == null) {
            this.createNew = true;
            if (this.featureEType == null) {
                ModelSubclassSelectionDialog dialog = new ModelSubclassSelectionDialog(this.editor, this.object, this.feature);
                if (dialog.open() == 0) {
                    this.featureEType = (EClass)dialog.getResult()[0];
                    this.newObject = this.createNewObject(this.object, this.feature, this.featureEType);
                } else {
                    this.cancel = true;
                }
            } else {
                this.newObject = this.createNewObject(this.object, this.feature, this.featureEType);
            }
        } else if (this.featureEType == null) {
            if (this.newObject instanceof EObject) {
                this.featureEType = this.newObject.eClass();
            } else if (this.feature.getEType() instanceof EClass) {
                this.featureEType = (EClass)this.feature.getEType();
            }
        }
        if (this.newObject == null) {
            this.cancel = true;
        }
        if (this.cancel) {
            this.rollbackTransaction();
        } else {
            super.create();
        }
    }

    protected EObject createNewObject(final EObject object, final EStructuralFeature feature, final EClass eclass) {
        final EObject[] result = new EObject[1];
        if (this.domain != null) {
            final Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)this.domain.getResourceSet());
            this.domain.getCommandStack().execute((Command)new RecordingCommand((TransactionalEditingDomain)this.domain){

                protected void doExecute() {
                    result[0] = Bpmn2ModelerFactory.createFeature(resource, object, feature, eclass);
                }
            });
        } else {
            Resource resource = ExtendedPropertiesAdapter.getResource((Notifier)object);
            result[0] = Bpmn2ModelerFactory.createFeature(resource, object, feature, eclass);
        }
        return result[0];
    }

    @Override
    protected String getPreferenceKey() {
        return String.valueOf(super.getPreferenceKey()) + "." + this.feature.getName();
    }

    @Override
    public String getTitle() {
        this.title = this.createNew ? NLS.bind((String)Messages.FeatureEditingDialog_Create, (Object)ExtendedPropertiesProvider.getLabel(this.newObject)) : NLS.bind((String)Messages.FeatureEditingDialog_Edit, (Object)ExtendedPropertiesProvider.getLabel(this.newObject));
        return this.title;
    }

    @Override
    public void aboutToOpen() {
        this.dialogContent.setData((Object)this.newObject);
    }

    @Override
    public int open() {
        int result = super.open();
        if (result != 0) {
            this.undoCreateNewObject();
        }
        return result;
    }

    private void undoCreateNewObject() {
        if (this.createNew && this.newObject != null) {
            ModelUtil.unsetID(this.newObject, this.object.eResource());
            if (this.domain != null && this.domain.getCommandStack().canUndo() && this.domain.getCommandStack().getUndoCommand().getAffectedObjects().contains(this.newObject)) {
                this.domain.getCommandStack().undo();
            } else {
                EcoreUtil.delete((EObject)this.newObject, (boolean)true);
            }
        }
        this.newObject = null;
    }

    @Override
    protected void cancelPressed() {
        super.cancelPressed();
        this.undoCreateNewObject();
    }

    public EObject getNewObject() {
        return this.newObject;
    }
}

