/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.debug.internal.ui.disassembly;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.cdt.core.IAddress;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.debug.internal.ui.CDebugUIUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AbstractDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.AddressRangePosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.DisassemblyUtils;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.ErrorPosition;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyBackend;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyDocument;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.IDisassemblyPartCallback;
import org.eclipse.cdt.debug.internal.ui.disassembly.dsf.LabelPosition;
import org.eclipse.cdt.debug.internal.ui.preferences.StringSetSerializer;
import org.eclipse.cdt.debug.ui.disassembly.rulers.IColumnSupport;
import org.eclipse.cdt.debug.ui.disassembly.rulers.IContributedRulerColumn;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnDescriptor;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnPreferenceAdapter;
import org.eclipse.cdt.debug.ui.disassembly.rulers.RulerColumnRegistry;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.AddressRulerColumn;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyColumnSupport;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyDropAdapter;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyImageRegistry;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyMessages;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblySelectionProvider;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.DisassemblyViewerConfiguration;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.EditionFinderJob;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.SourceColorerJob;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.SourcePosition;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AbstractDisassemblyAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.ActionGotoAddress;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.ActionGotoProgramCounter;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.ActionOpenPreferences;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.AddressBarContributionItem;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.JumpToAddressAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.actions.TextOperationAction;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.BreakpointsAnnotationModel;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.DisassemblyDocument;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.model.SourceFileInfo;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.presentation.DisassemblyIPAnnotation;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyAnnotationModel;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyRulerColumn;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.DisassemblyViewer;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.provisional.IDisassemblyPart;
import org.eclipse.cdt.dsf.debug.internal.ui.disassembly.util.HSL;
import org.eclipse.cdt.dsf.internal.ui.DsfUIPlugin;
import org.eclipse.cdt.internal.core.resources.ResourceLookup;
import org.eclipse.cdt.internal.ui.dnd.TextViewerDragAdapter;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.sourcelookup.containers.LocalFileStorage;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.contexts.IDebugContextListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceLocator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IFindReplaceTarget;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextOperationTarget;
import org.eclipse.jface.text.ITextPresentationListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.IViewportListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.jface.text.source.AnnotationRulerColumn;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IAnnotationAccess;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.IVerticalRulerExtension;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.OverviewRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.WorkbenchPart;
import org.eclipse.ui.texteditor.AnnotationPreference;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.eclipse.ui.texteditor.DefaultMarkerAnnotationAccess;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.texteditor.MarkerAnnotationPreferences;
import org.eclipse.ui.texteditor.SimpleMarkerAnnotation;
import org.eclipse.ui.texteditor.SourceViewerDecorationSupport;

public abstract class DisassemblyPart
extends WorkbenchPart
implements IDisassemblyPart,
IViewportListener,
ITextPresentationListener,
IDisassemblyPartCallback {
    static final boolean DEBUG = Boolean.parseBoolean(Platform.getDebugOption((String)"org.eclipse.cdt.dsf.ui/debug/disassembly"));
    private static final String BREAKPOINT_ANNOTATIONS = "breakpoints";
    private static final String EXTENDED_PC_ANNOTATIONS = "ExtendedPCAnnotations";
    private static final BigInteger PC_UNKNOWN = BigInteger.valueOf(-1L);
    private static final BigInteger PC_RUNNING = BigInteger.valueOf(-2L);
    private static final String CURRENT_LINE = "currentLine";
    private static final String CURRENT_LINE_COLOR = "currentLineColor";
    protected static final int VERTICAL_RULER_WIDTH = 12;
    private static final int fgHighWaterMark = 500;
    private static final int fgLowWaterMark = 100;
    private static final String COMMAND_ID_GOTO_ADDRESS = "org.eclipse.cdt.dsf.debug.ui.disassembly.commands.gotoAddress";
    private static final String COMMAND_ID_GOTO_PC = "org.eclipse.cdt.dsf.debug.ui.disassembly.commands.gotoPC";
    private static final String COMMAND_ID_TOGGLE_BREAKPOINT = "org.eclipse.cdt.dsf.debug.ui.disassembly.commands.rulerToggleBreakpoint";
    public static final String KEY_BINDING_CONTEXT_DISASSEMBLY = "org.eclipse.cdt.dsf.debug.ui.disassembly.context";
    public static final String PREFERENCE_RULER_CONTRIBUTIONS = "rulerContributions";
    protected DisassemblyViewer fViewer;
    protected AbstractDisassemblyAction fActionGotoPC;
    protected AbstractDisassemblyAction fActionGotoAddress;
    protected AbstractDisassemblyAction fActionToggleSource;
    protected AbstractDisassemblyAction fActionToggleSymbols;
    protected AbstractDisassemblyAction fActionRefreshView;
    protected Action fActionOpenPreferences;
    private AbstractDisassemblyAction fActionToggleBreakpointEnablement;
    protected DisassemblyDocument fDocument;
    private IAnnotationAccess fAnnotationAccess;
    private AnnotationRulerColumn fAnnotationRulerColumn;
    private MarkerAnnotationPreferences fAnnotationPreferences;
    private IPreferenceStore fPreferenceStore;
    private IOverviewRuler fOverviewRuler;
    private final ListenerList<IMenuListener> fRulerContextMenuListeners = new ListenerList(1);
    private SourceViewerDecorationSupport fDecorationSupport;
    private Font fFont;
    private IVerticalRuler fVerticalRuler;
    private IFindReplaceTarget fFindReplaceTarget;
    private IPropertyChangeListener fPropertyChangeListener = new PropertyChangeListener();
    private Color fInstructionColor;
    private Color fErrorColor;
    private Color fSourceColor;
    private Color fLabelColor;
    private Control fRedrawControl;
    private RGB fPCAnnotationRGB;
    protected Composite fComposite;
    private DropTarget fDropTarget;
    private DragSource fDragSource;
    private TextViewerDragAdapter fDragSourceAdapter;
    private DisassemblyDropAdapter fDropTargetAdapter;
    private BigInteger fStartAddress;
    private BigInteger fEndAddress;
    private int fAddressSize = 32;
    private volatile boolean fUpdatePending;
    private volatile int fUpdateCount;
    private BigInteger fPCAddress;
    private BigInteger fGotoAddressPending = PC_UNKNOWN;
    private BigInteger fFocusAddress = PC_UNKNOWN;
    private int fBufferZone;
    private String fDebugSessionId;
    private int fTargetFrame;
    private DisassemblyIPAnnotation fPCAnnotation;
    private DisassemblyIPAnnotation fSecondaryPCAnnotation;
    private boolean fPCAnnotationUpdatePending;
    private ArrayList<BigInteger> fPendingPCUpdates = new ArrayList(5);
    private Position fScrollPos;
    private int fScrollLine;
    private Position fFocusPos;
    private BigInteger fFrameAddress = PC_UNKNOWN;
    protected Map<String, Action> fGlobalActions = new HashMap<String, Action>();
    private List<Action> fSelectionActions = new ArrayList<Action>();
    private List<AbstractDisassemblyAction> fStateDependentActions = new ArrayList<AbstractDisassemblyAction>();
    private boolean fShowSource;
    private boolean fShowSymbols;
    private Map<String, Object> fFile2Storage = new HashMap<String, Object>();
    private boolean fShowDisassembly = true;
    private LinkedList<AddressRangePosition> fPCHistory = new LinkedList();
    private int fPCHistorySizeMax = 4;
    private boolean fGotoFramePending;
    protected Action fTrackExpressionAction;
    protected Action fSyncAction;
    protected boolean fSynchWithActiveDebugContext = true;
    protected boolean fTrackExpression = false;
    private String fPCLastLocationTxt = DisassemblyMessages.Disassembly_GotoLocation_initial_text;
    private BigInteger fPCLastAddress = PC_UNKNOWN;
    private IAdaptable fDebugContext;
    private String fPCAnnotationColorKey;
    private ArrayList<Runnable> fRunnableQueue = new ArrayList();
    protected IPartListener2 fPartListener = new IPartListener2(){

        public void partActivated(IWorkbenchPartReference partRef) {
        }

        public void partBroughtToTop(IWorkbenchPartReference partRef) {
        }

        public void partClosed(IWorkbenchPartReference partRef) {
        }

        public void partDeactivated(IWorkbenchPartReference partRef) {
        }

        public void partOpened(IWorkbenchPartReference partRef) {
        }

        public void partHidden(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(false);
            }
        }

        public void partVisible(IWorkbenchPartReference partRef) {
            if (partRef.getPart(false) == DisassemblyPart.this) {
                DisassemblyPart.this.setActive(true);
            }
        }

        public void partInputChanged(IWorkbenchPartReference partRef) {
        }
    };
    private boolean fActive = true;
    private boolean fDoPendingPosted;
    private boolean fUpdateBeforeFocus;
    private boolean fRefreshAll;
    private IMarker fGotoMarkerPending;
    private boolean fUpdateTitlePending;
    private boolean fRefreshViewPending;
    private boolean fUpdateSourcePending;
    private ArrayList<IHandlerActivation> fHandlerActivations;
    private IContextActivation fContextActivation;
    private IDisassemblyBackend fBackend;
    private AddressBarContributionItem fAddressBar = null;
    private Action fJumpToAddressAction = new JumpToAddressAction(this);
    private IDebugContextListener fDebugContextListener;
    private DisassemblyAnnotationModel fExtPCAnnotationModel;
    private IColumnSupport fColumnSupport;

    public DisassemblyPart() {
        this.fAnnotationPreferences = new MarkerAnnotationPreferences();
        this.setPreferenceStore((IPreferenceStore)new ChainedPreferenceStore(new IPreferenceStore[]{DsfUIPlugin.getDefault().getPreferenceStore(), EditorsUI.getPreferenceStore()}));
        this.fPCAddress = this.fFrameAddress = PC_UNKNOWN;
        this.fTargetFrame = -1;
        this.fBufferZone = 32;
        this.fPCAnnotation = new DisassemblyIPAnnotation(true, 0);
        this.fSecondaryPCAnnotation = new DisassemblyIPAnnotation(false, 0);
        IPreferenceStore prefs = this.getPreferenceStore();
        this.fStartAddress = new BigInteger(prefs.getString("disassembly.startAddress"));
        String endAddressString = prefs.getString("disassembly.endAddress");
        this.fEndAddress = endAddressString.startsWith("0x") ? new BigInteger(endAddressString.substring(2), 16) : new BigInteger(endAddressString, 16);
        this.fShowSource = prefs.getBoolean("disassembly.showSource");
        this.fShowSymbols = prefs.getBoolean("disassembly.showSymbols");
        this.fUpdateBeforeFocus = !prefs.getBoolean("disassembly.avoidReadBeforePC");
        this.fPCHistorySizeMax = prefs.getInt("disassembly.pcHistorySize");
    }

    public void logWarning(String message, Throwable error) {
        DsfUIPlugin.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.cdt.dsf.ui", message, error));
    }

    public <T> T getAdapter(Class<T> required) {
        if (IVerticalRulerInfo.class.equals(required)) {
            if (this.fVerticalRuler != null) {
                return (T)this.fVerticalRuler;
            }
        } else {
            if (IDisassemblyPart.class.equals(required)) {
                return (T)this;
            }
            if (IFindReplaceTarget.class.equals(required)) {
                if (this.fFindReplaceTarget == null) {
                    this.fFindReplaceTarget = this.fViewer == null ? null : this.fViewer.getFindReplaceTarget();
                }
                return (T)this.fFindReplaceTarget;
            }
            if (ITextOperationTarget.class.equals(required)) {
                return (T)(this.fViewer == null ? null : this.fViewer.getTextOperationTarget());
            }
            if (Control.class.equals(required)) {
                return (T)(this.fViewer != null ? this.fViewer.getTextWidget() : null);
            }
            if (IGotoMarker.class.equals(required)) {
                return (T)((IGotoMarker)marker -> this.gotoMarker(marker));
            }
            if (IColumnSupport.class.equals(required)) {
                if (this.fColumnSupport == null) {
                    this.fColumnSupport = this.createColumnSupport();
                }
                return (T)this.fColumnSupport;
            }
        }
        return (T)super.getAdapter(required);
    }

    private void addRulerContributionActions(IMenuManager menu) {
        final IColumnSupport support = this.getAdapter(IColumnSupport.class);
        IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
        final RulerColumnPreferenceAdapter adapter = new RulerColumnPreferenceAdapter(store, PREFERENCE_RULER_CONTRIBUTIONS);
        List descriptors = RulerColumnRegistry.getDefault().getColumnDescriptors();
        for (final RulerColumnDescriptor descriptor : descriptors) {
            if (!descriptor.isIncludedInMenu() || !support.isColumnSupported(descriptor)) continue;
            final boolean isVisible = support.isColumnVisible(descriptor);
            Action action = new Action(MessageFormat.format((String)DisassemblyMessages.DisassemblyPart_showRulerColumn_label, (Object[])new Object[]{descriptor.getName()}), 2){

                public void run() {
                    if (descriptor.isGlobal()) {
                        adapter.setEnabled(descriptor, !isVisible);
                    } else {
                        support.setColumnVisible(descriptor, !isVisible);
                    }
                }
            };
            action.setChecked(isVisible);
            action.setImageDescriptor(descriptor.getIcon());
            menu.appendToGroup("rulers", (IAction)action);
        }
    }

    protected void updateContributedRulerColumns(CompositeRuler ruler) {
        IColumnSupport support = this.getAdapter(IColumnSupport.class);
        if (support == null) {
            return;
        }
        RulerColumnPreferenceAdapter adapter = null;
        if (this.fPreferenceStore != null) {
            adapter = new RulerColumnPreferenceAdapter(this.getPreferenceStore(), PREFERENCE_RULER_CONTRIBUTIONS);
        }
        RulerColumnRegistry registry = RulerColumnRegistry.getDefault();
        List descriptors = registry.getColumnDescriptors();
        for (RulerColumnDescriptor descriptor : descriptors) {
            support.setColumnVisible(descriptor, adapter == null || adapter.isEnabled(descriptor));
        }
    }

    protected IColumnSupport createColumnSupport() {
        return new DisassemblyColumnSupport(this, RulerColumnRegistry.getDefault());
    }

    private void setPreferenceStore(IPreferenceStore store) {
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        this.fPreferenceStore = store;
        if (this.fPreferenceStore != null) {
            this.fPreferenceStore.addPropertyChangeListener(this.fPropertyChangeListener);
        }
    }

    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        if (this.fViewer == null) {
            return;
        }
        String property = event.getProperty();
        IPreferenceStore store = this.getPreferenceStore();
        if (this.getFontPropertyPreferenceKey().equals(property)) {
            this.initializeViewerFont((ISourceViewer)this.fViewer);
        } else if (property.equals("disassembly.showSource")) {
            boolean showSource = store.getBoolean(property);
            if (this.fShowSource == showSource) {
                return;
            }
            this.fShowSource = showSource;
            this.fActionToggleSource.update();
            this.refreshView(10);
        } else if (property.equals("disassembly.showSymbols")) {
            boolean showSymbols = store.getBoolean(property);
            if (this.fShowSymbols == showSymbols) {
                return;
            }
            this.fShowSymbols = showSymbols;
            this.fActionToggleSymbols.update();
            this.refreshView(10);
        } else if (property.equals("disassembly.avoidReadBeforePC")) {
            this.fUpdateBeforeFocus = !store.getBoolean(property);
            this.updateVisibleArea();
        } else if (property.equals(this.fPCAnnotationColorKey)) {
            this.fPCAnnotationRGB = PreferenceConverter.getColor((IPreferenceStore)store, (String)this.fPCAnnotationColorKey);
            for (AddressRangePosition pos : this.fPCHistory) {
                this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
            }
        } else if (property.equals("disassembly.pcHistorySize")) {
            this.fPCHistorySizeMax = store.getInt(property);
        } else if (PREFERENCE_RULER_CONTRIBUTIONS.equals(property)) {
            String[] difference = StringSetSerializer.getDifference((String)((String)event.getOldValue()), (String)((String)event.getNewValue()));
            IColumnSupport support = this.getAdapter(IColumnSupport.class);
            int i = 0;
            while (i < difference.length) {
                RulerColumnDescriptor desc = RulerColumnRegistry.getDefault().getColumnDescriptor(difference[i]);
                if (desc != null && support.isColumnSupported(desc)) {
                    boolean newState = !support.isColumnVisible(desc);
                    support.setColumnVisible(desc, newState);
                }
                ++i;
            }
        } else if (property.equals("disassembly.errorColor")) {
            this.fErrorColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.errorColor"));
            this.refreshView(10);
        } else if (property.equals("disassembly.instructionColor")) {
            this.fInstructionColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.instructionColor"));
            this.refreshView(10);
        } else if (property.equals("disassembly.sourceColor")) {
            this.fSourceColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.sourceColor"));
            this.refreshView(10);
        } else if (property.equals("disassembly.labelColor")) {
            this.fLabelColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.labelColor"));
            this.refreshView(10);
        }
    }

    public void createPartControl(Composite parent) {
        this.fComposite = parent;
        FillLayout layout = new FillLayout();
        layout.marginHeight = 2;
        parent.setLayout((Layout)layout);
        this.fVerticalRuler = this.createVerticalRuler();
        int styles = 68354;
        this.fViewer = new DisassemblyViewer(parent, this.fVerticalRuler, this.getOverviewRuler(), true, styles, this.getPreferenceStore());
        DisassemblyViewerConfiguration sourceViewerConfig = new DisassemblyViewerConfiguration(this);
        this.fViewer.addTextPresentationListener(this);
        this.fViewer.configure((SourceViewerConfiguration)sourceViewerConfig);
        this.fDecorationSupport = new SourceViewerDecorationSupport((ISourceViewer)this.fViewer, this.getOverviewRuler(), this.getAnnotationAccess(), this.getSharedColors());
        this.configureSourceViewerDecorationSupport(this.fDecorationSupport);
        this.fDecorationSupport.install(this.getPreferenceStore());
        this.fPCAnnotationRGB = this.fPCAnnotationColorKey != null ? PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)this.fPCAnnotationColorKey) : parent.getDisplay().getSystemColor(26).getRGB();
        this.initializeViewerFont((ISourceViewer)this.fViewer);
        this.fDocument = this.createDocument();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        JFaceResources.getFontRegistry().addListener(this.fPropertyChangeListener);
        this.createActions();
        this.hookRulerContextMenu();
        this.hookContextMenu();
        this.contributeToActionBars();
        this.fViewer.getTextWidget().addVerifyKeyListener(event -> {
            switch (event.keyCode) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000005: 
                case 0x1000006: {
                    event.doit = !this.keyScroll(event.keyCode);
                }
            }
        });
        this.fViewer.addSelectionChangedListener(event -> this.updateSelectionDependentActions());
        this.fErrorColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.errorColor"));
        this.fInstructionColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.instructionColor"));
        this.fSourceColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.sourceColor"));
        this.fLabelColor = EditorsUI.getSharedTextColors().getColor(PreferenceConverter.getColor((IPreferenceStore)this.getPreferenceStore(), (String)"disassembly.labelColor"));
        IVerticalRuler ruler = this.getVerticalRuler();
        if (ruler instanceof CompositeRuler) {
            this.updateContributedRulerColumns((CompositeRuler)ruler);
        }
        this.initDragAndDrop();
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.fViewer.getControl(), "org.eclipse.cdt.dsf.ui.disassembly_view");
        this.updateTitle();
        this.updateStateDependentActions();
        if (this.fDebugSessionId != null) {
            this.debugContextChanged();
        } else {
            this.updateDebugContext();
        }
    }

    protected void setSite(IWorkbenchPartSite site) {
        super.setSite(site);
        site.getPage().addPartListener(this.fPartListener);
        this.fDebugContextListener = event -> {
            if ((event.getFlags() & 1) != 0) {
                this.updateDebugContext();
            }
        };
        DebugUITools.addPartDebugContextListener((IWorkbenchPartSite)site, (IDebugContextListener)this.fDebugContextListener);
    }

    private DisassemblyDocument createDocument() {
        DisassemblyDocument doc = new DisassemblyDocument();
        return doc;
    }

    public void dispose() {
        ++this.fUpdateCount;
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider(null);
        site.getPage().removePartListener(this.fPartListener);
        if (this.fDebugContextListener != null) {
            DebugUITools.removePartDebugContextListener((IWorkbenchPartSite)site, (IDebugContextListener)this.fDebugContextListener);
            this.fDebugContextListener = null;
        }
        if (this.fHandlerActivations != null) {
            IHandlerService handlerService = (IHandlerService)site.getService(IHandlerService.class);
            handlerService.deactivateHandlers(this.fHandlerActivations);
            this.fHandlerActivations = null;
        }
        this.deactivateDisassemblyContext();
        this.fViewer = null;
        if (this.fBackend != null) {
            this.fBackend.clearDebugContext();
            this.fBackend.dispose();
            this.fBackend = null;
        }
        this.fAnnotationAccess = null;
        this.fAnnotationPreferences = null;
        this.fAnnotationRulerColumn = null;
        this.fComposite = null;
        if (this.fDecorationSupport != null) {
            this.fDecorationSupport.uninstall();
            this.fDecorationSupport = null;
        }
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (this.fDropTarget != null) {
            this.fDropTarget.dispose();
            this.fDropTarget = null;
            this.fDragSource.dispose();
            this.fDragSource = null;
        }
        if (this.fPropertyChangeListener != null) {
            if (this.fPreferenceStore != null) {
                this.fPreferenceStore.removePropertyChangeListener(this.fPropertyChangeListener);
                this.fPreferenceStore = null;
            }
            this.fPropertyChangeListener = null;
        }
        if (this.fColumnSupport != null) {
            this.fColumnSupport.dispose();
            this.fColumnSupport = null;
        }
        this.fDocument.dispose();
        this.fDocument = null;
        super.dispose();
    }

    private void initDragAndDrop() {
        if (this.fDropTarget == null) {
            StyledText dropControl;
            Transfer[] dropTypes = new Transfer[]{FileTransfer.getInstance(), TextTransfer.getInstance()};
            Transfer[] dragTypes = new Transfer[]{TextTransfer.getInstance()};
            StyledText dragControl = dropControl = this.getSourceViewer().getTextWidget();
            int dropOps = 17;
            int dragOps = 17;
            this.fDropTarget = new DropTarget((Control)dropControl, dropOps);
            this.fDropTarget.setTransfer(dropTypes);
            this.fDropTargetAdapter = new DisassemblyDropAdapter(this);
            this.fDropTarget.addDropListener((DropTargetListener)this.fDropTargetAdapter);
            this.fDragSource = new DragSource((Control)dragControl, dragOps);
            this.fDragSource.setTransfer(dragTypes);
            this.fDragSourceAdapter = new TextViewerDragAdapter((ITextViewer)this.getSourceViewer());
            this.fDragSource.addDragListener((DragSourceListener)this.fDragSourceAdapter);
        }
    }

    private ISourceViewer getSourceViewer() {
        return this.fViewer;
    }

    protected void configureSourceViewerDecorationSupport(SourceViewerDecorationSupport support) {
        for (AnnotationPreference pref : this.fAnnotationPreferences.getAnnotationPreferences()) {
            support.setAnnotationPreference(pref);
            if (!pref.getAnnotationType().equals(this.fPCAnnotation.getType())) continue;
            this.fPCAnnotationColorKey = pref.getColorPreferenceKey();
        }
        support.setCursorLinePainterPreferenceKeys(CURRENT_LINE, CURRENT_LINE_COLOR);
        support.setSymbolicFontName(this.getFontPropertyPreferenceKey());
    }

    private String getSymbolicFontName() {
        if (this.getConfigurationElement() != null) {
            return this.getConfigurationElement().getAttribute("symbolicFontName");
        }
        return null;
    }

    protected final String getFontPropertyPreferenceKey() {
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            return symbolicFontName;
        }
        return "org.eclipse.jface.textfont";
    }

    private void initializeViewerFont(ISourceViewer viewer) {
        FontData data;
        boolean isSharedFont = true;
        Font font = null;
        String symbolicFontName = this.getSymbolicFontName();
        if (symbolicFontName != null) {
            font = JFaceResources.getFont((String)symbolicFontName);
        } else if (this.fPreferenceStore != null && this.fPreferenceStore.contains("org.eclipse.jface.textfont") && !this.fPreferenceStore.isDefault("org.eclipse.jface.textfont") && (data = PreferenceConverter.getFontData((IPreferenceStore)this.fPreferenceStore, (String)"org.eclipse.jface.textfont")) != null) {
            isSharedFont = false;
            font = new Font((Device)viewer.getTextWidget().getDisplay(), data);
        }
        if (font == null) {
            font = JFaceResources.getTextFont();
        }
        this.setFont(viewer, font);
        if (this.fFont != null) {
            this.fFont.dispose();
            this.fFont = null;
        }
        if (!isSharedFont) {
            this.fFont = font;
        }
    }

    private void setFont(ISourceViewer sourceViewer, Font font) {
        if (sourceViewer.getDocument() != null) {
            StyledText styledText;
            Point selection = sourceViewer.getSelectedRange();
            int topIndex = sourceViewer.getTopIndex();
            StyledText parent = styledText = sourceViewer.getTextWidget();
            if (sourceViewer instanceof ITextViewerExtension) {
                ITextViewerExtension extension = (ITextViewerExtension)sourceViewer;
                parent = extension.getControl();
            }
            parent.setRedraw(false);
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
            sourceViewer.setSelectedRange(selection.x, selection.y);
            sourceViewer.setTopIndex(topIndex);
            if (parent instanceof Composite) {
                Composite composite = (Composite)parent;
                composite.layout(true);
            }
            parent.setRedraw(true);
        } else {
            StyledText styledText = sourceViewer.getTextWidget();
            styledText.setFont(font);
            if (this.fVerticalRuler instanceof IVerticalRulerExtension) {
                IVerticalRulerExtension e = (IVerticalRulerExtension)this.fVerticalRuler;
                e.setFont(font);
            }
        }
    }

    protected IVerticalRuler createVerticalRuler() {
        CompositeRuler ruler = this.createCompositeRuler();
        IPreferenceStore store = this.getPreferenceStore();
        if (ruler != null && store != null) {
            Iterator iter = ruler.getDecoratorIterator();
            while (iter.hasNext()) {
                IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
                if (!(column instanceof AnnotationRulerColumn)) continue;
                this.fAnnotationRulerColumn = (AnnotationRulerColumn)column;
                for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
                    String key = preference.getVerticalRulerPreferenceKey();
                    boolean showAnnotation = true;
                    if (key != null && store.contains(key)) {
                        showAnnotation = store.getBoolean(key);
                    }
                    if (!showAnnotation) continue;
                    this.fAnnotationRulerColumn.addAnnotationType(preference.getAnnotationType());
                }
                this.fAnnotationRulerColumn.addAnnotationType((Object)"org.eclipse.text.annotation.unknown");
                break;
            }
        }
        return ruler;
    }

    protected IVerticalRuler getVerticalRuler() {
        return this.fVerticalRuler;
    }

    protected IOverviewRuler getOverviewRuler() {
        if (this.fOverviewRuler == null) {
            this.fOverviewRuler = this.createOverviewRuler(this.getSharedColors());
        }
        return this.fOverviewRuler;
    }

    protected ISharedTextColors getSharedColors() {
        return EditorsUI.getSharedTextColors();
    }

    protected IOverviewRuler createOverviewRuler(ISharedTextColors sharedColors) {
        OverviewRuler ruler = new OverviewRuler(this.getAnnotationAccess(), 12, sharedColors);
        for (AnnotationPreference preference : this.fAnnotationPreferences.getAnnotationPreferences()) {
            if (!preference.contributesToHeader()) continue;
            ruler.addHeaderAnnotationType(preference.getAnnotationType());
        }
        return ruler;
    }

    protected void initializeRulerColumn(DisassemblyRulerColumn rulerColumn, String colorPrefKey) {
        ISharedTextColors sharedColors = this.getSharedColors();
        IPreferenceStore store = this.getPreferenceStore();
        if (store != null) {
            RGB rgb = null;
            if (store.contains(colorPrefKey)) {
                rgb = store.isDefault(colorPrefKey) ? PreferenceConverter.getDefaultColor((IPreferenceStore)store, (String)colorPrefKey) : PreferenceConverter.getColor((IPreferenceStore)store, (String)colorPrefKey);
            }
            if (rgb == null) {
                rgb = new RGB(0, 0, 0);
            }
            rulerColumn.setForeground(sharedColors.getColor(rgb));
            rgb = null;
            rulerColumn.redraw();
        }
    }

    private IPreferenceStore getPreferenceStore() {
        return this.fPreferenceStore;
    }

    protected CompositeRuler createCompositeRuler() {
        CompositeRuler ruler = new CompositeRuler();
        ruler.addDecorator(0, (IVerticalRulerColumn)new AnnotationRulerColumn(12, this.getAnnotationAccess()));
        return ruler;
    }

    protected IAnnotationAccess getAnnotationAccess() {
        if (this.fAnnotationAccess == null) {
            this.fAnnotationAccess = this.createAnnotationAccess();
        }
        return this.fAnnotationAccess;
    }

    protected IAnnotationAccess createAnnotationAccess() {
        return new DefaultMarkerAnnotationAccess();
    }

    private void hookContextMenu() {
        String id = "#DisassemblyPartContext";
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillContextMenu(manager));
        Menu menu = menuMgr.createContextMenu((Control)this.fViewer.getTextWidget());
        this.fViewer.getTextWidget().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void hookRulerContextMenu() {
        String id = "#DisassemblyPartRulerContext";
        MenuManager menuMgr = new MenuManager(id, id);
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(manager -> this.fillRulerContextMenu(manager));
        Menu menu = menuMgr.createContextMenu(this.fVerticalRuler.getControl());
        this.fVerticalRuler.getControl().setMenu(menu);
        this.getSite().registerContextMenu(id, menuMgr, (ISelectionProvider)this.fViewer);
    }

    private void contributeToActionBars() {
        IWorkbenchPartSite site = this.getSite();
        site.setSelectionProvider((ISelectionProvider)new DisassemblySelectionProvider(this));
        this.activateDisassemblyContext();
        this.contributeToActionBars(this.getActionBars());
    }

    protected abstract IActionBars getActionBars();

    protected void contributeToActionBars(IActionBars bars) {
        for (String key : this.fGlobalActions.keySet()) {
            IAction action = (IAction)this.fGlobalActions.get(key);
            bars.setGlobalActionHandler(key, action);
        }
        IMenuManager menu = bars.getMenuManager();
        IMenuManager navigateMenu = menu.findMenuUsingPath("navigate");
        if (navigateMenu != null) {
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoPC);
            navigateMenu.appendToGroup("additions", (IAction)this.fActionGotoAddress);
        }
        bars.updateActionBars();
    }

    protected void fillContextMenu(IMenuManager manager) {
        Point cursorLoc = this.getSite().getShell().getDisplay().getCursorLocation();
        this.fViewer.getTextWidget().toControl(cursorLoc);
        this.fActionToggleSource.update();
        this.fActionToggleSymbols.update();
        manager.add((IContributionItem)new GroupMarker("group.top"));
        manager.add((IContributionItem)new Separator("group.breakpoints"));
        manager.add((IContributionItem)new Separator("group.debug"));
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.SELECT_ALL));
        manager.add((IContributionItem)new Separator("settings"));
        manager.add((IAction)this.fActionToggleSource);
        manager.add((IAction)this.fActionToggleSymbols);
        manager.add((IAction)this.fActionOpenPreferences);
        manager.add((IContributionItem)new Separator("group.bottom"));
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void fillRulerContextMenu(IMenuManager manager) {
        this.fActionToggleBreakpointEnablement.update();
        manager.add((IContributionItem)new GroupMarker("group.top"));
        manager.add((IContributionItem)new Separator("group.breakpoints"));
        manager.add((IAction)this.fActionToggleBreakpointEnablement);
        manager.add((IContributionItem)new GroupMarker("debug"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new GroupMarker("restore"));
        manager.add((IContributionItem)new Separator("add"));
        manager.add((IContributionItem)new Separator("rulers"));
        this.addRulerContributionActions(manager);
        manager.add((IContributionItem)new Separator("group.rest"));
        for (IMenuListener listener : this.fRulerContextMenuListeners) {
            listener.menuAboutToShow(manager);
        }
        manager.add((IContributionItem)new Separator("group.edit"));
        manager.appendToGroup("group.edit", (IAction)this.fGlobalActions.get(ITextEditorActionConstants.COPY));
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        int ADDRESS_BAR_WIDTH = 190;
        ToolBar toolbar = ((ToolBarManager)manager).getControl();
        this.fAddressBar = new AddressBarContributionItem((IAction)this.fJumpToAddressAction);
        this.fAddressBar.createAddressBox(toolbar, 190, DisassemblyMessages.Disassembly_GotoLocation_initial_text, DisassemblyMessages.Disassembly_GotoLocation_warning);
        manager.add((IContributionItem)this.fAddressBar);
        this.fJumpToAddressAction.setEnabled(this.fDebugSessionId != null);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fActionRefreshView);
        manager.add((IAction)this.fActionGotoPC);
        manager.add((IAction)this.fSyncAction);
        manager.add((IAction)this.fActionToggleSource);
        manager.add((IContributionItem)new Separator("additions"));
    }

    protected void updateSelectionDependentActions() {
        for (IUpdate iUpdate : this.fSelectionActions) {
            iUpdate.update();
        }
    }

    protected void updateStateDependentActions() {
        for (IUpdate iUpdate : this.fStateDependentActions) {
            iUpdate.update();
        }
    }

    protected void createActions() {
        TextOperationAction action = new TextOperationAction((ITextViewer)this.fViewer, 4);
        action.setText(DisassemblyMessages.Disassembly_action_Copy_label);
        action.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_enabled));
        action.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Copy_disabled));
        action.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.fGlobalActions.put(ITextEditorActionConstants.COPY, action);
        this.fSelectionActions.add(action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 7);
        action.setText(DisassemblyMessages.Disassembly_action_SelectAll_label);
        action.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
        this.fGlobalActions.put(ITextEditorActionConstants.SELECT_ALL, action);
        action = new TextOperationAction((ITextViewer)this.fViewer, 10);
        action.setActionDefinitionId("org.eclipse.ui.file.print");
        this.fGlobalActions.put(ITextEditorActionConstants.PRINT, action);
        action = new FindReplaceAction(DisassemblyMessages.getBundleForConstructedKeys(), "FindReplaceAction.", (IWorkbenchPart)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.findReplace");
        this.fGlobalActions.put(ActionFactory.FIND.getId(), action);
        this.fSelectionActions.add(action);
        this.fActionGotoPC = new ActionGotoProgramCounter(this);
        this.fActionGotoPC.setActionDefinitionId(COMMAND_ID_GOTO_PC);
        this.fActionGotoPC.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Home_enabled));
        this.fActionGotoPC.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Home_disabled));
        this.fStateDependentActions.add(this.fActionGotoPC);
        this.registerWithHandlerService((IAction)this.fActionGotoPC);
        this.fActionGotoAddress = new ActionGotoAddress(this);
        this.fActionGotoAddress.setActionDefinitionId(COMMAND_ID_GOTO_ADDRESS);
        this.fStateDependentActions.add(this.fActionGotoAddress);
        this.registerWithHandlerService((IAction)this.fActionGotoAddress);
        this.fActionToggleSource = new ActionToggleSource();
        this.fStateDependentActions.add(this.fActionToggleSource);
        this.fActionToggleSource.setImageDescriptor((ImageDescriptor)ResourceLocator.imageDescriptorFromBundle((String)"org.eclipse.cdt.dsf.ui", (String)"icons/source.gif").get());
        this.fVerticalRuler.getControl().addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                IHandlerService handlerService = (IHandlerService)DisassemblyPart.this.getSite().getService(IHandlerService.class);
                if (handlerService != null) {
                    try {
                        Event event = new Event();
                        event.display = e.display;
                        event.widget = e.widget;
                        event.time = e.time;
                        event.data = e.data;
                        event.x = e.x;
                        event.y = e.y;
                        event.button = e.button;
                        event.stateMask = e.stateMask;
                        event.count = e.count;
                        handlerService.executeCommand(DisassemblyPart.COMMAND_ID_TOGGLE_BREAKPOINT, event);
                    }
                    catch (ExecutionException exc) {
                        DsfUIPlugin.log(exc);
                    }
                    catch (NotDefinedException notDefinedException) {
                    }
                    catch (NotEnabledException notEnabledException) {
                    }
                    catch (NotHandledException notHandledException) {
                        // empty catch block
                    }
                }
            }
        });
        this.fActionToggleBreakpointEnablement = new ActionToggleBreakpointEnablement();
        this.fActionToggleSymbols = new ActionToggleSymbols();
        this.fActionRefreshView = new ActionRefreshView();
        this.fSyncAction = new SyncActiveDebugContextAction();
        this.fTrackExpressionAction = new TrackExpressionAction();
        this.fStateDependentActions.add(this.fActionRefreshView);
        this.fGlobalActions.put(ActionFactory.REFRESH.getId(), this.fActionRefreshView);
        this.fActionOpenPreferences = new ActionOpenPreferences(this.getSite().getShell());
    }

    private void registerWithHandlerService(IAction action) {
        if (this.fHandlerActivations == null) {
            this.fHandlerActivations = new ArrayList(5);
        }
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fHandlerActivations.add(handlerService.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler(action)));
    }

    @Override
    public final void gotoProgramCounter() {
        if (this.fPCAddress != PC_RUNNING) {
            this.fPCLastAddress = PC_UNKNOWN;
            this.gotoFrame(this.getActiveStackFrame());
        }
    }

    @Override
    public final void gotoAddress(IAddress address) {
        assert (DisassemblyPart.isGuiThread());
        if (address != null) {
            BigInteger addr = address.getValue();
            this.startUpdate(() -> {
                this.fGotoFramePending = false;
                this.fGotoAddressPending = PC_UNKNOWN;
                this.gotoAddress(addr);
            });
        }
    }

    public final void gotoLocationByUser(BigInteger address, String locationTxt) {
        this.fPCLastAddress = address;
        this.fPCLastLocationTxt = locationTxt;
        this.gotoAddress(address);
    }

    public final void gotoActiveFrameByUser() {
        this.gotoFrame(this.getActiveStackFrame());
    }

    public final void gotoAddress(BigInteger address) {
        if (this.fDebugSessionId == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("gotoAddress " + DisassemblyUtils.getAddressText((BigInteger)address));
        }
        this.fFocusAddress = address;
        BigInteger previousAddress = this.fGotoAddressPending;
        if (this.fGotoAddressPending == PC_UNKNOWN) {
            this.fGotoAddressPending = address;
        }
        if (this.fUpdatePending) {
            return;
        }
        AddressRangePosition pos = this.getPositionOfAddress(address);
        if (pos != null) {
            if (pos.fValid) {
                if (!(!(pos instanceof ErrorPosition) && pos.fAddressOffset.equals(address) || previousAddress.equals(address))) {
                    pos.fValid = false;
                    this.fDocument.addInvalidAddressRange(pos);
                } else {
                    if (this.fGotoAddressPending.equals(address)) {
                        this.fGotoAddressPending = PC_UNKNOWN;
                    }
                    this.gotoPosition((Position)pos, !address.equals(this.fFrameAddress));
                    return;
                }
            }
            int lines = this.fBufferZone + 3;
            BigInteger endAddress = pos.fAddressOffset.add(pos.fAddressLength).min(address.add(BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions())));
            this.retrieveDisassembly(address, endAddress, lines);
        }
    }

    @Override
    public final void gotoSymbol(String symbol) {
        if (!this.fActive || this.fBackend == null) {
            return;
        }
        this.fBackend.gotoSymbol(symbol);
    }

    private void gotoPosition(Position pos, boolean onTop) {
        if (this.fViewer == null) {
            return;
        }
        this.setFocusPosition(pos);
        this.fViewer.setSelectedRange(pos.offset, 0);
        int revealOffset = pos.offset;
        if (pos.offset > 0) {
            try {
                AddressRangePosition previousPos = this.fDocument.getModelPosition(pos.offset - 1);
                if (previousPos instanceof LabelPosition) {
                    revealOffset = previousPos.offset;
                    onTop = true;
                } else if (previousPos == null || !previousPos.fValid) {
                    onTop = true;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        this.fViewer.revealOffset(revealOffset, onTop);
    }

    private void gotoMarker(IMarker marker) {
        if (marker == null) {
            return;
        }
        if (this.fDebugSessionId == null || this.fUpdatePending) {
            this.fGotoMarkerPending = marker;
            return;
        }
        this.fGotoMarkerPending = null;
    }

    public void viewportChanged(int verticalOffset) {
        if (this.fDebugSessionId != null && this.fGotoAddressPending == PC_UNKNOWN && this.fScrollPos == null && !this.fUpdatePending && !this.fRefreshViewPending && this.fFocusAddress != PC_UNKNOWN) {
            this.fUpdatePending = true;
            int updateCount = this.fUpdateCount;
            this.invokeLater(() -> {
                if (updateCount == this.fUpdateCount) {
                    assert (this.fUpdatePending);
                    if (this.fUpdatePending) {
                        this.fUpdatePending = false;
                        this.updateVisibleArea();
                    }
                }
            });
        }
    }

    public void updateVisibleArea() {
        boolean isScrollingUp;
        assert (DisassemblyPart.isGuiThread());
        if (!this.fActive || this.fUpdatePending || this.fViewer == null || this.fDebugSessionId == null) {
            return;
        }
        if (this.fBackend == null || !this.fBackend.hasDebugContext() || !this.fBackend.canDisassemble()) {
            return;
        }
        StyledText styledText = this.fViewer.getTextWidget();
        Rectangle clientArea = styledText.getClientArea();
        this.fBufferZone = Math.max(8, clientArea.height / styledText.getLineHeight());
        int topIndex = this.fViewer.getTopIndex();
        int bottomIndex = this.fViewer.getBottomIndex();
        int focusIndex = -1;
        boolean focusVisible = false;
        boolean bl = isScrollingUp = this.fViewer.isUserTriggeredScrolling() && this.fViewer.getLastTopPixel() >= styledText.getTopPixel();
        if (this.fFocusPos != null) {
            try {
                int focusOffset = this.fFocusPos.offset;
                focusIndex = this.fDocument.getLineOfOffset(focusOffset);
                boolean bl2 = focusVisible = focusIndex >= topIndex && focusIndex <= bottomIndex;
                if (!focusVisible) {
                    Point selection = this.fViewer.getSelectedRange();
                    if (selection.x == focusOffset && selection.y > 0) {
                        this.fViewer.setSelectedRange(selection.x, 0);
                    }
                }
            }
            catch (BadLocationException e) {
                this.setFocusPosition(null);
            }
        }
        if (!focusVisible) {
            focusIndex = topIndex + this.fScrollLine;
        }
        BigInteger focusAddress = this.getAddressOfLine(focusIndex);
        bottomIndex += 2;
        AddressRangePosition bestPosition = null;
        int bestLine = -1;
        BigInteger bestDistance = null;
        if (DEBUG) {
            System.out.println("DisassemblyPart.updateVisibleArea() called. There are " + this.fDocument.getInvalidAddressRanges().length + " invalid ranges to consider updating");
        }
        AddressRangePosition[] addressRangePositionArray = this.fDocument.getInvalidAddressRanges();
        int n = addressRangePositionArray.length;
        int n2 = 0;
        while (n2 < n) {
            AddressRangePosition p = addressRangePositionArray[n2];
            try {
                int line = this.fDocument.getLineOfOffset(p.offset);
                if (line >= topIndex && line <= bottomIndex && (p instanceof DisassemblyPosition || p.fAddressLength.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) <= 0 || isScrollingUp || this.fUpdateBeforeFocus || p.fAddressOffset.compareTo(focusAddress) >= 0)) {
                    BigInteger distance = p.fAddressOffset.subtract(focusAddress).abs();
                    if (bestDistance == null || distance.compareTo(bestDistance) < 0) {
                        bestPosition = p;
                        bestLine = line;
                        bestDistance = distance;
                        if (bestDistance.compareTo(BigInteger.valueOf(this.fBufferZone * 2)) <= 0) {
                            break;
                        }
                    }
                }
            }
            catch (BadLocationException line) {
                // empty catch block
            }
            ++n2;
        }
        if (bestPosition != null) {
            if (DEBUG) {
                System.out.println("...and the best candidate is: " + bestPosition);
            }
            int lines = this.fBufferZone + 3;
            BigInteger startAddress = bestPosition.fAddressOffset;
            BigInteger endAddress = bestPosition.fAddressOffset.add(bestPosition.fAddressLength);
            BigInteger addressRange = BigInteger.valueOf(lines * this.fDocument.getMeanSizeOfInstructions());
            if (bestLine > focusIndex || bestLine == focusIndex && startAddress.compareTo(focusAddress) >= 0) {
                if (endAddress.subtract(startAddress).compareTo(addressRange) < 0) {
                    Iterator<Position> iter = this.fDocument.getModelPositionIterator(endAddress);
                    while (iter.hasNext()) {
                        AddressRangePosition p = (AddressRangePosition)iter.next();
                        if (p.fValid && (endAddress = endAddress.add(p.fAddressLength)).subtract(startAddress).compareTo(addressRange) < 0) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                startAddress = startAddress.max(endAddress.subtract(addressRange));
                lines = endAddress.subtract(startAddress).intValue();
            }
            this.retrieveDisassembly(startAddress, endAddress, lines);
        } else if (DEBUG) {
            System.out.println("...but alas we didn't deem any of them worth updating. They are:");
            int i = 0;
            AddressRangePosition[] addressRangePositionArray2 = this.fDocument.getInvalidAddressRanges();
            int n3 = addressRangePositionArray2.length;
            n = 0;
            while (n < n3) {
                AddressRangePosition p = addressRangePositionArray2[n];
                System.out.println("[" + i++ + "] " + p);
                ++n;
            }
        }
        this.scheduleDoPending();
    }

    public void asyncExec(Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().asyncExec(runnable);
        }
    }

    private void invokeLater(Runnable runnable) {
        this.invokeLater(10, runnable);
    }

    private void invokeLater(int delay, Runnable runnable) {
        if (this.fViewer != null) {
            this.fViewer.getControl().getDisplay().timerExec(delay, runnable);
        }
    }

    public void updateInvalidSource() {
        assert (DisassemblyPart.isGuiThread());
        if (this.fViewer == null) {
            return;
        }
        boolean unlock = false;
        try {
            SourcePosition[] invalidSources;
            if (this.fScrollPos == null) {
                if (this.fUpdatePending) {
                    this.fUpdateSourcePending = true;
                    return;
                }
                this.fUpdateSourcePending = false;
                unlock = true;
                this.fUpdatePending = true;
                this.lockScroller();
            }
            SourcePosition[] sourcePositionArray = invalidSources = this.fDocument.getInvalidSourcePositions();
            int n = invalidSources.length;
            int n2 = 0;
            while (n2 < n) {
                SourcePosition p = sourcePositionArray[n2];
                if (!p.fValid) {
                    this.insertSource(p);
                } else if (DEBUG && this.fDocument.removeInvalidSourcePosition(p)) {
                    System.err.println("!!! valid source position in invalid source list at " + DisassemblyUtils.getAddressText((BigInteger)p.fAddressOffset));
                }
                ++n2;
            }
        }
        finally {
            if (unlock) {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
            }
        }
    }

    void retrieveDisassembly(String file, int lines, boolean mixed) {
        if (this.fDebugSessionId == null) {
            return;
        }
        this.startUpdate(() -> {
            if (DEBUG) {
                System.out.println("retrieveDisassembly " + file);
            }
            this.fBackend.retrieveDisassembly(file, lines, this.fEndAddress, mixed, this.fShowSymbols, this.fShowDisassembly);
        });
    }

    private void retrieveDisassembly(BigInteger startAddress, BigInteger endAddress, int lines) {
        if (this.fDebugSessionId == null) {
            return;
        }
        if (DEBUG) {
            System.out.println("retrieveDisassembly " + DisassemblyUtils.getAddressText((BigInteger)startAddress) + " " + lines + " lines");
        }
        this.retrieveDisassembly(startAddress, endAddress, lines, this.fShowSource, true);
    }

    public void retrieveDisassembly(BigInteger startAddress, BigInteger endAddress, int linesHint, boolean mixed, boolean ignoreFile) {
        assert (DisassemblyPart.isGuiThread());
        assert (!this.fUpdatePending);
        this.fUpdatePending = true;
        int lines = linesHint + 2;
        BigInteger addressLength = BigInteger.valueOf(lines * 4);
        if (endAddress.subtract(startAddress).compareTo(addressLength) > 0) {
            endAddress = startAddress.add(addressLength);
        }
        boolean insideActiveFrame = startAddress.equals(this.fFrameAddress);
        String file = null;
        int lineNumber = -1;
        if (!ignoreFile && insideActiveFrame && this.fBackend != null) {
            file = this.fBackend.getFrameFile();
            if (file != null && file.trim().length() == 0) {
                file = null;
            }
            if (file != null) {
                lineNumber = this.fBackend.getFrameLine();
            }
        }
        if (DEBUG) {
            System.out.println("Asking backend to retrieve disassembly: sa=0x" + startAddress.toString(16) + ",ea=0x" + endAddress.toString(16) + ",file=" + file + ",lineNumber=" + lineNumber + ",lines=" + lines);
        }
        this.fBackend.retrieveDisassembly(startAddress, endAddress, file, lineNumber, lines, mixed, this.fShowSymbols, this.fShowDisassembly, linesHint);
    }

    public void insertError(BigInteger address, String message) {
        assert (DisassemblyPart.isGuiThread());
        AddressRangePosition p = null;
        p = this.getPositionOfAddress(address);
        if (p.fValid) {
            return;
        }
        try {
            this.fDocument.insertErrorLine(p, address, BigInteger.ONE, message);
        }
        catch (BadLocationException exc) {
            DisassemblyUtils.internalError((Throwable)exc);
        }
    }

    public int getAddressSize() {
        assert (DisassemblyPart.isGuiThread());
        return this.fAddressSize;
    }

    public void addressSizeChanged(int addressSize) {
        assert (DisassemblyPart.isGuiThread());
        BigInteger oldEndAddress = this.fEndAddress;
        this.fEndAddress = BigInteger.ONE.shiftLeft(addressSize);
        int oldAddressSize = this.fAddressSize;
        this.fAddressSize = addressSize;
        if (addressSize < oldAddressSize) {
            this.fDocument.deleteDisassemblyRange(this.fEndAddress, oldEndAddress, true, true);
            ArrayList<AddressRangePosition> toRemove = new ArrayList<AddressRangePosition>();
            AddressRangePosition[] addressRangePositionArray = this.fDocument.getInvalidAddressRanges();
            int n = addressRangePositionArray.length;
            int n2 = 0;
            while (n2 < n) {
                AddressRangePosition position = addressRangePositionArray[n2];
                if (position.fAddressOffset.compareTo(this.fEndAddress) >= 0) {
                    try {
                        this.fDocument.replace(position, position.length, "");
                        this.fDocument.removeModelPosition(position);
                        toRemove.add(position);
                    }
                    catch (BadLocationException exc) {
                        DisassemblyUtils.internalError((Throwable)exc);
                    }
                } else if (position.containsAddress(this.fEndAddress)) {
                    position.fAddressLength = this.fEndAddress.subtract(position.fAddressOffset);
                }
                ++n2;
            }
            this.fDocument.removeInvalidAddressRanges(toRemove);
        } else if (addressSize > oldAddressSize) {
            this.fDocument.insertInvalidAddressRange(this.fDocument.getLength(), 0, oldEndAddress, this.fEndAddress);
        } else {
            return;
        }
        AddressRulerColumn fAddressRulerColumn = (AddressRulerColumn)this.getRulerColumn("org.eclipse.cdt.dsf.ui.disassemblyColumn.address");
        if (fAddressRulerColumn != null) {
            fAddressRulerColumn.setAddressSize(addressSize);
            if (this.fComposite != null) {
                this.fComposite.layout(true);
            }
        }
    }

    private IContributedRulerColumn getRulerColumn(String id) {
        CompositeRuler compositeRuler = (CompositeRuler)this.getVerticalRuler();
        Iterator iter = compositeRuler.getDecoratorIterator();
        while (iter.hasNext()) {
            IContributedRulerColumn contributedColumn;
            IVerticalRulerColumn column = (IVerticalRulerColumn)iter.next();
            if (!(column instanceof IContributedRulerColumn) || !id.equals((contributedColumn = (IContributedRulerColumn)column).getDescriptor().getId())) continue;
            return contributedColumn;
        }
        return null;
    }

    public AddressRangePosition getPositionOfAddress(BigInteger address) {
        assert (DisassemblyPart.isGuiThread());
        if (address == null || address.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        AddressRangePosition pos = this.fDocument.getPositionOfAddress(address);
        assert (!(pos instanceof SourcePosition));
        return pos;
    }

    private BigInteger getAddressOfLine(int line) {
        return this.fDocument.getAddressOfLine(line);
    }

    public void setFocus() {
        this.fViewer.getControl().setFocus();
    }

    protected void setActive(boolean active) {
        if (DEBUG) {
            System.out.println("setActive(" + active + ")");
        }
        this.fActive = active;
        if (this.fActive) {
            if (this.fRefreshAll) {
                this.fRefreshAll = false;
                this.refreshView(0);
            } else {
                this.doPendingPCUpdates();
                if (this.fBackend != null && this.fBackend.hasDebugContext()) {
                    int frame = this.getActiveStackFrame();
                    if (frame < 0 && this.isSuspended()) {
                        frame = 0;
                    }
                    if (frame != this.fTargetFrame) {
                        this.gotoFrame(frame);
                    }
                }
            }
        } else {
            this.fGotoAddressPending = this.fFocusAddress = PC_UNKNOWN;
        }
        this.firePropertyChange(1285);
    }

    private int getActiveStackFrame() {
        if (this.fBackend != null) {
            return this.fBackend.getFrameLevel();
        }
        return -1;
    }

    protected void updateDebugContext() {
        IDisassemblyBackend.SetDebugContextResult result;
        this.fDebugContext = DebugUITools.getPartDebugContext((IWorkbenchPartSite)this.getSite());
        IDisassemblyBackend prevBackend = this.fBackend;
        IDisassemblyBackend newBackend = null;
        this.fDebugSessionId = null;
        boolean needUpdate = false;
        if (this.fDebugContext != null) {
            IDisassemblyBackend contextBackend = (IDisassemblyBackend)this.fDebugContext.getAdapter(IDisassemblyBackend.class);
            if (prevBackend != null && contextBackend != null && prevBackend.getClass().equals(contextBackend.getClass()) && prevBackend.supportsDebugContext(this.fDebugContext)) {
                newBackend = prevBackend;
            } else {
                needUpdate = true;
                newBackend = (IDisassemblyBackend)this.fDebugContext.getAdapter(IDisassemblyBackend.class);
                if (newBackend != null) {
                    if (newBackend.supportsDebugContext(this.fDebugContext)) {
                        newBackend.init((IDisassemblyPartCallback)this);
                    } else {
                        newBackend = null;
                    }
                }
            }
        }
        this.fBackend = newBackend;
        if (newBackend != null && (result = newBackend.setDebugContext(this.fDebugContext)) != null) {
            this.fDebugSessionId = result.sessionId;
            if (result.contextChanged) {
                needUpdate = true;
            }
        }
        if (prevBackend != null && newBackend != prevBackend) {
            needUpdate = true;
            prevBackend.clearDebugContext();
            prevBackend.dispose();
        }
        if (needUpdate && this.fViewer != null) {
            this.startUpdate(() -> this.debugContextChanged());
        }
    }

    private void startUpdate(final Runnable update) {
        if (this.fViewer == null) {
            return;
        }
        final int updateCount = this.fUpdateCount;
        final SafeRunnable safeUpdate = new SafeRunnable(){

            public void run() {
                update.run();
            }

            public void handleException(Throwable e) {
                DisassemblyUtils.internalError((Throwable)e);
            }
        };
        if (this.fUpdatePending) {
            this.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (updateCount == DisassemblyPart.this.fUpdateCount && DisassemblyPart.this.fViewer != null) {
                        if (DisassemblyPart.this.fUpdatePending) {
                            DisassemblyPart.this.invokeLater(this);
                        } else {
                            SafeRunner.run((ISafeRunnable)safeUpdate);
                        }
                    }
                }
            });
        } else {
            SafeRunner.run((ISafeRunnable)safeUpdate);
        }
    }

    private void debugContextChanged() {
        if (DEBUG) {
            System.out.println("DisassemblyPart.debugContextChanged()");
        }
        ++this.fUpdateCount;
        this.fRunnableQueue.clear();
        this.fUpdatePending = false;
        this.resetViewer();
        if (this.fDebugSessionId != null) {
            int activeFrame;
            this.fJumpToAddressAction.setEnabled(true);
            if (this.fAddressBar != null) {
                this.fAddressBar.enableAddressBox(true);
            }
            if ((activeFrame = this.getActiveStackFrame()) > 0) {
                this.gotoFrame(activeFrame);
            } else {
                this.updatePC(PC_UNKNOWN);
            }
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            }
            if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            this.fViewer.addViewportListener(this);
        } else {
            this.fJumpToAddressAction.setEnabled(false);
            if (this.fAddressBar != null) {
                this.fAddressBar.enableAddressBox(false);
            }
            this.fViewer.removeViewportListener(this);
            this.fGotoMarkerPending = null;
        }
        this.updateTitle();
        this.updateStateDependentActions();
        this.firePropertyChange(1286);
        this.firePropertyChange(1287);
    }

    private void attachExtendedPCAnnotationModel() {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)annotationModel;
            this.fExtPCAnnotationModel = new DisassemblyAnnotationModel();
            ame.addAnnotationModel((Object)EXTENDED_PC_ANNOTATIONS, (IAnnotationModel)this.fExtPCAnnotationModel);
        }
    }

    private void attachBreakpointsAnnotationModel() {
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        if (annotationModel instanceof IAnnotationModelExtension) {
            IAnnotationModelExtension ame = (IAnnotationModelExtension)annotationModel;
            ame.addAnnotationModel((Object)BREAKPOINT_ANNOTATIONS, (IAnnotationModel)new BreakpointsAnnotationModel(this.fDebugContext));
        }
    }

    private void refreshView(int delay) {
        if (this.fViewer == null || this.fRefreshViewPending || this.fRefreshAll) {
            return;
        }
        this.fRunnableQueue.clear();
        this.fRefreshViewPending = true;
        long refreshViewScheduled = System.currentTimeMillis() + (long)delay;
        Runnable refresh = () -> {
            this.fRefreshViewPending = false;
            long now = System.currentTimeMillis();
            if (now >= refreshViewScheduled) {
                if (DEBUG) {
                    System.err.println("*** refreshing view ***");
                }
                BigInteger topAddress = this.getTopAddress();
                int targetFrame = this.fTargetFrame;
                BigInteger frameAddress = this.fFrameAddress;
                BigInteger pcAddress = this.fPCAddress;
                this.resetViewer();
                if (this.fScrollPos != null) {
                    this.fScrollPos.isDeleted = true;
                }
                this.fPCAnnotationUpdatePending = true;
                this.fTargetFrame = targetFrame;
                this.fFrameAddress = frameAddress;
                this.fPCAddress = pcAddress;
                this.gotoAddress(topAddress);
            } else {
                this.refreshView((int)(refreshViewScheduled - now));
            }
        };
        if (delay > 0) {
            this.invokeLater(delay, () -> this.doScrollLocked(refresh));
        } else {
            this.doScrollLocked(refresh);
        }
    }

    private BigInteger getTopAddress() {
        if (this.fViewer != null) {
            BigInteger topAddress = this.getAddressOfLine(this.fViewer.getTopIndex());
            if (topAddress.equals(this.fStartAddress)) {
                topAddress = this.getAddressOfLine(this.fViewer.getTopIndex() + 1);
            }
            return topAddress;
        }
        return PC_UNKNOWN;
    }

    private void resetViewer() {
        this.fExtPCAnnotationModel = null;
        this.fPCAnnotationUpdatePending = false;
        this.fGotoFramePending = false;
        this.fPCAddress = this.fFrameAddress = PC_RUNNING;
        this.fTargetFrame = -1;
        this.fGotoAddressPending = PC_UNKNOWN;
        this.fFocusAddress = PC_UNKNOWN;
        this.setFocusPosition(null);
        this.fPCHistory.clear();
        this.fPendingPCUpdates.clear();
        this.fFile2Storage.clear();
        this.fDocument.clear();
        this.fViewer.setDocument((IDocument)this.fDocument, (IAnnotationModel)new AnnotationModel());
        if (this.fDebugSessionId != null) {
            this.attachBreakpointsAnnotationModel();
            this.attachExtendedPCAnnotationModel();
            this.fDocument.insertInvalidAddressRange(0, 0, this.fStartAddress, this.fEndAddress);
        }
    }

    private AddressRangePosition getPCPosition(BigInteger address) {
        if (address.compareTo(BigInteger.ZERO) < 0) {
            return null;
        }
        AddressRangePosition pos = this.getPositionOfAddress(address);
        if (pos == null || !pos.fValid) {
            return null;
        }
        if (pos.length > 0) {
            return pos;
        }
        if (!(pos instanceof DisassemblyPosition)) {
            return pos;
        }
        String srcFile = ((DisassemblyPosition)pos).getFile();
        if (srcFile == null) {
            return pos;
        }
        SourceFileInfo fi = this.fDocument.getSourceInfo(srcFile);
        if (fi == null) {
            return pos;
        }
        if (fi.fSource == null) {
            if (fi.fError != null) {
                return pos;
            }
            return null;
        }
        int stmtLine = ((DisassemblyPosition)pos).getLine();
        if (stmtLine < 0) {
            return pos;
        }
        Position srcPos = this.fDocument.getSourcePosition(fi, stmtLine);
        if (srcPos == null) {
            return pos;
        }
        int offset = srcPos.offset;
        int length = srcPos.length;
        return new AddressRangePosition(offset, length, address, BigInteger.ZERO);
    }

    private AddressRangePosition updateAddressAnnotation(Annotation annotation, BigInteger address) {
        if (this.fViewer == null) {
            return null;
        }
        IAnnotationModel annotationModel = this.fViewer.getAnnotationModel();
        annotationModel.removeAnnotation(annotation);
        AddressRangePosition pos = this.getPCPosition(address);
        if (pos != null) {
            annotationModel.addAnnotation(annotation, new Position(pos.offset, Math.max(0, pos.length - 1)));
        }
        return pos;
    }

    public IBreakpoint[] getBreakpointsAtLine(int line) {
        IAnnotationModelExtension ame;
        BreakpointsAnnotationModel bpModel = null;
        IAnnotationModel am = this.fViewer.getAnnotationModel();
        if (am instanceof IAnnotationModelExtension && (bpModel = (BreakpointsAnnotationModel)(ame = (IAnnotationModelExtension)am).getAnnotationModel((Object)BREAKPOINT_ANNOTATIONS)) != null) {
            IRegion lineRegion;
            try {
                lineRegion = this.fDocument.getLineInformation(line);
            }
            catch (BadLocationException exc) {
                return null;
            }
            int offset = lineRegion.getOffset();
            int length = lineRegion.getLength();
            Iterator it = bpModel.getAnnotationIterator(offset, length, true, true);
            ArrayList<IBreakpoint> bpList = new ArrayList<IBreakpoint>(5);
            IBreakpointManager bpMgr = DebugPlugin.getDefault().getBreakpointManager();
            while (it.hasNext()) {
                SimpleMarkerAnnotation annotation = (SimpleMarkerAnnotation)it.next();
                IBreakpoint bp = bpMgr.getBreakpoint(annotation.getMarker());
                if (bp == null) continue;
                bpList.add(bp);
            }
            if (!bpList.isEmpty()) {
                return bpList.toArray(new IBreakpoint[bpList.size()]);
            }
        }
        return null;
    }

    public void gotoFrame(int frame) {
        assert (DisassemblyPart.isGuiThread());
        this.fGotoAddressPending = PC_UNKNOWN;
        this.gotoFrame(frame, PC_UNKNOWN);
    }

    public void gotoFrameIfActive(int frame) {
        assert (DisassemblyPart.isGuiThread());
        if (this.fActive) {
            this.gotoFrame(frame);
        } else {
            this.fTargetFrame = -1;
        }
    }

    public void gotoFrame(int frame, BigInteger address) {
        assert (DisassemblyPart.isGuiThread());
        if (DEBUG) {
            System.out.println("gotoFrame " + frame + " " + DisassemblyUtils.getAddressText((BigInteger)address));
        }
        if (!this.isSyncWithActiveDebugContext()) {
            if (this.isTrackExpression() && !DisassemblyMessages.Disassembly_GotoLocation_initial_text.equals(this.fPCLastLocationTxt)) {
                this.fPCLastAddress = this.eval(this.fPCLastLocationTxt, true);
            }
            if (this.fPCLastAddress != PC_UNKNOWN) {
                address = this.fPCLastAddress;
            } else if (address != PC_UNKNOWN) {
                this.fPCLastAddress = address;
            }
            if (this.fPCLastAddress != PC_UNKNOWN) {
                frame = -2;
            }
        } else {
            this.fPCLastAddress = address;
        }
        if (this.fGotoAddressPending == this.fFrameAddress) {
            this.fGotoAddressPending = PC_UNKNOWN;
        }
        this.fTargetFrame = frame;
        this.fFrameAddress = address;
        if (this.fTargetFrame == -1) {
            this.fTargetFrame = this.getActiveStackFrame();
            if (this.fTargetFrame < 0 && this.fBackend != null && this.fBackend.canDisassemble()) {
                this.fTargetFrame = 0;
            }
            if (this.fTargetFrame == -1) {
                this.fGotoFramePending = false;
                return;
            }
        }
        this.fGotoFramePending = true;
        if (frame == 0) {
            this.fPCAddress = this.fFrameAddress;
        }
        if (this.fFrameAddress.compareTo(PC_UNKNOWN) == 0) {
            if (!this.fUpdatePending) {
                this.fGotoFramePending = false;
                if (this.fBackend != null && this.fBackend.hasDebugContext() && this.fBackend.canDisassemble()) {
                    if (DEBUG) {
                        System.out.println("retrieveFrameAddress " + frame);
                    }
                    this.fUpdatePending = true;
                    this.fBackend.retrieveFrameAddress(this.fTargetFrame);
                }
            }
            return;
        }
        AddressRangePosition pcPos = this.updatePCAnnotation();
        if (pcPos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0 && (pcPos = this.getPCPosition(this.fFrameAddress)) == null) {
            this.gotoAddress(this.fFrameAddress);
            return;
        }
        if (pcPos != null) {
            if (frame == 0) {
                this.addToPCHistory(pcPos);
            }
            this.fGotoFramePending = false;
            this.gotoPosition((Position)pcPos, false);
            this.updateVisibleArea();
        } else {
            this.fGotoFramePending = false;
            this.fGotoAddressPending = PC_UNKNOWN;
        }
        this.doPendingPCUpdates();
    }

    @Override
    public final boolean isActive() {
        return this.fActive;
    }

    @Override
    public final boolean isConnected() {
        if (this.fDebugSessionId == null) {
            return false;
        }
        return this.fBackend != null ? this.fBackend.hasDebugContext() : false;
    }

    @Override
    public final boolean isSuspended() {
        return this.isConnected() && this.fBackend.isSuspended();
    }

    @Override
    public final ISourceViewer getTextViewer() {
        return this.fViewer;
    }

    public final boolean hasViewer() {
        return this.fViewer != null;
    }

    @Override
    public final void addRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.add((Object)listener);
    }

    @Override
    public final void removeRulerContextMenuListener(IMenuListener listener) {
        this.fRulerContextMenuListeners.remove((Object)listener);
    }

    synchronized Object retrieveModuleTimestamp(BigInteger address) {
        return null;
    }

    private void setFocusPosition(Position pcPos) {
        if (this.fFocusPos != null) {
            this.fDocument.removePosition(this.fFocusPos);
            this.fFocusPos = null;
        }
        if (pcPos != null) {
            this.fFocusPos = new Position(pcPos.offset, pcPos.length);
            try {
                this.fDocument.addPosition(this.fFocusPos);
            }
            catch (BadLocationException e) {
                DisassemblyUtils.internalError((Throwable)e);
            }
        } else {
            this.fFocusAddress = PC_UNKNOWN;
        }
    }

    private void doPendingPCUpdates() {
        BigInteger pc;
        if (this.fPendingPCUpdates.isEmpty()) {
            return;
        }
        while ((pc = this.fPendingPCUpdates.remove(0)).compareTo(BigInteger.ZERO) < 0 && !this.fPendingPCUpdates.isEmpty()) {
        }
        this.gotoFrame(0, pc);
    }

    private void addToPCHistory(AddressRangePosition pcPos) {
        if (DEBUG) {
            System.out.println("addToPCHistory " + DisassemblyUtils.getAddressText((BigInteger)pcPos.fAddressOffset));
        }
        if (this.fPCHistorySizeMax <= 1) {
            return;
        }
        AddressRangePosition first = null;
        if (!this.fPCHistory.isEmpty()) {
            first = this.fPCHistory.getFirst();
            if (first.fAddressOffset == pcPos.fAddressOffset) {
                if (first.offset != pcPos.offset || first.length != pcPos.length) {
                    this.fPCHistory.removeFirst();
                    this.fViewer.invalidateTextPresentation(first.offset, first.length);
                } else {
                    return;
                }
            }
        }
        pcPos = new AddressRangePosition(pcPos.offset, pcPos.length, pcPos.fAddressOffset, BigInteger.ZERO);
        this.fPCHistory.addFirst(pcPos);
        try {
            this.fDocument.addPosition((Position)pcPos);
        }
        catch (BadLocationException e) {
            DisassemblyUtils.internalError((Throwable)e);
        }
        if (this.fPCHistory.size() > this.fPCHistorySizeMax) {
            AddressRangePosition last = this.fPCHistory.removeLast();
            this.fDocument.removePosition((Position)last);
            this.fViewer.invalidateTextPresentation(last.offset, last.length);
        }
        for (AddressRangePosition pos : this.fPCHistory) {
            this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
        }
    }

    public void updatePC(BigInteger pc) {
        BigInteger last;
        assert (DisassemblyPart.isGuiThread());
        if (!this.fPendingPCUpdates.isEmpty() && (last = this.fPendingPCUpdates.get(this.fPendingPCUpdates.size() - 1)).compareTo(BigInteger.ZERO) < 0) {
            this.fPendingPCUpdates.remove(this.fPendingPCUpdates.size() - 1);
        }
        this.fPendingPCUpdates.add(pc);
        if (this.fPendingPCUpdates.size() > this.fPCHistorySizeMax) {
            if (!this.fActive) {
                this.fPendingPCUpdates.remove(0);
            }
            this.fGotoFramePending = false;
        }
        if (this.fActive) {
            if (this.fGotoFramePending) {
                if (!this.fUpdatePending) {
                    this.gotoFrame(0, this.fFrameAddress);
                }
            } else {
                this.doPendingPCUpdates();
            }
        }
    }

    private AddressRangePosition updatePCAnnotation() {
        if (this.fUpdatePending) {
            this.fPCAnnotationUpdatePending = true;
            return null;
        }
        AddressRangePosition pos = null;
        if (this.fTargetFrame == 0) {
            this.updateAddressAnnotation(this.fSecondaryPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fPCAnnotation, this.fPCAddress);
        } else if (this.fTargetFrame < 0) {
            this.updateAddressAnnotation(this.fPCAnnotation, PC_UNKNOWN);
            this.updateAddressAnnotation(this.fSecondaryPCAnnotation, PC_UNKNOWN);
        } else {
            this.updateAddressAnnotation(this.fPCAnnotation, PC_UNKNOWN);
            pos = this.updateAddressAnnotation(this.fSecondaryPCAnnotation, this.fFrameAddress);
        }
        boolean bl = this.fPCAnnotationUpdatePending = pos == null && this.fFrameAddress.compareTo(BigInteger.ZERO) >= 0;
        if (this.fExtPCAnnotationModel != null) {
            this.fBackend.updateExtendedPCAnnotation((IAnnotationModel)this.fExtPCAnnotationModel);
        }
        return pos;
    }

    private void scheduleDoPending() {
        if (!this.fUpdatePending && !this.fDoPendingPosted) {
            this.fDoPendingPosted = true;
            this.invokeLater(() -> {
                this.doPending();
                this.fDoPendingPosted = false;
            });
        }
    }

    public void doPending() {
        boolean sourceValid;
        assert (DisassemblyPart.isGuiThread());
        if (this.fViewer == null || this.fDocument == null) {
            return;
        }
        if (this.fUpdateSourcePending) {
            this.updateInvalidSource();
        }
        boolean bl = sourceValid = !this.fDocument.hasInvalidSourcePositions();
        if ((sourceValid || this.fShowDisassembly) && this.fGotoFramePending) {
            this.gotoFrame(this.fTargetFrame, this.fFrameAddress);
        }
        if (sourceValid) {
            if (this.fGotoAddressPending != PC_UNKNOWN) {
                this.gotoAddress(this.fGotoAddressPending);
            } else if (this.fGotoMarkerPending != null) {
                this.gotoMarker(this.fGotoMarkerPending);
            }
            if (this.fPCAnnotationUpdatePending && !this.fGotoFramePending) {
                this.updatePCAnnotation();
            }
            if (this.fUpdateTitlePending) {
                this.updateTitle();
            }
        }
    }

    public void doScrollLocked(Runnable doit) {
        assert (DisassemblyPart.isGuiThread());
        if (this.fViewer == null || this.fDebugSessionId == null) {
            return;
        }
        if (!this.fActive) {
            this.fRefreshViewPending = false;
            this.fRefreshAll = true;
            return;
        }
        if (doit != null) {
            this.fRunnableQueue.add(doit);
        }
        int updateCount = this.fUpdateCount;
        if (this.fUpdatePending) {
            if (this.fRunnableQueue.size() == 1) {
                Runnable doitlater = () -> {
                    if (updateCount == this.fUpdateCount) {
                        this.doScrollLocked(null);
                    }
                };
                this.invokeLater(doitlater);
            }
        } else {
            this.fUpdatePending = true;
            this.lockScroller();
            try {
                ArrayList<Runnable> copy = new ArrayList<Runnable>(this.fRunnableQueue);
                this.fRunnableQueue.clear();
                Iterator<Runnable> iter = copy.iterator();
                while (iter.hasNext()) {
                    if (updateCount != this.fUpdateCount) {
                        return;
                    }
                    Runnable doitnow = iter.next();
                    try {
                        doitnow.run();
                    }
                    catch (Exception e) {
                        DisassemblyUtils.internalError((Throwable)e);
                    }
                }
            }
            finally {
                this.fUpdatePending = false;
                this.unlockScroller();
                this.doPending();
                this.updateVisibleArea();
            }
        }
    }

    public void lockScroller() {
        assert (DisassemblyPart.isGuiThread());
        assert (this.fScrollPos == null);
        this.fRedrawControl = this.fViewer.getControl();
        this.fRedrawControl.setRedraw(false);
        try {
            int focusLine;
            int focusOffset;
            int topOffset = this.fViewer.getTopIndexStartOffset();
            int topIndex = this.fViewer.getTopIndex();
            int bottomIndex = this.fViewer.getBottomIndex();
            int bottomOffset = this.fViewer.getBottomIndexEndOffset();
            if (this.fFocusPos != null && this.fFocusPos.isDeleted) {
                this.fFocusPos = null;
            }
            if (this.fFocusPos != null && this.fFocusPos.offset >= topOffset && this.fFocusPos.offset <= bottomOffset) {
                focusOffset = this.fFocusPos.offset;
                focusLine = this.fDocument.getLineOfOffset(focusOffset);
            } else {
                focusLine = Math.max(0, (topIndex + bottomIndex) / 2);
                focusOffset = this.fDocument.getLineOffset(focusLine);
                AddressRangePosition pos = this.fDocument.getDisassemblyPosition(focusOffset);
                if (pos != null && !pos.fValid) {
                    focusOffset = pos.offset + pos.length;
                    focusLine = this.fDocument.getLineOfOffset(focusOffset);
                }
            }
            this.fScrollPos = new Position(focusOffset);
            this.fScrollLine = focusLine - topIndex;
            this.fDocument.addPosition(this.fScrollPos);
        }
        catch (BadLocationException e) {
            DisassemblyUtils.internalError((Throwable)e);
        }
    }

    public void unlockScroller() {
        assert (DisassemblyPart.isGuiThread());
        try {
            if (this.fScrollPos == null) {
                return;
            }
            try {
                if (this.fScrollPos.isDeleted) {
                    this.fScrollPos.isDeleted = false;
                    if (this.fScrollPos.offset >= this.fDocument.getLength()) {
                        this.fScrollPos.offset = 0;
                        this.fScrollLine = 0;
                    }
                }
                if (this.fFocusPos != null && (this.fFocusPos.isDeleted || this.fFocusPos.length == 0) && this.fFocusAddress.compareTo(BigInteger.ZERO) >= 0) {
                    this.fGotoAddressPending = this.fFocusAddress;
                    this.setFocusPosition((Position)this.getPositionOfAddress(this.fFocusAddress));
                }
                int topLine = this.fDocument.getLineOfOffset(this.fScrollPos.offset) - this.fScrollLine;
                int lineCount = this.fDocument.getNumberOfLines();
                if (lineCount > 500 * this.fBufferZone) {
                    int startLine = Math.max(0, topLine - 50 * this.fBufferZone);
                    int endLine = Math.min(lineCount - 1, topLine + 50 * this.fBufferZone);
                    this.fDocument.deleteLineRange(endLine, lineCount - 1);
                    this.fDocument.deleteLineRange(0, startLine);
                }
                int lineHeight = this.fViewer.getTextWidget().getLineHeight();
                int topPixel = topLine * lineHeight;
                if (Math.abs(this.fViewer.getTextWidget().getTopPixel() - topPixel) >= lineHeight) {
                    this.fViewer.setTopIndex(topLine);
                }
            }
            catch (BadLocationException e) {
                DisassemblyUtils.internalError((Throwable)e);
            }
        }
        finally {
            if (this.fScrollPos != null && this.fDocument != null) {
                this.fDocument.removePosition(this.fScrollPos);
                this.fScrollPos = null;
            }
            if (this.fViewer != null) {
                this.fRedrawControl.setRedraw(true);
                this.getVerticalRuler().update();
                this.getOverviewRuler().update();
            }
        }
    }

    public void insertSource(AddressRangePosition _pos) {
        block24: {
            assert (DisassemblyPart.isGuiThread());
            if (!(_pos instanceof SourcePosition)) {
                assert (false) : "Caller should have passed in a SourcePosition";
                return;
            }
            SourcePosition pos = (SourcePosition)_pos;
            if (!this.fShowSource) {
                this.fDocument.insertSource(pos, "", pos.fLine, true);
                return;
            }
            SourceFileInfo fi = pos.fFileInfo;
            if (fi.fSource != null || fi.fError != null) {
                int lineNr = pos.fLine;
                if (fi.fSource != null && lineNr >= 0 && lineNr < fi.fSource.getNumberOfLines()) {
                    fi.fStartAddress = fi.fStartAddress.min(pos.fAddressOffset);
                    fi.fEndAddress = fi.fEndAddress.max(pos.fAddressOffset.add(pos.fAddressLength));
                    int last = pos.fLast > lineNr ? pos.fLast : lineNr;
                    BigInteger lineAddr = fi.fLine2Addr[lineNr];
                    if (lineAddr == null) {
                        fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                        String source = fi.getLines(lineNr, last);
                        this.fDocument.insertSource(pos, source, lineNr, true);
                    } else {
                        int comparison = lineAddr.compareTo(pos.fAddressOffset);
                        if (comparison > 0) {
                            SourcePosition oldPos = this.fDocument.getSourcePosition(lineAddr);
                            if (oldPos != null) {
                                try {
                                    int index = this.fDocument.computeIndexInCategory("category_source", pos.fAddressOffset);
                                    if (index >= 0) {
                                        SourcePosition nextPos = (SourcePosition)this.fDocument.getPositionOfIndex("category_source", index + 1);
                                        if (nextPos.fFileInfo == fi && nextPos.fLine == lineNr) {
                                            this.fDocument.replace(oldPos, oldPos.length, "");
                                            this.fDocument.removeSourcePosition(oldPos);
                                        }
                                    }
                                }
                                catch (BadLocationException e) {
                                    DisassemblyUtils.internalError((Throwable)e);
                                }
                                catch (BadPositionCategoryException e) {
                                    DisassemblyUtils.internalError((Throwable)e);
                                }
                            }
                            fi.fLine2Addr[lineNr] = pos.fAddressOffset;
                            String source = fi.getLines(lineNr, last);
                            this.fDocument.insertSource(pos, source, lineNr, true);
                        } else if (comparison == 0) {
                            String source = fi.getLines(lineNr, last);
                            this.fDocument.insertSource(pos, source, lineNr, true);
                        } else {
                            try {
                                int index = this.fDocument.computeIndexInCategory("category_source", pos.fAddressOffset);
                                if (index > 0) {
                                    SourcePosition prevPos = (SourcePosition)this.fDocument.getPositionOfIndex("category_source", index - 1);
                                    if (prevPos.fFileInfo == fi && prevPos.fLine == lineNr) {
                                        this.fDocument.insertSource(pos, "", lineNr, true);
                                        this.fDocument.removeSourcePosition(pos);
                                    } else {
                                        String source = fi.getLines(lineNr, last);
                                        this.fDocument.insertSource(pos, source, lineNr, true);
                                    }
                                    break block24;
                                }
                                String source = fi.getLines(lineNr, last);
                                this.fDocument.insertSource(pos, source, lineNr, true);
                            }
                            catch (BadPositionCategoryException e) {
                                DisassemblyUtils.internalError((Throwable)e);
                            }
                        }
                    }
                } else {
                    this.fDocument.insertSource(pos, "", lineNr, true);
                    this.fDocument.removeSourcePosition(pos);
                }
            }
        }
    }

    private void updateTitle() {
        if (this.fDebugSessionId == null) {
            String descr = DisassemblyMessages.Disassembly_message_notConnected;
            String title = this.getConfigurationElement().getAttribute("name");
            this.setPartName(title);
            this.setContentDescription(descr);
            this.setTitleToolTip(title);
        } else {
            this.setContentDescription("");
        }
    }

    protected abstract void closePart();

    public void applyTextPresentation(TextPresentation textPresentation) {
        Iterator<Position> it;
        IRegion coverage = textPresentation.getExtent();
        if (coverage == null) {
            coverage = new Region(0, this.fDocument.getLength());
        }
        int startOffset = coverage.getOffset();
        int length = coverage.getLength();
        int endOffset = startOffset + length;
        try {
            AddressRangePosition pos = this.fDocument.getModelPosition(startOffset);
            if (pos == null) {
                assert (false);
                return;
            }
            it = this.fDocument.getPositionIterator("category_model", pos.offset);
        }
        catch (BadPositionCategoryException e) {
            return;
        }
        catch (BadLocationException e) {
            return;
        }
        ArrayList<StyleRange> styleRanges = new ArrayList<StyleRange>();
        while (it.hasNext()) {
            AddressRangePosition pos = (AddressRangePosition)it.next();
            if (pos.offset >= endOffset) break;
            if (pos.offset + pos.length <= startOffset || !pos.fValid || pos.length <= 0) continue;
            if (pos instanceof DisassemblyPosition) {
                DisassemblyPosition disPos = (DisassemblyPosition)pos;
                styleRanges.add(new StyleRange(pos.offset, disPos.length, this.fInstructionColor, null, 0));
                continue;
            }
            if (pos instanceof ErrorPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fErrorColor, null, 0));
                continue;
            }
            if (pos instanceof LabelPosition) {
                styleRanges.add(new StyleRange(pos.offset, pos.length, this.fLabelColor, null, 1));
                continue;
            }
            if (!(pos instanceof SourcePosition)) continue;
            SourcePosition srcPos = (SourcePosition)pos;
            TextPresentation presentation = null;
            if (srcPos.fFileInfo.fSource != null) {
                presentation = srcPos.fFileInfo.getPresentation(srcPos.fFileInfo.getRegion(srcPos.fLine, pos.length));
            }
            if (presentation != null) {
                int start = Math.max(startOffset, srcPos.offset);
                int end = Math.min(endOffset, srcPos.offset + srcPos.length);
                int srcOffset = srcPos.fFileInfo.getLineOffset(srcPos.fLine);
                int clipOffset = start - srcPos.offset;
                presentation.setResultWindow((IRegion)new Region(srcOffset + clipOffset, end - start));
                Iterator iter = presentation.getNonDefaultStyleRangeIterator();
                while (iter.hasNext()) {
                    StyleRange styleRange = (StyleRange)iter.next();
                    styleRange.start += srcPos.offset + clipOffset;
                    styleRanges.add(styleRange);
                }
                continue;
            }
            styleRanges.add(new StyleRange(pos.offset, pos.length, this.fSourceColor, null, 0));
        }
        if (!styleRanges.isEmpty()) {
            Iterator iter = styleRanges.iterator();
            while (iter.hasNext()) {
                textPresentation.addStyleRange((StyleRange)iter.next());
            }
        }
        if (this.fPCHistory.size() > 1) {
            double bgLuminance = new HSL((RGB)this.fViewer.getTextWidget().getBackground().getRGB()).luminance;
            HSL hsv = new HSL(this.fPCAnnotationRGB);
            double luminanceStep = (bgLuminance - hsv.luminance) / (double)(this.fPCHistorySizeMax + 1);
            hsv.luminance = bgLuminance - luminanceStep * (double)(this.fPCHistorySizeMax - this.fPCHistory.size());
            ListIterator<AddressRangePosition> listIt = this.fPCHistory.listIterator(this.fPCHistory.size());
            while (listIt.hasPrevious()) {
                AddressRangePosition pcPos = listIt.previous();
                hsv.luminance -= luminanceStep;
                if (pcPos.isDeleted) {
                    listIt.remove();
                    continue;
                }
                if (!pcPos.fValid || !pcPos.overlapsWith(startOffset, length)) continue;
                RGB rgb = hsv.toRGB();
                Color pcColor = this.getSharedColors().getColor(rgb);
                Color textColor = null;
                textPresentation.mergeStyleRange(new StyleRange(pcPos.offset, pcPos.length, textColor, pcColor));
            }
        }
    }

    public AddressRangePosition insertSource(AddressRangePosition pos, BigInteger address, String file, int lineNumber) {
        return this.insertSource(pos, address, file, lineNumber, lineNumber);
    }

    public AddressRangePosition insertSource(AddressRangePosition pos, BigInteger address, String file, int firstLine, int lastLine) {
        IPath location;
        assert (DisassemblyPart.isGuiThread());
        Object sourceElement = null;
        sourceElement = this.fFile2Storage.containsKey(file) ? this.fFile2Storage.get(file) : this.fBackend.insertSource((Position)pos, address, file, firstLine);
        if (sourceElement instanceof File) {
            sourceElement = new LocalFileStorage((File)sourceElement);
        } else if (sourceElement instanceof ITranslationUnit && (location = ((ITranslationUnit)sourceElement).getLocation()) != null) {
            sourceElement = new LocalFileStorage(location.toFile());
        }
        if (sourceElement instanceof IStorage) {
            IFile iFile;
            if (!(sourceElement instanceof IFile) && (location = ((IStorage)sourceElement).getFullPath()) != null && (iFile = ResourceLookup.selectFileForLocation((IPath)location, null)) != null && iFile.isAccessible()) {
                sourceElement = iFile;
            }
            this.fFile2Storage.put(file, sourceElement);
        } else if (sourceElement == null) {
            if (!this.fFile2Storage.containsKey(file)) {
                this.logWarning(String.valueOf(DisassemblyMessages.Disassembly_log_error_locateFile) + file, null);
                this.fFile2Storage.put(file, null);
            }
        } else {
            this.fFile2Storage.put(file, null);
            assert (false) : "missing support for source element of type " + sourceElement.getClass().toString();
        }
        if (sourceElement instanceof IStorage) {
            SourceFileInfo fi = this.fDocument.getSourceInfo((IStorage)sourceElement);
            if (fi == null) {
                IStorage storage = (IStorage)sourceElement;
                Display display = this.getSite().getShell().getDisplay();
                SourceColorerJob done = new SourceColorerJob(display, storage, this);
                fi = this.fDocument.createSourceInfo(file, storage, done);
                EditionFinderJob editionJob = null;
                if (storage instanceof IFile) {
                    editionJob = new EditionFinderJob(fi, address, this);
                    editionJob.schedule();
                }
                fi.fReadingJob.schedule();
            }
            pos = this.fDocument.insertInvalidSource(pos, address, fi, firstLine, lastLine);
        }
        return pos;
    }

    public AddressBarContributionItem getAddressBar() {
        return this.fAddressBar;
    }

    public void generateErrorDialog(String message) {
        MessageDialog messageDialog = new MessageDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), DisassemblyMessages.Disassembly_Error_Dialog_title, null, message, 1, new String[]{DisassemblyMessages.Disassembly_Error_Dialog_ok_button}, 0);
        messageDialog.open();
    }

    public void activateDisassemblyContext() {
        IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
        if (ctxService != null) {
            this.fContextActivation = ctxService.activateContext(KEY_BINDING_CONTEXT_DISASSEMBLY);
        }
    }

    public void deactivateDisassemblyContext() {
        if (this.fContextActivation != null) {
            IContextService ctxService = (IContextService)this.getSite().getService(IContextService.class);
            ctxService.deactivateContext(this.fContextActivation);
        }
    }

    public void handleTargetSuspended() {
        this.asyncExec(() -> {
            this.updatePC(PC_UNKNOWN);
            this.firePropertyChange(1287);
        });
    }

    public void handleTargetResumed() {
        this.asyncExec(() -> {
            this.updatePC(PC_RUNNING);
            this.firePropertyChange(1287);
        });
    }

    public void handleTargetEnded() {
        this.asyncExec(() -> {
            this.fDebugSessionId = null;
            this.startUpdate(() -> this.debugContextChanged());
        });
    }

    public void setUpdatePending(boolean pending) {
        this.fUpdatePending = pending;
    }

    public boolean getUpdatePending() {
        assert (DisassemblyPart.isGuiThread());
        return this.fUpdatePending;
    }

    public void setGotoAddressPending(BigInteger address) {
        assert (DisassemblyPart.isGuiThread());
        this.fGotoAddressPending = address;
    }

    public BigInteger getGotoAddressPending() {
        assert (DisassemblyPart.isGuiThread());
        return this.fGotoAddressPending;
    }

    public IDisassemblyDocument getDocument() {
        assert (DisassemblyPart.isGuiThread());
        return this.fDocument;
    }

    public Object getStorageForFile(String file) {
        assert (DisassemblyPart.isGuiThread());
        return this.fFile2Storage.get(file);
    }

    public String getHoverInfoData(AddressRangePosition pos, String ident) {
        if (this.fBackend != null) {
            return this.fBackend.getHoverInfoData(pos, ident);
        }
        return "";
    }

    public String evaluateRegister(String register) {
        if (this.fBackend != null) {
            return this.fBackend.evaluateRegister(register);
        }
        return "";
    }

    public String evaluateExpression(String expr) {
        if (this.fBackend != null) {
            return this.fBackend.evaluateExpression(expr);
        }
        return "";
    }

    public BigInteger eval(String expr, boolean suppressError) {
        if (this.fBackend != null) {
            BigInteger address;
            block7: {
                address = null;
                if (this.fBackend instanceof AbstractDisassemblyBackend) {
                    address = ((AbstractDisassemblyBackend)this.fBackend).evaluateAddressExpression(expr, suppressError);
                } else {
                    String value = this.fBackend.evaluateExpression(expr);
                    if (value != null) {
                        try {
                            address = DisassemblyUtils.decodeAddress((String)value);
                        }
                        catch (NumberFormatException e) {
                            if (suppressError) break block7;
                            this.generateErrorDialog(DisassemblyMessages.Disassembly_log_error_expression_eval);
                        }
                    }
                }
            }
            if (address != null) {
                return address;
            }
        }
        return PC_UNKNOWN;
    }

    protected boolean isTrackExpression() {
        return this.fTrackExpression;
    }

    private void setTrackExpression(boolean track) {
        this.fTrackExpression = track;
    }

    protected boolean isSyncWithActiveDebugContext() {
        return this.fSynchWithActiveDebugContext;
    }

    /*
     * Unable to fully structure code
     */
    private void setSyncWithDebugView(boolean sync) {
        block1: {
            this.fSynchWithActiveDebugContext = sync;
            this.fTrackExpressionAction.setEnabled(sync == false);
            if (!sync) ** GOTO lbl8
            this.gotoActiveFrameByUser();
            break block1;
lbl-1000:
            // 1 sources

            {
                pos = this.fPCHistory.removeFirst();
                this.fViewer.invalidateTextPresentation(pos.offset, pos.length);
lbl8:
                // 2 sources

                ** while (!this.fPCHistory.isEmpty())
            }
lbl9:
            // 1 sources

            this.fTargetFrame = -2;
            this.updatePCAnnotation();
        }
    }

    private static boolean isGuiThread() {
        return Display.getCurrent() != null;
    }

    boolean keyScroll(int keyCode) {
        BigInteger topAddress = this.getTopAddress();
        BigInteger bottomAddress = this.getBottomAddress();
        BigInteger addressRange = bottomAddress.subtract(topAddress);
        StyledText styledText = this.fViewer.getTextWidget();
        Rectangle clientArea = styledText.getClientArea();
        int lineRange = 0x1000005 == keyCode || 0x1000006 == keyCode ? clientArea.height / styledText.getLineHeight() : 1;
        addressRange = addressRange.min(BigInteger.valueOf(lineRange * this.fDocument.getMeanSizeOfInstructions()));
        BigInteger scrollToAddress = switch (keyCode) {
            case 0x1000001, 0x1000005 -> topAddress.subtract(addressRange).max(this.fStartAddress);
            case 0x1000006 -> topAddress.add(addressRange).min(bottomAddress);
            case 0x1000002 -> bottomAddress.add(addressRange).min(bottomAddress);
            default -> {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                yield this.fFocusAddress;
            }
        };
        AddressRangePosition pos = this.getPositionOfAddress(scrollToAddress);
        if (pos != null && pos.fValid) {
            if (0x1000002 == keyCode && pos.fAddressOffset.compareTo(bottomAddress) <= 0 || 0x1000001 == keyCode && pos.fAddressOffset.compareTo(topAddress) >= 0) {
                return false;
            }
            this.gotoPosition((Position)pos, 0x1000002 != keyCode);
        } else {
            this.gotoAddress(scrollToAddress);
        }
        return true;
    }

    private BigInteger getBottomAddress() {
        BigInteger bottomAddress = this.getAddressOfLine(this.fViewer.getBottomIndex());
        if (bottomAddress == null || bottomAddress.equals(PC_UNKNOWN)) {
            bottomAddress = this.fEndAddress.subtract(BigInteger.ONE);
        }
        return bottomAddress;
    }

    public void refresh() {
        this.fBackend.clearCaches();
        this.asyncExec(() -> this.updatePC(PC_UNKNOWN));
    }

    private final class ActionRefreshView
    extends AbstractDisassemblyAction {
        public ActionRefreshView() {
            super(DisassemblyPart.this);
            this.setText(DisassemblyMessages.Disassembly_action_RefreshView_label);
            this.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_enabled));
            this.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Refresh_disabled));
        }

        @Override
        public void run() {
            DisassemblyPart.this.refresh();
        }
    }

    private final class ActionToggleBreakpointEnablement
    extends AbstractDisassemblyAction {
        private IBreakpoint fBreakpoint;

        public ActionToggleBreakpointEnablement() {
            super(DisassemblyPart.this);
            this.setText(String.valueOf(DisassemblyMessages.Disassembly_action_EnableBreakpoint_label) + "\t" + CDebugUIUtils.formatKeyBindingString((int)SWT.MOD2, (String)DisassemblyMessages.Disassembly_action_ToggleBreakpoint_accelerator));
        }

        @Override
        public void run() {
            try {
                this.fBreakpoint.setEnabled(!this.fBreakpoint.isEnabled());
            }
            catch (CoreException e) {
                DisassemblyUtils.internalError((Throwable)e);
            }
        }

        @Override
        public void update() {
            super.update();
            if (this.isEnabled()) {
                int line = DisassemblyPart.this.fVerticalRuler.getLineOfLastMouseButtonActivity();
                IBreakpoint[] bps = DisassemblyPart.this.getBreakpointsAtLine(line);
                if (bps == null || bps.length == 0) {
                    this.setEnabled(false);
                } else {
                    this.fBreakpoint = bps[0];
                    try {
                        if (this.fBreakpoint.isEnabled()) {
                            this.setText(String.valueOf(DisassemblyMessages.Disassembly_action_DisableBreakpoint_label) + "\t" + CDebugUIUtils.formatKeyBindingString((int)SWT.MOD2, (String)DisassemblyMessages.Disassembly_action_ToggleBreakpoint_accelerator));
                        } else {
                            this.setText(String.valueOf(DisassemblyMessages.Disassembly_action_EnableBreakpoint_label) + "\t" + CDebugUIUtils.formatKeyBindingString((int)SWT.MOD2, (String)DisassemblyMessages.Disassembly_action_ToggleBreakpoint_accelerator));
                        }
                    }
                    catch (CoreException e) {
                        this.setEnabled(false);
                    }
                }
            }
        }
    }

    private final class ActionToggleSource
    extends AbstractDisassemblyAction {
        public ActionToggleSource() {
            super(DisassemblyPart.this, 2);
            this.setText(DisassemblyMessages.Disassembly_action_ShowSource_label);
        }

        @Override
        public void run() {
            IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
            store.setValue("disassembly.showSource", !DisassemblyPart.this.fShowSource);
        }

        @Override
        public void update() {
            super.update();
            if (this.isEnabled()) {
                this.setEnabled(DisassemblyPart.this.fShowDisassembly);
            }
            this.setChecked(DisassemblyPart.this.fShowSource);
        }
    }

    private final class ActionToggleSymbols
    extends AbstractDisassemblyAction {
        public ActionToggleSymbols() {
            super(DisassemblyPart.this, 2);
            this.setText(DisassemblyMessages.Disassembly_action_ShowSymbols_label);
        }

        @Override
        public void run() {
            IPreferenceStore store = DsfUIPlugin.getDefault().getPreferenceStore();
            store.setValue("disassembly.showSymbols", !DisassemblyPart.this.fShowSymbols);
        }

        @Override
        public void update() {
            super.update();
            this.setChecked(DisassemblyPart.this.fShowSymbols);
        }
    }

    class PropertyChangeListener
    implements IPropertyChangeListener {
        PropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            DisassemblyPart.this.handlePreferenceStoreChanged(event);
        }
    }

    private final class SyncActiveDebugContextAction
    extends Action {
        public SyncActiveDebugContextAction() {
            this.setChecked(DisassemblyPart.this.isSyncWithActiveDebugContext());
            this.setText(DisassemblyMessages.Disassembly_action_Sync_label);
            this.setImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Sync_enabled));
            this.setDisabledImageDescriptor(DisassemblyImageRegistry.getImageDescriptor(DisassemblyImageRegistry.ICON_Sync_disabled));
        }

        public void run() {
            DisassemblyPart.this.setSyncWithDebugView(this.isChecked());
        }
    }

    private final class TrackExpressionAction
    extends Action {
        public TrackExpressionAction() {
            this.setChecked(DisassemblyPart.this.isTrackExpression());
            this.setEnabled(!DisassemblyPart.this.fSynchWithActiveDebugContext);
            this.setText(DisassemblyMessages.Disassembly_action_TrackExpression_label);
        }

        public void run() {
            DisassemblyPart.this.setTrackExpression(this.isChecked());
        }
    }
}

