/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sap.maxdb.internal.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import org.eclipse.datatools.connectivity.IConnectionProfile;
import org.eclipse.datatools.connectivity.Version;
import org.eclipse.datatools.connectivity.drivers.jdbc.JDBCConnection;
import org.eclipse.datatools.enablement.sap.maxdb.MaxDBEnablementPlugin;

public class JDBCMaxDBJDBCConnection
extends JDBCConnection {
    private Version mMaxDBServerVersion = Version.NULL_VERSION;

    public JDBCMaxDBJDBCConnection(IConnectionProfile profile, Class factoryClass) {
        super(profile, factoryClass);
    }

    public Version getProviderVersion() {
        return this.mMaxDBServerVersion;
    }

    public String getProviderName() {
        return MaxDBEnablementPlugin.getResourceString("MaxDBName");
    }

    protected void initVersions() {
        String versionString = "";
        try {
            super.initVersions();
            DatabaseMetaData dbmd = ((Connection)this.getRawConnection()).getMetaData();
            versionString = dbmd.getDatabaseProductVersion();
            this.parseVersion(versionString);
        }
        catch (Exception exception) {
            this.mMaxDBServerVersion = Version.valueOf((String)versionString);
        }
    }

    private void parseVersion(String versionStr) {
        int startpos = 0;
        int endpos = 0;
        int curpos = 0;
        versionStr = versionStr.substring(10);
        while (Character.isSpaceChar(versionStr.charAt(curpos))) {
            ++curpos;
        }
        startpos = curpos;
        while (versionStr.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        int majorVersion = Integer.parseInt(versionStr.substring(startpos, endpos));
        startpos = curpos;
        while (versionStr.charAt(curpos) != '.') {
            ++curpos;
        }
        endpos = curpos++;
        int minorVersion = Integer.parseInt(versionStr.substring(startpos, endpos));
        startpos = curpos;
        while (!Character.isSpaceChar(versionStr.charAt(curpos))) {
            ++curpos;
        }
        endpos = curpos;
        int clVersion = Integer.parseInt(versionStr.substring(startpos, endpos));
        while (Character.isSpaceChar(versionStr.charAt(curpos))) {
            ++curpos;
        }
        this.mMaxDBServerVersion = new Version(majorVersion, minorVersion, clVersion, "");
    }
}

