/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.session;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDUtil;
import org.eclipse.emf.cdo.common.lock.CDOLockDelta;
import org.eclipse.emf.cdo.common.lock.CDOLockOwner;
import org.eclipse.emf.cdo.common.lock.CDOLockState;
import org.eclipse.emf.cdo.common.lock.CDOLockUtil;
import org.eclipse.emf.cdo.common.revision.CDOIDAndBranch;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.spi.common.lock.AbstractCDOLockState;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewTargetChangedEvent;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.spi.cdo.CDOLockStateCache;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.ImplementationError;
import org.eclipse.net4j.util.ObjectUtil;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.collection.CollectionUtil;
import org.eclipse.net4j.util.collection.HashBag;
import org.eclipse.net4j.util.collection.Pair;
import org.eclipse.net4j.util.concurrent.IRWLockManager;
import org.eclipse.net4j.util.container.ContainerEventAdapter;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.lifecycle.ILifecycle;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.om.OMPlatform;

public final class CDOLockStateCacheImpl
extends Lifecycle
implements CDOLockStateCache {
    private static final Class<CDOLockOwner[]> ARRAY_CLASS = CDOLockOwner[].class;
    private static final boolean DEBUG = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.internal.cdo.session.CDOLockStateCacheImpl.DEBUG");
    private static final boolean DEBUG_STACK_TRACE = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.internal.cdo.session.CDOLockStateCacheImpl.DEBUG_STACK_TRACE");
    private final Map<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> ownerInfosPerBranch = new HashMap<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>>();
    private final ConcurrentMap<CDOID, OwnerInfo> ownerInfosOfMainBranch = new ConcurrentHashMap<CDOID, OwnerInfo>();
    private final ConcurrentMap<CDOLockOwner, SingleOwnerInfo>[] singleOwnerInfos = new ConcurrentMap[]{new ConcurrentHashMap(), new ConcurrentHashMap(), new ConcurrentHashMap(), new ConcurrentHashMap(), new ConcurrentHashMap()};
    private final InternalCDOSession session;
    private final IListener sessionListener = new ContainerEventAdapter<CDOView>(){

        protected void onAdded(IContainer<CDOView> container, CDOView view) {
            CDOLockStateCacheImpl.this.viewAdded(view);
        }

        protected void onRemoved(IContainer<CDOView> container, CDOView view) {
            CDOLockStateCacheImpl.this.viewRemoved(view);
        }

        protected void onDeactivated(ILifecycle lifecycle) {
            CDOLockStateCacheImpl.this.deactivate();
        }
    };
    private final IListener viewListener = new IListener(){

        public void notifyEvent(IEvent event) {
            if (event instanceof CDOViewTargetChangedEvent) {
                CDOViewTargetChangedEvent e = (CDOViewTargetChangedEvent)event;
                CDOLockStateCacheImpl.this.viewTargetChanged(e.getSource(), e.getOldBranchPoint(), e.getBranchPoint());
            }
        }
    };
    private final boolean branching;
    private final CDOBranch mainBranch;
    private final HashBag<CDOBranch> branches = new HashBag();

    public CDOLockStateCacheImpl(CDOSession session) {
        this.session = (InternalCDOSession)session;
        this.branching = session.getRepositoryInfo().isSupportingBranches();
        this.mainBranch = session.getBranchManager().getMainBranch();
        this.ownerInfosPerBranch.put(this.mainBranch, this.ownerInfosOfMainBranch);
        this.activate();
    }

    @Override
    public InternalCDOSession getSession() {
        return this.session;
    }

    @Override
    public Object createKey(CDOBranch branch, CDOID id) {
        if (this.branching) {
            return CDOIDUtil.createIDAndBranch((CDOID)id, (CDOBranch)branch);
        }
        return id;
    }

    @Override
    public CDOLockState getLockState(CDOBranch branch, CDOID id) {
        Object key = this.createKey(branch, id);
        return new LockState(key, this);
    }

    @Override
    public void getLockStates(CDOBranch branch, Collection<CDOID> ids, boolean loadOnDemand, Consumer<CDOLockState> consumer) {
        if (ids == null) {
            if (loadOnDemand) {
                this.loadLockStates(branch, null, consumer);
            } else {
                this.collectLockStates(branch, ids, null, consumer);
            }
        } else {
            HashSet<CDOID> missingIDs = loadOnDemand ? new HashSet<CDOID>() : null;
            this.collectLockStates(branch, ids, missingIDs, consumer);
            if (!ObjectUtil.isEmpty(missingIDs)) {
                this.loadLockStates(branch, missingIDs, lockState -> {
                    missingIDs.remove(lockState.getID());
                    consumer.accept((CDOLockState)lockState);
                });
                int size = missingIDs.size();
                if (size != 0) {
                    ArrayList<CDOLockState> defaultLockStatesToCache = new ArrayList<CDOLockState>(size);
                    for (CDOID id : missingIDs) {
                        CDOLockState defaultLockStateToCache = this.getLockState(branch, id);
                        defaultLockStatesToCache.add(defaultLockStateToCache);
                    }
                    this.addLockStates(branch, defaultLockStatesToCache, consumer);
                }
            }
        }
    }

    @Override
    public void forEachLockState(CDOBranch branch, CDOLockOwner owner, Consumer<CDOLockState> consumer) {
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        infos.forEach((id, info) -> {
            if (info.isLocked(null, owner, false)) {
                this.notifyConsumer(branch, (CDOID)id, consumer);
            }
        });
    }

    @Override
    public synchronized void updateLockStates(CDOBranch branch, Collection<CDOLockDelta> lockDeltas, Collection<CDOLockState> lockStates, Consumer<CDOLockState> consumer) {
        try {
            ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
            block7: for (CDOLockDelta delta : lockDeltas) {
                CDOID id = delta.getID();
                OwnerInfo info = null;
                OwnerInfo newInfo = null;
                int i = 50;
                while (i >= 0) {
                    info = (OwnerInfo)infos.get(id);
                    if (info == null || delta.getType() == null) {
                        for (CDOLockState cDOLockState : lockStates) {
                            if (cDOLockState.getID() != id) continue;
                            this.addLockState(infos, cDOLockState, consumer);
                            continue block7;
                        }
                        continue block7;
                    }
                    try {
                        newInfo = info.applyDelta(this, delta);
                        break;
                    }
                    catch (CDOLockStateCache.ObjectAlreadyLockedException objectAlreadyLockedException) {
                        if (i == 0) {
                            throw new CDOLockStateCache.ObjectAlreadyLockedException(id, branch, objectAlreadyLockedException);
                        }
                        try {
                            this.wait(100L);
                        }
                        catch (InterruptedException ex1) {
                            throw new Error(ex1);
                        }
                        --i;
                    }
                }
                if (newInfo != info) {
                    this.trace(id, info, newInfo);
                    infos.put(id, newInfo);
                }
                if (consumer == null) continue;
                Object target = delta.getTarget();
                LockState lockState = new LockState(target, this);
                consumer.accept((CDOLockState)lockState);
            }
        }
        finally {
            this.notifyAll();
        }
    }

    @Override
    public void addLockStates(CDOBranch branch, Collection<? extends CDOLockState> lockStates, Consumer<CDOLockState> consumer) {
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        for (CDOLockState cDOLockState : lockStates) {
            try {
                this.addLockState(infos, cDOLockState, consumer);
            }
            catch (Exception ex) {
                OM.LOG.error((Throwable)ex);
            }
        }
    }

    @Override
    public List<CDOLockDelta> removeOwner(CDOBranch branch, CDOLockOwner owner, Consumer<CDOLockState> consumer) {
        ArrayList<CDOLockDelta> deltas = new ArrayList<CDOLockDelta>();
        ArrayList newInfos = new ArrayList();
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        infos.forEach((id, info) -> {
            OwnerInfo newInfo = info.removeOwner(this, owner, (IRWLockManager.LockType lockType) -> {
                boolean bl = this.appendRemoveDelta((List<CDOLockDelta>)deltas, branch, (CDOID)id, (IRWLockManager.LockType)lockType, owner);
            });
            if (newInfo != info) {
                newInfos.add(Pair.create((Object)id, (Object)newInfo));
                this.notifyConsumer(branch, (CDOID)id, consumer);
            }
        });
        for (Pair pair : newInfos) {
            CDOID id2 = (CDOID)pair.getElement1();
            OwnerInfo newInfo = (OwnerInfo)pair.getElement2();
            OwnerInfo oldInfo = infos.put(id2, newInfo);
            this.trace(id2, oldInfo, newInfo);
        }
        return deltas;
    }

    @Override
    public void remapOwner(CDOBranch branch, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        int type = 0;
        while (type < this.singleOwnerInfos.length) {
            for (OwnerInfo info : this.singleOwnerInfos[type].values()) {
                this.remapOwnerInfo(info, oldOwner, newOwner);
            }
            ++type;
        }
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        for (OwnerInfo info : infos.values()) {
            this.remapOwnerInfo(info, oldOwner, newOwner);
        }
    }

    @Override
    public void removeLockStates(CDOBranch branch, Collection<CDOID> ids, Consumer<CDOLockState> consumer) {
        if (ObjectUtil.isEmpty(ids)) {
            return;
        }
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        for (CDOID id : ids) {
            OwnerInfo info = (OwnerInfo)infos.remove(id);
            if (info == null) continue;
            this.notifyConsumer(branch, id, consumer);
        }
    }

    @Override
    public void removeLockStates(CDOBranch branch) {
        ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
        infos.clear();
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.session.addListener(this.sessionListener);
    }

    protected void doDeactivate() throws Exception {
        this.session.removeListener(this.sessionListener);
        super.doDeactivate();
    }

    private void viewAdded(CDOView view) {
        CDOLockOwner owner = view.getLockOwner();
        this.addSingleOwnerInfos(owner, -1);
        CDOBranch branch = view.getBranch();
        this.addBranch(branch);
        view.addListener(this.viewListener);
    }

    private void viewRemoved(CDOView view) {
        view.removeListener(this.viewListener);
        CDOBranch branch = view.getBranch();
        this.removeBranch(branch);
        CDOLockOwner owner = view.getLockOwner();
        this.removeSingleOwnerInfos(owner);
    }

    private void viewTargetChanged(CDOView view, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
        CDOBranch oldBranch = oldBranchPoint.getBranch();
        CDOBranch newBranch = newBranchPoint.getBranch();
        if (newBranch != oldBranch) {
            this.removeBranch(oldBranch);
            this.addBranch(newBranch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBranch(CDOBranch branch) {
        HashBag<CDOBranch> hashBag = this.branches;
        synchronized (hashBag) {
            if (this.branches.addAndGet((Object)branch, 1) == 1 && !branch.isMainBranch()) {
                Map<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> map = this.ownerInfosPerBranch;
                synchronized (map) {
                    this.ownerInfosPerBranch.put(branch, new ConcurrentHashMap());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeBranch(CDOBranch branch) {
        HashBag<CDOBranch> hashBag = this.branches;
        synchronized (hashBag) {
            if (this.branches.removeAndGet((Object)branch, 1) == 0 && !branch.isMainBranch()) {
                Map<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> map = this.ownerInfosPerBranch;
                synchronized (map) {
                    this.ownerInfosPerBranch.remove(branch);
                }
            }
        }
    }

    private SingleOwnerInfo addSingleOwnerInfos(CDOLockOwner owner, int typeToReturn) {
        SingleOwnerInfo infoToReturn = null;
        int type = 0;
        while (type < this.singleOwnerInfos.length) {
            int finalType = type;
            SingleOwnerInfo info = this.singleOwnerInfos[type].computeIfAbsent(owner, o -> SingleOwnerInfo.create(o, finalType));
            if (type == typeToReturn) {
                infoToReturn = info;
            }
            ++type;
        }
        return infoToReturn;
    }

    private void removeSingleOwnerInfos(CDOLockOwner owner) {
        int type = 0;
        while (type < this.singleOwnerInfos.length) {
            this.singleOwnerInfos[type].remove(owner);
            ++type;
        }
    }

    private <T> T withKey(Object key, BiFunction<CDOBranch, CDOID, T> function) {
        CDOID id;
        CDOBranch branch;
        if (this.branching) {
            CDOIDAndBranch idAndBranch = (CDOIDAndBranch)key;
            branch = idAndBranch.getBranch();
            id = idAndBranch.getID();
        } else {
            branch = this.mainBranch;
            id = (CDOID)key;
        }
        return function.apply(branch, id);
    }

    private void notifyConsumer(CDOBranch branch, CDOID id, Consumer<CDOLockState> consumer) {
        if (consumer != null) {
            CDOLockState lockState = this.getLockState(branch, id);
            consumer.accept(lockState);
        }
    }

    private SingleOwnerInfo getSingleOwnerInfo(CDOLockOwner owner, int type) {
        SingleOwnerInfo info = (SingleOwnerInfo)this.singleOwnerInfos[type].get(owner);
        if (info == null) {
            info = this.addSingleOwnerInfos(owner, type);
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConcurrentMap<CDOID, OwnerInfo> getOwnerInfoMap(CDOBranch branch) {
        if (branch.isMainBranch()) {
            return this.ownerInfosOfMainBranch;
        }
        Map<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> map = this.ownerInfosPerBranch;
        synchronized (map) {
            return this.ownerInfosPerBranch.get(branch);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map.Entry<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>>[] getOwnerInfoMapEntries() {
        Map<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> map = this.ownerInfosPerBranch;
        synchronized (map) {
            return this.ownerInfosPerBranch.entrySet().toArray(new Map.Entry[this.ownerInfosPerBranch.size()]);
        }
    }

    private OwnerInfo getOwnerInfo(Object key) {
        return this.withKey(key, (branch, id) -> {
            ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap((CDOBranch)branch);
            return this.getOwnerInfo(infos, (CDOBranch)branch, (CDOID)id);
        });
    }

    private OwnerInfo getOwnerInfo(ConcurrentMap<CDOID, OwnerInfo> infos, CDOBranch branch, CDOID id) {
        OwnerInfo info = (OwnerInfo)infos.get(id);
        if (info == null) {
            return NoOwnerInfo.INSTANCE;
        }
        return info;
    }

    private boolean changeOwnerInfo(Object key, CDOLockOwner owner, BiFunction<OwnerInfo, CDOLockOwner, OwnerInfo> changer) {
        return this.withKey(key, (branch, id) -> {
            boolean[] changed = new boolean[1];
            ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap((CDOBranch)branch);
            CollectionUtil.compute(infos, (Object)id, (unused, info) -> {
                OwnerInfo newInfo;
                if (info == null) {
                    info = NoOwnerInfo.INSTANCE;
                }
                if ((newInfo = (OwnerInfo)changer.apply((OwnerInfo)info, owner)) != info) {
                    this.trace((CDOID)id, (OwnerInfo)info, newInfo);
                    blArray[0] = true;
                    return newInfo;
                }
                throw new CollectionUtil.KeepMappedValue(info);
            });
            return changed[0];
        });
    }

    private void remapOwnerInfo(OwnerInfo info, CDOLockOwner oldOwner, CDOLockOwner newOwner) {
        if (info.remapOwner(oldOwner, newOwner) && DEBUG) {
            IOUtil.OUT().println("Remap owner: " + info);
        }
    }

    private void collectLockStates(CDOBranch branch, Collection<CDOID> ids, Set<CDOID> missingIDs, Consumer<CDOLockState> consumer) {
        if (branch != null) {
            ConcurrentMap<CDOID, OwnerInfo> infos = this.getOwnerInfoMap(branch);
            this.collectLockStates(branch, ids, infos, missingIDs, consumer);
        } else {
            Map.Entry<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>>[] entryArray = this.getOwnerInfoMapEntries();
            int n = entryArray.length;
            int n2 = 0;
            while (n2 < n) {
                Map.Entry<CDOBranch, ConcurrentMap<CDOID, OwnerInfo>> entry = entryArray[n2];
                CDOBranch infosBranch = entry.getKey();
                ConcurrentMap<CDOID, OwnerInfo> infos = entry.getValue();
                this.collectLockStates(infosBranch, ids, infos, missingIDs, consumer);
                ++n2;
            }
        }
    }

    private void collectLockStates(CDOBranch branch, Collection<CDOID> ids, ConcurrentMap<CDOID, OwnerInfo> infos, Set<CDOID> missingIDs, Consumer<CDOLockState> consumer) {
        for (CDOID id : ids) {
            OwnerInfo info = (OwnerInfo)infos.get(id);
            if (info != null) {
                this.notifyConsumer(branch, id, consumer);
                continue;
            }
            if (missingIDs == null) continue;
            missingIDs.add(id);
        }
    }

    private void loadLockStates(CDOBranch branch, Set<CDOID> ids, Consumer<CDOLockState> consumer) {
        CDOSessionProtocol sessionProtocol = this.session.getSessionProtocol();
        List<CDOLockState> lockStates = sessionProtocol.getLockStates2(branch.getID(), ids, 0);
        this.addLockStates(branch, lockStates, consumer);
    }

    private void addLockState(ConcurrentMap<CDOID, OwnerInfo> infos, CDOLockState lockState, Consumer<CDOLockState> consumer) {
        CDOID id = lockState.getID();
        OwnerInfo info = this.createOwnerInfo(lockState);
        this.trace(id, null, info);
        infos.put(id, info);
        if (consumer != null) {
            consumer.accept(lockState);
        }
    }

    private OwnerInfo createOwnerInfo(CDOLockState lockState) {
        return this.updateOwnerInfo(NoOwnerInfo.INSTANCE, lockState);
    }

    private OwnerInfo updateOwnerInfo(OwnerInfo info, CDOLockState lockState) {
        try {
            for (CDOLockOwner readLockOwner : lockState.getReadLockOwners()) {
                info = info.addReadLockOwner(this, readLockOwner);
            }
            info = info.addWriteLockOwner(this, lockState.getWriteLockOwner());
            info = info.addWriteOptionOwner(this, lockState.getWriteOptionOwner());
        }
        catch (CDOLockStateCache.ObjectAlreadyLockedException ex) {
            CDOBranch branch = lockState.getBranch();
            if (branch == null) {
                branch = this.mainBranch;
            }
            throw new CDOLockStateCache.ObjectAlreadyLockedException(lockState.getID(), branch, ex);
        }
        catch (Error | RuntimeException ex) {
            throw new ImplementationError("Could not modify " + info + " of " + lockState.getLockedObject(), ex);
        }
        return info;
    }

    private boolean appendRemoveDelta(List<CDOLockDelta> deltas, CDOBranch branch, CDOID id, IRWLockManager.LockType lockType, CDOLockOwner owner) {
        return deltas.add(CDOLockUtil.createLockDelta((Object)this.createKey(branch, id), (IRWLockManager.LockType)lockType, (CDOLockOwner)owner, null));
    }

    private static boolean isOwnerInfoLocked(OwnerInfo info, IRWLockManager.LockType lockType, CDOLockOwner lockOwner, boolean others) {
        if (lockType == null) {
            return CDOLockStateCacheImpl.isOwnerInfoReadLocked(info, lockOwner, others) || CDOLockStateCacheImpl.isOwnerInfoWriteLocked(info, lockOwner, others) || CDOLockStateCacheImpl.isOwnerInfoOptionLocked(info, lockOwner, others);
        }
        switch (lockType) {
            case READ: {
                return CDOLockStateCacheImpl.isOwnerInfoReadLocked(info, lockOwner, others);
            }
            case WRITE: {
                return CDOLockStateCacheImpl.isOwnerInfoWriteLocked(info, lockOwner, others);
            }
            case OPTION: {
                return CDOLockStateCacheImpl.isOwnerInfoOptionLocked(info, lockOwner, others);
            }
        }
        return false;
    }

    private static boolean isOwnerInfoReadLocked(OwnerInfo info, CDOLockOwner by, boolean others) {
        boolean contained;
        int n;
        Object readLockOwners = info.getReadLockOwners();
        if (readLockOwners == null) {
            return false;
        }
        if (readLockOwners.getClass() == ARRAY_CLASS) {
            CDOLockOwner[] owners = (CDOLockOwner[])readLockOwners;
            n = owners.length;
            if (n == 0) {
                return false;
            }
            contained = CDOLockUtil.indexOf((CDOLockOwner[])owners, (CDOLockOwner)by) != -1;
        } else {
            n = 1;
            boolean bl = contained = readLockOwners == by;
        }
        if (others) {
            int ownCount;
            int n2 = ownCount = contained ? 1 : 0;
            return n > ownCount;
        }
        return contained;
    }

    private static boolean isOwnerInfoWriteLocked(OwnerInfo info, CDOLockOwner by, boolean others) {
        CDOLockOwner writeLockOwner = info.getWriteLockOwner();
        if (writeLockOwner == null) {
            return false;
        }
        return writeLockOwner == by ^ others;
    }

    private static boolean isOwnerInfoOptionLocked(OwnerInfo info, CDOLockOwner by, boolean others) {
        CDOLockOwner writeOptionOwner = info.getWriteOptionOwner();
        if (writeOptionOwner == null) {
            return false;
        }
        return writeOptionOwner == by ^ others;
    }

    private void trace(CDOID id, OwnerInfo oldInfo, OwnerInfo newInfo) {
        if (DEBUG) {
            String message = "[" + this.session.getSessionID() + "] " + id + ": " + oldInfo + " --> " + newInfo;
            if (DEBUG_STACK_TRACE) {
                message = String.valueOf(message) + "\n" + ReflectUtil.dumpThread();
            }
            IOUtil.OUT().println(message);
        }
    }

    private static final class LockState
    extends AbstractCDOLockState {
        private static final Set<CDOLockOwner> NO_LOCK_OWNERS = Collections.emptySet();
        private final CDOLockStateCacheImpl cache;

        public LockState(Object lockedObject, CDOLockStateCacheImpl cache) {
            super(lockedObject);
            this.cache = cache;
        }

        public final boolean isLocked(IRWLockManager.LockType lockType, CDOLockOwner lockOwner, boolean others) {
            OwnerInfo info = this.getInfo();
            return info.isLocked(lockType, lockOwner, others);
        }

        public final Set<CDOLockOwner> getReadLockOwners() {
            OwnerInfo info = this.getInfo();
            Object readLockOwners = info.getReadLockOwners();
            if (readLockOwners == null) {
                return NO_LOCK_OWNERS;
            }
            if (readLockOwners.getClass() == ARRAY_CLASS) {
                CDOLockOwner[] owners = (CDOLockOwner[])readLockOwners;
                HashSet<CDOLockOwner> result = new HashSet<CDOLockOwner>();
                CDOLockOwner[] cDOLockOwnerArray = owners;
                int n = owners.length;
                int n2 = 0;
                while (n2 < n) {
                    CDOLockOwner owner = cDOLockOwnerArray[n2];
                    result.add(owner);
                    ++n2;
                }
                return Collections.unmodifiableSet(result);
            }
            return Collections.singleton((CDOLockOwner)readLockOwners);
        }

        public final CDOLockOwner getWriteLockOwner() {
            OwnerInfo info = this.getInfo();
            return info.getWriteLockOwner();
        }

        public final CDOLockOwner getWriteOptionOwner() {
            OwnerInfo info = this.getInfo();
            return info.getWriteOptionOwner();
        }

        protected CDOLockDelta addReadOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.addReadLockOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.READ, null, (CDOLockOwner)owner);
            }
            return null;
        }

        protected CDOLockDelta addWriteOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.addWriteLockOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.WRITE, null, (CDOLockOwner)owner);
            }
            return null;
        }

        protected CDOLockDelta addOptionOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.addWriteOptionOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.OPTION, null, (CDOLockOwner)owner);
            }
            return null;
        }

        protected CDOLockDelta removeReadOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.removeReadLockOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.READ, (CDOLockOwner)owner, null);
            }
            return null;
        }

        protected CDOLockDelta removeWriteOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.removeWriteLockOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.WRITE, (CDOLockOwner)owner, null);
            }
            return null;
        }

        protected CDOLockDelta removeOptionOwner(CDOLockOwner owner) {
            if (this.cache.changeOwnerInfo(this.lockedObject, owner, (i, o) -> i.removeWriteOptionOwner(this.cache, (CDOLockOwner)o))) {
                return CDOLockUtil.createLockDelta((Object)this.lockedObject, (IRWLockManager.LockType)IRWLockManager.LockType.OPTION, (CDOLockOwner)owner, null);
            }
            return null;
        }

        private OwnerInfo getInfo() {
            return this.cache.getOwnerInfo(this.lockedObject);
        }

        @Deprecated
        public CDOLockDelta[] remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            throw new UnsupportedOperationException();
        }
    }

    protected static abstract class MultiOwnerInfo
    extends OwnerInfo {
        @Override
        public final CDOLockOwner getWriteLockOwner() {
            return null;
        }

        @Override
        public final OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            if (owner == null) {
                return this;
            }
            throw this.failure(owner, IRWLockManager.LockType.WRITE);
        }

        @Override
        public final OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            return this;
        }

        protected final CDOLockStateCache.ObjectAlreadyLockedException failure(CDOLockOwner owner, IRWLockManager.LockType lockType) {
            String message = owner + " could not acquire the " + lockType + " lock because the READ lock is already acquired by " + this.getReadLockOwners();
            CDOLockOwner writeOptionOwner = this.getWriteOptionOwner();
            if (writeOptionOwner != null) {
                message = String.valueOf(message) + " and the OPTION lock is already acquired by " + writeOptionOwner;
            }
            return new CDOLockStateCache.ObjectAlreadyLockedException(message);
        }

        protected static class ReadLock
        extends MultiOwnerInfo {
            protected final CDOLockOwner[] readLockOwners;

            public ReadLock(CDOLockOwner ... readLockOwners) {
                CheckUtil.checkArg((readLockOwners.length != 0 ? 1 : 0) != 0, (String)"No read lock owners");
                this.readLockOwners = readLockOwners;
            }

            @Override
            public Object getReadLockOwners() {
                return this.readLockOwners;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                CDOLockOwner[] owners = this.readLockOwners;
                if (CDOLockUtil.indexOf((CDOLockOwner[])owners, (CDOLockOwner)owner) == -1) {
                    int oldLength = owners.length;
                    CDOLockOwner[] newOwners = new CDOLockOwner[oldLength + 1];
                    System.arraycopy(owners, 0, newOwners, 0, oldLength);
                    newOwners[oldLength] = owner;
                    return ReadLock.createMultiOwnerInfo(this.getWriteOptionOwner(), newOwners);
                }
                return this;
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                CDOLockOwner[] owners = this.readLockOwners;
                int index = CDOLockUtil.indexOf((CDOLockOwner[])owners, (CDOLockOwner)owner);
                if (index != -1) {
                    int rest;
                    CDOLockOwner writeOptionOwner = this.getWriteOptionOwner();
                    int oldLength = owners.length;
                    if (oldLength == 1) {
                        return cache.getSingleOwnerInfo(writeOptionOwner, 4);
                    }
                    if (oldLength == 2) {
                        CDOLockOwner remainingReadLockOwner = this.readLockOwners[index == 0 ? 1 : 0];
                        if (writeOptionOwner == remainingReadLockOwner) {
                            return cache.getSingleOwnerInfo(writeOptionOwner, 2);
                        }
                        return ReadLock.createMultiOwnerInfo(writeOptionOwner, remainingReadLockOwner);
                    }
                    CDOLockOwner[] newOwners = new CDOLockOwner[oldLength - 1];
                    if (index > 0) {
                        System.arraycopy(owners, 0, newOwners, 0, index);
                    }
                    if ((rest = oldLength - index - 1) > 0) {
                        System.arraycopy(owners, index + 1, newOwners, index, rest);
                    }
                    return ReadLock.createMultiOwnerInfo(writeOptionOwner, newOwners);
                }
                return this;
            }

            @Override
            public CDOLockOwner getWriteOptionOwner() {
                return null;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                return new ReadLockAndWriteOption(owner, this.readLockOwners);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo removeOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner, Consumer<IRWLockManager.LockType> consumer) {
                OwnerInfo newInfo = this.removeReadLockOwner(cache, owner);
                if (newInfo != this) {
                    consumer.accept(IRWLockManager.LockType.READ);
                }
                return newInfo;
            }

            @Override
            public boolean remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
                CDOLockOwner[] owners = this.readLockOwners;
                int index = CDOLockUtil.indexOf((CDOLockOwner[])owners, (CDOLockOwner)oldOwner);
                if (index != -1) {
                    this.readLockOwners[index] = newOwner;
                    return true;
                }
                return false;
            }

            @Override
            public String toString() {
                return String.valueOf(super.toString()) + "[readLockOwners=" + Arrays.asList(this.readLockOwners) + "]";
            }

            private static MultiOwnerInfo createMultiOwnerInfo(CDOLockOwner writeOptionOwner, CDOLockOwner ... readLockOwners) {
                if (writeOptionOwner != null) {
                    return new ReadLockAndWriteOption(writeOptionOwner, readLockOwners);
                }
                return new ReadLock(readLockOwners);
            }
        }

        protected static final class ReadLockAndWriteOption
        extends ReadLock {
            private CDOLockOwner writeOptionOwner;

            public ReadLockAndWriteOption(CDOLockOwner writeOptionOwner, CDOLockOwner ... readLockOwners) {
                super(readLockOwners);
                this.writeOptionOwner = writeOptionOwner;
            }

            @Override
            public CDOLockOwner getWriteOptionOwner() {
                return this.writeOptionOwner;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.writeOptionOwner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.OPTION);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.writeOptionOwner) {
                    return new ReadLock(this.readLockOwners);
                }
                return this;
            }

            @Override
            public OwnerInfo removeOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner, Consumer<IRWLockManager.LockType> consumer) {
                OwnerInfo newInfo = super.removeOwner(cache, owner, consumer);
                if (owner == newInfo.getWriteOptionOwner()) {
                    consumer.accept(IRWLockManager.LockType.OPTION);
                    return newInfo.removeWriteOptionOwner(cache, owner);
                }
                return newInfo;
            }

            @Override
            public boolean remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
                boolean remapped = super.remapOwner(oldOwner, newOwner);
                if (this.writeOptionOwner == oldOwner) {
                    this.writeOptionOwner = newOwner;
                    remapped = true;
                }
                return remapped;
            }

            @Override
            public String toString() {
                return String.valueOf(super.toString()) + "[readLockOwners=" + Arrays.asList(this.readLockOwners) + ", writeOptionOwner=" + this.writeOptionOwner + "]";
            }
        }
    }

    protected static final class NoOwnerInfo
    extends OwnerInfo {
        public static final OwnerInfo INSTANCE = new NoOwnerInfo();

        private NoOwnerInfo() {
        }

        @Override
        public Object getReadLockOwners() {
            return null;
        }

        @Override
        public CDOLockOwner getWriteLockOwner() {
            return null;
        }

        @Override
        public CDOLockOwner getWriteOptionOwner() {
            return null;
        }

        @Override
        public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            if (owner == null) {
                return this;
            }
            return cache.getSingleOwnerInfo(owner, 0);
        }

        @Override
        public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            return this;
        }

        @Override
        public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            if (owner == null) {
                return this;
            }
            return cache.getSingleOwnerInfo(owner, 3);
        }

        @Override
        public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            return this;
        }

        @Override
        public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            if (owner == null) {
                return this;
            }
            return cache.getSingleOwnerInfo(owner, 4);
        }

        @Override
        public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
            return this;
        }

        @Override
        public OwnerInfo removeOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner, Consumer<IRWLockManager.LockType> consumer) {
            return this;
        }

        @Override
        public boolean remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            return false;
        }
    }

    protected static abstract class OwnerInfo {
        public final boolean isLocked(IRWLockManager.LockType lockType, CDOLockOwner lockOwner, boolean others) {
            return CDOLockStateCacheImpl.isOwnerInfoLocked(this, lockType, lockOwner, others);
        }

        public abstract Object getReadLockOwners();

        public abstract CDOLockOwner getWriteLockOwner();

        public abstract CDOLockOwner getWriteOptionOwner();

        public abstract OwnerInfo addReadLockOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2);

        public abstract OwnerInfo removeOwner(CDOLockStateCacheImpl var1, CDOLockOwner var2, Consumer<IRWLockManager.LockType> var3);

        public abstract boolean remapOwner(CDOLockOwner var1, CDOLockOwner var2);

        public final OwnerInfo applyDelta(CDOLockStateCacheImpl cache, CDOLockDelta delta) {
            OwnerInfo info = this;
            CDOLockOwner oldOwner = delta.getOldOwner();
            CDOLockOwner newOwner = delta.getNewOwner();
            switch (delta.getType()) {
                case READ: {
                    if (oldOwner != null) {
                        info = info.removeReadLockOwner(cache, oldOwner);
                    }
                    if (newOwner == null) break;
                    info = info.addReadLockOwner(cache, newOwner);
                    break;
                }
                case OPTION: {
                    if (oldOwner != null) {
                        info = info.removeWriteOptionOwner(cache, oldOwner);
                    }
                    if (newOwner == null) break;
                    info = info.addWriteOptionOwner(cache, newOwner);
                    break;
                }
                case WRITE: {
                    if (oldOwner != null) {
                        info = info.removeWriteLockOwner(cache, oldOwner);
                    }
                    if (newOwner == null) break;
                    info = info.addWriteLockOwner(cache, newOwner);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            return info;
        }

        public String toString() {
            String name = this.getClass().getName();
            name = name.replace(String.valueOf(CDOLockStateCacheImpl.class.getName()) + "$", "");
            name = name.replace('$', '.');
            return name;
        }
    }

    protected static abstract class SingleOwnerInfo
    extends OwnerInfo {
        protected CDOLockOwner owner;

        public SingleOwnerInfo(CDOLockOwner owner) {
            this.owner = owner;
        }

        @Override
        public Object getReadLockOwners() {
            return null;
        }

        @Override
        public CDOLockOwner getWriteLockOwner() {
            return null;
        }

        @Override
        public CDOLockOwner getWriteOptionOwner() {
            return null;
        }

        @Override
        public final OwnerInfo removeOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner, Consumer<IRWLockManager.LockType> consumer) {
            if (owner == this.owner) {
                this.notifyLockTypes(consumer);
                return NoOwnerInfo.INSTANCE;
            }
            return this;
        }

        @Override
        public final boolean remapOwner(CDOLockOwner oldOwner, CDOLockOwner newOwner) {
            if (this.owner == oldOwner) {
                this.owner = newOwner;
                return true;
            }
            return false;
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + "[" + this.owner + "]";
        }

        protected final CDOLockStateCache.ObjectAlreadyLockedException failure(CDOLockOwner owner, IRWLockManager.LockType lockType) {
            StringJoiner joiner = new StringJoiner(" and the ", owner + " could not acquire the " + lockType + " lock because the ", " is already acquired by " + this.owner);
            this.notifyLockTypes(type -> joiner.add(type + " lock"));
            return new CDOLockStateCache.ObjectAlreadyLockedException(joiner.toString());
        }

        protected abstract void notifyLockTypes(Consumer<IRWLockManager.LockType> var1);

        public static SingleOwnerInfo create(CDOLockOwner owner, int type) {
            switch (type) {
                case 0: {
                    return new ReadLock(owner);
                }
                case 1: {
                    return new ReadLockAndWriteLock(owner);
                }
                case 2: {
                    return new ReadLockAndWriteOption(owner);
                }
                case 3: {
                    return new WriteLock(owner);
                }
                case 4: {
                    return new WriteOption(owner);
                }
            }
            throw new IllegalArgumentException("Illegal type: " + type);
        }

        protected static final class ReadLock
        extends SingleOwnerInfo {
            public static final int TYPE = 0;

            public ReadLock(CDOLockOwner owner) {
                super(owner);
            }

            @Override
            public Object getReadLockOwners() {
                return this.owner;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                return new MultiOwnerInfo.ReadLock(this.owner, owner);
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this.removeOwner(cache, owner, null);
            }

            @Override
            public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 1);
                }
                throw this.failure(owner, IRWLockManager.LockType.WRITE);
            }

            @Override
            public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 2);
                }
                return new MultiOwnerInfo.ReadLockAndWriteOption(owner, new CDOLockOwner[]{this.owner});
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            protected void notifyLockTypes(Consumer<IRWLockManager.LockType> consumer) {
                if (consumer != null) {
                    consumer.accept(IRWLockManager.LockType.READ);
                }
            }
        }

        protected static final class ReadLockAndWriteLock
        extends SingleOwnerInfo {
            public static final int TYPE = 1;

            public ReadLockAndWriteLock(CDOLockOwner owner) {
                super(owner);
            }

            @Override
            public Object getReadLockOwners() {
                return this.owner;
            }

            @Override
            public CDOLockOwner getWriteLockOwner() {
                return this.owner;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.READ);
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 3);
                }
                return this;
            }

            @Override
            public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.WRITE);
            }

            @Override
            public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 0);
                }
                return this;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.OPTION);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            protected void notifyLockTypes(Consumer<IRWLockManager.LockType> consumer) {
                consumer.accept(IRWLockManager.LockType.READ);
                consumer.accept(IRWLockManager.LockType.WRITE);
            }
        }

        protected static final class ReadLockAndWriteOption
        extends SingleOwnerInfo {
            public static final int TYPE = 2;

            public ReadLockAndWriteOption(CDOLockOwner owner) {
                super(owner);
            }

            @Override
            public Object getReadLockOwners() {
                return this.owner;
            }

            @Override
            public CDOLockOwner getWriteOptionOwner() {
                return this.owner;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                return new MultiOwnerInfo.ReadLockAndWriteOption(this.owner, new CDOLockOwner[]{this.owner, owner});
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 4);
                }
                return this;
            }

            @Override
            public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 3);
                }
                throw this.failure(owner, IRWLockManager.LockType.WRITE);
            }

            @Override
            public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.OPTION);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 0);
                }
                return this;
            }

            @Override
            protected void notifyLockTypes(Consumer<IRWLockManager.LockType> consumer) {
                consumer.accept(IRWLockManager.LockType.READ);
                consumer.accept(IRWLockManager.LockType.OPTION);
            }
        }

        protected static final class WriteLock
        extends SingleOwnerInfo {
            public static final int TYPE = 3;

            public WriteLock(CDOLockOwner owner) {
                super(owner);
            }

            @Override
            public CDOLockOwner getWriteLockOwner() {
                return this.owner;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 1);
                }
                throw this.failure(owner, IRWLockManager.LockType.READ);
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.WRITE);
            }

            @Override
            public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return NoOwnerInfo.INSTANCE;
                }
                return this;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.OPTION);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            protected void notifyLockTypes(Consumer<IRWLockManager.LockType> consumer) {
                consumer.accept(IRWLockManager.LockType.WRITE);
            }
        }

        protected static final class WriteOption
        extends SingleOwnerInfo {
            public static final int TYPE = 4;

            public WriteOption(CDOLockOwner owner) {
                super(owner);
            }

            @Override
            public CDOLockOwner getWriteOptionOwner() {
                return this.owner;
            }

            @Override
            public OwnerInfo addReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 2);
                }
                return new MultiOwnerInfo.ReadLockAndWriteOption(this.owner, new CDOLockOwner[]{owner});
            }

            @Override
            public OwnerInfo removeReadLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo addWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return cache.getSingleOwnerInfo(owner, 3);
                }
                throw this.failure(owner, IRWLockManager.LockType.WRITE);
            }

            @Override
            public OwnerInfo removeWriteLockOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                return this;
            }

            @Override
            public OwnerInfo addWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == null) {
                    return this;
                }
                if (owner == this.owner) {
                    return this;
                }
                throw this.failure(owner, IRWLockManager.LockType.OPTION);
            }

            @Override
            public OwnerInfo removeWriteOptionOwner(CDOLockStateCacheImpl cache, CDOLockOwner owner) {
                if (owner == this.owner) {
                    return NoOwnerInfo.INSTANCE;
                }
                return this;
            }

            @Override
            protected void notifyLockTypes(Consumer<IRWLockManager.LockType> consumer) {
                consumer.accept(IRWLockManager.LockType.OPTION);
            }
        }
    }
}

