/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.mvc.fx.ui.properties;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.gef.mvc.fx.operations.ForwardUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.operations.ITransactionalOperation;
import org.eclipse.gef.mvc.fx.operations.ReverseUndoCompositeOperation;
import org.eclipse.gef.mvc.fx.ui.properties.SetPropertyValueOperation;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public class UndoablePropertySheetEntry
extends PropertySheetEntry {
    private IWorkbenchPart workbenchPart;
    private IOperationHistory operationHistory;
    private IOperationHistoryListener operationHistoryListener;
    private IUndoContext undoContext;

    private UndoablePropertySheetEntry() {
    }

    public UndoablePropertySheetEntry(IWorkbenchPart workbenchPart, IOperationHistory operationHistory, IUndoContext undoContext) {
        this.workbenchPart = workbenchPart;
        this.operationHistory = operationHistory;
        this.undoContext = undoContext;
        this.operationHistoryListener = new IOperationHistoryListener(){

            public void historyNotification(OperationHistoryEvent event) {
                UndoablePropertySheetEntry.this.refreshFromRoot();
            }
        };
        this.operationHistory.addOperationHistoryListener(this.operationHistoryListener);
    }

    protected PropertySheetEntry createChildEntry() {
        return new UndoablePropertySheetEntry();
    }

    public void dispose() {
        if (this.operationHistory != null) {
            this.operationHistory.removeOperationHistoryListener(this.operationHistoryListener);
        }
        super.dispose();
    }

    protected IOperationHistory getOperationHistory() {
        if (this.getParent() != null) {
            return ((UndoablePropertySheetEntry)this.getParent()).getOperationHistory();
        }
        return this.operationHistory;
    }

    protected IPropertySource getPropertySource(Object object) {
        if (object instanceof IPropertySource) {
            return (IPropertySource)object;
        }
        return super.getPropertySource(object);
    }

    public void resetPropertyValue() {
        ReverseUndoCompositeOperation cc = new ReverseUndoCompositeOperation("");
        if (this.getParent() == null) {
            return;
        }
        boolean change = false;
        Object[] objects = this.getParent().getValues();
        int i = 0;
        while (i < objects.length) {
            IPropertySource source = this.getPropertySource(objects[i]);
            if (source.isPropertySet(this.getDescriptor().getId())) {
                SetPropertyValueOperation restoreCmd = new SetPropertyValueOperation(this.getDescriptor().getDisplayName(), source, this.getDescriptor().getId(), SetPropertyValueOperation.DEFAULT_VALUE);
                cc.add((IUndoableOperation)restoreCmd);
                change = true;
            }
            ++i;
        }
        if (change) {
            try {
                this.getOperationHistory().execute((IUndoableOperation)cc, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            this.refreshFromRoot();
        }
    }

    public void setValues(Object[] objects) {
        IPropertySource source;
        if ((objects == null || objects.length == 0) && this.workbenchPart != null && (source = (IPropertySource)this.workbenchPart.getAdapter(IPropertySource.class)) != null) {
            objects = new Object[]{source};
        }
        super.setValues(objects);
    }

    protected void valueChanged(PropertySheetEntry child) {
        ForwardUndoCompositeOperation compositeOperation = new ForwardUndoCompositeOperation("Update child property values");
        int i = 0;
        while (i < this.getValues().length) {
            SetPropertyValueOperation setOperation = new SetPropertyValueOperation(child.getDisplayName(), this.getPropertySource(this.getValues()[i]), ((UndoablePropertySheetEntry)child).getDescriptor().getId(), child.getValues()[i]);
            compositeOperation.add((IUndoableOperation)setOperation);
            ++i;
        }
        this.valueChanged((UndoablePropertySheetEntry)child, compositeOperation.unwrap(true));
    }

    protected void valueChanged(UndoablePropertySheetEntry child, ITransactionalOperation operation) {
        if (this.getParent() != null) {
            ((UndoablePropertySheetEntry)this.getParent()).valueChanged(this, operation);
        } else {
            try {
                operation.addContext(this.undoContext);
                this.operationHistory.execute((IUndoableOperation)operation, (IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
    }
}

