/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.rpm.ui.editor.outline;

import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.linuxtools.rpm.ui.editor.parser.Specfile;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackage;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfilePackageContainer;
import org.eclipse.linuxtools.rpm.ui.editor.parser.SpecfileParser;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class SpecfileContentProvider
implements ITreeContentProvider {
    private IDocumentProvider documentProvider;
    private Specfile specfile;
    protected static final String SECTION_POSITIONS = "section_positions";
    protected IPositionUpdater positionUpdater = new DefaultPositionUpdater("section_positions");

    public SpecfileContentProvider(ITextEditor editor) {
        this.specfile = new SpecfileParser().parse(editor.getDocumentProvider().getDocument((Object)editor.getEditorInput()));
        this.documentProvider = editor.getDocumentProvider();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IDocument document;
        if (oldInput != null && (document = this.documentProvider.getDocument(oldInput)) != null) {
            try {
                document.removePositionCategory(SECTION_POSITIONS);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
            document.removePositionUpdater(this.positionUpdater);
        }
        if (newInput != null && (document = this.documentProvider.getDocument(newInput)) != null) {
            document.addPositionCategory(SECTION_POSITIONS);
            document.addPositionUpdater(this.positionUpdater);
            this.specfile = new SpecfileParser().parse(document);
        }
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement == this.specfile) {
            int elmsSize = 2 + this.specfile.getSections().size();
            Object[] elms = new Object[elmsSize];
            elms[0] = this.specfile.getPreamble();
            Object[] sections = this.specfile.getSections().toArray();
            int i = 0;
            while (i < sections.length) {
                elms[i + 1] = sections[i];
                ++i;
            }
            elms[elmsSize - 1] = this.specfile.getPackages();
            return elms;
        }
        Object object = parentElement;
        if (object instanceof SpecfilePackageContainer && (elmsSize = (SpecfilePackageContainer)object) == (SpecfilePackageContainer)var3_5) {
            return spc.getPackages();
        }
        if (parentElement instanceof SpecfilePackage sections) {
            return sp.getSections();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element == this.specfile) {
            return true;
        }
        Object object = element;
        if (object instanceof SpecfilePackageContainer && (var2_3 = (SpecfilePackageContainer)object) == (SpecfilePackageContainer)var3_2) {
            return spc.hasChildren();
        }
        if (element instanceof SpecfilePackage var4_5) {
            return sp.hasChildren();
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(this.specfile);
    }
}

