/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AssociationKind implements Enumerator
{
    LEFT(0, "Left", "Left"),
    RIGHT(1, "Right", "Right");

    public static final int LEFT_VALUE = 0;
    public static final int RIGHT_VALUE = 1;
    private static final AssociationKind[] VALUES_ARRAY;
    public static final List<AssociationKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AssociationKind[]{LEFT, RIGHT};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AssociationKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssociationKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssociationKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AssociationKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AssociationKind get(int value) {
        switch (value) {
            case 0: {
                return LEFT;
            }
            case 1: {
                return RIGHT;
            }
        }
        return null;
    }

    private AssociationKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

