/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.library;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.evaluation.ModelManager;
import org.eclipse.ocl.pivot.ids.CollectionTypeId;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.library.AbstractProperty;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public class UnboxedOppositeNavigationProperty
extends AbstractProperty {
    protected @NonNull PropertyId oppositePropertyId;

    public UnboxedOppositeNavigationProperty(@NonNull PropertyId oppositePropertyId) {
        this.oppositePropertyId = oppositePropertyId;
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypeId returnTypeId, @Nullable Object sourceValue) {
        EObject esObject;
        IdResolver idResolver = executor.getIdResolver();
        Property oppositeProperty = idResolver.getProperty(this.oppositePropertyId);
        ArrayList<Object> results = null;
        ModelManager modelManager = executor.getModelManager();
        if (modelManager instanceof ModelManager.EcoreModelManager && (esObject = oppositeProperty.getESObject()) instanceof EReference) {
            results = new ArrayList();
            if (sourceValue instanceof EObject) {
                EReference oppositeEReference = (EReference)esObject;
                results = new ArrayList();
                Iterable<@NonNull EObject> opposites = ((ModelManager.EcoreModelManager)modelManager).getOpposites(oppositeEReference, (EObject)sourceValue);
                if (opposites != null) {
                    for (EObject eObject : opposites) {
                        results.add(idResolver.boxedValueOf(eObject));
                    }
                }
            }
        }
        if (results == null) {
            results = new ArrayList<Object>();
            Type thatType = ClassUtil.nonNullModel(oppositeProperty.getType());
            if (thatType instanceof CollectionType) {
                thatType = ((CollectionType)thatType).getElementType();
            }
            if (thatType instanceof Class) {
                Class thatClass = (Class)thatType;
                ModelManager.ModelManagerExtension modelManager2 = (ModelManager.ModelManagerExtension)modelManager;
                for (Object object : modelManager.get(thatClass)) {
                    EClass eClass = modelManager2.eClass(object);
                    EStructuralFeature eFeature = eClass.getEStructuralFeature(oppositeProperty.getName());
                    assert (eFeature != null);
                    Object eGet = modelManager2.eGet(object, eFeature);
                    if (eGet != sourceValue) continue;
                    results.add(object);
                }
            }
        }
        if (returnTypeId instanceof CollectionTypeId) {
            return idResolver.createCollectionOfAll(false, false, returnTypeId, results);
        }
        int size = results.size();
        if (size <= 1) {
            return size == 1 ? results.get(0) : null;
        }
        throw new InvalidValueException("Multiple opposites for '" + oppositeProperty + "'", new Object[0]);
    }
}

