/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.constraints.util;

import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ComposedSwitch;
import org.eclipse.emf.ecore.util.Switch;
import org.eclipse.papyrus.infra.constraints.ConfigProperty;
import org.eclipse.papyrus.infra.constraints.ConstraintDescriptor;
import org.eclipse.papyrus.infra.constraints.SimpleConstraint;
import org.eclipse.papyrus.infra.constraints.environment.ConstraintType;
import org.eclipse.papyrus.infra.constraints.environment.util.EnvironmentSwitch;
import org.eclipse.papyrus.infra.constraints.util.ConstraintsSwitch;
import org.eclipse.uml2.common.util.UML2Util;

public class ConstraintsUtil
extends UML2Util {
    private static final Switch<String> NAME_SWITCH = ConstraintsUtil.createNameSwitch();

    public static final String getName(EObject object) {
        return (String)NAME_SWITCH.doSwitch(object);
    }

    public static final String getLabel(EObject object) {
        return ConstraintsUtil.getLabel(object, true);
    }

    public static final String getLabel(EObject object, boolean localize) {
        String name = ConstraintsUtil.getName(object);
        return ConstraintsUtil.getString(object, "_UI_label_" + ConstraintsUtil.getValidJavaIdentifier((String)(ConstraintsUtil.isEmpty((String)name) ? "" : name.replace(':', '_'))), name, localize);
    }

    protected static String getString(EObject context, String key, String defaultValue, boolean localize) {
        ConstraintType type;
        EObject container;
        if (context instanceof ConfigProperty && (container = context.eContainer()) instanceof SimpleConstraint && (type = ((SimpleConstraint)container).getConstraintType()) != null) {
            context = type;
        }
        return UML2Util.getString((EObject)context, (String)key, (String)defaultValue, (boolean)localize);
    }

    private static final Switch<String> createNameSwitch() {
        ConstraintsSwitch<String> constraints = new ConstraintsSwitch<String>(){

            @Override
            public String caseConstraintDescriptor(ConstraintDescriptor object) {
                return object.getName();
            }

            @Override
            public String caseConfigProperty(ConfigProperty object) {
                return object.getName();
            }
        };
        EnvironmentSwitch<String> environment = new EnvironmentSwitch<String>(){

            @Override
            public String caseConstraintType(ConstraintType object) {
                return object.getLabel();
            }
        };
        return new ComposedSwitch(List.of(constraints, environment));
    }
}

