/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.profile.part;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.gmf.runtime.emf.core.util.CrossReferenceAdapter;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.infra.gmfdiag.common.updater.DiagramUpdater;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLLinkDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLNodeDescriptor;
import org.eclipse.papyrus.uml.diagram.profile.part.UMLVisualIDRegistry;
import org.eclipse.papyrus.uml.diagram.profile.providers.UMLElementTypes;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Extension;
import org.eclipse.uml2.uml.Generalization;
import org.eclipse.uml2.uml.Model;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.PrimitiveType;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLDiagramUpdater
implements DiagramUpdater {
    public static final UMLDiagramUpdater INSTANCE = new UMLDiagramUpdater();

    protected UMLDiagramUpdater() {
    }

    public List<UMLNodeDescriptor> getSemanticChildren(View view) {
        block70: {
            String vid = UMLVisualIDRegistry.getVisualID(view);
            if (vid == null) break block70;
            switch (vid) {
                case "Profile_ProfileDiagram": {
                    return this.getProfile_ProfileDiagram_SemanticChildren(view);
                }
                case "Package_Shape_CN": {
                    return this.getPackage_Shape_CN_SemanticChildren(view);
                }
                case "Package_PackagedElementCompartment": {
                    return this.getPackage_PackagedElementCompartment_SemanticChildren(view);
                }
                case "Package_PackagedElementCompartment_CN": {
                    return this.getPackage_PackagedElementCompartment_CN_SemanticChildren(view);
                }
                case "Profile_PackagedElementCompartment": {
                    return this.getProfile_PackagedElementCompartment_SemanticChildren(view);
                }
                case "Profile_PackagedElementCompartment_CN": {
                    return this.getProfile_PackagedElementCompartment_CN_SemanticChildren(view);
                }
                case "Stereotype_AttributeCompartment": {
                    return this.getStereotype_AttributeCompartment_SemanticChildren(view);
                }
                case "Stereotype_AttributeCompartment_CN": {
                    return this.getStereotype_AttributeCompartment_CN_SemanticChildren(view);
                }
                case "Stereotype_OperationCompartment": {
                    return this.getStereotype_OperationCompartment_SemanticChildren(view);
                }
                case "Stereotype_OperationCompartment_CN": {
                    return this.getStereotype_OperationCompartment_CN_SemanticChildren(view);
                }
                case "Model_PackagedElementCompartment": {
                    return this.getModel_PackagedElementCompartment_SemanticChildren(view);
                }
                case "Model_PackagedElementCompartment_CN": {
                    return this.getModel_PackagedElementCompartment_CN_SemanticChildren(view);
                }
                case "Enumeration_LiteralCompartment_CN": {
                    return this.getEnumeration_LiteralCompartment_CN_SemanticChildren(view);
                }
                case "Enumeration_LiteralCompartment": {
                    return this.getEnumeration_LiteralCompartment_SemanticChildren(view);
                }
                case "DataType_AttributeCompartment": {
                    return this.getDataType_AttributeCompartment_SemanticChildren(view);
                }
                case "DataType_AttributeCompartment_CN": {
                    return this.getDataType_AttributeCompartment_CN_SemanticChildren(view);
                }
                case "DataType_OperationCompartment": {
                    return this.getDataType_OperationCompartment_SemanticChildren(view);
                }
                case "DataType_OperationCompartment_CN": {
                    return this.getDataType_OperationCompartment_CN_SemanticChildren(view);
                }
                case "Class_AttributeCompartment": {
                    return this.getClass_AttributeCompartment_SemanticChildren(view);
                }
                case "Class_AttributeCompartment_CN": {
                    return this.getClass_AttributeCompartment_CN_SemanticChildren(view);
                }
                case "Class_OperationCompartment": {
                    return this.getClass_OperationCompartment_SemanticChildren(view);
                }
                case "Class_OperationCompartment_CN": {
                    return this.getClass_OperationCompartment_CN_SemanticChildren(view);
                }
            }
        }
        return Collections.emptyList();
    }

    public List<UMLNodeDescriptor> getProfile_ProfileDiagram_SemanticChildren(View view) {
        String visualID;
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (PackageableElement childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Dependency_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Association_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Class_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Class_MetaclassShape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Model_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"DataType_Shape".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (PackageableElement childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Stereotype_Shape".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (PackageableElement childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        Resource resource = modelElement.eResource();
        Iterator<EObject> it = UMLDiagramUpdater.getPhantomNodesIterator(resource);
        while (it.hasNext()) {
            EObject childElement = it.next();
            if (childElement == modelElement || UMLVisualIDRegistry.getNodeVisualID(view, childElement) != "Diagram_ShortcutShape") continue;
            result.add(new UMLNodeDescriptor(childElement, "Diagram_ShortcutShape"));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getPackage_Shape_CN_SemanticChildren(View view) {
        if (!view.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (PackageableElement childElement : modelElement.getPackagedElements()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Package_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getPackage_PackagedElementCompartment_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Stereotype_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getPackage_PackagedElementCompartment_CN_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Package modelElement = (Package)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Stereotype_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getProfile_PackagedElementCompartment_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Profile modelElement = (Profile)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Stereotype childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Stereotype_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Class_MetaclassShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getProfile_PackagedElementCompartment_CN_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Profile modelElement = (Profile)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Stereotype childElement : modelElement.getOwnedStereotypes()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Stereotype_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Class_MetaclassShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Stereotype childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getStereotype_AttributeCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_ClassAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getStereotype_AttributeCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_ClassAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getStereotype_OperationCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_ClassOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getStereotype_OperationCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Stereotype modelElement = (Stereotype)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_ClassOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getModel_PackagedElementCompartment_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Model modelElement = (Model)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getModel_PackagedElementCompartment_CN_SemanticChildren(View view) {
        String visualID;
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Model modelElement = (Model)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Comment childElement : modelElement.getOwnedComments()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Comment_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        for (Comment childElement : modelElement.getPackagedElements()) {
            visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if ("Model_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Profile_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Package_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Constraint_PackagedElementShape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("Enumeration_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("PrimitiveType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if ("DataType_Shape_CN".equals(visualID)) {
                result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
                continue;
            }
            if (!"Class_Shape_CN".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getEnumeration_LiteralCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Enumeration modelElement = (Enumeration)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (EnumerationLiteral childElement : modelElement.getOwnedLiterals()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"EnumerationLiteral_LiteralLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getEnumeration_LiteralCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Enumeration modelElement = (Enumeration)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (EnumerationLiteral childElement : modelElement.getOwnedLiterals()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"EnumerationLiteral_LiteralLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getDataType_AttributeCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_DataTypeAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getDataType_AttributeCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_DataTypeAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getDataType_OperationCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_DataTypeOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getDataType_OperationCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        DataType modelElement = (DataType)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_DataTypeOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getClass_AttributeCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Class modelElement = (Class)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_ClassAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getClass_AttributeCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Class modelElement = (Class)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Property childElement : modelElement.getOwnedAttributes()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Property_ClassAttributeLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getClass_OperationCompartment_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Class modelElement = (Class)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_ClassOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    public List<UMLNodeDescriptor> getClass_OperationCompartment_CN_SemanticChildren(View view) {
        if (!(view.eContainer() instanceof View)) {
            return Collections.emptyList();
        }
        View containerView = (View)view.eContainer();
        if (!containerView.isSetElement()) {
            return Collections.emptyList();
        }
        Class modelElement = (Class)containerView.getElement();
        LinkedList<UMLNodeDescriptor> result = new LinkedList<UMLNodeDescriptor>();
        for (Operation childElement : modelElement.getOwnedOperations()) {
            String visualID = UMLVisualIDRegistry.getNodeVisualID(view, (EObject)childElement);
            if (!"Operation_ClassOperationLabel".equals(visualID)) continue;
            result.add(new UMLNodeDescriptor((EObject)childElement, visualID));
        }
        return result;
    }

    private static Iterator<EObject> getPhantomNodesIterator(Resource resource) {
        return resource.getAllContents();
    }

    public List<UMLLinkDescriptor> getContainedLinks(View view) {
        block124: {
            String vid = UMLVisualIDRegistry.getVisualID(view);
            if (vid == null) break block124;
            switch (vid) {
                case "Profile_ProfileDiagram": {
                    return this.getProfile_ProfileDiagram_ContainedLinks(view);
                }
                case "Dependency_Shape": {
                    return this.getDependency_Shape_ContainedLinks(view);
                }
                case "Association_Shape": {
                    return this.getAssociation_Shape_ContainedLinks(view);
                }
                case "Stereotype_Shape": {
                    return this.getStereotype_Shape_ContainedLinks(view);
                }
                case "Class_Shape": {
                    return this.getClass_Shape_ContainedLinks(view);
                }
                case "Class_MetaclassShape": {
                    return this.getClass_MetaclassShape_ContainedLinks(view);
                }
                case "Comment_Shape": {
                    return this.getComment_Shape_ContainedLinks(view);
                }
                case "Constraint_PackagedElementShape": {
                    return this.getConstraint_PackagedElementShape_ContainedLinks(view);
                }
                case "Model_Shape": {
                    return this.getModel_Shape_ContainedLinks(view);
                }
                case "Profile_Shape": {
                    return this.getProfile_Shape_ContainedLinks(view);
                }
                case "Package_Shape": {
                    return this.getPackage_Shape_ContainedLinks(view);
                }
                case "Enumeration_Shape": {
                    return this.getEnumeration_Shape_ContainedLinks(view);
                }
                case "PrimitiveType_Shape": {
                    return this.getPrimitiveType_Shape_ContainedLinks(view);
                }
                case "DataType_Shape": {
                    return this.getDataType_Shape_ContainedLinks(view);
                }
                case "Diagram_ShortcutShape": {
                    return this.getDiagram_ShortcutShape_ContainedLinks(view);
                }
                case "PrimitiveType_Shape_CN": {
                    return this.getPrimitiveType_Shape_CN_ContainedLinks(view);
                }
                case "Operation_DataTypeOperationLabel": {
                    return this.getOperation_DataTypeOperationLabel_ContainedLinks(view);
                }
                case "EnumerationLiteral_LiteralLabel": {
                    return this.getEnumerationLiteral_LiteralLabel_ContainedLinks(view);
                }
                case "Property_DataTypeAttributeLabel": {
                    return this.getProperty_DataTypeAttributeLabel_ContainedLinks(view);
                }
                case "Property_ClassAttributeLabel": {
                    return this.getProperty_ClassAttributeLabel_ContainedLinks(view);
                }
                case "Operation_ClassOperationLabel": {
                    return this.getOperation_ClassOperationLabel_ContainedLinks(view);
                }
                case "Stereotype_Shape_CN": {
                    return this.getStereotype_Shape_CN_ContainedLinks(view);
                }
                case "Class_Shape_CN": {
                    return this.getClass_Shape_CN_ContainedLinks(view);
                }
                case "Class_MetaclassShape_CN": {
                    return this.getClass_MetaclassShape_CN_ContainedLinks(view);
                }
                case "Comment_Shape_CN": {
                    return this.getComment_Shape_CN_ContainedLinks(view);
                }
                case "Model_Shape_CN": {
                    return this.getModel_Shape_CN_ContainedLinks(view);
                }
                case "Profile_Shape_CN": {
                    return this.getProfile_Shape_CN_ContainedLinks(view);
                }
                case "Package_Shape_CN": {
                    return this.getPackage_Shape_CN_ContainedLinks(view);
                }
                case "Constraint_PackagedElementShape_CN": {
                    return this.getConstraint_PackagedElementShape_CN_ContainedLinks(view);
                }
                case "Enumeration_Shape_CN": {
                    return this.getEnumeration_Shape_CN_ContainedLinks(view);
                }
                case "DataType_Shape_CN": {
                    return this.getDataType_Shape_CN_ContainedLinks(view);
                }
                case "Extension_Edge": {
                    return this.getExtension_Edge_ContainedLinks(view);
                }
                case "Association_Edge": {
                    return this.getAssociation_Edge_ContainedLinks(view);
                }
                case "ProfileApplication_Edge": {
                    return this.getProfileApplication_Edge_ContainedLinks(view);
                }
                case "Association_BranchEdge": {
                    return this.getAssociation_BranchEdge_ContainedLinks(view);
                }
                case "Generalization_Edge": {
                    return this.getGeneralization_Edge_ContainedLinks(view);
                }
                case "Dependency_Edge": {
                    return this.getDependency_Edge_ContainedLinks(view);
                }
                case "Dependency_BranchEdge": {
                    return this.getDependency_BranchEdge_ContainedLinks(view);
                }
                case "ElementImport_Edge": {
                    return this.getElementImport_Edge_ContainedLinks(view);
                }
                case "PackageImport_Edge": {
                    return this.getPackageImport_Edge_ContainedLinks(view);
                }
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getIncomingLinks(View view) {
        block121: {
            String vid = UMLVisualIDRegistry.getVisualID(view);
            if (vid == null) break block121;
            switch (vid) {
                case "Dependency_Shape": {
                    return this.getDependency_Shape_IncomingLinks(view);
                }
                case "Association_Shape": {
                    return this.getAssociation_Shape_IncomingLinks(view);
                }
                case "Stereotype_Shape": {
                    return this.getStereotype_Shape_IncomingLinks(view);
                }
                case "Class_Shape": {
                    return this.getClass_Shape_IncomingLinks(view);
                }
                case "Class_MetaclassShape": {
                    return this.getClass_MetaclassShape_IncomingLinks(view);
                }
                case "Comment_Shape": {
                    return this.getComment_Shape_IncomingLinks(view);
                }
                case "Constraint_PackagedElementShape": {
                    return this.getConstraint_PackagedElementShape_IncomingLinks(view);
                }
                case "Model_Shape": {
                    return this.getModel_Shape_IncomingLinks(view);
                }
                case "Profile_Shape": {
                    return this.getProfile_Shape_IncomingLinks(view);
                }
                case "Package_Shape": {
                    return this.getPackage_Shape_IncomingLinks(view);
                }
                case "Enumeration_Shape": {
                    return this.getEnumeration_Shape_IncomingLinks(view);
                }
                case "PrimitiveType_Shape": {
                    return this.getPrimitiveType_Shape_IncomingLinks(view);
                }
                case "DataType_Shape": {
                    return this.getDataType_Shape_IncomingLinks(view);
                }
                case "Diagram_ShortcutShape": {
                    return this.getDiagram_ShortcutShape_IncomingLinks(view);
                }
                case "PrimitiveType_Shape_CN": {
                    return this.getPrimitiveType_Shape_CN_IncomingLinks(view);
                }
                case "Operation_DataTypeOperationLabel": {
                    return this.getOperation_DataTypeOperationLabel_IncomingLinks(view);
                }
                case "EnumerationLiteral_LiteralLabel": {
                    return this.getEnumerationLiteral_LiteralLabel_IncomingLinks(view);
                }
                case "Property_DataTypeAttributeLabel": {
                    return this.getProperty_DataTypeAttributeLabel_IncomingLinks(view);
                }
                case "Property_ClassAttributeLabel": {
                    return this.getProperty_ClassAttributeLabel_IncomingLinks(view);
                }
                case "Operation_ClassOperationLabel": {
                    return this.getOperation_ClassOperationLabel_IncomingLinks(view);
                }
                case "Stereotype_Shape_CN": {
                    return this.getStereotype_Shape_CN_IncomingLinks(view);
                }
                case "Class_Shape_CN": {
                    return this.getClass_Shape_CN_IncomingLinks(view);
                }
                case "Class_MetaclassShape_CN": {
                    return this.getClass_MetaclassShape_CN_IncomingLinks(view);
                }
                case "Comment_Shape_CN": {
                    return this.getComment_Shape_CN_IncomingLinks(view);
                }
                case "Model_Shape_CN": {
                    return this.getModel_Shape_CN_IncomingLinks(view);
                }
                case "Profile_Shape_CN": {
                    return this.getProfile_Shape_CN_IncomingLinks(view);
                }
                case "Package_Shape_CN": {
                    return this.getPackage_Shape_CN_IncomingLinks(view);
                }
                case "Constraint_PackagedElementShape_CN": {
                    return this.getConstraint_PackagedElementShape_CN_IncomingLinks(view);
                }
                case "Enumeration_Shape_CN": {
                    return this.getEnumeration_Shape_CN_IncomingLinks(view);
                }
                case "DataType_Shape_CN": {
                    return this.getDataType_Shape_CN_IncomingLinks(view);
                }
                case "Extension_Edge": {
                    return this.getExtension_Edge_IncomingLinks(view);
                }
                case "Association_Edge": {
                    return this.getAssociation_Edge_IncomingLinks(view);
                }
                case "ProfileApplication_Edge": {
                    return this.getProfileApplication_Edge_IncomingLinks(view);
                }
                case "Association_BranchEdge": {
                    return this.getAssociation_BranchEdge_IncomingLinks(view);
                }
                case "Generalization_Edge": {
                    return this.getGeneralization_Edge_IncomingLinks(view);
                }
                case "Dependency_Edge": {
                    return this.getDependency_Edge_IncomingLinks(view);
                }
                case "Dependency_BranchEdge": {
                    return this.getDependency_BranchEdge_IncomingLinks(view);
                }
                case "ElementImport_Edge": {
                    return this.getElementImport_Edge_IncomingLinks(view);
                }
                case "PackageImport_Edge": {
                    return this.getPackageImport_Edge_IncomingLinks(view);
                }
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOutgoingLinks(View view) {
        block121: {
            String vid = UMLVisualIDRegistry.getVisualID(view);
            if (vid == null) break block121;
            switch (vid) {
                case "Dependency_Shape": {
                    return this.getDependency_Shape_OutgoingLinks(view);
                }
                case "Association_Shape": {
                    return this.getAssociation_Shape_OutgoingLinks(view);
                }
                case "Stereotype_Shape": {
                    return this.getStereotype_Shape_OutgoingLinks(view);
                }
                case "Class_Shape": {
                    return this.getClass_Shape_OutgoingLinks(view);
                }
                case "Class_MetaclassShape": {
                    return this.getClass_MetaclassShape_OutgoingLinks(view);
                }
                case "Comment_Shape": {
                    return this.getComment_Shape_OutgoingLinks(view);
                }
                case "Constraint_PackagedElementShape": {
                    return this.getConstraint_PackagedElementShape_OutgoingLinks(view);
                }
                case "Model_Shape": {
                    return this.getModel_Shape_OutgoingLinks(view);
                }
                case "Profile_Shape": {
                    return this.getProfile_Shape_OutgoingLinks(view);
                }
                case "Package_Shape": {
                    return this.getPackage_Shape_OutgoingLinks(view);
                }
                case "Enumeration_Shape": {
                    return this.getEnumeration_Shape_OutgoingLinks(view);
                }
                case "PrimitiveType_Shape": {
                    return this.getPrimitiveType_Shape_OutgoingLinks(view);
                }
                case "DataType_Shape": {
                    return this.getDataType_Shape_OutgoingLinks(view);
                }
                case "Diagram_ShortcutShape": {
                    return this.getDiagram_ShortcutShape_OutgoingLinks(view);
                }
                case "PrimitiveType_Shape_CN": {
                    return this.getPrimitiveType_Shape_CN_OutgoingLinks(view);
                }
                case "Operation_DataTypeOperationLabel": {
                    return this.getOperation_DataTypeOperationLabel_OutgoingLinks(view);
                }
                case "EnumerationLiteral_LiteralLabel": {
                    return this.getEnumerationLiteral_LiteralLabel_OutgoingLinks(view);
                }
                case "Property_DataTypeAttributeLabel": {
                    return this.getProperty_DataTypeAttributeLabel_OutgoingLinks(view);
                }
                case "Property_ClassAttributeLabel": {
                    return this.getProperty_ClassAttributeLabel_OutgoingLinks(view);
                }
                case "Operation_ClassOperationLabel": {
                    return this.getOperation_ClassOperationLabel_OutgoingLinks(view);
                }
                case "Stereotype_Shape_CN": {
                    return this.getStereotype_Shape_CN_OutgoingLinks(view);
                }
                case "Class_Shape_CN": {
                    return this.getClass_Shape_CN_OutgoingLinks(view);
                }
                case "Class_MetaclassShape_CN": {
                    return this.getClass_MetaclassShape_CN_OutgoingLinks(view);
                }
                case "Comment_Shape_CN": {
                    return this.getComment_Shape_CN_OutgoingLinks(view);
                }
                case "Model_Shape_CN": {
                    return this.getModel_Shape_CN_OutgoingLinks(view);
                }
                case "Profile_Shape_CN": {
                    return this.getProfile_Shape_CN_OutgoingLinks(view);
                }
                case "Package_Shape_CN": {
                    return this.getPackage_Shape_CN_OutgoingLinks(view);
                }
                case "Constraint_PackagedElementShape_CN": {
                    return this.getConstraint_PackagedElementShape_CN_OutgoingLinks(view);
                }
                case "Enumeration_Shape_CN": {
                    return this.getEnumeration_Shape_CN_OutgoingLinks(view);
                }
                case "DataType_Shape_CN": {
                    return this.getDataType_Shape_CN_OutgoingLinks(view);
                }
                case "Extension_Edge": {
                    return this.getExtension_Edge_OutgoingLinks(view);
                }
                case "Association_Edge": {
                    return this.getAssociation_Edge_OutgoingLinks(view);
                }
                case "ProfileApplication_Edge": {
                    return this.getProfileApplication_Edge_OutgoingLinks(view);
                }
                case "Association_BranchEdge": {
                    return this.getAssociation_BranchEdge_OutgoingLinks(view);
                }
                case "Generalization_Edge": {
                    return this.getGeneralization_Edge_OutgoingLinks(view);
                }
                case "Dependency_Edge": {
                    return this.getDependency_Edge_OutgoingLinks(view);
                }
                case "Dependency_BranchEdge": {
                    return this.getDependency_BranchEdge_OutgoingLinks(view);
                }
                case "ElementImport_Edge": {
                    return this.getElementImport_Edge_OutgoingLinks(view);
                }
                case "PackageImport_Edge": {
                    return this.getPackageImport_Edge_OutgoingLinks(view);
                }
            }
        }
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProfile_ProfileDiagram_ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDependency_Shape_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getAssociation_Shape_ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_ContainedLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_ContainedLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_ContainedLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ContextEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_ContainedLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_ContainedLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_ContainedLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_ContainedLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_ContainedLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDiagram_ShortcutShape_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_CN_ContainedLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getOperation_DataTypeOperationLabel_ContainedLinks(View view) {
        Operation modelElement = (Operation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumerationLiteral_LiteralLabel_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_DataTypeAttributeLabel_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_ClassAttributeLabel_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOperation_ClassOperationLabel_ContainedLinks(View view) {
        Operation modelElement = (Operation)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_CN_ContainedLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_CN_ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_CN_ContainedLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_CN_ContainedLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_CN_ContainedLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_CN_ContainedLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge((Package)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_CN_ContainedLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Extension_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ProfileApplication_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Association_BranchEdge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_Edge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Dependency_BranchEdge(modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_CN_ContainedLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ContextEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_CN_ContainedLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_CN_ContainedLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getExtension_Edge_ContainedLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_Edge_ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfileApplication_Edge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getAssociation_BranchEdge_ContainedLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getGeneralization_Edge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDependency_Edge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDependency_BranchEdge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getElementImport_Edge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPackageImport_Edge_ContainedLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDependency_Shape_IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_Shape_IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_IncomingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge((Class)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_IncomingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_IncomingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_IncomingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge((Package)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_IncomingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_ProfileApplication_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge((Package)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_IncomingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_IncomingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_IncomingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_IncomingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDiagram_ShortcutShape_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_CN_IncomingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getOperation_DataTypeOperationLabel_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getEnumerationLiteral_LiteralLabel_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_DataTypeAttributeLabel_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_ClassAttributeLabel_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOperation_ClassOperationLabel_IncomingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_CN_IncomingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge((Class)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_CN_IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_CN_IncomingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Extension_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_CN_IncomingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_CN_IncomingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge((Package)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_CN_IncomingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_ProfileApplication_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge((Package)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_CN_IncomingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_PackageImport_Edge(modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_CN_IncomingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_CN_IncomingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_CN_IncomingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getExtension_Edge_IncomingLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_Edge_IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getProfileApplication_Edge_IncomingLinks(View view) {
        ProfileApplication modelElement = (ProfileApplication)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_BranchEdge_IncomingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_Edge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ContextEdge((Namespace)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getGeneralization_Edge_IncomingLinks(View view) {
        Generalization modelElement = (Generalization)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDependency_Edge_IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDependency_BranchEdge_IncomingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingTypeModelFacetLinks_ElementImport_Edge((PackageableElement)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getElementImport_Edge_IncomingLinks(View view) {
        ElementImport modelElement = (ElementImport)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getPackageImport_Edge_IncomingLinks(View view) {
        PackageImport modelElement = (PackageImport)view.getElement();
        CrossReferenceAdapter crossReferencer = CrossReferenceAdapter.getCrossReferenceAdapter((ResourceSet)view.eResource().getResourceSet());
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge((Element)modelElement, crossReferencer));
        result.addAll(this.getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge((Element)modelElement, crossReferencer));
        return result;
    }

    public List<UMLLinkDescriptor> getDependency_Shape_OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_Shape_OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_OutgoingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_OutgoingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_OutgoingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ContextEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_OutgoingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_OutgoingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_OutgoingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge(modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_OutgoingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_OutgoingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_OutgoingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDiagram_ShortcutShape_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPrimitiveType_Shape_CN_OutgoingLinks(View view) {
        PrimitiveType modelElement = (PrimitiveType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getOperation_DataTypeOperationLabel_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getEnumerationLiteral_LiteralLabel_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_DataTypeAttributeLabel_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getProperty_ClassAttributeLabel_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getOperation_ClassOperationLabel_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getStereotype_Shape_CN_OutgoingLinks(View view) {
        Stereotype modelElement = (Stereotype)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_Shape_CN_OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getClass_MetaclassShape_CN_OutgoingLinks(View view) {
        Class modelElement = (Class)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getComment_Shape_CN_OutgoingLinks(View view) {
        Comment modelElement = (Comment)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getModel_Shape_CN_OutgoingLinks(View view) {
        Model modelElement = (Model)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfile_Shape_CN_OutgoingLinks(View view) {
        Profile modelElement = (Profile)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge((Package)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getPackage_Shape_CN_OutgoingLinks(View view) {
        Package modelElement = (Package)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_ProfileApplication_Edge(modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getConstraint_PackagedElementShape_CN_OutgoingLinks(View view) {
        Constraint modelElement = (Constraint)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(modelElement));
        result.addAll(this.getOutgoingFeatureModelFacetLinks_Constraint_ContextEdge(modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getEnumeration_Shape_CN_OutgoingLinks(View view) {
        Enumeration modelElement = (Enumeration)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDataType_Shape_CN_OutgoingLinks(View view) {
        DataType modelElement = (DataType)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getExtension_Edge_OutgoingLinks(View view) {
        Extension modelElement = (Extension)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getAssociation_Edge_OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getProfileApplication_Edge_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getAssociation_BranchEdge_OutgoingLinks(View view) {
        Association modelElement = (Association)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_Edge((Type)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Association_BranchEdge((Type)modelElement));
        result.addAll(this.getContainedTypeModelFacetLinks_Generalization_Edge((Classifier)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_ElementImport_Edge((Namespace)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_PackageImport_Edge((Namespace)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getGeneralization_Edge_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getDependency_Edge_OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getDependency_BranchEdge_OutgoingLinks(View view) {
        Dependency modelElement = (Dependency)view.getElement();
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_Edge((NamedElement)modelElement));
        result.addAll(this.getOutgoingTypeModelFacetLinks_Dependency_BranchEdge((NamedElement)modelElement));
        return result;
    }

    public List<UMLLinkDescriptor> getElementImport_Edge_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    public List<UMLLinkDescriptor> getPackageImport_Edge_OutgoingLinks(View view) {
        return Collections.emptyList();
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Extension_Edge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Extension link;
            if (!(linkObject instanceof Extension) || !"Extension_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Extension)linkObject)))) continue;
            Class dst = link.getMetaclass();
            EList sources = link.getOwnedEnds();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Property)) continue;
            Property src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Extension_Edge, "Extension_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Association_Edge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || !"Association_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject)))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_Edge, "Association_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_ProfileApplication_Edge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getProfileApplications()) {
            ProfileApplication link;
            if (!(linkObject instanceof ProfileApplication) || !"ProfileApplication_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)linkObject)))) continue;
            Profile dst = link.getAppliedProfile();
            Package src = link.getApplyingPackage();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ProfileApplication_Edge, "ProfileApplication_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Association_BranchEdge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || !"Association_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject)))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_BranchEdge, "Association_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Generalization_Edge(Classifier container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getGeneralizations()) {
            Generalization link;
            if (!(linkObject instanceof Generalization) || !"Generalization_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Generalization)linkObject)))) continue;
            Classifier dst = link.getGeneral();
            result.add(new UMLLinkDescriptor((EObject)container, (EObject)dst, (EObject)link, UMLElementTypes.Generalization_Edge, "Generalization_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Dependency_Edge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || !"Dependency_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject)))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_Edge, "Dependency_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_Dependency_BranchEdge(Package container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || !"Dependency_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject)))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_BranchEdge, "Dependency_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_ElementImport_Edge(Namespace container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getElementImports()) {
            ElementImport link;
            if (!(linkObject instanceof ElementImport) || !"ElementImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)linkObject)))) continue;
            PackageableElement dst = link.getImportedElement();
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ElementImport_Edge, "ElementImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getContainedTypeModelFacetLinks_PackageImport_Edge(Namespace container) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackageImports()) {
            PackageImport link;
            if (!(linkObject instanceof PackageImport) || !"PackageImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)linkObject)))) continue;
            Package dst = link.getImportedPackage();
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.PackageImport_Edge, "PackageImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Extension_Edge(Class target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Extension link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getExtension_Metaclass() || !(setting.getEObject() instanceof Extension) || !"Extension_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Extension)setting.getEObject())))) continue;
            EList sources = link.getOwnedEnds();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Property)) continue;
            Property src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Extension_Edge, "Extension_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Association_Edge(Type target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Association link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getAssociation_EndType() || !(setting.getEObject() instanceof Association) || !"Association_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)setting.getEObject())))) continue;
            EList sources = link.getEndTypes();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Association_Edge, "Association_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_ProfileApplication_Edge(Profile target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            ProfileApplication link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getProfileApplication_AppliedProfile() || !(setting.getEObject() instanceof ProfileApplication) || !"ProfileApplication_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)setting.getEObject())))) continue;
            Package src = link.getApplyingPackage();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.ProfileApplication_Edge, "ProfileApplication_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Association_BranchEdge(Type target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Association link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getAssociation_EndType() || !(setting.getEObject() instanceof Association) || !"Association_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)setting.getEObject())))) continue;
            EList sources = link.getEndTypes();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type)) continue;
            Type src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Association_BranchEdge, "Association_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Generalization_Edge(Classifier target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Generalization link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getGeneralization_General() || !(setting.getEObject() instanceof Generalization) || !"Generalization_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Generalization)setting.getEObject()))) || !(link.eContainer() instanceof Classifier)) continue;
            Classifier container = (Classifier)link.eContainer();
            result.add(new UMLLinkDescriptor((EObject)container, (EObject)target, (EObject)link, UMLElementTypes.Generalization_Edge, "Generalization_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Dependency_Edge(NamedElement target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Dependency link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getDependency_Supplier() || !(setting.getEObject() instanceof Dependency) || !"Dependency_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)setting.getEObject())))) continue;
            EList sources = link.getClients();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Dependency_Edge, "Dependency_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_Dependency_BranchEdge(NamedElement target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            Object theSource;
            Dependency link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getDependency_Supplier() || !(setting.getEObject() instanceof Dependency) || !"Dependency_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)setting.getEObject())))) continue;
            EList sources = link.getClients();
            Object v0 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement)) continue;
            NamedElement src = theSource;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.Dependency_BranchEdge, "Dependency_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_ElementImport_Edge(PackageableElement target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            ElementImport link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getElementImport_ImportedElement() || !(setting.getEObject() instanceof ElementImport) || !"ElementImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)setting.getEObject())))) continue;
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.ElementImport_Edge, "ElementImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingTypeModelFacetLinks_PackageImport_Edge(Package target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            PackageImport link;
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getPackageImport_ImportedPackage() || !(setting.getEObject() instanceof PackageImport) || !"PackageImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)setting.getEObject())))) continue;
            Namespace src = link.getImportingNamespace();
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)target, (EObject)link, UMLElementTypes.PackageImport_Edge, "PackageImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(Element target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getComment_AnnotatedElement()) continue;
            result.add(new UMLLinkDescriptor(setting.getEObject(), (EObject)target, UMLElementTypes.Comment_AnnotatedElementEdge, "Comment_AnnotatedElementEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(Element target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getConstraint_ConstrainedElement()) continue;
            result.add(new UMLLinkDescriptor(setting.getEObject(), (EObject)target, UMLElementTypes.Constraint_ConstrainedElementEdge, "Constraint_ConstrainedElementEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getIncomingFeatureModelFacetLinks_Constraint_ContextEdge(Namespace target, CrossReferenceAdapter crossReferencer) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Collection settings = crossReferencer.getInverseReferences((EObject)target);
        for (EStructuralFeature.Setting setting : settings) {
            if (setting.getEStructuralFeature() != UMLPackage.eINSTANCE.getConstraint_Context()) continue;
            result.add(new UMLLinkDescriptor(setting.getEObject(), (EObject)target, UMLElementTypes.Constraint_ContextEdge, "Constraint_ContextEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Association_Edge(Type source) {
        Package container = null;
        Type element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Type src;
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || !"Association_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject)))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type) || (src = (Type)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_Edge, "Association_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_ProfileApplication_Edge(Package source) {
        Package container = null;
        Package element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getProfileApplications()) {
            ProfileApplication link;
            if (!(linkObject instanceof ProfileApplication) || !"ProfileApplication_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ProfileApplication)linkObject)))) continue;
            Profile dst = link.getAppliedProfile();
            Package src = link.getApplyingPackage();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ProfileApplication_Edge, "ProfileApplication_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Association_BranchEdge(Type source) {
        Package container = null;
        Type element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            Type src;
            Object theSource;
            Object theTarget;
            Association link;
            if (!(linkObject instanceof Association) || !"Association_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Association)linkObject)))) continue;
            EList targets = link.getEndTypes();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof Type)) continue;
            Type dst = theTarget;
            EList sources = link.getEndTypes();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof Type) || (src = (Type)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Association_BranchEdge, "Association_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Dependency_Edge(NamedElement source) {
        Package container = null;
        NamedElement element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            NamedElement src;
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || !"Dependency_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject)))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement) || (src = (NamedElement)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_Edge, "Dependency_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_Dependency_BranchEdge(NamedElement source) {
        Package container = null;
        NamedElement element = source;
        while (element != null && container == null) {
            if (element instanceof Package) {
                container = (Package)element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackagedElements()) {
            NamedElement src;
            Object theSource;
            Object theTarget;
            Dependency link;
            if (!(linkObject instanceof Dependency) || !"Dependency_BranchEdge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (Dependency)linkObject)))) continue;
            EList targets = link.getSuppliers();
            Object v0 = theTarget = targets.size() == 1 ? targets.get(0) : null;
            if (!(theTarget instanceof NamedElement)) continue;
            NamedElement dst = theTarget;
            EList sources = link.getClients();
            Object v1 = theSource = sources.size() == 1 ? sources.get(0) : null;
            if (!(theSource instanceof NamedElement) || (src = (NamedElement)theSource) != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.Dependency_BranchEdge, "Dependency_BranchEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_ElementImport_Edge(Namespace source) {
        Namespace container = null;
        Namespace element = source;
        while (element != null && container == null) {
            if (element instanceof Namespace) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getElementImports()) {
            ElementImport link;
            if (!(linkObject instanceof ElementImport) || !"ElementImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (ElementImport)linkObject)))) continue;
            PackageableElement dst = link.getImportedElement();
            Namespace src = link.getImportingNamespace();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.ElementImport_Edge, "ElementImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingTypeModelFacetLinks_PackageImport_Edge(Namespace source) {
        Namespace container = null;
        Namespace element = source;
        while (element != null && container == null) {
            if (element instanceof Namespace) {
                container = element;
            }
            element = element.eContainer();
        }
        if (container == null) {
            return Collections.emptyList();
        }
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (EObject linkObject : container.getPackageImports()) {
            PackageImport link;
            if (!(linkObject instanceof PackageImport) || !"PackageImport_Edge".equals(UMLVisualIDRegistry.getLinkWithClassVisualID((EObject)(link = (PackageImport)linkObject)))) continue;
            Package dst = link.getImportedPackage();
            Namespace src = link.getImportingNamespace();
            if (src != source) continue;
            result.add(new UMLLinkDescriptor((EObject)src, (EObject)dst, (EObject)link, UMLElementTypes.PackageImport_Edge, "PackageImport_Edge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingFeatureModelFacetLinks_Comment_AnnotatedElementEdge(Comment source) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (Element destination : source.getAnnotatedElements()) {
            result.add(new UMLLinkDescriptor((EObject)source, (EObject)destination, UMLElementTypes.Comment_AnnotatedElementEdge, "Comment_AnnotatedElementEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingFeatureModelFacetLinks_Constraint_ConstrainedElementEdge(Constraint source) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        for (Element destination : source.getConstrainedElements()) {
            result.add(new UMLLinkDescriptor((EObject)source, (EObject)destination, UMLElementTypes.Constraint_ConstrainedElementEdge, "Constraint_ConstrainedElementEdge"));
        }
        return result;
    }

    protected Collection<UMLLinkDescriptor> getOutgoingFeatureModelFacetLinks_Constraint_ContextEdge(Constraint source) {
        LinkedList<UMLLinkDescriptor> result = new LinkedList<UMLLinkDescriptor>();
        Namespace destination = source.getContext();
        if (destination == null) {
            return result;
        }
        result.add(new UMLLinkDescriptor((EObject)source, (EObject)destination, UMLElementTypes.Constraint_ContextEdge, "Constraint_ContextEdge"));
        return result;
    }
}

