/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.ExamplePlugin;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.Messages;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.ProceduralObjectEditorInput;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.RoutineFormDocumentProviderAdapter;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.model.ProceduralObjectEditModel;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.routineeditor.pages.source.SourcePage;
import org.eclipse.datatools.modelbase.sql.routines.Routine;
import org.eclipse.datatools.modelbase.sql.schema.Event;
import org.eclipse.datatools.modelbase.sql.schema.SQLObject;
import org.eclipse.datatools.modelbase.sql.tables.Trigger;
import org.eclipse.datatools.sqltools.common.ui.dialog.SaveAsDialog;
import org.eclipse.datatools.sqltools.core.DatabaseIdentifier;
import org.eclipse.datatools.sqltools.core.EditorCorePlugin;
import org.eclipse.datatools.sqltools.core.IControlConnection;
import org.eclipse.datatools.sqltools.core.ProcIdentifier;
import org.eclipse.datatools.sqltools.core.SQLDevToolsConfiguration;
import org.eclipse.datatools.sqltools.core.SQLToolsFacade;
import org.eclipse.datatools.sqltools.core.services.ConnectionService;
import org.eclipse.datatools.sqltools.debugger.editorext.SQLDebuggerDocumentProvider;
import org.eclipse.datatools.sqltools.debugger.model.SPDebugModelUtil;
import org.eclipse.datatools.sqltools.editor.IExtendedSaveSupport;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLDevToolsUIConfiguration;
import org.eclipse.datatools.sqltools.editor.ui.core.SQLToolsUIFacade;
import org.eclipse.datatools.sqltools.internal.SQLDevToolsUtil;
import org.eclipse.datatools.sqltools.internal.sqlscrapbook.util.SQLFileUtil;
import org.eclipse.datatools.sqltools.routineeditor.ui.IRoutineEditorDocumentProvider;
import org.eclipse.datatools.sqltools.routineeditor.ui.ProcEditorInput;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.ISchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.action.RefreshSchemaEditorAction;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.DefaultSchemaObjectEditorHandler;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditor;
import org.eclipse.datatools.sqltools.schemaobjecteditor.ui.core.SchemaObjectEditorPage;
import org.eclipse.datatools.sqltools.sqleditor.SQLEditor;
import org.eclipse.datatools.sqltools.sqleditor.internal.SQLEditorPlugin;
import org.eclipse.datatools.sqltools.sqleditor.internal.editor.SQLOutlinePage;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class ProceduralObjectEditorHandler
extends DefaultSchemaObjectEditorHandler
implements ISchemaObjectEditorHandler {
    private boolean _reservePrivileges = false;
    private SQLOutlinePage _outlinePage = null;
    protected OutlineSelectionChangedListener _fOutlineSelectionChangedListener = new OutlineSelectionChangedListener();

    public Object getAdapter(Class adapter) {
        if (adapter == SQLEditor.class) {
            return this.getSQLEditor();
        }
        if (IContentOutlinePage.class.equals((Object)adapter)) {
            SQLEditor editor = this.getSQLEditor();
            if (editor != null) {
                this._outlinePage = (SQLOutlinePage)editor.getAdapter(adapter);
                this._fOutlineSelectionChangedListener.install((ISelectionProvider)this._outlinePage);
                return this._outlinePage;
            }
        } else if (IRoutineEditorDocumentProvider.class.equals((Object)adapter)) {
            return new RoutineFormDocumentProviderAdapter(){

                @Override
                public void refreshFromDatabase(Object element, IControlConnection controlCon, ProcIdentifier proc) throws CoreException, SQLException {
                    if (ProceduralObjectEditorHandler.this._editor == null) {
                        return;
                    }
                    if (ProceduralObjectEditorHandler.this._editor.isDirty()) {
                        String[] buttons = new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL};
                        MessageDialog d = new MessageDialog(ExamplePlugin.getActiveWorkbenchShell(), Messages.ProceduralObjectEditorHandler_refresh_editor, null, Messages.ProceduralObjectEditorHandler_refresh_q, 3, buttons, 0);
                        int result = d.open();
                        switch (result) {
                            case 1: {
                                return;
                            }
                        }
                    }
                    RefreshSchemaEditorAction.RefreshSchemaEditorJob refreshJob = new RefreshSchemaEditorAction.RefreshSchemaEditorJob(Messages.ProceduralObjectEditorHandler_refresh, (ISchemaObjectEditorHandler)ProceduralObjectEditorHandler.this);
                    refreshJob.setUser(true);
                    refreshJob.schedule();
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public void refreshFromDB(IProgressMonitor monitor) {
        SQLEditor sqlEditor = this.getSQLEditor();
        IControlConnection controlCon = null;
        ProcEditorInput element = null;
        ProcIdentifier proc = null;
        if (sqlEditor != null) {
            try {
                controlCon = EditorCorePlugin.getControlConnectionManager().getOrCreateControlConnection(sqlEditor.getDatabaseIdentifier());
                element = (ProcEditorInput)sqlEditor.getEditorInput();
                proc = element.getProcIdentifier();
                SQLDebuggerDocumentProvider delegate = new SQLDebuggerDocumentProvider();
                delegate.refreshFromDatabase((Object)element, controlCon, proc);
            }
            catch (Exception e) {
                ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", e.getMessage()));
            }
        }
        super.refreshFromDB(monitor);
    }

    private SQLEditor getSQLEditor() {
        SourcePage sourcePage = this.getSourcePage();
        if (sourcePage != null) {
            return (SQLEditor)sourcePage.getNestedEditor();
        }
        return null;
    }

    private SourcePage getSourcePage() {
        ISchemaObjectEditorPage[] allPages = this._editor.getAllPages();
        int i = 0;
        while (i < allPages.length) {
            if (allPages[i] instanceof SourcePage && allPages[i].getId().equals("com.sybase.stf.dmp.ui.routine.formeditor.internal.SourcePage")) {
                return (SourcePage)allPages[i];
            }
            ++i;
        }
        return null;
    }

    public SchemaObjectEditorPage getDebugPage() {
        return this.getSourcePage();
    }

    public void doSave(IProgressMonitor monitor) {
        if (this._editor == null) {
            return;
        }
        ProcIdentifier procid = SQLDevToolsUtil.getProcIdentifier((SQLObject)this.getEditorInput().getEditModelObject().getSchemaObjectImmutableModel().getMainSQLObject());
        boolean inDebug = SPDebugModelUtil.isProcInDebugging((ProcIdentifier)procid);
        if (inDebug) {
            MessageDialog.openError((Shell)((FormEditor)this._editor).getEditorSite().getShell(), (String)Messages.ProceduralObjectEditorHandler_save_error, (String)Messages.ProceduralObjectEditorHandler_save_error_debug);
            return;
        }
        if (procid == null) {
            MessageDialog.openError((Shell)((FormEditor)this._editor).getEditorSite().getShell(), (String)Messages.ProceduralObjectEditorHandler_save_error, (String)Messages.ProceduralObjectEditorHandler_cannot_find_proc);
            ExamplePlugin.getActiveWorkbenchPage().closeEditor((IEditorPart)this._editor, false);
            return;
        }
        SQLDevToolsConfiguration factory = SQLToolsFacade.getConfiguration(null, (DatabaseIdentifier)procid.getDatabaseIdentifier());
        SQLDevToolsUIConfiguration uiFactory = SQLToolsUIFacade.getConfiguration(null, (DatabaseIdentifier)procid.getDatabaseIdentifier());
        IExtendedSaveSupport extendedSaveSupport = uiFactory.getSQLEditorUIService().getExtendedSaveSupport();
        SQLEditor editor = this.getSQLEditor();
        if (extendedSaveSupport != null && editor != null) {
            try {
                ConnectionService connectionService = factory.getConnectionService();
                Connection conn = connectionService.createConnection(procid.getDatabaseIdentifier(), true);
                extendedSaveSupport.preSave(conn, (TextEditor)editor);
                connectionService.closeConnection(conn, -1, procid.getDatabaseIdentifier());
                SourcePage sourcePage = this.getSourcePage();
                sourcePage.aboutToSave(monitor);
            }
            catch (Exception e) {
                ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", e.getMessage()));
            }
        }
        super.doSave(monitor);
    }

    public void doSaveAs() {
        SQLEditor editor = this.getSQLEditor();
        if (editor != null && editor instanceof SQLEditor) {
            String content = editor.getText();
            SaveAsDialog dlg = new SaveAsDialog(SQLEditorPlugin.getActiveWorkbenchShell(), content);
            dlg.setOriginalName(String.valueOf(editor.getTitle()) + ".sql");
            dlg.setOpenMode(false);
            int r = dlg.open();
            if (r == 0 && this.getOpenFileAfterSaveasOption()) {
                IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(dlg.getResult());
                SQLFileUtil.setEncodedConnectionInfo((IFile)file, (String)editor.getConnectionInfo().encode());
                try {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (CoreException coreException) {
                    ExamplePlugin.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples", Messages.ProceduralObjectEditorHandler_save_error));
                }
            }
            return;
        }
        super.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return this.getSQLEditor() != null;
    }

    public void hookInitialization() {
        String defaultPageId;
        super.hookInitialization();
        if (this.getEditorInput() instanceof ProceduralObjectEditorInput && (defaultPageId = ((ProceduralObjectEditorInput)this.getEditorInput()).getDefaultPageId()) != null) {
            ((FormEditor)this._editor).setActivePage(defaultPageId);
        }
    }

    public boolean isReservePrivileges() {
        return this._reservePrivileges;
    }

    public void setReservePrivileges(boolean reservePrivileges) {
        this._reservePrivileges = reservePrivileges;
    }

    public String generateScript() {
        ProceduralObjectEditModel editModelObject = (ProceduralObjectEditModel)this.getEditorInput().getEditModelObject();
        editModelObject.setReservePrivileges(this._reservePrivileges);
        return editModelObject.getDeltaDDL();
    }

    public void dispose() {
        super.dispose();
        this._fOutlineSelectionChangedListener.uninstall((ISelectionProvider)this._outlinePage);
    }

    public void forceFocusObject(SQLObject object) {
        ISchemaObjectEditorPage page;
        ExamplePlugin.getActiveWorkbenchPage().activate((IWorkbenchPart)this._editor);
        if ((object instanceof Trigger || object instanceof Routine || object instanceof Event) && (page = this._editor.getPageByName(Messages.ProceduralObjectEditorHandler_general)) != null) {
            ((SchemaObjectEditor)this._editor).setActivePage(page.getPageDescriptor().getPageId());
            page.setFocus(-1, (Object)object);
        }
    }

    protected class OutlineSelectionChangedListener
    implements ISelectionChangedListener {
        protected OutlineSelectionChangedListener() {
        }

        public void install(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.addPostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void uninstall(ISelectionProvider selectionProvider) {
            if (selectionProvider == null) {
                return;
            }
            if (selectionProvider instanceof IPostSelectionProvider) {
                IPostSelectionProvider provider = (IPostSelectionProvider)selectionProvider;
                provider.removePostSelectionChangedListener((ISelectionChangedListener)this);
            } else {
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISchemaObjectEditorPage activePage;
            if (!(ProceduralObjectEditorHandler.this._editor == null || (activePage = ((SchemaObjectEditor)ProceduralObjectEditorHandler.this._editor).getActiveEditorPage()) instanceof SourcePage && activePage.getId().equals("com.sybase.stf.dmp.ui.routine.formeditor.internal.SourcePage"))) {
                ISelection selection = event.getSelection();
                ((SchemaObjectEditor)ProceduralObjectEditorHandler.this._editor).setActivePage("com.sybase.stf.dmp.ui.routine.formeditor.internal.SourcePage");
                if (ProceduralObjectEditorHandler.this._outlinePage != null) {
                    ProceduralObjectEditorHandler.this._outlinePage.setSelection(selection);
                }
            }
        }
    }
}

