/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui.language.editor.autoedit;

import com.google.inject.Injector;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlContent;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlLabel;
import org.eclipse.gef.dot.internal.language.htmllabel.HtmlTag;
import org.eclipse.gef.dot.internal.ui.language.DotActivator;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.parser.IParser;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.XtextDocument;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class DotAutoEditStrategy
implements IAutoEditStrategy {
    public void customizeDocumentCommand(IDocument document, DocumentCommand command) {
        String text = command.text;
        if (">".equals(text)) {
            command.caretOffset = command.offset + text.length();
            command.text = String.valueOf(text) + this.computeEndTag(document, command);
            command.shiftsCaret = false;
        }
    }

    private String computeEndTag(IDocument document, final DocumentCommand command) {
        IUnitOfWork<String, XtextResource> endTagComputationWork = new IUnitOfWork<String, XtextResource>(){

            public String exec(XtextResource state) throws Exception {
                HtmlTag openTag = DotAutoEditStrategy.this.findOpenTag(state, command);
                if (openTag != null) {
                    return "</" + openTag.getName() + ">";
                }
                return "";
            }
        };
        return (String)((XtextDocument)document).readOnly((IUnitOfWork)endTagComputationWork);
    }

    private HtmlTag findOpenTag(XtextResource resource, DocumentCommand command) {
        if (!resource.getContents().isEmpty()) {
            int cursorPosition;
            EObject dotAst = (EObject)resource.getContents().get(0);
            ICompositeNode rootNode = NodeModelUtils.getNode((EObject)dotAst);
            ILeafNode leafNode = NodeModelUtils.findLeafNodeAtOffset((INode)rootNode, (int)(cursorPosition = command.offset));
            String leafNodeText = leafNode.getText();
            String htmlLabelText = this.extractHtmlLabelContent(leafNodeText);
            if (htmlLabelText == null) {
                return null;
            }
            int htmlLabelStartOffset = leafNode.getOffset() + 1 + leafNodeText.substring(1).indexOf(60);
            int htmlLabelCursorPosition = cursorPosition - htmlLabelStartOffset;
            return this.findOpenTag(htmlLabelText, htmlLabelCursorPosition);
        }
        return null;
    }

    private HtmlTag findOpenTag(String htmlLabelText, int offset) {
        HtmlContent result;
        Injector htmlLabelInjector = DotActivator.getInstance().getInjector("org.eclipse.gef.dot.internal.language.DotHtmlLabel");
        IParser htmlLabelParser = (IParser)htmlLabelInjector.getInstance(IParser.class);
        HtmlLabel htmlLabel = (HtmlLabel)htmlLabelParser.parse((Reader)new StringReader(htmlLabelText)).getRootASTElement();
        if (htmlLabel != null && (result = this.findContentAtOffset((List<HtmlContent>)htmlLabel.getParts(), offset)) != null) {
            return result.getTag();
        }
        return null;
    }

    private HtmlContent findContentAtOffset(List<HtmlContent> contents, int offset) {
        HtmlContent result = null;
        for (HtmlContent content : contents) {
            HtmlContent result2;
            HtmlTag tag = content.getTag();
            if (tag == null) continue;
            ICompositeNode node = NodeModelUtils.getNode((EObject)content);
            if (node.getOffset() <= offset && offset <= node.getOffset() + node.getLength() && result == null) {
                result = content;
            }
            if ((result2 = this.findContentAtOffset((List<HtmlContent>)tag.getChildren(), offset)) == null) continue;
            result = result2;
        }
        return result;
    }

    private String extractHtmlLabelContent(String text) {
        int beginnIndex = text.indexOf(60);
        int endIndex = text.lastIndexOf(62);
        if (beginnIndex != -1 && endIndex != -1 && beginnIndex < endIndex) {
            return text.substring(beginnIndex + 1, endIndex).trim();
        }
        return null;
    }
}

