/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal;

import java.util.HashSet;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jpt.common.core.JptCommonCoreMessages;
import org.eclipse.jpt.common.core.internal.utility.ProjectTools;
import org.eclipse.jpt.common.core.internal.utility.ResourceChangeAdapter;
import org.eclipse.jpt.common.core.internal.utility.ValidationMessageTools;
import org.eclipse.jpt.common.core.internal.utility.command.CommandJobCommandAdapter;
import org.eclipse.jpt.common.core.internal.utility.command.InactiveExtendedJobCommandContext;
import org.eclipse.jpt.common.core.internal.utility.command.JobCommandAdapter;
import org.eclipse.jpt.common.core.internal.utility.command.SimpleJobCommandContext;
import org.eclipse.jpt.common.core.internal.utility.command.SingleUseQueueingExtendedJobCommandContext;
import org.eclipse.jpt.common.core.utility.ValidationMessage;
import org.eclipse.jpt.common.core.utility.command.ExtendedJobCommandContext;
import org.eclipse.jpt.common.core.utility.command.JobCommand;
import org.eclipse.jpt.common.utility.command.Command;
import org.eclipse.jpt.common.utility.command.CommandContext;
import org.eclipse.jpt.common.utility.command.ExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.command.CommandAdapter;
import org.eclipse.jpt.common.utility.internal.command.NullCommand;
import org.eclipse.jpt.common.utility.internal.command.ThreadLocalExtendedCommandContext;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.internal.iterable.SingleElementIterable;
import org.eclipse.jpt.common.utility.internal.model.AbstractModel;
import org.eclipse.jpt.common.utility.internal.reference.FalseBooleanReference;
import org.eclipse.jpt.common.utility.reference.BooleanReference;
import org.eclipse.jpt.common.utility.reference.ModifiableObjectReference;
import org.eclipse.jpt.jpa.core.JpaPlatform;
import org.eclipse.jpt.jpa.core.JpaPreferences;
import org.eclipse.jpt.jpa.core.JpaProject;
import org.eclipse.jpt.jpa.core.JpaProjectManager;
import org.eclipse.jpt.jpa.core.JpaWorkspace;
import org.eclipse.jpt.jpa.core.JptJpaCoreMessages;
import org.eclipse.jpt.jpa.core.internal.AbstractJpaProject;
import org.eclipse.jpt.jpa.core.internal.SimpleJpaProjectConfig;
import org.eclipse.jpt.jpa.core.internal.plugin.JptJpaCorePlugin;
import org.eclipse.jpt.jpa.core.platform.JpaPlatformManager;
import org.eclipse.jpt.jpa.core.validation.JptJpaCoreValidationMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;

class InternalJpaProjectManager
extends AbstractModel
implements JpaProject.Manager {
    private final JpaWorkspace jpaWorkspace;
    private volatile ExtendedJobCommandContext commandContext;
    private final Vector<JpaProject> jpaProjects = new Vector();
    private final IResourceChangeListener resourceChangeListener = new ResourceChangeListener();
    private static final int RESOURCE_CHANGE_EVENT_TYPES = 17;
    private final JavaElementChangeListener javaElementChangeListener = new JavaElementChangeListener();
    private static final int JAVA_CHANGE_EVENT_TYPES = 5;
    private final HashSet<BooleanReference> javaEventListenerFlags = new HashSet();
    private final ThreadLocalExtendedCommandContext modifySharedDocumentCommandContext = new ThreadLocalExtendedCommandContext();
    static final String TRACE_OPTION = JpaProjectManager.class.getSimpleName();

    InternalJpaProjectManager(JpaWorkspace jpaWorkspace) {
        this.jpaWorkspace = jpaWorkspace;
        JptJpaCorePlugin.instance().dumpStackTrace(TRACE_OPTION, "*** new JPA project manager ***");
        try {
            JavaCore.initializeAfterLoad(null);
            this.commandContext = this.buildAsynchronousCommandContext();
            this.buildJpaProjects();
            this.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 17);
            JavaCore.addElementChangedListener((IElementChangedListener)this.javaElementChangeListener, (int)5);
        }
        catch (Exception ex) {
            JptJpaCorePlugin.instance().logError(ex);
            this.dispose();
        }
    }

    private void buildJpaProjects() {
        IProject[] iProjectArray = this.getWorkspaceRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET)) {
                JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: build JPA project: {0}", new Object[]{project.getName()});
                BuildJpaProjectCommand command = new BuildJpaProjectCommand(project);
                this.execute((JobCommand)command, NLS.bind((String)JptJpaCoreMessages.BUILD_JPA_PROJECT_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
            }
            ++n2;
        }
    }

    void buildJpaProject_(IProject project, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: build JPA project: {0}", new Object[]{project.getName()});
        this.addJpaProject(project, monitor);
    }

    void dispose() {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "*** JPA project manager dispose ***");
        JavaCore.removeElementChangedListener((IElementChangedListener)this.javaElementChangeListener);
        this.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        ExtendedJobCommandContext oldCE = this.commandContext;
        this.commandContext = InactiveExtendedJobCommandContext.instance();
        this.clearJpaProjects(oldCE);
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "*** JPA project manager DEAD ***");
    }

    private void clearJpaProjects(ExtendedJobCommandContext oldCE) {
        try {
            this.clearJpaProjects_(oldCE);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    private void clearJpaProjects_(ExtendedJobCommandContext oldCE) throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: clear JPA projects");
        ClearJpaProjectsCommand command = new ClearJpaProjectsCommand();
        oldCE.waitToExecute((JobCommand)command, JptJpaCoreMessages.DISPOSE_JPA_PROJECTS_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "end: clear JPA projects");
    }

    void clearJpaProjects_(IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: clear JPA projects");
        for (JpaProject jpaProject : this.getJpaProjects()) {
            if (monitor.isCanceled()) {
                JptJpaCorePlugin.instance().trace(TRACE_OPTION, "CANCEL: clear JPA projects: {0}", new Object[]{jpaProject.getName()});
                throw new OperationCanceledException();
            }
            this.removeJpaProject(jpaProject);
        }
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "end: clear JPA projects");
    }

    @Override
    public Iterable<JpaProject> waitToGetJpaProjects() throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: get JPA projects");
        GetJpaProjectsCommand command = new GetJpaProjectsCommand();
        this.waitToExecute((Command)command, JptJpaCoreMessages.GET_JPA_PROJECTS_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
        return command.result;
    }

    Iterable<JpaProject> getJpaProjects_() {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: get JPA projects: {0}", new Object[]{this.jpaProjects});
        return this.getJpaProjects();
    }

    @Override
    public Iterable<JpaProject> getJpaProjects() {
        return IterableTools.cloneSnapshot(this.jpaProjects);
    }

    @Override
    public int getJpaProjectsSize() {
        return this.jpaProjects.size();
    }

    JpaProject waitToGetJpaProject(IProject project) throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: get JPA project: {0}", new Object[]{project.getName()});
        GetJpaProjectCommand command = new GetJpaProjectCommand(project);
        this.waitToExecute((Command)command, NLS.bind((String)JptJpaCoreMessages.GET_JPA_PROJECT_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
        return command.result;
    }

    private boolean waitToGetJpaProject(ModifiableObjectReference<JpaProject> jpaProjectRef, IProject project, long timeout) throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: get JPA project (time-out): {0}", new Object[]{project.getName()});
        GetJpaProjectCommand command = new GetJpaProjectCommand(project);
        boolean result = this.waitToExecute((Command)command, JptJpaCoreMessages.GET_JPA_PROJECT_JOB_NAME, (ISchedulingRule)project, timeout);
        if (result) {
            jpaProjectRef.setValue((Object)command.result);
        } else {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "time-out: get JPA project: {0}", new Object[]{project.getName()});
        }
        return result;
    }

    JpaProject getJpaProjectUnsafe(IProject project) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: get JPA project: {0}", new Object[]{project.getName()});
        JpaProject jpaProject = InternalJpaProjectManager.selectJpaProject(this.jpaProjects, project);
        if (jpaProject == null) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "not found: get JPA project: {0}", new Object[]{project.getName()});
        }
        return jpaProject;
    }

    private JpaProject getJpaProject_(IProject project) {
        return InternalJpaProjectManager.selectJpaProject(this.getJpaProjects(), project);
    }

    private static JpaProject selectJpaProject(Iterable<JpaProject> jpaProjects, IProject project) {
        for (JpaProject jpaProject : jpaProjects) {
            if (!jpaProject.getProject().equals((Object)project)) continue;
            return jpaProject;
        }
        return null;
    }

    JpaProject rebuildJpaProject(IProject project) throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: rebuild JPA project: {0}", new Object[]{project.getName()});
        RebuildJpaProjectCommand command = new RebuildJpaProjectCommand(project);
        this.waitToExecute((JobCommand)command, NLS.bind((String)JptJpaCoreMessages.REBUILD_JPA_PROJECT_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
        return command.result;
    }

    JpaProject rebuildJpaProject_(IProject project, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: rebuild JPA project: {0}", new Object[]{project.getName()});
        this.removeJpaProject(this.getJpaProject_(project));
        if (monitor.isCanceled()) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "CANCEL: rebuild JPA project: {0}", new Object[]{project.getName()});
            throw new OperationCanceledException();
        }
        return this.addJpaProject(project, monitor);
    }

    Iterable<IMessage> buildValidationMessages(IProject project, IReporter reporter) throws InterruptedException {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: build validation messages: {0}", new Object[]{project.getName()});
        BuildValidationMessagesCommand command = new BuildValidationMessagesCommand(project, reporter);
        this.waitToExecute((Command)command, NLS.bind((String)JptJpaCoreMessages.BUILD_VALIDATION_MESSAGES_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
        return command.result;
    }

    Iterable<IMessage> buildValidationMessages_(IProject project, IReporter reporter) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: build validation messages: {0}", new Object[]{project.getName()});
        JpaProject jpaProject = this.getJpaProject_(project);
        if (jpaProject == null) {
            return this.buildNoJpaProjectMessages(project);
        }
        try {
            return jpaProject.getValidationMessages(reporter);
        }
        catch (RuntimeException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return EmptyIterable.instance();
        }
    }

    private Iterable<IMessage> buildNoJpaProjectMessages(IProject project) {
        return new SingleElementIterable((Object)this.buildNoJpaProjectMessage(project));
    }

    private IMessage buildNoJpaProjectMessage(IProject project) {
        return ValidationMessageTools.buildValidationMessage((IResource)project, (ValidationMessage)JptJpaCoreValidationMessages.NO_JPA_PROJECT);
    }

    JpaProject addJpaProject(IProject project, IProgressMonitor monitor) {
        JpaProject jpaProject = this.buildJpaProject(project, monitor);
        if (jpaProject == null) {
            JptJpaCorePlugin.instance().dumpStackTrace(TRACE_OPTION, "add JPA project fail: {0}", new Object[]{project});
        } else {
            JptJpaCorePlugin.instance().dumpStackTrace(TRACE_OPTION, "add JPA project: {0}", new Object[]{jpaProject});
        }
        if (jpaProject != null) {
            this.addItemToCollection(jpaProject, this.jpaProjects, "jpaProjects");
        }
        return jpaProject;
    }

    private JpaProject buildJpaProject(IProject project, IProgressMonitor monitor) {
        return this.buildJpaProject(this.buildJpaProjectConfig(project), monitor);
    }

    private JpaProject buildJpaProject(JpaProject.Config config, IProgressMonitor monitor) {
        return this.buildJpaProject(config.getJpaPlatform(), config, monitor);
    }

    private JpaProject buildJpaProject(JpaPlatform jpaPlatform, JpaProject.Config config, IProgressMonitor monitor) {
        if (jpaPlatform == null) {
            JptJpaCorePlugin.instance().logError(new IllegalArgumentException(), "null JPA platform: {0}", new Object[]{config.getProject()});
            return null;
        }
        try {
            return jpaPlatform.getJpaFactory().buildJpaProject(config, monitor);
        }
        catch (RuntimeException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private JpaProject.Config buildJpaProjectConfig(IProject project) {
        SimpleJpaProjectConfig config = new SimpleJpaProjectConfig();
        config.setJpaProjectManager(this);
        config.setProject(project);
        config.setJpaPlatform(this.getJpaPlatform(project));
        config.setConnectionProfileName(JpaPreferences.getConnectionProfileName(project));
        config.setUserOverrideDefaultCatalog(JpaPreferences.getUserOverrideDefaultCatalog(project));
        config.setUserOverrideDefaultSchema(JpaPreferences.getUserOverrideDefaultSchema(project));
        config.setDiscoverAnnotatedClasses(JpaPreferences.getDiscoverAnnotatedClasses(project));
        config.setMetamodelSourceFolderName(JpaPreferences.getMetamodelSourceFolderName(project));
        return config;
    }

    private JpaPlatform getJpaPlatform(IProject project) {
        JpaPlatformManager mgr = this.jpaWorkspace.getJpaPlatformManager();
        String jpaPlatformID = JpaPreferences.getJpaPlatformID(project);
        if (jpaPlatformID != null) {
            return mgr.getJpaPlatform(jpaPlatformID);
        }
        jpaPlatformID = this.getDefaultJpaPlatformID(project);
        return jpaPlatformID == null ? null : mgr.getJpaPlatform(jpaPlatformID);
    }

    private String getDefaultJpaPlatformID(IProject project) {
        IProjectFacetVersion jpaFacetVersion = this.getJpaFacetVersion(project);
        if (jpaFacetVersion == null) {
            return null;
        }
        JpaPlatform.Config config = this.jpaWorkspace.getJpaPlatformManager().getDefaultJpaPlatformConfig(jpaFacetVersion);
        return config == null ? null : config.getId();
    }

    private IProjectFacetVersion getJpaFacetVersion(IProject project) {
        try {
            return ProjectFacetsManager.create((IProject)project).getProjectFacetVersion(JpaProject.FACET);
        }
        catch (CoreException ex) {
            JptJpaCorePlugin.instance().logError(ex);
            return null;
        }
    }

    private void removeJpaProject(JpaProject jpaProject) {
        JptJpaCorePlugin.instance().dumpStackTrace(TRACE_OPTION, "remove JPA project: {0}", new Object[]{jpaProject});
        this.removeItemFromCollection(jpaProject, this.jpaProjects, "jpaProjects");
        this.disposeJpaProject(jpaProject);
    }

    private void disposeJpaProject(JpaProject jpaProject) {
        try {
            jpaProject.dispose();
        }
        catch (RuntimeException ex) {
            JptJpaCorePlugin.instance().logError(ex);
        }
    }

    void projectChanged(IResourceDelta delta) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: project changed: {0}", new Object[]{delta.getResource()});
        ProjectChangeEventHandlerCommand command = new ProjectChangeEventHandlerCommand(delta);
        this.execute((JobCommand)command, JptJpaCoreMessages.PROJECT_CHANGE_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
    }

    void projectChanged_(IResourceDelta delta, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: project changed: {0}", new Object[]{delta.getResource()});
        for (JpaProject jpaProject : this.jpaProjects) {
            if (monitor.isCanceled()) {
                JptJpaCorePlugin.instance().trace(TRACE_OPTION, "CANCEL: project changed: {0}", new Object[]{jpaProject.getName()});
                throw new OperationCanceledException();
            }
            try {
                jpaProject.projectChanged(delta);
            }
            catch (RuntimeException ex) {
                JptJpaCorePlugin.instance().logError(ex);
            }
        }
    }

    void projectPostCleanBuild(IProject project) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: post clean build: {0}", new Object[]{project.getName()});
        ProjectPostCleanBuildEventHandlerCommand command = new ProjectPostCleanBuildEventHandlerCommand(project);
        this.execute((JobCommand)command, NLS.bind((String)JptJpaCoreMessages.PROJECT_POST_CLEAN_BUILD_EVENT_HANDLER_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
    }

    void projectPostCleanBuild_(IProject project, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: post clean build: {0}", new Object[]{project.getName()});
        JpaProject jpaProject = this.getJpaProject_(project);
        if (jpaProject != null) {
            this.removeJpaProject(jpaProject);
            if (monitor.isCanceled()) {
                JptJpaCorePlugin.instance().trace(TRACE_OPTION, "CANCEL: post clean build: {0}", new Object[]{project.getName()});
                throw new OperationCanceledException();
            }
            this.addJpaProject(project, monitor);
        }
    }

    void checkForJpaFacetTransition(IProject project) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: project facet file changed: {0}", new Object[]{project.getName()});
        FacetFileChangeEventHandlerCommand command = new FacetFileChangeEventHandlerCommand(project);
        this.execute((JobCommand)command, NLS.bind((String)JptJpaCoreMessages.FACET_FILE_CHANGE_EVENT_HANDLER_JOB_NAME, (Object)project.getName()), (ISchedulingRule)project);
    }

    void checkForJpaFacetTransition_(IProject project, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: project facet file changed: {0}", new Object[]{project.getName()});
        JpaProject jpaProject = this.getJpaProject_(project);
        if (ProjectTools.hasFacet((IProject)project, (IProjectFacet)JpaProject.FACET)) {
            if (jpaProject == null) {
                this.addJpaProject(project, monitor);
            }
        } else if (jpaProject != null) {
            this.removeJpaProject(jpaProject);
        }
    }

    void javaElementChanged(ElementChangedEvent event) {
        if (this.handleJavaElementChangedEvent(event)) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: Java element changed: {0}", new Object[]{event.getDelta()});
            JavaChangeEventHandlerCommand command = new JavaChangeEventHandlerCommand(event);
            this.execute((JobCommand)command, JptJpaCoreMessages.JAVA_CHANGE_EVENT_HANDLER_JOB_NAME, (ISchedulingRule)this.getWorkspaceRoot());
        }
    }

    void javaElementChanged_(ElementChangedEvent event, IProgressMonitor monitor) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: Java element changed: {0}", new Object[]{event.getDelta()});
        for (JpaProject jpaProject : this.jpaProjects) {
            if (monitor.isCanceled()) {
                JptJpaCorePlugin.instance().trace(TRACE_OPTION, "CANCEL: Java element changed: {0}", new Object[]{jpaProject.getName()});
                throw new OperationCanceledException();
            }
            try {
                jpaProject.javaElementChanged(event);
            }
            catch (RuntimeException ex) {
                JptJpaCorePlugin.instance().logError(ex);
            }
        }
    }

    private boolean handleJavaElementChangedEvent(ElementChangedEvent event) {
        return this.handleJavaDelta(event.getDelta());
    }

    protected boolean handleJavaDelta(IJavaElementDelta delta) {
        switch (delta.getElement().getElementType()) {
            case 1: {
                return this.handleJavaModelDelta(delta);
            }
            case 2: {
                return this.handleJavaProjectDelta(delta);
            }
            case 3: {
                return this.handleJavaPackageFragmentRootDelta(delta);
            }
            case 4: {
                return this.processJavaPackageFragmentDelta(delta);
            }
            case 5: {
                return this.handleJavaCompilationUnitDelta(delta);
            }
        }
        return false;
    }

    protected boolean handleJavaDeltaChildren(IJavaElementDelta delta) {
        IJavaElementDelta[] iJavaElementDeltaArray = delta.getAffectedChildren();
        int n = iJavaElementDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaElementDelta child = iJavaElementDeltaArray[n2];
            if (this.handleJavaDelta(child)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected boolean handleJavaModelDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta);
    }

    protected boolean handleJavaProjectDelta(IJavaElementDelta delta) {
        boolean handle = this.handleJavaDeltaChildren(delta);
        if (handle) {
            return handle;
        }
        return AbstractJpaProject.classpathHasChanged(delta);
    }

    protected boolean handleJavaPackageFragmentRootDelta(IJavaElementDelta delta) {
        boolean handle = this.handleJavaDeltaChildren(delta);
        if (handle) {
            return handle;
        }
        if (AbstractJpaProject.classpathEntryHasBeenAdded(delta)) {
            return true;
        }
        return AbstractJpaProject.classpathEntryHasBeenRemoved(delta);
    }

    protected boolean processJavaPackageFragmentDelta(IJavaElementDelta delta) {
        return this.handleJavaDeltaChildren(delta);
    }

    protected boolean handleJavaCompilationUnitDelta(IJavaElementDelta delta) {
        return this.javaCompilationUnitDeltaIsRelevant(delta);
    }

    protected boolean javaCompilationUnitDeltaIsRelevant(IJavaElementDelta delta) {
        return AbstractJpaProject.javaCompilationUnitDeltaIsRelevant(delta);
    }

    @Override
    public ExtendedCommandContext getModifySharedDocumentCommandContext() {
        return this.modifySharedDocumentCommandContext;
    }

    private void setThreadLocalModifySharedDocumentCommandContext(ExtendedCommandContext commandContext) {
        this.modifySharedDocumentCommandContext.set((CommandContext)commandContext);
    }

    @Override
    public JpaWorkspace getJpaWorkspace() {
        return this.jpaWorkspace;
    }

    private IWorkspace getWorkspace() {
        return this.jpaWorkspace.getWorkspace();
    }

    private IWorkspaceRoot getWorkspaceRoot() {
        return this.getWorkspace().getRoot();
    }

    private ISchedulingRule getCurrentRule() {
        return this.getJobManager().currentRule();
    }

    private IJobManager getJobManager() {
        return Job.getJobManager();
    }

    public void toString(StringBuilder sb) {
        sb.append(this.getJpaProjects());
    }

    @Override
    public void execute(JobCommand command, String jobName, JpaProject jpaProject) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, "dispatch: client command: {0}", new Object[]{command});
        this.execute((JobCommand)new ClientJobCommandWrapper(command, jpaProject), jobName, (ISchedulingRule)jpaProject.getProject());
    }

    private void execute(JobCommand command, String jobName, ISchedulingRule schedulingRule) {
        this.commandContext.execute(command, jobName, schedulingRule);
    }

    private void waitToExecute(Command command, String jobName, ISchedulingRule schedulingRule) throws InterruptedException {
        this.waitToExecute((JobCommand)new CommandJobCommandAdapter(command), jobName, schedulingRule);
    }

    private void waitToExecute(JobCommand command, String jobName, ISchedulingRule schedulingRule) throws InterruptedException {
        this.waitToExecute(command, jobName, schedulingRule, 0L);
    }

    private boolean waitToExecute(Command command, String jobName, ISchedulingRule schedulingRule, long timeout) throws InterruptedException {
        return this.waitToExecute((JobCommand)new CommandJobCommandAdapter(command), jobName, schedulingRule, timeout);
    }

    private boolean waitToExecute(JobCommand command, String jobName, ISchedulingRule schedulingRule, long timeout) throws InterruptedException {
        ISchedulingRule currentRule = this.getCurrentRule();
        if (currentRule != null && schedulingRule.isConflicting(currentRule)) {
            JptJpaCorePlugin.instance().dumpStackTrace(TRACE_OPTION, "scheduling rule conflict: {0} vs. {1}", new Object[]{schedulingRule, currentRule});
            command.execute((IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        return this.commandContext.waitToExecute(command, jobName, schedulingRule, timeout);
    }

    @Override
    public void execute(Command command) throws InterruptedException {
        this.execute(command, null);
    }

    @Override
    public synchronized void execute(Command command, ExtendedCommandContext threadLocalModifySharedDocumentCommandContext) throws InterruptedException {
        this.setThreadLocalModifySharedDocumentCommandContext(threadLocalModifySharedDocumentCommandContext);
        this.executeCommandsSynchronously();
        try {
            command.execute();
        }
        finally {
            this.executeCommandsAsynchronously();
        }
        this.setThreadLocalModifySharedDocumentCommandContext(null);
    }

    private void executeCommandsSynchronously() throws InterruptedException {
        this.addJavaEventListenerFlag(FalseBooleanReference.instance());
        SimpleJobCommandContext oldContext = (SimpleJobCommandContext)this.commandContext;
        SingleUseQueueingExtendedJobCommandContext newContext = this.buildSynchronousCommandContext();
        this.commandContext = newContext;
        oldContext.waitToExecute(NullCommand.instance());
        newContext.start();
    }

    private SingleUseQueueingExtendedJobCommandContext buildSynchronousCommandContext() {
        return new SingleUseQueueingExtendedJobCommandContext();
    }

    private void executeCommandsAsynchronously() {
        this.commandContext = this.buildAsynchronousCommandContext();
        this.removeJavaEventListenerFlag(FalseBooleanReference.instance());
    }

    private SimpleJobCommandContext buildAsynchronousCommandContext() {
        return new SimpleJobCommandContext(JptCommonCoreMessages.DALI_JOB_NAME);
    }

    void execute_(JobCommand command, IProgressMonitor monitor, JpaProject jpaProject) {
        if (this.jpaProjects.contains(jpaProject)) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "execute: client command: {0}", new Object[]{command});
            command.execute(monitor);
        } else {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "ignore: client command: {0}", new Object[]{command});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean javaEventListenersAreActive() {
        HashSet<BooleanReference> hashSet = this.javaEventListenerFlags;
        synchronized (hashSet) {
            return this.javaEventListenersAreActive_();
        }
    }

    private boolean javaEventListenersAreActive_() {
        for (BooleanReference flag : this.javaEventListenerFlags) {
            if (!flag.isFalse()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addJavaEventListenerFlag(BooleanReference flag) {
        HashSet<BooleanReference> hashSet = this.javaEventListenerFlags;
        synchronized (hashSet) {
            this.addJavaEventListenerFlag_(flag);
        }
    }

    private void addJavaEventListenerFlag_(BooleanReference flag) {
        if (!this.javaEventListenerFlags.add(flag)) {
            throw new IllegalArgumentException("duplicate flag: " + flag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJavaEventListenerFlag(BooleanReference flag) {
        HashSet<BooleanReference> hashSet = this.javaEventListenerFlags;
        synchronized (hashSet) {
            this.removeJavaEventListenerFlag_(flag);
        }
    }

    private void removeJavaEventListenerFlag_(BooleanReference flag) {
        if (!this.javaEventListenerFlags.remove(flag)) {
            throw new IllegalArgumentException("missing flag: " + flag);
        }
    }

    private static void trace(String message) {
        JptJpaCorePlugin.instance().trace(TRACE_OPTION, message);
    }

    class BuildJpaProjectCommand
    extends JobCommandAdapter {
        private final IProject project;

        BuildJpaProjectCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.buildJpaProject_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class BuildValidationMessagesCommand
    extends CommandAdapter {
        private final IProject project;
        private final IReporter reporter;
        Iterable<IMessage> result;

        BuildValidationMessagesCommand(IProject project, IReporter reporter) {
            this.project = project;
            this.reporter = reporter;
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.buildValidationMessages_(this.project, this.reporter);
        }
    }

    class ClearJpaProjectsCommand
    extends JobCommandAdapter {
        ClearJpaProjectsCommand() {
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.clearJpaProjects_(monitor);
            return Status.OK_STATUS;
        }
    }

    class ClientJobCommandWrapper
    implements JobCommand {
        private final JobCommand jobCommand;
        private final JpaProject jpaProject;

        ClientJobCommandWrapper(JobCommand jobCommand, JpaProject jpaProject) {
            if (jobCommand == null || jpaProject == null) {
                throw new NullPointerException();
            }
            this.jobCommand = jobCommand;
            this.jpaProject = jpaProject;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.execute_(this.jobCommand, monitor, this.jpaProject);
            return Status.OK_STATUS;
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (Object)this.jobCommand);
        }
    }

    class FacetFileChangeEventHandlerCommand
    extends JobCommandAdapter {
        private final IProject project;

        FacetFileChangeEventHandlerCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.checkForJpaFacetTransition_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class GetJpaProjectCommand
    extends CommandAdapter {
        private final IProject project;
        JpaProject result;

        GetJpaProjectCommand(IProject project) {
            this.project = project;
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.getJpaProjectUnsafe(this.project);
        }
    }

    class GetJpaProjectsCommand
    extends CommandAdapter {
        Iterable<JpaProject> result;

        GetJpaProjectsCommand() {
        }

        public void execute() {
            this.result = InternalJpaProjectManager.this.getJpaProjects_();
        }
    }

    class JavaChangeEventHandlerCommand
    extends JobCommandAdapter {
        private final ElementChangedEvent event;

        JavaChangeEventHandlerCommand(ElementChangedEvent event) {
            this.event = event;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.javaElementChanged_(this.event, monitor);
            return Status.OK_STATUS;
        }
    }

    class JavaElementChangeListener
    implements IElementChangedListener {
        JavaElementChangeListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (this.isActive()) {
                InternalJpaProjectManager.this.javaElementChanged(event);
            }
        }

        private boolean isActive() {
            return InternalJpaProjectManager.this.javaEventListenersAreActive();
        }

        public String toString() {
            return ObjectTools.toString((Object)this, (CharSequence)(this.isActive() ? "active" : "inactive"));
        }
    }

    class ProjectChangeEventHandlerCommand
    extends JobCommandAdapter {
        private final IResourceDelta delta;

        ProjectChangeEventHandlerCommand(IResourceDelta delta) {
            this.delta = delta;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.projectChanged_(this.delta, monitor);
            return Status.OK_STATUS;
        }
    }

    class ProjectPostCleanBuildEventHandlerCommand
    extends JobCommandAdapter {
        private final IProject project;

        ProjectPostCleanBuildEventHandlerCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            InternalJpaProjectManager.this.projectPostCleanBuild_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class RebuildJpaProjectCommand
    extends JobCommandAdapter {
        private final IProject project;
        JpaProject result;

        RebuildJpaProjectCommand(IProject project) {
            this.project = project;
        }

        public IStatus execute(IProgressMonitor monitor) {
            this.result = InternalJpaProjectManager.this.rebuildJpaProject_(this.project, monitor);
            return Status.OK_STATUS;
        }
    }

    class ResourceChangeListener
    extends ResourceChangeAdapter {
        ResourceChangeListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 1: {
                    this.processPostChangeEvent(event);
                    break;
                }
                case 32: {
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    this.processPostBuildEvent(event);
                    break;
                }
                case 2: {
                    break;
                }
                case 4: {
                    break;
                }
            }
        }

        private void processPostChangeEvent(IResourceChangeEvent event) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "Resource POST_CHANGE event: {0}", new Object[]{event.getResource()});
            this.processPostChangeDelta(event.getDelta());
        }

        private void processPostChangeDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostChangeRootDelta(delta);
                    break;
                }
                case 4: {
                    this.processPostChangeProjectDelta(delta);
                    break;
                }
                case 2: {
                    this.processPostChangeFolderDelta((IFolder)resource, delta);
                    break;
                }
                case 1: {
                    this.processPostChangeFileDelta((IFile)resource, delta);
                    break;
                }
            }
        }

        private void processPostChangeRootDelta(IResourceDelta delta) {
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeProjectDelta(IResourceDelta delta) {
            InternalJpaProjectManager.this.projectChanged(delta);
            this.processPostChangeDeltaChildren(delta);
        }

        private void processPostChangeFolderDelta(IFolder folder, IResourceDelta delta) {
            if (folder.getName().equals(".settings")) {
                this.processPostChangeDeltaChildren(delta);
            }
        }

        private void processPostChangeFileDelta(IFile file, IResourceDelta delta) {
            if (file.getName().equals("org.eclipse.wst.common.project.facet.core.xml")) {
                this.checkForFacetFileChanges(file, delta);
            }
        }

        private void checkForFacetFileChanges(IFile file, IResourceDelta delta) {
            switch (delta.getKind()) {
                case 1: 
                case 2: 
                case 4: {
                    InternalJpaProjectManager.this.checkForJpaFacetTransition(file.getProject());
                    break;
                }
                case 8: {
                    break;
                }
                case 16: {
                    break;
                }
            }
        }

        private void processPostChangeDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostChangeDelta(child);
                ++n2;
            }
        }

        private void processPostBuildEvent(IResourceChangeEvent event) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "Resource POST_BUILD event: {0}", new Object[]{event.getDelta().getResource()});
            if (event.getBuildKind() == 15) {
                this.processPostCleanBuildDelta(event.getDelta());
            }
        }

        private void processPostCleanBuildDelta(IResourceDelta delta) {
            IResource resource = delta.getResource();
            switch (resource.getType()) {
                case 8: {
                    this.processPostCleanBuildDeltaChildren(delta);
                    break;
                }
                case 4: {
                    this.processProjectPostCleanBuild((IProject)resource);
                    break;
                }
                case 2: {
                    break;
                }
                case 1: {
                    break;
                }
            }
        }

        private void processPostCleanBuildDeltaChildren(IResourceDelta delta) {
            IResourceDelta[] iResourceDeltaArray = delta.getAffectedChildren();
            int n = iResourceDeltaArray.length;
            int n2 = 0;
            while (n2 < n) {
                IResourceDelta child = iResourceDeltaArray[n2];
                this.processPostCleanBuildDelta(child);
                ++n2;
            }
        }

        private void processProjectPostCleanBuild(IProject project) {
            JptJpaCorePlugin.instance().trace(TRACE_OPTION, "\tProject CLEAN event: {0}", new Object[]{project.getName()});
            InternalJpaProjectManager.this.projectPostCleanBuild(project);
        }
    }
}

