/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.github.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.github.core.IRepositoryIdProvider;
import org.eclipse.egit.github.core.Languages;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.SearchRepository;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.eclipse.egit.ui.internal.UIIcons;
import org.eclipse.egit.ui.internal.provisional.wizards.GitRepositoryInfo;
import org.eclipse.egit.ui.internal.provisional.wizards.IRepositorySearchResult;
import org.eclipse.egit.ui.internal.provisional.wizards.NoRepositoryInfoException;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.github.core.GitHub;
import org.eclipse.mylyn.internal.github.core.GitHubException;
import org.eclipse.mylyn.internal.github.ui.GitHubUi;
import org.eclipse.mylyn.internal.github.ui.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RepositorySearchWizardPage
extends WizardPage
implements IRepositorySearchResult {
    private SearchRepository[] repositories = null;
    private final RepositoryService repositoryService;
    private Text searchText;

    public RepositorySearchWizardPage() {
        super("repoSearchPage", Messages.RepositorySearchWizardPage_Title, null);
        this.setDescription(Messages.RepositorySearchWizardPage_Description);
        this.setPageComplete(false);
        this.repositoryService = new RepositoryService();
        GitHub.configureClient((GitHubClient)this.repositoryService.getClient());
    }

    protected SearchRepository[] getRepositories() {
        return this.repositories;
    }

    public void createControl(Composite parent) {
        Composite root = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(root);
        Composite rowOne = new Composite(root, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(rowOne);
        Label searchForLabel = new Label(rowOne, 0);
        searchForLabel.setText(Messages.RepositorySearchWizardPage_SearchForRepositories);
        final Combo languageCombo = new Combo(rowOne, 12);
        languageCombo.add(Messages.RepositorySearchWizardPage_AnyLanguage);
        String[] stringArray = Languages.getLanguages();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String language = stringArray[n2];
            languageCombo.add(language);
            ++n2;
        }
        languageCombo.select(0);
        Composite rowTwo = new Composite(root, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(rowTwo);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)rowTwo);
        this.searchText = new Text(rowTwo, 2052);
        GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)this.searchText);
        final Button searchButton = new Button(rowTwo, 0);
        searchButton.setText(Messages.RepositorySearchWizardPage_SearchButton);
        searchButton.setEnabled(false);
        final TableViewer repoListViewer = new TableViewer(root);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(repoListViewer.getControl());
        repoListViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        repoListViewer.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(new DelegatingStyledCellLabelProvider.IStyledLabelProvider(){
            private Image repoImage = UIIcons.REPOSITORY.createImage();

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void dispose() {
                this.repoImage.dispose();
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public StyledString getStyledText(Object element) {
                StyledString styled = new StyledString();
                SearchRepository repo = (SearchRepository)element;
                styled.append(String.valueOf(repo.getOwner()) + "/" + repo.getName());
                String language = repo.getLanguage();
                if (language != null && language.length() > 0) {
                    styled.append(" (" + language + ")", StyledString.QUALIFIER_STYLER);
                }
                String counters = " " + MessageFormat.format(Messages.RepositorySearchWizardPage_counters, repo.getForks(), repo.getWatchers());
                styled.append(counters, StyledString.COUNTER_STYLER);
                return styled;
            }

            public Image getImage(Object element) {
                return this.repoImage;
            }
        }));
        repoListViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                RepositorySearchWizardPage.this.validate(repoListViewer);
            }
        });
        this.searchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                searchButton.setEnabled(RepositorySearchWizardPage.this.searchText.getText().trim().length() != 0);
            }
        });
        searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String language = null;
                if (languageCombo.getSelectionIndex() > 0) {
                    language = languageCombo.getText();
                }
                RepositorySearchWizardPage.this.search(language, RepositorySearchWizardPage.this.searchText.getText().trim(), repoListViewer);
            }
        });
        this.setControl((Control)root);
    }

    private void validate(TableViewer viewer) {
        ISelection selection = viewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            Object[] selected = ((IStructuredSelection)selection).toArray();
            this.repositories = new SearchRepository[selected.length];
            System.arraycopy(selected, 0, this.repositories, 0, selected.length);
        }
        this.setPageComplete(!selection.isEmpty());
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.searchText.setFocus();
        }
    }

    private void search(final String language, final String text, final TableViewer viewer) {
        viewer.setSelection((ISelection)StructuredSelection.EMPTY);
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(MessageFormat.format(Messages.RepositorySearchWizardPage_Searching, text), 10);
                    try {
                        List repositories = RepositorySearchWizardPage.this.repositoryService.searchRepositories(text.trim(), language);
                        PlatformUI.getWorkbench().getDisplay().syncExec(() -> {
                            if (viewer.getControl().isDisposed()) {
                                return;
                            }
                            RepositorySearchWizardPage.this.setMessage(MessageFormat.format(Messages.RepositorySearchWizardPage_Found, repositories.size()), 1);
                            viewer.setInput((Object)repositories);
                            RepositorySearchWizardPage.this.validate(viewer);
                        });
                    }
                    catch (IOException e) {
                        throw new InvocationTargetException(GitHubException.wrap((IOException)e));
                    }
                }
            });
            this.setErrorMessage(null);
        }
        catch (InvocationTargetException e) {
            viewer.setInput(Collections.emptyList());
            Throwable cause = e.getCause();
            if (cause == null) {
                cause = e;
            }
            this.setErrorMessage(MessageFormat.format(Messages.RepositorySearchWizardPage_Error, cause.getLocalizedMessage()));
        }
        catch (InterruptedException e) {
            GitHubUi.logError(e);
        }
    }

    public GitRepositoryInfo getGitRepositoryInfo() throws NoRepositoryInfoException {
        String cloneUrl = null;
        try {
            Repository fullRepo = this.repositoryService.getRepository((IRepositoryIdProvider)this.repositories[0]);
            cloneUrl = fullRepo.getCloneUrl();
        }
        catch (IOException e) {
            throw new NoRepositoryInfoException(e.getMessage(), (Throwable)e);
        }
        return new GitRepositoryInfo(cloneUrl);
    }
}

