/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.canonical.internal.provider;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.CompartmentEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IBorderedShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.CreateEditPoliciesOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpolicy.IEditPolicyProvider;
import org.eclipse.papyrus.infra.gmfdiag.canonical.editpolicy.PapyrusCanonicalEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.service.ProviderServiceUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.utils.ServiceUtilsForEditPart;
import org.osgi.framework.ServiceException;

public class PapyrusCanonicalEditPolicyProvider
extends AbstractProvider
implements IEditPolicyProvider {
    public void createEditPolicies(EditPart editPart) {
        if (this.supportsCanonical(editPart) && (editPart instanceof DiagramEditPart || editPart instanceof CompartmentEditPart || editPart instanceof IBorderedShapeEditPart)) {
            editPart.installEditPolicy((Object)"Canonical", (EditPolicy)new PapyrusCanonicalEditPolicy());
        }
    }

    protected boolean supportsCanonical(EditPart editPart) {
        boolean result = false;
        if (!(editPart instanceof ITextAwareEditPart)) {
            result = editPart instanceof DiagramEditPart || editPart instanceof CompartmentEditPart || editPart instanceof IBorderedShapeEditPart;
        }
        return result;
    }

    public boolean provides(IOperation operation) {
        CreateEditPoliciesOperation epOperation = (CreateEditPoliciesOperation)operation;
        EditPart gep = epOperation.getEditPart();
        if (!ProviderServiceUtil.isPapyrusPart((EditPart)gep)) {
            return false;
        }
        try {
            if (ServiceUtilsForEditPart.getInstance().getServiceRegistry(gep) == null) {
                return false;
            }
        }
        catch (ServiceException ex) {
            return false;
        }
        catch (org.eclipse.papyrus.infra.core.services.ServiceException e) {
            return false;
        }
        return this.supportsCanonical(gep);
    }
}

