/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.util.Collection;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.agreements.AgreementToAccept;
import org.eclipse.passage.lic.api.diagnostic.Diagnostic;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AgreementsWizardDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.DiagnosticDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.EnvironmentStateDialog;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.ImportLicenseDialog;
import org.eclipse.swt.widgets.Shell;

public abstract class GoodIntention {
    public abstract boolean paveTheWay();

    static final class Diagnose
    extends GoodIntention {
        private final Supplier<Shell> shell;
        private final Diagnostic diagnostic;

        Diagnose(Supplier<Shell> shell, Diagnostic diagnostic) {
            this.shell = shell;
            this.diagnostic = diagnostic;
        }

        @Override
        public boolean paveTheWay() {
            new DiagnosticDialog(this.shell.get(), this.diagnostic).open();
            return false;
        }
    }

    static final class ExposeLicenseAgreements
    extends GoodIntention {
        private final Supplier<Shell> shell;
        private final Collection<AgreementToAccept> agreements;

        ExposeLicenseAgreements(Supplier<Shell> shell, Collection<AgreementToAccept> agreements) {
            this.shell = shell;
            this.agreements = agreements;
        }

        @Override
        public boolean paveTheWay() {
            int result = new AgreementsWizardDialog(this.shell.get(), this.agreements).open();
            return result == 0;
        }
    }

    static final class ImportLicense
    extends GoodIntention {
        private final Supplier<Shell> shell;

        ImportLicense(Supplier<Shell> shell) {
            this.shell = shell;
        }

        @Override
        public boolean paveTheWay() {
            return new ImportLicenseDialog(this.shell.get()).open() == 0;
        }
    }

    static final class Nope
    extends GoodIntention {
        Nope() {
        }

        @Override
        public boolean paveTheWay() {
            return false;
        }
    }

    static final class RequestLicense
    extends GoodIntention {
        private final Supplier<Shell> shell;

        RequestLicense(Supplier<Shell> shell) {
            this.shell = shell;
        }

        @Override
        public boolean paveTheWay() {
            new EnvironmentStateDialog(this.shell.get()).open();
            return false;
        }
    }
}

