/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.editors.ecl;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.source.CompositeRuler;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.IVerticalRulerColumn;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.rcptt.core.ecl.model.Q7ElementContainer;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.ui.editors.ecl.EnhancedSourceViewer;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;

public class EclSourceViewer
extends EnhancedSourceViewer {
    private Q7ElementContainer elementContainer;
    private IQ7NamedElement element;

    public EclSourceViewer(Composite parent, IVerticalRuler ruler) {
        this(parent, ruler, null, false, 2818);
    }

    public EclSourceViewer(Composite parent, IVerticalRuler ruler, IOverviewRuler overviewRuler, boolean showsAnnotationOverview, int styles) {
        super(parent, ruler, overviewRuler, showsAnnotationOverview, styles);
    }

    @Override
    public void configure(SourceViewerConfiguration configuration) {
        super.configure(configuration);
    }

    public Composite getControl() {
        return (Composite)super.getControl();
    }

    public static EclSourceViewer createEclSourceViewer(Composite parent) {
        CompositeRuler ruler = new CompositeRuler();
        LineNumberRulerColumn column = new LineNumberRulerColumn(){

            public int getWidth() {
                return super.getWidth() + 10;
            }
        };
        Font font = JFaceResources.getTextFont();
        column.setFont(font);
        column.setForeground(parent.getDisplay().getSystemColor(16));
        ruler.addDecorator(0, (IVerticalRulerColumn)column);
        return new EclSourceViewer(parent, (IVerticalRuler)ruler);
    }

    public void ignoreAutoEditStrategies(boolean ignore) {
        super.ignoreAutoEditStrategies(ignore);
    }

    public synchronized Q7ElementContainer getElementContainer() {
        if (this.elementContainer != null && this.element != null && !this.elementContainer.isSameContent(this.getDocument().get(), this.element)) {
            this.elementContainer = null;
        }
        if (this.elementContainer == null) {
            this.elementContainer = new Q7ElementContainer(this.element, this.getDocument().get(), this.getDocument().getLength(), true);
        }
        return this.elementContainer;
    }

    public synchronized void clearElementContainer() {
        if (this.elementContainer != null && this.element != null && this.elementContainer.isSameContent(this.getDocument().get(), this.element)) {
            return;
        }
        this.elementContainer = null;
    }

    public IQ7NamedElement getElement() {
        return this.element;
    }

    public void setElement(IQ7NamedElement element) {
        if (this.elementContainer != null) {
            this.elementContainer = null;
        }
        this.element = element;
    }
}

