/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.LineAttributes;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.DPIUtil;
import org.eclipse.swt.internal.cocoa.CGPathElement;
import org.eclipse.swt.internal.cocoa.CGPoint;
import org.eclipse.swt.internal.cocoa.CGRect;
import org.eclipse.swt.internal.cocoa.NSAffineTransform;
import org.eclipse.swt.internal.cocoa.NSAffineTransformStruct;
import org.eclipse.swt.internal.cocoa.NSArray;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSAutoreleasePool;
import org.eclipse.swt.internal.cocoa.NSBezierPath;
import org.eclipse.swt.internal.cocoa.NSBitmapImageRep;
import org.eclipse.swt.internal.cocoa.NSColor;
import org.eclipse.swt.internal.cocoa.NSGradient;
import org.eclipse.swt.internal.cocoa.NSGraphicsContext;
import org.eclipse.swt.internal.cocoa.NSImage;
import org.eclipse.swt.internal.cocoa.NSLayoutManager;
import org.eclipse.swt.internal.cocoa.NSMutableDictionary;
import org.eclipse.swt.internal.cocoa.NSNumber;
import org.eclipse.swt.internal.cocoa.NSPoint;
import org.eclipse.swt.internal.cocoa.NSRange;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSScreen;
import org.eclipse.swt.internal.cocoa.NSScrollView;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTextContainer;
import org.eclipse.swt.internal.cocoa.NSTextStorage;
import org.eclipse.swt.internal.cocoa.NSThread;
import org.eclipse.swt.internal.cocoa.NSView;
import org.eclipse.swt.internal.cocoa.OS;

public final class GC
extends Resource {
    public NSGraphicsContext handle;
    Drawable drawable;
    GCData data;
    GCTextData.Cache textDataCache = new GCTextData.Cache(20);
    CGPathElement element;
    int count;
    int typeCount;
    byte[] types;
    double[] points;
    double[] point;
    static final int TAB_COUNT = 32;
    static final int FOREGROUND = 1;
    static final int BACKGROUND = 2;
    static final int FONT = 4;
    static final int LINE_STYLE = 8;
    static final int LINE_CAP = 16;
    static final int LINE_JOIN = 32;
    static final int LINE_WIDTH = 64;
    static final int LINE_MITERLIMIT = 128;
    static final int FOREGROUND_FILL = 256;
    static final int DRAW_OFFSET = 512;
    static final int CLIPPING = 1024;
    static final int TRANSFORM = 2048;
    static final int VISIBLE_REGION = 4096;
    static final int DRAW = 3833;
    static final int FILL = 3074;
    static final float[] LINE_DOT = new float[]{1.0f, 1.0f};
    static final float[] LINE_DASH = new float[]{3.0f, 1.0f};
    static final float[] LINE_DASHDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DASHDOTDOT = new float[]{3.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    static final float[] LINE_DOT_ZERO = new float[]{3.0f, 3.0f};
    static final float[] LINE_DASH_ZERO = new float[]{18.0f, 6.0f};
    static final float[] LINE_DASHDOT_ZERO = new float[]{9.0f, 6.0f, 3.0f, 6.0f};
    static final float[] LINE_DASHDOTDOT_ZERO = new float[]{9.0f, 3.0f, 3.0f, 3.0f, 3.0f, 3.0f};

    GC() {
    }

    public GC(Drawable drawable) {
        this(drawable, 0);
    }

    public GC(Drawable drawable, int style) {
        if (drawable == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            GCData data = new GCData();
            data.style = GC.checkStyle(style);
            long contextId = drawable.internal_new_GC(data);
            Device device = data.device;
            if (device == null) {
                device = Device.getDevice();
            }
            if (device == null) {
                SWT.error(4);
            }
            this.device = data.device = device;
            this.init(drawable, data, contextId);
            this.init();
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    static int checkStyle(int style) {
        if ((style & 0x2000000) != 0) {
            style &= 0xFBFFFFFF;
        }
        return style & 0x6000000;
    }

    public static GC cocoa_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        long context = drawable.internal_new_GC(data);
        gc.device = data.device;
        gc.init(drawable, data, context);
        return gc;
    }

    long applierFunc(long info, long elementPtr) {
        OS.memmove(this.element, elementPtr, (long)CGPathElement.sizeof);
        int type = 0;
        int length = 1;
        switch (this.element.type) {
            case 0: {
                type = 1;
                break;
            }
            case 1: {
                type = 2;
                break;
            }
            case 2: {
                type = 3;
                length = 2;
                break;
            }
            case 3: {
                type = 4;
                length = 3;
                break;
            }
            case 4: {
                type = 5;
                length = 0;
            }
        }
        if (this.types != null) {
            this.types[this.typeCount] = (byte)type;
            if (length > 0) {
                C.memmove(this.point, this.element.points, (long)(length * CGPoint.sizeof));
                System.arraycopy(this.point, 0, this.points, this.count, length * 2);
            }
        }
        ++this.typeCount;
        this.count += length * 2;
        return 0L;
    }

    NSAutoreleasePool checkGC(int mask) {
        NSColor fg;
        double[] color;
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        if (this.data.flippedContext != null && !this.handle.isEqual(NSGraphicsContext.currentContext())) {
            this.data.restoreContext = true;
            NSGraphicsContext.static_saveGraphicsState();
            NSGraphicsContext.setCurrentContext(this.handle);
        }
        if ((mask & 0xC00) != 0) {
            NSView view = this.data.view;
            if ((this.data.state & 0x400) == 0 || (this.data.state & 0x800) == 0 || (this.data.state & 0x1000) == 0) {
                boolean antialias = this.handle.shouldAntialias();
                this.handle.restoreGraphicsState();
                this.handle.saveGraphicsState();
                this.handle.setShouldAntialias(antialias);
                if (!(view == null || this.data.paintRect != null && view.isFlipped())) {
                    NSAffineTransform transform = NSAffineTransform.transform();
                    NSRect rect = view.convertRect_toView_(view.bounds(), null);
                    if (this.data.paintRect == null) {
                        transform.translateXBy(rect.x, rect.y + rect.height);
                    } else {
                        transform.translateXBy(0.0, rect.height);
                    }
                    transform.scaleXBy(1.0, -1.0);
                    transform.concat();
                    if (this.data.visibleRgn != 0L) {
                        if (this.data.visiblePath == null || (this.data.state & 0x1000) == 0) {
                            if (this.data.visiblePath != null) {
                                this.data.visiblePath.release();
                            }
                            this.data.visiblePath = Region.cocoa_new(this.device, this.data.visibleRgn).getPath();
                        }
                        this.data.visiblePath.addClip();
                        this.data.state |= 0x1000;
                    }
                }
                if (this.data.clipPath != null) {
                    this.data.clipPath.addClip();
                }
                if (this.data.transform != null) {
                    this.data.transform.concat();
                }
                mask &= 0xFFFFF3FF;
                this.data.state |= 0xC00;
                this.data.state &= 0xFFFFFFFC;
            }
        }
        OS.CGContextSetBlendMode(this.handle.graphicsPort(), this.data.xorMode ? 10 : 0);
        int state = this.data.state;
        if ((state & mask) == mask) {
            return pool;
        }
        state = (state ^ mask) & mask;
        this.data.state |= mask;
        if ((state & 1) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setStroke();
                }
            } else {
                color = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                fg = this.data.fg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                fg.retain();
                fg.setStroke();
            }
        }
        if ((state & 0x100) != 0) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                color = this.data.foreground;
                if (this.data.fg != null) {
                    this.data.fg.release();
                }
                fg = this.data.fg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                fg.retain();
                fg.setFill();
            }
            this.data.state &= 0xFFFFFFFD;
        }
        if ((state & 2) != 0) {
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    pattern.color.setFill();
                }
            } else {
                color = this.data.background;
                if (this.data.bg != null) {
                    this.data.bg.release();
                }
                NSColor bg = this.data.bg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                bg.retain();
                bg.setFill();
            }
            this.data.state &= 0xFFFFFEFF;
        }
        NSBezierPath path = this.data.path;
        if ((state & 0x40) != 0) {
            path.setLineWidth(this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                double[] lengths = new double[dashes.length];
                int i = 0;
                while (i < lengths.length) {
                    lengths[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                path.setLineDash(lengths, lengths.length, this.data.lineDashesOffset);
            } else {
                path.setLineDash(null, 0L, 0.0);
            }
        }
        if ((state & 0x80) != 0) {
            path.setMiterLimit(this.data.lineMiterLimit);
        }
        if ((state & 0x20) != 0) {
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 0;
                    break;
                }
                case 2: {
                    joinStyle = 1;
                    break;
                }
                case 3: {
                    joinStyle = 2;
                }
            }
            path.setLineJoinStyle(joinStyle);
        }
        if ((state & 0x10) != 0) {
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 1;
                    break;
                }
                case 1: {
                    capStyle = 0;
                    break;
                }
                case 3: {
                    capStyle = 2;
                }
            }
            path.setLineCapStyle(capStyle);
        }
        if ((state & 0x200) != 0) {
            double strokeWidth;
            double scaling;
            this.data.drawYOffset = 0.0;
            this.data.drawXOffset = 0.0;
            NSSize size = new NSSize();
            size.height = 1.0;
            size.width = 1.0;
            if (this.data.transform != null) {
                size = this.data.transform.transformSize(size);
            }
            if ((scaling = size.width) < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.drawXOffset = 0.5 / scaling;
            }
            if ((scaling = size.height) < 0.0) {
                scaling = -scaling;
            }
            if ((strokeWidth = (double)this.data.lineWidth * scaling) == 0.0 || (int)strokeWidth % 2 == 1) {
                this.data.drawYOffset = 0.5 / scaling;
            }
        }
        return pool;
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            if (this.data.image != null) {
                int srcX = x;
                int srcY = y;
                boolean destX = false;
                int destY = 0;
                int scaleFactor = DPIUtil.getDeviceZoom() / 100;
                NSSize srcSize = this.data.image.handle.size();
                int imgHeight = (int)srcSize.height;
                int destWidth = (int)srcSize.width - x;
                int destHeight = (int)srcSize.height - y;
                int srcWidth = destWidth;
                int srcHeight = destHeight;
                NSGraphicsContext context = NSGraphicsContext.graphicsContextWithBitmapImageRep(image.getRepresentation());
                NSGraphicsContext.static_saveGraphicsState();
                NSGraphicsContext.setCurrentContext(context);
                NSAffineTransform transform = NSAffineTransform.transform();
                NSSize size = image.handle.size();
                transform.translateXBy(0.0, size.height - (double)(destHeight + 2 * destY));
                transform.concat();
                NSRect srcRect = new NSRect();
                srcRect.x = srcX;
                srcRect.y = imgHeight - (srcY + srcHeight);
                srcRect.width = srcWidth;
                srcRect.height = srcHeight;
                NSRect destRect = new NSRect();
                destRect.x = (double)destX;
                destRect.y = destY;
                destRect.width = destWidth * scaleFactor;
                destRect.height = destHeight * scaleFactor;
                this.data.image.handle.drawInRect(destRect, srcRect, 1L, 1.0);
                NSGraphicsContext.static_restoreGraphicsState();
                return;
            }
            if (this.data.view != null) {
                NSSize size = image.handle.size();
                NSView topView = this.getTopView(this.data.view);
                NSRect rect = new NSRect();
                rect.x = x;
                rect.y = y;
                rect.width = size.width;
                rect.height = size.height;
                NSBitmapImageRep imageRep = topView.bitmapImageRepForCachingDisplayInRect(rect);
                imageRep.setSize(size);
                topView.cacheDisplayInRect(rect, imageRep);
                NSBitmapImageRep rep = image.getRepresentation();
                image.handle.addRepresentation(imageRep);
                image.handle.removeRepresentation(rep);
                return;
            }
            if (this.handle.isDrawingToScreen()) {
                long countPtr;
                NSImage imageHandle = image.handle;
                NSSize size = imageHandle.size();
                NSArray screens = null;
                NSString key = null;
                screens = NSScreen.screens();
                key = NSString.stringWith("NSScreenNumber");
                CGRect rect = new CGRect();
                rect.origin.x = x;
                rect.origin.y = y;
                rect.size.width = size.width;
                rect.size.height = size.height;
                int displayCount = 16;
                long displays = C.malloc(4 * displayCount);
                if (OS.CGGetDisplaysWithRect(rect, displayCount, displays, countPtr = C.malloc(4L)) != 0) {
                    return;
                }
                int[] count = new int[1];
                int[] display = new int[1];
                C.memmove(count, countPtr, (long)C.PTR_SIZEOF);
                int i = 0;
                while (i < count[0]) {
                    C.memmove(display, displays + (long)(i * 4), 4L);
                    OS.CGDisplayBounds(display[0], rect);
                    double scaling = 1.0;
                    if (screens != null) {
                        int j = 0;
                        while ((long)j < screens.count()) {
                            NSScreen screen = new NSScreen(screens.objectAtIndex(j));
                            if (display[0] == new NSNumber(screen.deviceDescription().objectForKey(key)).intValue()) {
                                scaling = screen.backingScaleFactor();
                                break;
                            }
                            ++j;
                        }
                    }
                    if (scaling > 1.0) {
                        int width = (int)(size.width * scaling);
                        int height = (int)(size.height * scaling);
                        NSBitmapImageRep rep = (NSBitmapImageRep)new NSBitmapImageRep().alloc();
                        rep = rep.initWithBitmapDataPlanes(0L, width, height, 8L, 3L, false, false, OS.NSDeviceRGBColorSpace, 3L, width * 4, 32L);
                        C.memset(rep.bitmapData(), 255, width * height * 4);
                        imageHandle.addRepresentation(rep);
                        rep.release();
                    }
                    long srcImage = 0L;
                    srcImage = OS.CGDisplayCreateImage(display[0]);
                    if (srcImage != 0L) {
                        this.copyArea(image, (int)((double)x * scaling - rect.origin.x), (int)((double)y * scaling - rect.origin.y), srcImage);
                        OS.CGImageRelease(srcImage);
                    }
                    ++i;
                }
                C.free(displays);
                C.free(countPtr);
            }
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    void copyArea(Image image, int x, int y, long srcImage) {
        if (srcImage == 0L) {
            return;
        }
        NSBitmapImageRep rep = image.getRepresentation();
        long bpc = rep.bitsPerSample();
        long width = rep.pixelsWide();
        long height = rep.pixelsHigh();
        long bpr = rep.bytesPerRow();
        long data = rep.bitmapData();
        long format = rep.bitmapFormat();
        int alphaInfo = rep.hasAlpha() ? ((format & 1L) != 0L ? 4 : 3) : ((format & 1L) != 0L ? 6 : 5);
        long colorspace = OS.CGColorSpaceCreateDeviceRGB();
        long context = OS.CGBitmapContextCreate(data, width, height, bpc, bpr, colorspace, alphaInfo);
        OS.CGColorSpaceRelease(colorspace);
        if (context != 0L) {
            CGRect rect = new CGRect();
            rect.origin.x = -x;
            rect.origin.y = y;
            rect.size.width = OS.CGImageGetWidth(srcImage);
            rect.size.height = OS.CGImageGetHeight(srcImage);
            OS.CGContextTranslateCTM(context, 0.0, -(rect.size.height - (double)height));
            OS.CGContextDrawImage(context, rect, srcImage);
            OS.CGContextRelease(context);
        }
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        this.copyArea(srcX, srcY, width, height, destX, destY, true);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY, boolean paint) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (width <= 0 || height <= 0) {
            return;
        }
        int deltaX = destX - srcX;
        int deltaY = destY - srcY;
        if (deltaX == 0 && deltaY == 0) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            Image image = this.data.image;
            if (image != null) {
                NSImage imageHandle = image.handle;
                NSSize size = imageHandle.size();
                int imgHeight = (int)size.height;
                this.handle.saveGraphicsState();
                NSAffineTransform transform = NSAffineTransform.transform();
                transform.scaleXBy(1.0, -1.0);
                transform.translateXBy(0.0, -(height + 2 * destY));
                transform.concat();
                NSRect srcRect = new NSRect();
                srcRect.x = srcX;
                srcRect.y = imgHeight - (srcY + height);
                srcRect.width = width;
                srcRect.height = height;
                NSRect destRect = new NSRect();
                destRect.x = destX;
                destRect.y = destY;
                destRect.width = width;
                destRect.height = height;
                imageHandle.drawInRect(destRect, srcRect, 1L, 1.0);
                this.handle.restoreGraphicsState();
                return;
            }
            if (this.data.view != null) {
                NSView view = this.data.view;
                NSRect visibleRect = view.visibleRect();
                if (visibleRect.width <= 0.0 || visibleRect.height <= 0.0) {
                    return;
                }
                NSRect damage = new NSRect();
                damage.x = srcX;
                damage.y = srcY;
                damage.width = width;
                damage.height = height;
                NSPoint dest = new NSPoint();
                dest.x = destX;
                dest.y = destY;
                view.lockFocus();
                NSSize delta = new NSSize();
                delta.width = deltaX;
                delta.height = deltaY;
                view.scrollRect(damage, delta);
                view.unlockFocus();
                if (paint) {
                    boolean disjoint;
                    boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                    if (disjoint) {
                        view.setNeedsDisplayInRect(damage);
                    } else {
                        if (deltaX != 0) {
                            int newX = destX - deltaX;
                            if (deltaX < 0) {
                                newX = destX + width;
                            }
                            damage.x = newX;
                            damage.width = Math.abs(deltaX);
                            view.setNeedsDisplayInRect(damage);
                        }
                        if (deltaY != 0) {
                            int newY = destY - deltaY;
                            if (deltaY < 0) {
                                newY = destY + height;
                            }
                            damage.x = srcX;
                            damage.y = newY;
                            damage.width = width;
                            damage.height = Math.abs(deltaY);
                            view.setNeedsDisplayInRect(damage);
                        }
                    }
                    NSRect srcRect = new NSRect();
                    srcRect.x = srcX;
                    srcRect.y = srcY;
                    srcRect.width = width;
                    srcRect.height = height;
                    OS.NSIntersectionRect(visibleRect, visibleRect, srcRect);
                    if (!OS.NSEqualRects(visibleRect, srcRect)) {
                        if (srcRect.x != visibleRect.x) {
                            damage.x = srcRect.x + (double)deltaX;
                            damage.y = srcRect.y + (double)deltaY;
                            damage.width = visibleRect.x - srcRect.x;
                            damage.height = srcRect.height;
                            view.setNeedsDisplayInRect(damage);
                        }
                        if (visibleRect.x + visibleRect.width != srcRect.x + srcRect.width) {
                            damage.x = srcRect.x + visibleRect.width + (double)deltaX;
                            damage.y = srcRect.y + (double)deltaY;
                            damage.width = srcRect.width - visibleRect.width;
                            damage.height = srcRect.height;
                            view.setNeedsDisplayInRect(damage);
                        }
                        if (visibleRect.y != srcRect.y) {
                            damage.x = visibleRect.x + (double)deltaX;
                            damage.y = srcRect.y + (double)deltaY;
                            damage.width = visibleRect.width;
                            damage.height = visibleRect.y - srcRect.y;
                            view.setNeedsDisplayInRect(damage);
                        }
                        if (visibleRect.y + visibleRect.height != srcRect.y + srcRect.height) {
                            damage.x = visibleRect.x + (double)deltaX;
                            damage.y = visibleRect.y + visibleRect.height + (double)deltaY;
                            damage.width = visibleRect.width;
                            damage.height = srcRect.y + srcRect.height - (visibleRect.y + visibleRect.height);
                            view.setNeedsDisplayInRect(damage);
                        }
                    }
                }
                return;
            }
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    static long createCGPathRef(NSBezierPath nsPath) {
        long count = nsPath.elementCount();
        if (count > 0L) {
            long points;
            long cgPath = OS.CGPathCreateMutable();
            if (cgPath == 0L) {
                SWT.error(2);
            }
            if ((points = C.malloc(NSPoint.sizeof * 3)) == 0L) {
                SWT.error(2);
            }
            double[] pt = new double[6];
            int i = 0;
            while ((long)i < count) {
                int element = (int)nsPath.elementAtIndex(i, points);
                switch (element) {
                    case 0: {
                        C.memmove(pt, points, (long)NSPoint.sizeof);
                        OS.CGPathMoveToPoint(cgPath, 0L, pt[0], pt[1]);
                        break;
                    }
                    case 1: {
                        C.memmove(pt, points, (long)NSPoint.sizeof);
                        OS.CGPathAddLineToPoint(cgPath, 0L, pt[0], pt[1]);
                        break;
                    }
                    case 2: {
                        C.memmove(pt, points, (long)(NSPoint.sizeof * 3));
                        OS.CGPathAddCurveToPoint(cgPath, 0L, pt[0], pt[1], pt[2], pt[3], pt[4], pt[5]);
                        break;
                    }
                    case 3: {
                        OS.CGPathCloseSubpath(cgPath);
                    }
                }
                ++i;
            }
            C.free(points);
            return cgPath;
        }
        return 0L;
    }

    void createLayout() {
        NSSize size = new NSSize();
        size.width = 5000000.0;
        size.height = 5000000.0;
        NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
        NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
        layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
        NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
        textContainer = textContainer.initWithContainerSize(size);
        textContainer.setLineFragmentPadding(0.0);
        textStorage.addLayoutManager(layoutManager);
        layoutManager.addTextContainer(textContainer);
        layoutManager.release();
        textContainer.release();
        this.data.textContainer = textContainer;
        this.data.layoutManager = layoutManager;
        this.data.textStorage = textStorage;
    }

    NSAttributedString createString(String string, int flags, boolean draw) {
        NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(5L);
        Font font = this.data.font;
        dict.setObject(font.handle, OS.NSFontAttributeName);
        font.addTraits(dict);
        if (draw) {
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                if (pattern.color != null) {
                    dict.setObject(pattern.color, OS.NSForegroundColorAttributeName);
                }
            } else {
                NSColor fg = this.data.fg;
                if (fg == null) {
                    double[] color = this.data.foreground;
                    fg = this.data.fg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                    fg.retain();
                }
                dict.setObject(fg, OS.NSForegroundColorAttributeName);
            }
        }
        if ((flags & 4) == 0) {
            dict.setObject(this.device.paragraphStyle, OS.NSParagraphStyleAttributeName);
        }
        int length = string.length();
        char[] chars = new char[length];
        string.getChars(0, length, chars, 0);
        if ((flags & 8) != 0 || (flags & 2) == 0) {
            int i = 0;
            int j = 0;
            block4: while (i < chars.length) {
                int n = j++;
                char c = chars[i++];
                chars[n] = c;
                char c2 = c;
                switch (c2) {
                    case '&': {
                        if ((flags & 8) == 0 || i == chars.length) continue block4;
                        if (chars[i] == '&') {
                            ++i;
                            break;
                        }
                        --j;
                        break;
                    }
                    case '\n': 
                    case '\r': {
                        if ((flags & 2) != 0) break;
                        if (c2 == '\r' && i != chars.length && chars[i] == '\n') {
                            ++i;
                        }
                        --j;
                    }
                }
            }
            length = j;
        }
        NSString str = ((NSString)new NSString().alloc()).initWithCharacters(chars, length);
        NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(str, dict);
        dict.release();
        str.release();
        return attribStr;
    }

    NSBezierPath createNSBezierPath(long cgPath) {
        Callback callback = new Callback(this, "applierFunc", 2);
        long proc = callback.getAddress();
        this.typeCount = 0;
        this.count = 0;
        this.element = new CGPathElement();
        OS.CGPathApply(cgPath, 0L, proc);
        this.types = new byte[this.typeCount];
        this.points = new double[this.count];
        this.point = new double[6];
        this.typeCount = 0;
        this.count = 0;
        OS.CGPathApply(cgPath, 0L, proc);
        callback.dispose();
        NSBezierPath bezierPath = NSBezierPath.bezierPath();
        NSPoint nsPoint = new NSPoint();
        NSPoint nsPoint2 = new NSPoint();
        NSPoint nsPoint3 = new NSPoint();
        int i = 0;
        int j = 0;
        while (i < this.types.length) {
            switch (this.types[i]) {
                case 1: {
                    nsPoint.x = this.points[j++];
                    nsPoint.y = this.points[j++];
                    bezierPath.moveToPoint(nsPoint);
                    break;
                }
                case 2: {
                    nsPoint.x = this.points[j++];
                    nsPoint.y = this.points[j++];
                    bezierPath.lineToPoint(nsPoint);
                    break;
                }
                case 4: {
                    nsPoint2.x = this.points[j++];
                    nsPoint2.y = this.points[j++];
                    nsPoint3.x = this.points[j++];
                    nsPoint3.y = this.points[j++];
                    nsPoint.x = this.points[j++];
                    nsPoint.y = this.points[j++];
                    bezierPath.curveToPoint(nsPoint, nsPoint2, nsPoint3);
                    break;
                }
                case 3: {
                    double currentX = nsPoint.x;
                    double currentY = nsPoint.y;
                    nsPoint2.x = this.points[j++];
                    nsPoint2.y = this.points[j++];
                    nsPoint.x = this.points[j++];
                    nsPoint.y = this.points[j++];
                    double x0 = currentX;
                    double y0 = currentY;
                    double cx1 = x0 + 2.0 * (nsPoint2.x - x0) / 3.0;
                    double cy1 = y0 + 2.0 * (nsPoint2.y - y0) / 3.0;
                    double cx2 = cx1 + (nsPoint.x - x0) / 3.0;
                    double cy2 = cy1 + (nsPoint.y - y0) / 3.0;
                    nsPoint2.x = cx1;
                    nsPoint2.y = cy1;
                    nsPoint3.x = cx2;
                    nsPoint3.y = cy2;
                    bezierPath.curveToPoint(nsPoint, nsPoint2, nsPoint3);
                    break;
                }
                case 5: {
                    bezierPath.closePath();
                    break;
                }
                default: {
                    this.dispose();
                    SWT.error(5);
                }
            }
            ++i;
        }
        this.element = null;
        this.types = null;
        this.points = null;
        nsPoint = null;
        return bezierPath;
    }

    @Override
    void destroy() {
        Image image = this.data.image;
        if (image != null) {
            image.memGC = null;
            image.createAlpha();
        }
        if (this.data.textStorage != null) {
            this.data.textStorage.release();
        }
        this.data.textStorage = null;
        this.data.layoutManager = null;
        this.data.textContainer = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        if (this.data.path != null) {
            this.data.path.release();
        }
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
        }
        if (this.data.visiblePath != null) {
            this.data.visiblePath.release();
        }
        if (this.data.transform != null) {
            this.data.transform.release();
        }
        if (this.data.inverseTransform != null) {
            this.data.inverseTransform.release();
        }
        this.data.visiblePath = null;
        this.data.clipPath = null;
        this.data.path = null;
        this.data.inverseTransform = null;
        this.data.transform = null;
        this.data.bg = null;
        this.data.fg = null;
        this.textDataCache.release();
        if (this.drawable != null) {
            this.drawable.internal_dispose_GC(this.handle.id, this.data);
        }
        this.handle.restoreGraphicsState();
        this.handle.release();
        this.drawable = null;
        this.data.image = null;
        this.data = null;
        this.handle = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            double xOffset = this.data.drawXOffset;
            double yOffset = this.data.drawYOffset;
            transform.translateXBy((double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
            transform.scaleXBy((float)width / 2.0f, (float)height / 2.0f);
            NSBezierPath path = this.data.path;
            NSPoint center = new NSPoint();
            float sAngle = -startAngle;
            float eAngle = -(startAngle + arcAngle);
            path.appendBezierPathWithArcWithCenter(center, 1.0, sAngle, eAngle, arcAngle > 0);
            path.transformUsingAffineTransform(transform);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            int[] metric = new int[1];
            OS.GetThemeMetric(7, metric);
            CGRect rect = new CGRect();
            rect.origin.x = x + metric[0];
            rect.origin.y = y + metric[0];
            rect.size.width = width - metric[0] * 2;
            rect.size.height = height - metric[0] * 2;
            OS.HIThemeDrawFocusRect(rect, true, this.handle.graphicsPort(), 0);
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        NSImage imageHandle = srcImage.handle;
        NSSize size = imageHandle.size();
        int imgWidth = (int)size.width;
        int imgHeight = (int)size.height;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            boolean bl = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            if (srcImage.memGC != null) {
                srcImage.createAlpha();
            }
            this.handle.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.scaleXBy(1.0, -1.0);
            transform.translateXBy(0.0, -(destHeight + 2 * destY));
            transform.concat();
            NSRect srcRect = new NSRect();
            srcRect.x = srcX;
            srcRect.y = imgHeight - (srcY + srcHeight);
            srcRect.width = srcWidth;
            srcRect.height = srcHeight;
            NSRect destRect = new NSRect();
            destRect.x = destX;
            destRect.y = destY;
            destRect.width = destWidth;
            destRect.height = destHeight;
            imageHandle.drawInRect(destRect, srcRect, 2L, (float)this.data.alpha / 255.0f);
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (x1 == x2 && y1 == y2 && this.data.lineWidth <= 1.0f) {
            this.drawPoint(x1, y1);
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            NSBezierPath path = this.data.path;
            NSPoint pt = new NSPoint();
            pt.x = (double)x1 + this.data.drawXOffset;
            pt.y = (double)y1 + this.data.drawYOffset;
            path.moveToPoint(pt);
            pt.x = (double)x2 + this.data.drawXOffset;
            pt.y = (double)y2 + this.data.drawYOffset;
            path.lineToPoint(pt);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSBezierPath path = this.data.path;
            NSRect rect = new NSRect();
            rect.x = (double)x + this.data.drawXOffset;
            rect.y = (double)y + this.data.drawXOffset;
            rect.width = width;
            rect.height = height;
            path.appendBezierPathWithOvalInRect(rect);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            transform.translateXBy(this.data.drawXOffset, this.data.drawYOffset);
            transform.concat();
            NSBezierPath drawPath = this.data.path;
            drawPath.appendBezierPath(path.handle);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(drawPath, pattern);
            } else {
                drawPath.stroke();
            }
            drawPath.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawPoint(int x, int y) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3328);
        try {
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = 1.0;
            rect.height = 1.0;
            NSBezierPath path = this.data.path;
            path.appendBezierPathWithRect(rect);
            path.fill();
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 4) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            double xOffset = this.data.drawXOffset;
            double yOffset = this.data.drawYOffset;
            NSBezierPath path = this.data.path;
            NSPoint pt = new NSPoint();
            pt.x = (double)pointArray[0] + xOffset;
            pt.y = (double)pointArray[1] + yOffset;
            path.moveToPoint(pt);
            int end = pointArray.length / 2 * 2;
            int i = 2;
            while (i < end) {
                pt.x = (double)pointArray[i] + xOffset;
                pt.y = (double)pointArray[i + 1] + yOffset;
                path.lineToPoint(pt);
                i += 2;
            }
            path.closePath();
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 4) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            double xOffset = this.data.drawXOffset;
            double yOffset = this.data.drawYOffset;
            NSBezierPath path = this.data.path;
            NSPoint pt = new NSPoint();
            pt.x = (double)pointArray[0] + xOffset;
            pt.y = (double)pointArray[1] + yOffset;
            path.moveToPoint(pt);
            int end = pointArray.length / 2 * 2;
            int i = 2;
            while (i < end) {
                pt.x = (double)pointArray[i] + xOffset;
                pt.y = (double)pointArray[i + 1] + yOffset;
                path.lineToPoint(pt);
                i += 2;
            }
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSRect rect = new NSRect();
            rect.x = (double)x + this.data.drawXOffset;
            rect.y = (double)y + this.data.drawYOffset;
            rect.width = width;
            rect.height = height;
            NSBezierPath path = this.data.path;
            path.appendBezierPathWithRect(rect);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawRectangle(Rectangle rect) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.drawRectangle(x, y, width, height);
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3833);
        try {
            NSBezierPath path = this.data.path;
            NSRect rect = new NSRect();
            rect.x = (double)x + this.data.drawXOffset;
            rect.y = (double)y + this.data.drawYOffset;
            rect.width = width;
            rect.height = height;
            path.appendBezierPathWithRoundedRect(rect, (float)arcWidth / 2.0f, (float)arcHeight / 2.0f);
            Pattern pattern = this.data.foregroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.strokePattern(path, pattern);
            } else {
                path.stroke();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        this.drawText(string, x, y, isTransparent ? 1 : 0);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = this.checkGC(3332);
        try {
            int length = string.length();
            if (length == 0) {
                return;
            }
            boolean mode = true;
            switch (this.data.textAntialias) {
                case -1: {
                    if (this.handle.isDrawingToScreen()) break;
                    mode = false;
                    break;
                }
                case 0: {
                    mode = false;
                    break;
                }
                case 1: {
                    mode = true;
                }
            }
            this.handle.saveGraphicsState();
            this.handle.setShouldAntialias(mode);
            if (length == 1 && (flags & 1) != 0) {
                this.doFastDrawText(string, x, y);
            } else {
                this.doDrawText(string, x, y, flags);
            }
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    private void doFastDrawText(String string, int x, int y) {
        GCTextData data = this.getTextData(string);
        data.draw(x, y);
    }

    private GCTextData getTextData(String string) {
        GCTextData.Key key = new GCTextData.Key(string, this.data.alpha, this.data.font == null || this.data.font.handle == null ? 0L : this.data.font.handle.id, this.data.foreground);
        GCTextData gcData = this.textDataCache.get(key);
        if (gcData == null) {
            NSAttributedString attribStr = this.createString(string, 0, true);
            gcData = new GCTextData(attribStr);
            attribStr.release();
            this.textDataCache.put(key, gcData);
        }
        return gcData;
    }

    private void doDrawText(String string, int x, int y, int flags) {
        if (this.data.textStorage == null) {
            this.createLayout();
        }
        NSAttributedString attribStr = this.createString(string, flags, true);
        this.data.textStorage.setAttributedString(attribStr);
        attribStr.release();
        NSPoint pt = new NSPoint();
        pt.x = x;
        pt.y = y;
        NSRange range = this.data.layoutManager.glyphRangeForTextContainer(this.data.textContainer);
        if ((flags & 1) == 0) {
            NSRect rect = this.data.layoutManager.usedRectForTextContainer(this.data.textContainer);
            rect.x = x;
            rect.y = y;
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                NSBezierPath path = NSBezierPath.bezierPathWithRect(rect);
                this.fillPattern(path, pattern);
            } else {
                NSColor bg = this.data.bg;
                if (bg == null) {
                    double[] color = this.data.background;
                    bg = this.data.bg = NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f);
                    bg.retain();
                }
                bg.setFill();
                NSBezierPath.fillRect(rect);
            }
        }
        this.data.layoutManager.drawGlyphsForGlyphRange(range, pt);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof GC)) {
            return false;
        }
        return this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || arcAngle == 0) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            this.handle.saveGraphicsState();
            NSAffineTransform transform = NSAffineTransform.transform();
            double xOffset = this.data.drawXOffset;
            double yOffset = this.data.drawYOffset;
            transform.translateXBy((double)x + xOffset + (double)((float)width / 2.0f), (double)y + yOffset + (double)((float)height / 2.0f));
            transform.scaleXBy((float)width / 2.0f, (float)height / 2.0f);
            NSBezierPath path = this.data.path;
            NSPoint center = new NSPoint();
            path.moveToPoint(center);
            float sAngle = -startAngle;
            float eAngle = -(startAngle + arcAngle);
            path.appendBezierPathWithArcWithCenter(center, 1.0, sAngle, eAngle, arcAngle > 0);
            path.closePath();
            path.transformUsingAffineTransform(transform);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
            this.handle.restoreGraphicsState();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        try {
            RGB foregroundRGB;
            RGB backgroundRGB = this.getBackground().getRGB();
            RGB fromRGB = foregroundRGB = this.getForeground().getRGB();
            RGB toRGB = backgroundRGB;
            boolean swapColors = false;
            if (width < 0) {
                x += width;
                width = -width;
                if (!vertical) {
                    swapColors = true;
                }
            }
            if (height < 0) {
                y += height;
                height = -height;
                if (vertical) {
                    swapColors = true;
                }
            }
            if (swapColors) {
                fromRGB = backgroundRGB;
                toRGB = foregroundRGB;
            }
            if (fromRGB.equals(toRGB)) {
                this.fillRectangle(x, y, width, height);
            } else {
                NSColor startingColor = NSColor.colorWithDeviceRed((float)fromRGB.red / 255.0f, (float)fromRGB.green / 255.0f, (float)fromRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
                NSColor endingColor = NSColor.colorWithDeviceRed((float)toRGB.red / 255.0f, (float)toRGB.green / 255.0f, (float)toRGB.blue / 255.0f, (float)this.data.alpha / 255.0f);
                NSGradient gradient = ((NSGradient)new NSGradient().alloc()).initWithStartingColor(startingColor, endingColor);
                NSRect rect = new NSRect();
                rect.x = x;
                rect.y = y < 0 ? 0 : y;
                rect.width = width;
                rect.height = height;
                gradient.drawInRect(rect, vertical ? 90 : 0);
                gradient.release();
            }
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSBezierPath path = this.data.path;
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            path.appendBezierPathWithOvalInRect(rect);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    /*
     * Unable to fully structure code
     */
    void fillPattern(NSBezierPath path, Pattern pattern) {
        block7: {
            this.handle.saveGraphicsState();
            path.addClip();
            bounds = path.bounds();
            start = new NSPoint();
            start.x = pattern.pt1.x;
            start.y = pattern.pt1.y;
            end = new NSPoint();
            end.x = pattern.pt2.x;
            end.y = pattern.pt2.y;
            difx = end.x - start.x;
            dify = end.y - start.y;
            if (difx == 0.0 && dify == 0.0) {
                color = pattern.color1;
                NSColor.colorWithDeviceRed(color[0], color[1], color[2], (float)this.data.alpha / 255.0f).setFill();
                path.fill();
                this.handle.restoreGraphicsState();
                return;
            }
            if (difx == 0.0 || dify == 0.0) {
                startx = bounds.x;
                starty = bounds.y;
                endx = bounds.x + bounds.width;
                endy = bounds.y + bounds.height;
                if (difx < 0.0 || dify < 0.0) {
                    startx = endx;
                    starty = endy;
                    endx = bounds.x;
                    endy = bounds.y;
                }
            } else {
                m = (end.y - start.y) / (end.x - start.x);
                b = end.y - m * end.x;
                m2 = -1.0 / m;
                b2 = bounds.y - m2 * bounds.x;
                startx = endx = (b - b2) / (m2 - m);
                b2 = bounds.y + bounds.height - m2 * bounds.x;
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                b2 = bounds.y - m2 * (bounds.x + bounds.width);
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                b2 = bounds.y + bounds.height - m2 * (bounds.x + bounds.width);
                x2 = (b - b2) / (m2 - m);
                startx = difx > 0.0 ? Math.min(startx, x2) : Math.max(startx, x2);
                endx = difx < 0.0 ? Math.min(endx, x2) : Math.max(endx, x2);
                starty = m * startx + b;
                endy = m * endx + b;
            }
            if (difx == 0.0) ** GOTO lbl56
            while (difx > 0.0 && start.x >= startx || difx < 0.0 && start.x <= startx) {
                start.x -= difx;
                start.y -= dify;
            }
            break block7;
lbl-1000:
            // 1 sources

            {
                start.x -= difx;
                start.y -= dify;
lbl56:
                // 2 sources

                ** while (dify > 0.0 && start.y >= starty || dify < 0.0 && start.y <= starty)
            }
        }
        end.x = start.x;
        end.y = start.y;
        do {
            end.x += difx;
            end.y += dify;
            pattern.gradient.drawFromPoint(start, end, 0L);
            start.x = end.x;
            start.y = end.y;
        } while (difx > 0.0 && end.x <= endx || difx < 0.0 && end.x >= endx || difx == 0.0 && (dify > 0.0 && end.y <= endy || dify < 0.0 && end.y >= endy));
        this.handle.restoreGraphicsState();
    }

    public void fillPath(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path == null) {
            SWT.error(4);
        }
        if (path.handle == null) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            NSBezierPath drawPath = this.data.path;
            drawPath.appendBezierPath(path.handle);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(drawPath, pattern);
            } else {
                drawPath.fill();
            }
            drawPath.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        if (pointArray.length < 4) {
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            NSBezierPath path = this.data.path;
            NSPoint pt = new NSPoint();
            pt.x = pointArray[0];
            pt.y = pointArray[1];
            path.moveToPoint(pt);
            int end = pointArray.length / 2 * 2;
            int i = 2;
            while (i < end) {
                pt.x = pointArray[i];
                pt.y = pointArray[i + 1];
                path.lineToPoint(pt);
                i += 2;
            }
            path.closePath();
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            NSBezierPath path = this.data.path;
            path.appendBezierPathWithRect(rect);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public void fillRectangle(Rectangle rect) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (arcWidth == 0 || arcHeight == 0) {
            this.fillRectangle(x, y, width, height);
            return;
        }
        NSAutoreleasePool pool = this.checkGC(3074);
        try {
            NSBezierPath path = this.data.path;
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            path.appendBezierPathWithRoundedRect(rect, (float)arcWidth / 2.0f, (float)arcHeight / 2.0f);
            Pattern pattern = this.data.backgroundPattern;
            if (pattern != null) {
                this.setPatternPhase(pattern);
            }
            if (pattern != null && pattern.gradient != null) {
                this.fillPattern(path, pattern);
            } else {
                path.fill();
            }
            path.removeAllPoints();
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    void strokePattern(NSBezierPath path, Pattern pattern) {
        this.handle.saveGraphicsState();
        long cgPath = GC.createCGPathRef(path);
        long cgContext = this.handle.graphicsPort();
        OS.CGContextSaveGState(cgContext);
        this.initCGContext(cgContext);
        OS.CGContextAddPath(cgContext, cgPath);
        OS.CGContextReplacePathWithStrokedPath(cgContext);
        OS.CGPathRelease(cgPath);
        cgPath = 0L;
        cgPath = OS.CGContextCopyPath(cgContext);
        if (cgPath == 0L) {
            SWT.error(2);
        }
        OS.CGContextRestoreGState(cgContext);
        NSBezierPath strokePath = this.createNSBezierPath(cgPath);
        OS.CGPathRelease(cgPath);
        this.fillPattern(strokePath, pattern);
        this.handle.restoreGraphicsState();
    }

    void flush() {
        this.handle.flushGraphics();
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Color getBackground() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return Color.cocoa_new(this.data.device, this.data.background);
    }

    public Pattern getBackgroundPattern() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return this.data.backgroundPattern;
    }

    public boolean getAdvanced() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return true;
    }

    public int getAlpha() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.alpha;
    }

    public int getAntialias() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.antialias;
    }

    public int getCharWidth(char ch) {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.stringExtent((String)new String((char[])new char[]{ch})).x;
    }

    public Rectangle getClipping() {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            NSRect rect = null;
            if (this.data.view != null) {
                rect = this.data.view.visibleRect();
            } else {
                rect = new NSRect();
                if (this.data.image != null) {
                    NSSize size = this.data.image.handle.size();
                    rect.width = size.width;
                    rect.height = size.height;
                } else if (this.data.size != null) {
                    rect.width = this.data.size.width;
                    rect.height = this.data.size.height;
                }
            }
            if (this.data.paintRect != null || this.data.clipPath != null || this.data.inverseTransform != null) {
                if (this.data.paintRect != null) {
                    OS.NSIntersectionRect(rect, rect, this.data.paintRect);
                }
                if (this.data.clipPath != null) {
                    NSRect clip = this.data.clipPath.bounds();
                    clip.x = (int)clip.x;
                    clip.y = (int)clip.y;
                    OS.NSIntersectionRect(rect, rect, clip);
                }
                if (this.data.inverseTransform != null && rect.width > 0.0 && rect.height > 0.0) {
                    NSPoint pt = new NSPoint();
                    pt.x = rect.x;
                    pt.y = rect.y;
                    NSSize size = new NSSize();
                    size.width = rect.width;
                    size.height = rect.height;
                    pt = this.data.inverseTransform.transformPoint(pt);
                    size = this.data.inverseTransform.transformSize(size);
                    rect.x = pt.x;
                    rect.y = pt.y;
                    rect.width = size.width;
                    rect.height = size.height;
                }
            }
            Rectangle rectangle = new Rectangle((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
            return rectangle;
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void getClipping(Region region) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if (region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            region.subtract(region);
            NSRect rect = null;
            if (this.data.view != null) {
                rect = this.data.view.visibleRect();
            } else {
                rect = new NSRect();
                if (this.data.image != null) {
                    NSSize size = this.data.image.handle.size();
                    rect.width = size.width;
                    rect.height = size.height;
                } else if (this.data.size != null) {
                    rect.width = this.data.size.width;
                    rect.height = this.data.size.height;
                }
            }
            region.add((int)rect.x, (int)rect.y, (int)rect.width, (int)rect.height);
            NSRect paintRect = this.data.paintRect;
            if (paintRect != null) {
                region.intersect((int)paintRect.x, (int)paintRect.y, (int)paintRect.width, (int)paintRect.height);
            }
            if (this.data.clipPath != null) {
                NSBezierPath clip = this.data.clipPath.bezierPathByFlatteningPath();
                int count = (int)clip.elementCount();
                int pointCount = 0;
                Region clipRgn = new Region(this.device);
                int[] pointArray = new int[count * 2];
                long points = C.malloc(NSPoint.sizeof);
                if (points == 0L) {
                    SWT.error(2);
                }
                NSPoint pt = new NSPoint();
                int i = 0;
                while (i < count) {
                    int element = (int)clip.elementAtIndex(i, points);
                    switch (element) {
                        case 0: {
                            if (pointCount != 0) {
                                clipRgn.add(pointArray, pointCount);
                            }
                            pointCount = 0;
                            OS.memmove(pt, points, (long)NSPoint.sizeof);
                            pointArray[pointCount++] = (int)pt.x;
                            pointArray[pointCount++] = (int)pt.y;
                            break;
                        }
                        case 1: {
                            OS.memmove(pt, points, (long)NSPoint.sizeof);
                            pointArray[pointCount++] = (int)pt.x;
                            pointArray[pointCount++] = (int)pt.y;
                            break;
                        }
                        case 3: {
                            if (pointCount != 0) {
                                clipRgn.add(pointArray, pointCount);
                            }
                            pointCount = 0;
                        }
                    }
                    ++i;
                }
                if (pointCount != 0) {
                    clipRgn.add(pointArray, pointCount);
                }
                C.free(points);
                region.intersect(clipRgn);
                clipRgn.dispose();
            }
            if (this.data.inverseTransform != null) {
                region.convertRgn(this.data.inverseTransform);
            }
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public int getFillRule() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.fillRule;
    }

    public Font getFont() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.font;
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = this.checkGC(4);
        try {
            if (this.data.textStorage == null) {
                this.createLayout();
            }
            if (this.data.font.metrics == null) {
                String s = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
                NSMutableDictionary dict = ((NSMutableDictionary)new NSMutableDictionary().alloc()).initWithCapacity(3L);
                dict.setObject(this.data.font.handle, OS.NSFontAttributeName);
                this.data.font.addTraits(dict);
                NSAttributedString attribStr = ((NSAttributedString)new NSAttributedString().alloc()).initWithString(NSString.stringWith(s), dict);
                this.data.textStorage.setAttributedString(attribStr);
                attribStr.release();
                dict.release();
                NSLayoutManager layoutManager = this.data.layoutManager;
                layoutManager.glyphRangeForTextContainer(this.data.textContainer);
                NSRect rect = layoutManager.usedRectForTextContainer(this.data.textContainer);
                double avgWidth = Math.ceil(rect.width) / (double)s.length();
                int ascent = (int)layoutManager.defaultBaselineOffsetForFont(this.data.font.handle);
                int height = (int)layoutManager.defaultLineHeightForFont(this.data.font.handle);
                this.data.font.metrics = FontMetrics.cocoa_new(ascent, height - ascent, avgWidth, 0, height);
            }
            FontMetrics fontMetrics = this.data.font.metrics;
            return fontMetrics;
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public Color getForeground() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return Color.cocoa_new(this.data.device, this.data.foreground);
    }

    public Pattern getForegroundPattern() {
        if (this.handle == null) {
            SWT.error(24);
        }
        return this.data.foregroundPattern;
    }

    public GCData getGCData() {
        if (this.handle == null) {
            SWT.error(24);
        }
        NSAutoreleasePool pool = this.checkGC(3072);
        this.uncheckGC(pool);
        return this.data;
    }

    public int getInterpolation() {
        if (this.handle == null) {
            SWT.error(44);
        }
        int interpolation = (int)this.handle.imageInterpolation();
        switch (interpolation) {
            case 0: {
                return -1;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return -1;
    }

    public LineAttributes getLineAttributes() {
        if (this.handle == null) {
            SWT.error(44);
        }
        float[] dashes = null;
        if (this.data.lineDashes != null) {
            dashes = new float[this.data.lineDashes.length];
            System.arraycopy(this.data.lineDashes, 0, dashes, 0, dashes.length);
        }
        return new LineAttributes(this.data.lineWidth, this.data.lineCap, this.data.lineJoin, this.data.lineStyle, dashes, this.data.lineDashesOffset, this.data.lineMiterLimit);
    }

    public int getLineCap() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineCap;
    }

    public int[] getLineDash() {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineDashes == null) {
            return null;
        }
        int[] lineDashes = new int[this.data.lineDashes.length];
        int i = 0;
        while (i < lineDashes.length) {
            lineDashes[i] = (int)this.data.lineDashes[i];
            ++i;
        }
        return lineDashes;
    }

    public int getLineJoin() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineJoin;
    }

    public int getLineStyle() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.lineStyle;
    }

    public int getLineWidth() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return (int)this.data.lineWidth;
    }

    public int getStyle() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.style;
    }

    public int getTextAntialias() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.textAntialias;
    }

    NSView getTopView(NSView view) {
        NSScrollView scrollView;
        NSView superView;
        NSView contentView;
        if (view != null && (contentView = view.superview()) != null && contentView.isKindOfClass(OS.class_NSClipView) && (superView = contentView.superview()) != null && superView.isKindOfClass(OS.class_NSScrollView) && (scrollView = new NSScrollView(superView.id)).documentView() != null && scrollView.documentView().id == view.id) {
            return superView;
        }
        return view;
    }

    public void getTransform(Transform transform) {
        NSAffineTransform cmt;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (transform == null) {
            SWT.error(4);
        }
        if (transform.isDisposed()) {
            SWT.error(5);
        }
        if ((cmt = this.data.transform) != null) {
            NSAffineTransformStruct struct = cmt.transformStruct();
            transform.handle.setTransformStruct(struct);
        } else {
            transform.setElements(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
    }

    public boolean getXORMode() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.xorMode;
    }

    public int hashCode() {
        return this.handle != null ? (int)this.handle.id : 0;
    }

    void init(Drawable drawable, GCData data, long context) {
        if (data.foreground != null) {
            data.state &= 0xFFFFFEFE;
        }
        if (data.background != null) {
            data.state &= 0xFFFFFFFD;
        }
        if (data.font != null) {
            data.state &= 0xFFFFFFFB;
        }
        data.state &= 0xFFFFFDFF;
        Image image = data.image;
        if (image != null) {
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = new NSGraphicsContext(context);
        this.handle.retain();
        this.handle.saveGraphicsState();
        data.path = NSBezierPath.bezierPath();
        data.path.setWindingRule(data.fillRule == 2 ? 0 : 1);
        data.path.retain();
    }

    void initCGContext(long cgContext) {
        int state = this.data.state;
        if ((state & 0x40) != 0) {
            OS.CGContextSetLineWidth(cgContext, this.data.lineWidth == 0.0f ? 1.0f : this.data.lineWidth);
            switch (this.data.lineStyle) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    state |= 8;
                }
            }
        }
        if ((state & 8) != 0) {
            float[] dashes = null;
            float width = this.data.lineWidth;
            switch (this.data.lineStyle) {
                case 1: {
                    break;
                }
                case 2: {
                    dashes = width != 0.0f ? LINE_DASH : LINE_DASH_ZERO;
                    break;
                }
                case 3: {
                    dashes = width != 0.0f ? LINE_DOT : LINE_DOT_ZERO;
                    break;
                }
                case 4: {
                    dashes = width != 0.0f ? LINE_DASHDOT : LINE_DASHDOT_ZERO;
                    break;
                }
                case 5: {
                    dashes = width != 0.0f ? LINE_DASHDOTDOT : LINE_DASHDOTDOT_ZERO;
                    break;
                }
                case 6: {
                    dashes = this.data.lineDashes;
                }
            }
            if (dashes != null) {
                double[] lengths = new double[dashes.length];
                int i = 0;
                while (i < lengths.length) {
                    lengths[i] = width == 0.0f || this.data.lineStyle == 6 ? dashes[i] : dashes[i] * width;
                    ++i;
                }
                OS.CGContextSetLineDash(cgContext, this.data.lineDashesOffset, lengths, lengths.length);
            } else {
                OS.CGContextSetLineDash(cgContext, 0.0, null, 0L);
            }
        }
        if ((state & 0x80) != 0) {
            OS.CGContextSetMiterLimit(cgContext, this.data.lineMiterLimit);
        }
        if ((state & 0x20) != 0) {
            int joinStyle = 0;
            switch (this.data.lineJoin) {
                case 1: {
                    joinStyle = 0;
                    break;
                }
                case 2: {
                    joinStyle = 1;
                    break;
                }
                case 3: {
                    joinStyle = 2;
                }
            }
            OS.CGContextSetLineJoin(cgContext, joinStyle);
        }
        if ((state & 0x10) != 0) {
            int capStyle = 0;
            switch (this.data.lineCap) {
                case 2: {
                    capStyle = 1;
                    break;
                }
                case 1: {
                    capStyle = 0;
                    break;
                }
                case 3: {
                    capStyle = 2;
                }
            }
            OS.CGContextSetLineCap(cgContext, capStyle);
        }
    }

    public boolean isClipped() {
        if (this.handle == null) {
            SWT.error(44);
        }
        return this.data.clipPath != null;
    }

    @Override
    public boolean isDisposed() {
        return this.handle == null;
    }

    boolean isIdentity(float[] transform) {
        return transform[0] == 1.0f && transform[1] == 0.0f && transform[2] == 0.0f && transform[3] == 1.0f && transform[4] == 0.0f && transform[5] == 0.0f;
    }

    public void setAdvanced(boolean advanced) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (!advanced) {
            this.setAlpha(255);
            this.setAntialias(-1);
            this.setBackgroundPattern(null);
            this.setClipping((Rectangle)null);
            this.setForegroundPattern(null);
            this.setInterpolation(-1);
            this.setTextAntialias(-1);
            this.setTransform(null);
        }
    }

    public void setAlpha(int alpha) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.alpha = alpha & 0xFF;
        this.data.state &= 0xFFFFFEFC;
    }

    public void setAntialias(int antialias) {
        if (this.handle == null) {
            SWT.error(44);
        }
        boolean mode = true;
        switch (antialias) {
            case -1: {
                if (this.handle.isDrawingToScreen()) break;
                mode = false;
                break;
            }
            case 0: {
                mode = false;
                break;
            }
            case 1: {
                mode = true;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.antialias = antialias;
        this.handle.setShouldAntialias(mode);
    }

    public void setBackground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.background = color.handle;
        this.data.backgroundPattern = null;
        if (this.data.bg != null) {
            this.data.bg.release();
        }
        this.data.bg = null;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setBackgroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.backgroundPattern == pattern) {
            return;
        }
        this.data.backgroundPattern = pattern;
        this.data.state &= 0xFFFFFFFD;
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == null) {
            SWT.error(44);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            NSRect rect = new NSRect();
            rect.x = x;
            rect.y = y;
            rect.width = width;
            rect.height = height;
            NSBezierPath path = NSBezierPath.bezierPathWithRect(rect);
            path.retain();
            this.setClipping(path);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setClipping(Path path) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (path != null && path.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.setClipping(new NSBezierPath(path.handle.copy().id));
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (rect == null) {
            this.setClipping((NSBezierPath)null);
        } else {
            this.setClipping(rect.x, rect.y, rect.width, rect.height);
        }
    }

    public void setClipping(Region region) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (region != null && region.isDisposed()) {
            SWT.error(5);
        }
        NSAutoreleasePool pool = null;
        if (!NSThread.isMainThread()) {
            pool = (NSAutoreleasePool)new NSAutoreleasePool().alloc().init();
        }
        try {
            this.setClipping(region != null ? region.getPath() : null);
        }
        finally {
            if (pool != null) {
                pool.release();
            }
        }
    }

    void setClipping(NSBezierPath path) {
        if (this.data.clipPath != null) {
            this.data.clipPath.release();
            this.data.clipPath = null;
        }
        if (path != null) {
            this.data.clipPath = path;
            if (this.data.transform != null) {
                this.data.clipPath.transformUsingAffineTransform(this.data.transform);
            }
        }
        this.data.state &= 0xFFFFFBFF;
    }

    public void setFillRule(int rule) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (rule) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.fillRule = rule;
        this.data.path.setWindingRule(rule == 2 ? 0 : 1);
    }

    public void setFont(Font font) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        this.data.font = font != null ? font : this.data.device.systemFont;
        this.data.state &= 0xFFFFFFFB;
    }

    public void setForeground(Color color) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        this.data.foreground = color.handle;
        this.data.foregroundPattern = null;
        if (this.data.fg != null) {
            this.data.fg.release();
        }
        this.data.fg = null;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setForegroundPattern(Pattern pattern) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (pattern != null && pattern.isDisposed()) {
            SWT.error(5);
        }
        if (this.data.foregroundPattern == pattern) {
            return;
        }
        this.data.foregroundPattern = pattern;
        this.data.state &= 0xFFFFFEFE;
    }

    public void setInterpolation(int interpolation) {
        if (this.handle == null) {
            SWT.error(44);
        }
        int quality = 0;
        switch (interpolation) {
            case -1: {
                quality = 0;
                break;
            }
            case 0: {
                quality = 1;
                break;
            }
            case 1: {
                quality = 2;
                break;
            }
            case 2: {
                quality = 3;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.handle.setImageInterpolation(quality);
    }

    public void setLineAttributes(LineAttributes attributes) {
        float miterLimit;
        int cap;
        int join;
        int lineStyle;
        if (this.handle == null) {
            SWT.error(44);
        }
        if (attributes == null) {
            SWT.error(4);
        }
        int mask = 0;
        float lineWidth = attributes.width;
        if (lineWidth != this.data.lineWidth) {
            mask |= 0x240;
        }
        if ((lineStyle = attributes.style) != this.data.lineStyle) {
            mask |= 8;
            switch (lineStyle) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    if (attributes.dash != null) break;
                    lineStyle = 1;
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((join = attributes.join) != this.data.lineJoin) {
            mask |= 0x20;
            switch (join) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        if ((cap = attributes.cap) != this.data.lineCap) {
            mask |= 0x10;
            switch (cap) {
                case 1: 
                case 2: 
                case 3: {
                    break;
                }
                default: {
                    SWT.error(5);
                }
            }
        }
        float[] dashes = attributes.dash;
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                float dash = dashes[i];
                if (dash <= 0.0f) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != dash) {
                    changed = true;
                }
                ++i;
            }
            if (changed) {
                float[] newDashes = new float[dashes.length];
                System.arraycopy(dashes, 0, newDashes, 0, dashes.length);
                dashes = newDashes;
                mask |= 8;
            } else {
                dashes = lineDashes;
            }
        } else if (lineDashes != null && lineDashes.length > 0) {
            mask |= 8;
        } else {
            dashes = lineDashes;
        }
        float dashOffset = attributes.dashOffset;
        if (dashOffset != this.data.lineDashesOffset) {
            mask |= 8;
        }
        if ((miterLimit = attributes.miterLimit) != this.data.lineMiterLimit) {
            mask |= 0x80;
        }
        if (mask == 0) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.lineStyle = lineStyle;
        this.data.lineCap = cap;
        this.data.lineJoin = join;
        this.data.lineDashes = dashes;
        this.data.lineDashesOffset = dashOffset;
        this.data.lineMiterLimit = miterLimit;
        this.data.state &= ~mask;
    }

    public void setLineCap(int cap) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineCap == cap) {
            return;
        }
        switch (cap) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineCap = cap;
        this.data.state &= 0xFFFFFFEF;
    }

    public void setLineDash(int[] dashes) {
        if (this.handle == null) {
            SWT.error(44);
        }
        float[] lineDashes = this.data.lineDashes;
        if (dashes != null && dashes.length > 0) {
            boolean changed = this.data.lineStyle != 6 || lineDashes == null || lineDashes.length != dashes.length;
            int i = 0;
            while (i < dashes.length) {
                int dash = dashes[i];
                if (dash <= 0) {
                    SWT.error(5);
                }
                if (!changed && lineDashes[i] != (float)dash) {
                    changed = true;
                }
                ++i;
            }
            if (!changed) {
                return;
            }
            this.data.lineDashes = new float[dashes.length];
            i = 0;
            while (i < dashes.length) {
                this.data.lineDashes[i] = dashes[i];
                ++i;
            }
            this.data.lineStyle = 6;
        } else {
            if (this.data.lineStyle == 1 && (lineDashes == null || lineDashes.length == 0)) {
                return;
            }
            this.data.lineDashes = null;
            this.data.lineStyle = 1;
        }
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineJoin(int join) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineJoin == join) {
            return;
        }
        switch (join) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineJoin = join;
        this.data.state &= 0xFFFFFFDF;
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineStyle == lineStyle) {
            return;
        }
        switch (lineStyle) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                if (this.data.lineDashes != null) break;
                lineStyle = 1;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.lineStyle = lineStyle;
        this.data.state &= 0xFFFFFFF7;
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (this.data.lineWidth == (float)lineWidth) {
            return;
        }
        this.data.lineWidth = lineWidth;
        this.data.state &= 0xFFFFFDBF;
    }

    void setPatternPhase(Pattern pattern) {
        if (pattern.image == null) {
            return;
        }
        NSPoint phase = new NSPoint();
        if (this.data.image != null) {
            phase.y += this.data.image.handle.size().height - pattern.image.handle.size().height;
        } else if (this.data.view != null) {
            NSView view = this.data.view;
            if (!view.isFlipped()) {
                phase.y = view.bounds().height;
            }
            NSView contentView = view.window().contentView();
            phase = view.convertPoint_toView_(phase, contentView);
            phase.y = contentView.bounds().height - phase.y;
        } else if (this.data.size != null) {
            phase.y += this.data.size.height - pattern.image.handle.size().height;
        }
        this.handle.setPatternPhase(phase);
    }

    public void setXORMode(boolean xor) {
        if (this.handle == null) {
            SWT.error(44);
        }
        this.data.xorMode = xor;
    }

    public void setTextAntialias(int antialias) {
        if (this.handle == null) {
            SWT.error(44);
        }
        switch (antialias) {
            case -1: 
            case 0: 
            case 1: {
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        this.data.textAntialias = antialias;
    }

    public void setTransform(Transform transform) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (transform != null && transform.isDisposed()) {
            SWT.error(5);
        }
        if (transform != null) {
            if (this.data.transform != null) {
                this.data.transform.release();
            }
            if (this.data.inverseTransform != null) {
                this.data.inverseTransform.release();
            }
            this.data.transform = ((NSAffineTransform)new NSAffineTransform().alloc()).initWithTransform(transform.handle);
            this.data.inverseTransform = ((NSAffineTransform)new NSAffineTransform().alloc()).initWithTransform(transform.handle);
            NSAffineTransformStruct struct = this.data.inverseTransform.transformStruct();
            if (struct.m11 * struct.m22 - struct.m12 * struct.m21 != 0.0) {
                this.data.inverseTransform.invert();
            }
        } else {
            this.data.inverseTransform = null;
            this.data.transform = null;
        }
        this.data.state &= 0xFFFFF5FF;
    }

    public Point stringExtent(String string) {
        return this.textExtent(string, 0);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == null) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        NSAutoreleasePool pool = this.checkGC(4);
        try {
            int length = string.length();
            if (this.data.textStorage == null) {
                this.createLayout();
            }
            NSAttributedString attribStr = this.createString(length == 0 ? " " : string, flags, false);
            this.data.textStorage.setAttributedString(attribStr);
            attribStr.release();
            this.data.layoutManager.glyphRangeForTextContainer(this.data.textContainer);
            NSRect rect = this.data.layoutManager.usedRectForTextContainer(this.data.textContainer);
            Point point = new Point(length == 0 ? 0 : (int)Math.ceil(rect.width), (int)Math.ceil(rect.height));
            return point;
        }
        finally {
            this.uncheckGC(pool);
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    void uncheckGC(NSAutoreleasePool pool) {
        NSView view;
        if (this.data.flippedContext != null && this.data.restoreContext) {
            NSGraphicsContext.static_restoreGraphicsState();
            this.data.restoreContext = false;
        }
        if ((view = this.data.view) != null && this.data.paintRect == null && this.data.thread != Thread.currentThread()) {
            this.flush();
        }
        if (pool != null) {
            pool.release();
        }
    }

    private static class GCTextData {
        private NSPoint pt = new NSPoint();
        private NSLayoutManager layoutManager;
        private NSTextStorage textStorage;
        private NSRange range;

        public GCTextData(NSAttributedString attribStr) {
            NSSize size = new NSSize();
            size.width = 5000000.0;
            size.height = 5000000.0;
            NSTextStorage textStorage = (NSTextStorage)new NSTextStorage().alloc().init();
            NSLayoutManager layoutManager = (NSLayoutManager)new NSLayoutManager().alloc().init();
            layoutManager.setBackgroundLayoutEnabled(NSThread.isMainThread());
            NSTextContainer textContainer = (NSTextContainer)new NSTextContainer().alloc();
            textContainer = textContainer.initWithContainerSize(size);
            textContainer.setLineFragmentPadding(0.0);
            textStorage.addLayoutManager(layoutManager);
            layoutManager.addTextContainer(textContainer);
            layoutManager.release();
            textContainer.release();
            this.layoutManager = layoutManager;
            this.textStorage = textStorage;
            textStorage.setAttributedString(attribStr);
            this.range = layoutManager.glyphRangeForTextContainer(textContainer);
        }

        public void release() {
            if (this.textStorage != null) {
                this.textStorage.release();
            }
            this.textStorage = null;
            this.layoutManager = null;
        }

        public void draw(int x, int y) {
            this.pt.x = x;
            this.pt.y = y;
            this.layoutManager.drawGlyphsForGlyphRange(this.range, this.pt);
        }

        private static class Cache {
            private final int cacheSize;
            private final Map<Key, GCTextData> cache = new LinkedHashMap<Key, GCTextData>(){
                private static final long serialVersionUID = 1L;

                @Override
                protected boolean removeEldestEntry(Map.Entry<Key, GCTextData> eldest) {
                    if (this.size() >= cacheSize) {
                        eldest.getValue().release();
                        return true;
                    }
                    return false;
                }
            };

            public Cache(int cacheSize) {
                this.cacheSize = cacheSize;
            }

            public void release() {
                for (GCTextData data : this.cache.values()) {
                    data.release();
                }
                this.cache.clear();
            }

            public GCTextData get(Key key) {
                return this.cache.get(key);
            }

            public void put(Key key, GCTextData data) {
                this.cache.put(key, data);
            }
        }

        private record Key(String string, int alpha, long font, double[] fgColor) {
        }
    }
}

