/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.core.utils;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;

public abstract class Ancestor<T> {
    protected T getAncestor(List<T> elements) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        T element1 = elements.get(0);
        int i = 1;
        while (i < elements.size()) {
            T element2 = elements.get(i);
            if ((element1 = this.getCommonAncestor(element1, element2)) == null) {
                return null;
            }
            ++i;
        }
        return element1;
    }

    protected List<T> getAncestors(List<T> elements) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : elements) {
            if (this.hasAncestor(element, elements)) continue;
            result.add(element);
        }
        return result;
    }

    private T getCommonAncestor(T element1, T element2) {
        Assert.isNotNull(element1);
        Assert.isNotNull(element2);
        if (this.isAncestorOf(element1, element2)) {
            return element1;
        }
        if (this.isAncestorOf(element2, element1)) {
            return element2;
        }
        T ancestor = null;
        T parent1 = this.getParent(element1);
        if (parent1 != null) {
            ancestor = this.getCommonAncestor(parent1, element2);
        }
        if (ancestor != null) {
            return ancestor;
        }
        T parent2 = this.getParent(element2);
        if (parent2 != null) {
            ancestor = this.getCommonAncestor(element1, parent2);
        }
        if (ancestor != null) {
            return ancestor;
        }
        if (parent1 != null && parent2 != null) {
            ancestor = this.getCommonAncestor(parent1, parent2);
        }
        return ancestor;
    }

    private boolean hasAncestor(T element, List<T> elements) {
        for (T node : elements) {
            if (!this.isAncestorOf(node, element)) continue;
            return true;
        }
        return false;
    }

    private boolean isAncestorOf(T element1, T element2) {
        if (element2 == null) {
            return false;
        }
        T parent = this.getParent(element2);
        if (parent == element1) {
            return true;
        }
        return this.isAncestorOf(element1, parent);
    }

    protected abstract T getParent(T var1);
}

