/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.databinding.ui.property;

import java.util.List;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectEventListener;
import org.eclipse.wb.internal.core.databinding.Messages;
import org.eclipse.wb.internal.core.databinding.model.IBindingInfo;
import org.eclipse.wb.internal.core.databinding.model.IObserveInfo;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractObserveProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.AbstractProperty;
import org.eclipse.wb.internal.core.databinding.ui.property.BindingsPropertyEditor;
import org.eclipse.wb.internal.core.databinding.ui.property.Context;
import org.eclipse.wb.internal.core.databinding.ui.property.ObserveAction;
import org.eclipse.wb.internal.core.databinding.ui.property.SingleObserveBindingAction;
import org.eclipse.wb.internal.core.databinding.ui.property.SingleObserveBindingProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.category.PropertyCategory;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;

public abstract class AbstractBindingsProperty
extends AbstractProperty {
    private Property[] m_properties;

    public AbstractBindingsProperty(Context context) {
        super((PropertyEditor)BindingsPropertyEditor.EDITOR, context);
        this.setCategory(PropertyCategory.system((int)7));
        this.m_context.objectInfo.addBroadcastListener((Object)new ObjectEventListener(){

            public void addContextMenu(List<? extends ObjectInfo> objects, ObjectInfo object, IMenuManager manager) throws Exception {
                if (AbstractBindingsProperty.this.m_context.objectInfo == object) {
                    AbstractBindingsProperty.this.contributeActions(manager);
                }
            }
        });
    }

    public final Property[] getProperties() throws Exception {
        if (this.m_properties == null) {
            this.m_properties = this.createProperties();
        }
        return this.m_properties;
    }

    protected abstract Property[] createProperties() throws Exception;

    public final String getTitle() {
        return Messages.AbstractBindingsProperty_title;
    }

    public final boolean isModified() throws Exception {
        Property[] propertyArray = this.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (property.isModified()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private void contributeActions(IMenuManager manager) throws Exception {
        MenuManager menu = new MenuManager(Messages.AbstractBindingsProperty_menuName);
        for (IBindingInfo binding : this.m_context.provider.getBindings()) {
            if (this.checkEquals(binding.getTarget())) {
                this.addBindingAction((IMenuManager)menu, binding, binding.getTargetProperty(), true);
                continue;
            }
            if (!this.checkEquals(binding.getModel())) continue;
            this.addBindingAction((IMenuManager)menu, binding, binding.getModelProperty(), false);
        }
        menu.add((IContributionItem)new Separator());
        Property[] propertyArray = this.getProperties();
        int n = propertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            Property property = propertyArray[n2];
            if (property instanceof AbstractObserveProperty) {
                observeProperty = (AbstractObserveProperty)property;
                menu.add((IAction)new ObserveAction(this.m_context.objectInfo, (AbstractObserveProperty)observeProperty));
            } else if (property instanceof SingleObserveBindingProperty) {
                observeProperty = (SingleObserveBindingProperty)property;
                menu.add((IAction)new SingleObserveBindingAction(this.m_context.objectInfo, (SingleObserveBindingProperty)observeProperty));
            }
            ++n2;
        }
        manager.appendToGroup("org.eclipse.wb.popup.group.layout", (IContributionItem)menu);
    }

    protected abstract boolean checkEquals(IObserveInfo var1) throws Exception;

    protected abstract void addBindingAction(IMenuManager var1, IBindingInfo var2, IObserveInfo var3, boolean var4) throws Exception;
}

