/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTagParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockTokenizer;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionHandler;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParser;
import org.eclipse.wst.sse.core.internal.ltk.parser.StructuredDocumentRegionParserExtension;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionCollection;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.sse.core.internal.text.CharSequenceReader;
import org.eclipse.wst.sse.core.internal.text.IRegionComparible;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.parser.XMLStructuredRegionFactory;
import org.eclipse.wst.xml.core.internal.parser.XMLTokenizer;

public class XMLSourceParser
implements RegionParser,
BlockTagParser,
StructuredDocumentRegionParser,
IRegionComparible,
StructuredDocumentRegionParserExtension {
    public CharSequence fCharSequenceSource = null;
    private IDocument fDocumentInput;
    protected int fOffset = 0;
    protected String fStringInput = null;
    protected List<StructuredDocumentRegionHandler> fStructuredDocumentRegionHandlers = new ArrayList<StructuredDocumentRegionHandler>();
    protected BlockTokenizer fTokenizer = null;
    protected long startTime;
    protected long stopTime;

    protected int _countNodes(IStructuredDocumentRegion nodes) {
        int result = 0;
        IStructuredDocumentRegion countNode = nodes;
        while (countNode != null) {
            ++result;
            countNode = countNode.getNext();
        }
        return result;
    }

    public void addBlockMarker(BlockMarker marker) {
        this.getTokenizer().addBlockMarker(marker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addStructuredDocumentRegionHandler(StructuredDocumentRegionHandler handler) {
        if (this.fStructuredDocumentRegionHandlers == null) {
            this.fStructuredDocumentRegionHandlers = new ArrayList<StructuredDocumentRegionHandler>();
        }
        List<StructuredDocumentRegionHandler> list = this.fStructuredDocumentRegionHandlers;
        synchronized (list) {
            this.fStructuredDocumentRegionHandlers.add(handler);
        }
    }

    public void beginBlockScan(String newTagName) {
        this.getTokenizer().beginBlockTagScan(newTagName);
    }

    protected IStructuredDocumentRegion createStructuredDocumentRegion(String type) {
        IStructuredDocumentRegion newNode = null;
        newNode = type == "BLOCK_TEXT" ? XMLStructuredRegionFactory.createRegion(1002) : XMLStructuredRegionFactory.createRegion(1001);
        return newNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireNodeParsed(IStructuredDocumentRegion fCurrentNode) {
        Object[] handlers = null;
        List<StructuredDocumentRegionHandler> list = this.fStructuredDocumentRegionHandlers;
        synchronized (list) {
            if (this.fStructuredDocumentRegionHandlers == null) {
                return;
            }
            handlers = this.fStructuredDocumentRegionHandlers.toArray();
        }
        if (fCurrentNode != null && handlers != null) {
            int i = 0;
            while (i < handlers.length) {
                try {
                    ((StructuredDocumentRegionHandler)handlers[i]).nodeParsed(fCurrentNode);
                }
                catch (Exception e) {
                    Logger.log(4, "Error occurred while firing Node Parsed event", e);
                }
                ++i;
            }
        }
    }

    public BlockMarker getBlockMarker(String tagName) {
        List markers = this.getTokenizer().getBlockMarkers();
        int i = 0;
        while (i < markers.size()) {
            BlockMarker marker = (BlockMarker)markers.get(i);
            if (marker.isCaseSensitive() ? marker.getTagName().equals(tagName) : marker.getTagName().equalsIgnoreCase(tagName)) {
                return marker;
            }
            ++i;
        }
        return null;
    }

    public List<BlockMarker> getBlockMarkers() {
        return this.getTokenizer().getBlockMarkers();
    }

    public IStructuredDocumentRegion getDocumentRegions() {
        IStructuredDocumentRegion headnode = null;
        if (headnode == null) {
            headnode = this.parseNodes();
        }
        return headnode;
    }

    protected ITextRegion getNextRegion() {
        ITextRegion region = null;
        try {
            region = this.getTokenizer().getNextToken();
            return region;
        }
        catch (StackOverflowError e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset(), e);
            throw e;
        }
        catch (Exception e) {
            Logger.logException(String.valueOf(this.getClass().getName()) + ": input could not be parsed correctly at position " + this.getTokenizer().getOffset() + " (" + e.getLocalizedMessage() + ")", e);
            return null;
        }
    }

    public List<ITextRegion> getRegions() {
        IStructuredDocumentRegion headNode = null;
        if (!this.getTokenizer().isEOF()) {
            headNode = this.getDocumentRegions();
        }
        List<ITextRegion> localRegionsList = this.getRegions(headNode);
        this.primReset();
        return localRegionsList;
    }

    protected List<ITextRegion> getRegions(IStructuredDocumentRegion headNode) {
        ArrayList<ITextRegion> allRegions = new ArrayList<ITextRegion>();
        IStructuredDocumentRegion currentNode = headNode;
        while (currentNode != null) {
            ITextRegionList nodeRegions = currentNode.getRegions();
            int i = 0;
            while (i < nodeRegions.size()) {
                allRegions.add(nodeRegions.get(i));
                ++i;
            }
            currentNode = currentNode.getNext();
        }
        return allRegions;
    }

    public List<StructuredDocumentRegionHandler> getStructuredDocumentRegionHandlers() {
        if (this.fStructuredDocumentRegionHandlers == null) {
            this.fStructuredDocumentRegionHandlers = new ArrayList<StructuredDocumentRegionHandler>(0);
        }
        return this.fStructuredDocumentRegionHandlers;
    }

    public String getText(int offset, int length) {
        String text = null;
        if (this.fCharSequenceSource != null) {
            int start = this.fOffset + offset;
            int end = start + length;
            text = this.fCharSequenceSource.subSequence(start, end).toString();
        } else if (this.fDocumentInput != null) {
            try {
                text = this.fDocumentInput.get(offset, length);
            }
            catch (BadLocationException badLocationException) {
                text = "";
            }
        } else {
            text = this.fStringInput == null || this.fStringInput.length() == 0 || offset + length > this.fStringInput.length() || offset < 0 ? "" : this.fStringInput.substring(offset, offset + length);
        }
        return text;
    }

    protected BlockTokenizer getTokenizer() {
        if (this.fTokenizer == null) {
            this.fTokenizer = new XMLTokenizer();
        }
        return this.fTokenizer;
    }

    public RegionParser newInstance() {
        XMLSourceParser newInstance = new XMLSourceParser();
        newInstance.setTokenizer(this.getTokenizer().newInstance());
        return newInstance;
    }

    protected IStructuredDocumentRegion parseNodes() {
        IStructuredDocumentRegion headNode = null;
        IStructuredDocumentRegion lastNode = null;
        ITextRegion region = null;
        IStructuredDocumentRegion currentNode = null;
        String type = null;
        while ((region = this.getNextRegion()) != null) {
            type = region.getType();
            if (type == "BLOCK_TEXT") {
                if (currentNode != null && currentNode.getLastRegion().getType() == "BLOCK_TEXT") {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                } else {
                    if (currentNode != null) {
                        if (!currentNode.isEnded()) {
                            currentNode.setLength(region.getStart() - currentNode.getStart());
                        }
                        lastNode = currentNode;
                    }
                    this.fireNodeParsed(currentNode);
                    currentNode = this.createStructuredDocumentRegion(type);
                    if (lastNode != null) {
                        lastNode.setNext(currentNode);
                    }
                    currentNode.setPrevious(lastNode);
                    currentNode.setStart(region.getStart());
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    currentNode.setEnded(true);
                    region.adjustStart(-currentNode.getStart());
                    currentNode.addRegion(region);
                }
            } else if (currentNode != null && currentNode.isEnded() || type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE" || type == "XML_PI_OPEN" || type == "XML_TAG_OPEN" || type == "XML_END_TAG_OPEN" || type == "XML_COMMENT_OPEN" || type == "XML_CDATA_OPEN" || type == "XML_DECLARATION_OPEN") {
                if (currentNode != null) {
                    if (!currentNode.isEnded()) {
                        currentNode.setLength(region.getStart() - currentNode.getStart());
                    }
                    lastNode = currentNode;
                }
                this.fireNodeParsed(currentNode);
                currentNode = this.createStructuredDocumentRegion(type);
                if (lastNode != null) {
                    lastNode.setNext(currentNode);
                }
                currentNode.setPrevious(lastNode);
                currentNode.setStart(region.getStart());
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            } else if (type == "XML_TAG_NAME" || type == "XML_TAG_ATTRIBUTE_NAME" || type == "XML_TAG_ATTRIBUTE_EQUALS" || type == "XML_TAG_ATTRIBUTE_VALUE" || type == "XML_COMMENT_TEXT" || type == "XML_PI_CONTENT" || type == "XML_DOCTYPE_INTERNAL_SUBSET") {
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            } else if (type == "XML_PI_CLOSE" || type == "XML_TAG_CLOSE" || type == "XML_EMPTY_TAG_CLOSE" || type == "XML_COMMENT_CLOSE" || type == "XML_DECLARATION_CLOSE" || type == "XML_CDATA_CLOSE") {
                currentNode.setEnded(true);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                currentNode.addRegion(region);
                region.adjustStart(-currentNode.getStart());
            } else if (type == "WHITE_SPACE") {
                ITextRegion lastRegion = currentNode.getLastRegion();
                if (lastRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)lastRegion;
                    container.getRegions().add(region);
                    container.setParent((ITextRegionCollection)currentNode);
                    region.adjustStart(container.getLength() - region.getStart());
                }
                currentNode.getLastRegion().adjustLength(region.getLength());
                currentNode.adjustLength(region.getLength());
            } else if (type == "UNDEFINED" && currentNode != null) {
                if (currentNode.getLastRegion() != null && currentNode.getLastRegion().getType() == "UNDEFINED") {
                    currentNode.getLastRegion().adjustLength(region.getLength());
                    currentNode.adjustLength(region.getLength());
                } else {
                    currentNode.addRegion(region);
                    currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                    region.adjustStart(-currentNode.getStart());
                }
            } else {
                if (currentNode == null) {
                    currentNode = this.createStructuredDocumentRegion(type);
                    currentNode.setStart(region.getStart());
                }
                currentNode.addRegion(region);
                currentNode.setLength(region.getStart() + region.getLength() - currentNode.getStart());
                region.adjustStart(-currentNode.getStart());
            }
            if (type == "XML_CONTENT" || type == "XML_CHAR_REFERENCE" || type == "XML_ENTITY_REFERENCE") {
                currentNode.setEnded(true);
            }
            if (headNode != null || currentNode == null) continue;
            headNode = currentNode;
        }
        if (currentNode != null) {
            this.fireNodeParsed(currentNode);
            currentNode.setPrevious(lastNode);
        }
        this.primReset();
        return headNode;
    }

    protected void primReset() {
        this.fStringInput = null;
        this.fCharSequenceSource = null;
        this.fDocumentInput = null;
        this.fOffset = 0;
        this.getTokenizer().reset(new char[0]);
    }

    public boolean regionMatches(int offset, int length, String stringToCompare) {
        if (stringToCompare == null) {
            return false;
        }
        int ajustedOffset = this.fOffset + offset;
        boolean result = false;
        if (this.fCharSequenceSource != null && this.fCharSequenceSource instanceof IRegionComparible) {
            result = ((IRegionComparible)this.fCharSequenceSource).regionMatches(ajustedOffset, length, stringToCompare);
        } else {
            String test = null;
            if (this.fCharSequenceSource != null) {
                test = this.fCharSequenceSource.subSequence(ajustedOffset, ajustedOffset + length).toString();
            } else if (this.fStringInput != null) {
                test = this.fStringInput.substring(ajustedOffset, ajustedOffset + length);
            }
            result = stringToCompare.equals(test);
        }
        return result;
    }

    public boolean regionMatchesIgnoreCase(int offset, int length, String stringToCompare) {
        if (stringToCompare == null) {
            return false;
        }
        int ajustedOffset = this.fOffset + offset;
        boolean result = false;
        if (this.fCharSequenceSource != null && this.fCharSequenceSource instanceof IRegionComparible) {
            result = ((IRegionComparible)this.fCharSequenceSource).regionMatchesIgnoreCase(ajustedOffset, length, stringToCompare);
        } else {
            String test = null;
            if (this.fCharSequenceSource != null) {
                test = this.fCharSequenceSource.subSequence(ajustedOffset, ajustedOffset + length).toString();
            } else if (this.fStringInput != null) {
                test = this.fStringInput.substring(ajustedOffset, ajustedOffset + length);
            }
            result = stringToCompare.equalsIgnoreCase(test);
        }
        return result;
    }

    public void removeBlockMarker(BlockMarker marker) {
        this.getTokenizer().removeBlockMarker(marker);
    }

    public void removeBlockMarker(String tagName) {
        this.getTokenizer().removeBlockMarker(tagName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStructuredDocumentRegionHandler(StructuredDocumentRegionHandler handler) {
        if (this.fStructuredDocumentRegionHandlers == null) {
            return;
        }
        List<StructuredDocumentRegionHandler> list = this.fStructuredDocumentRegionHandlers;
        synchronized (list) {
            this.fStructuredDocumentRegionHandlers.remove(handler);
        }
    }

    public void reset(FileInputStream instream) {
        this.primReset();
        this.getTokenizer().reset((InputStream)instream);
    }

    public void reset(Reader reader) {
        this.reset(reader, 0);
    }

    public void reset(Reader reader, int position) {
        this.primReset();
        this.fOffset = position;
        this.getTokenizer().reset(reader, position);
        if (reader instanceof DocumentReader) {
            IDocument doc = ((DocumentReader)reader).getDocument();
            if (doc instanceof CharSequence) {
                this.fCharSequenceSource = (CharSequence)doc;
            } else {
                this.fDocumentInput = ((DocumentReader)reader).getDocument();
            }
        } else if (reader instanceof CharSequenceReader) {
            this.fCharSequenceSource = ((CharSequenceReader)reader).getOriginalSource();
        }
    }

    public void reset(String sourceString) {
        this.reset(new StringReader(sourceString));
        this.fStringInput = sourceString;
    }

    public void reset(String sourceString, int position) {
        StringReader reader = new StringReader(sourceString);
        this.reset(reader, position);
        this.fStringInput = sourceString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetHandlers() {
        Object[] handlers = null;
        List<StructuredDocumentRegionHandler> list = this.fStructuredDocumentRegionHandlers;
        synchronized (list) {
            if (this.fStructuredDocumentRegionHandlers == null) {
                return;
            }
            handlers = this.fStructuredDocumentRegionHandlers.toArray();
        }
        int i = 0;
        while (i < handlers.length) {
            try {
                ((StructuredDocumentRegionHandler)handlers[i]).resetNodes();
            }
            catch (Exception e) {
                Logger.log(4, "Error occurred while resetting handlers", e);
            }
            ++i;
        }
    }

    public void setStructuredDocumentRegionHandlers(List newStructuredDocumentRegionHandlers) {
        this.fStructuredDocumentRegionHandlers = newStructuredDocumentRegionHandlers;
    }

    protected void setTokenizer(BlockTokenizer newTokenizer) {
        this.fTokenizer = newTokenizer;
    }
}

