/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.server.internal.admin.protocol;

import java.util.concurrent.Callable;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServer;
import org.eclipse.emf.cdo.server.internal.admin.CDOAdminServerRepository;
import org.eclipse.emf.cdo.server.internal.admin.protocol.CDOAdminServerProtocol;
import org.eclipse.emf.cdo.spi.server.AuthenticationUtil;
import org.eclipse.emf.cdo.spi.server.IAuthenticationProtocol;
import org.eclipse.net4j.signal.IndicationWithResponse;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.util.io.ExtendedDataInputStream;
import org.eclipse.net4j.util.io.ExtendedDataOutputStream;
import org.eclipse.net4j.util.security.NotAuthenticatedException;

public class DeleteRepositoryIndication
extends IndicationWithResponse {
    private String name;
    private String type;

    public DeleteRepositoryIndication(CDOAdminServerProtocol protocol) {
        super((SignalProtocol)protocol, (short)3);
    }

    protected void indicating(ExtendedDataInputStream in) throws Exception {
        this.name = in.readString();
        this.type = in.readString();
    }

    protected void responding(ExtendedDataOutputStream out) throws Exception {
        try {
            CDOAdminServerProtocol protocol = (CDOAdminServerProtocol)this.getProtocol();
            out.writeBoolean(this.deleteRepository(protocol));
        }
        catch (NotAuthenticatedException ex) {
            out.writeBoolean(false);
            return;
        }
    }

    protected boolean deleteRepository(CDOAdminServerProtocol protocol) throws Exception {
        final CDOAdminServer admin = (CDOAdminServer)((Object)protocol.getInfraStructure());
        return (Boolean)AuthenticationUtil.authenticatingOperation((IAuthenticationProtocol)protocol, (Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                CDOAdminServerRepository repository = (CDOAdminServerRepository)admin.getRepository(DeleteRepositoryIndication.this.name);
                if (repository != null) {
                    return admin.deleteRepository(repository, DeleteRepositoryIndication.this.type);
                }
                return false;
            }
        }).call();
    }
}

