/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.php.internal.core.util.text.TextSequence;
import org.eclipse.php.internal.ui.Logger;
import org.eclipse.php.internal.ui.PHPUIMessages;
import org.eclipse.php.internal.ui.editor.contentassist.AutoActivationTrigger;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class AddObjectOperator
extends AbstractHandler
implements IHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        IDocument document;
        Object o;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ITextEditor textEditor = null;
        if (editor instanceof ITextEditor) {
            textEditor = (ITextEditor)editor;
        } else if (editor != null && (o = editor.getAdapter(ITextEditor.class)) != null) {
            textEditor = (ITextEditor)o;
        }
        if (textEditor != null && (document = textEditor.getDocumentProvider().getDocument((Object)textEditor.getEditorInput())) != null) {
            if (textEditor.getSelectionProvider() == null || !(textEditor.getSelectionProvider().getSelection() instanceof ITextSelection)) {
                return null;
            }
            ITextSelection textSelection = (ITextSelection)textEditor.getSelectionProvider().getSelection();
            if (textSelection.isEmpty()) {
                return null;
            }
            if (document instanceof IStructuredDocument) {
                int selectionOffset = textSelection.getOffset() - 1;
                IStructuredDocument sDoc = (IStructuredDocument)document;
                IStructuredDocumentRegion sdRegion = sDoc.getRegionAtCharacterOffset(selectionOffset);
                ITextRegion textRegion = sdRegion.getRegionAtCharacterOffset(selectionOffset);
                IStructuredDocumentRegion container = sdRegion;
                if (textRegion instanceof ITextRegionContainer) {
                    container = (ITextRegionContainer)textRegion;
                    textRegion = container.getRegionAtCharacterOffset(selectionOffset);
                }
                if (textRegion == null) {
                    return null;
                }
                if (sdRegion instanceof IStructuredDocumentRegion && textRegion.getType() == "PHP_CONTENT") {
                    this.run(textEditor, document, textSelection, sdRegion);
                }
            }
        }
        return null;
    }

    private void run(ITextEditor textEditor, IDocument document, ITextSelection textSelection, IStructuredDocumentRegion textRegion) {
        if (textSelection.getLength() != 0) {
            return;
        }
        IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(document);
        if (model != null) {
            try {
                AutoActivationTrigger.register(document);
                TextSequence statement = PHPTextSequenceUtilities.getStatement((int)textSelection.getOffset(), (IStructuredDocumentRegion)textRegion, (boolean)true);
                String insert = PHPTextSequenceUtilities.suggestObjectOperator((CharSequence)statement);
                if (insert == null) {
                    return;
                }
                model.beginRecording((Object)this, PHPUIMessages.AddObjectOperator_tooltip);
                model.aboutToChangeModel();
                try {
                    try {
                        document.replace(textSelection.getOffset(), 0, insert);
                        textEditor.selectAndReveal(textSelection.getOffset() + insert.length(), 0);
                    }
                    catch (BadLocationException e) {
                        Logger.logException(e);
                        model.changedModel();
                        model.endRecording((Object)this);
                    }
                }
                finally {
                    model.changedModel();
                    model.endRecording((Object)this);
                }
            }
            finally {
                model.releaseFromEdit();
            }
        }
    }
}

