/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.dom.fragments;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.visitor.ApplyAll;
import org.eclipse.php.core.ast.visitor.Visitor;
import org.eclipse.php.internal.ui.corext.dom.fragments.ASTFragment;
import org.eclipse.php.internal.ui.corext.dom.fragments.IASTFragment;

class ASTMatchingFragmentFinder
extends ApplyAll {
    private static boolean isProgramScope = false;
    private ASTFragment fFragmentToMatch;
    private Set<IASTFragment> fMatches = new HashSet<IASTFragment>();

    public static IASTFragment[] findMatchingFragments(ASTNode scope, ASTFragment toMatch) {
        isProgramScope = scope.getType() == 46;
        return new ASTMatchingFragmentFinder(toMatch).findMatches(scope);
    }

    private ASTMatchingFragmentFinder(ASTFragment toMatch) {
        this.fFragmentToMatch = toMatch;
    }

    private IASTFragment[] findMatches(ASTNode scope) {
        this.fMatches.clear();
        scope.accept((Visitor)this);
        return this.getMatches();
    }

    private IASTFragment[] getMatches() {
        return this.fMatches.toArray(new IASTFragment[this.fMatches.size()]);
    }

    protected boolean apply(ASTNode node) {
        if (node.getType() == 29 && isProgramScope) {
            return false;
        }
        IASTFragment[] localMatches = this.fFragmentToMatch.getMatchingFragmentsWithNode(node);
        int i = 0;
        while (i < localMatches.length) {
            this.fMatches.add(localMatches[i]);
            ++i;
        }
        return true;
    }
}

