/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.corext.refactoring.changes;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.php.internal.ui.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.php.internal.ui.corext.refactoring.changes.SourceModuleReorgChange;
import org.eclipse.php.internal.ui.util.Messages;

public class MoveSourceModuleChange
extends SourceModuleReorgChange {
    private boolean fUndoable;
    private long fStampToRestore;

    public MoveSourceModuleChange(ISourceModule cu, IScriptFolder dest) {
        super(cu, dest);
        this.fStampToRestore = -1L;
    }

    private MoveSourceModuleChange(IScriptFolder oldPackage, String cuName, IScriptFolder newPackage, long stampToRestore) {
        super(oldPackage.getHandleIdentifier(), newPackage.getHandleIdentifier(), oldPackage.getSourceModule(cuName).getHandleIdentifier());
        this.fStampToRestore = stampToRestore;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.MoveSourceModuleChange_name, new String[]{BasicElementLabels.getFileName((ISourceModule)this.getCu()), MoveSourceModuleChange.getPackageName(this.getDestinationPackage())});
    }

    @Override
    Change doPerformReorg(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ISourceModule moved;
        IResource movedResource;
        IScriptFolder destination;
        String newName = this.getNewName();
        String name = newName == null ? this.getCu().getElementName() : newName;
        long currentStamp = -1L;
        IResource resource = this.getCu().getResource();
        if (resource != null) {
            currentStamp = resource.getModificationStamp();
        }
        this.fUndoable = !(destination = this.getDestinationPackage()).getSourceModule(name).exists();
        this.getCu().move((IModelElement)destination, null, newName, true, pm);
        if (this.fStampToRestore != -1L && (movedResource = (moved = destination.getSourceModule(name)).getResource()) != null) {
            movedResource.revertModificationStamp(this.fStampToRestore);
        }
        if (this.fUndoable) {
            return new MoveSourceModuleChange(destination, this.getCu().getElementName(), this.getOldPackage(), currentStamp);
        }
        return null;
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }
}

