/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.ui.editor.highlighters;

import java.util.List;
import org.eclipse.php.core.PHPVersion;
import org.eclipse.php.core.ast.nodes.ASTNode;
import org.eclipse.php.core.ast.nodes.Attribute;
import org.eclipse.php.core.ast.nodes.CatchClause;
import org.eclipse.php.core.ast.nodes.ClassDeclaration;
import org.eclipse.php.core.ast.nodes.ClassInstanceCreation;
import org.eclipse.php.core.ast.nodes.DNFType;
import org.eclipse.php.core.ast.nodes.EnumDeclaration;
import org.eclipse.php.core.ast.nodes.Expression;
import org.eclipse.php.core.ast.nodes.FieldsDeclaration;
import org.eclipse.php.core.ast.nodes.FormalParameter;
import org.eclipse.php.core.ast.nodes.FullyQualifiedTraitMethodReference;
import org.eclipse.php.core.ast.nodes.FunctionDeclaration;
import org.eclipse.php.core.ast.nodes.Identifier;
import org.eclipse.php.core.ast.nodes.InstanceOfExpression;
import org.eclipse.php.core.ast.nodes.InterfaceDeclaration;
import org.eclipse.php.core.ast.nodes.NamespaceName;
import org.eclipse.php.core.ast.nodes.StaticConstantAccess;
import org.eclipse.php.core.ast.nodes.StaticDispatch;
import org.eclipse.php.core.ast.nodes.StaticFieldAccess;
import org.eclipse.php.core.ast.nodes.StaticMethodInvocation;
import org.eclipse.php.core.ast.nodes.TraitAliasStatement;
import org.eclipse.php.core.ast.nodes.TraitDeclaration;
import org.eclipse.php.core.ast.nodes.TraitPrecedenceStatement;
import org.eclipse.php.core.ast.nodes.TraitStatement;
import org.eclipse.php.core.ast.nodes.TraitUseStatement;
import org.eclipse.php.internal.core.typeinference.PHPSimpleTypes;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticApply;
import org.eclipse.php.internal.ui.editor.highlighter.AbstractSemanticHighlighting;
import org.eclipse.php.internal.ui.editor.highlighters.Messages;

public class ClassHighlighting
extends AbstractSemanticHighlighting {
    public static final String SELF = "self";
    public static final String PARENT = "parent";
    public static final String CLASS = "class";

    @Override
    public AbstractSemanticApply getSemanticApply() {
        return new ClassApply();
    }

    @Override
    protected void initDefaultPreferences() {
        this.getStyle().setEnabledByDefault(true).setDefaultTextColor(0, 80, 50);
    }

    public String getDisplayName() {
        return Messages.ClassHighlighting_0;
    }

    protected class ClassApply
    extends AbstractSemanticApply {
        protected ClassApply() {
        }

        public boolean visit(InterfaceDeclaration interfaceDeclaration) {
            ClassHighlighting.this.highlight((ASTNode)interfaceDeclaration.getName());
            for (Identifier identifier : interfaceDeclaration.interfaces()) {
                this.highlightIdentifier((ASTNode)identifier, false);
            }
            return true;
        }

        public boolean visit(ClassDeclaration clazz) {
            ClassHighlighting.this.highlight((ASTNode)clazz.getName());
            this.highlightIdentifier((ASTNode)clazz.getSuperClass(), false);
            for (Identifier identifier : clazz.interfaces()) {
                this.highlightIdentifier((ASTNode)identifier, false);
            }
            return true;
        }

        public boolean visit(TraitDeclaration trait) {
            ClassHighlighting.this.highlight((ASTNode)trait.getName());
            this.highlightIdentifier((ASTNode)trait.getSuperClass(), false);
            for (Identifier identifier : trait.interfaces()) {
                this.highlightIdentifier((ASTNode)identifier, false);
            }
            return true;
        }

        public boolean visit(EnumDeclaration en) {
            ClassHighlighting.this.highlight((ASTNode)en.getName());
            for (Identifier identifier : en.interfaces()) {
                this.highlightIdentifier((ASTNode)identifier, false);
            }
            return true;
        }

        public boolean visit(ClassInstanceCreation clazz) {
            Expression name = clazz.getClassName().getName();
            if (name instanceof Identifier) {
                this.highlightIdentifier((ASTNode)name, false);
            }
            return true;
        }

        public boolean visit(InstanceOfExpression instanceOfExpression) {
            Expression name = instanceOfExpression.getClassName().getName();
            this.highlightIdentifier((ASTNode)name, false);
            return true;
        }

        public boolean visit(FormalParameter param) {
            Expression type = param.getParameterType();
            this.highlightIdentifier((ASTNode)type, false);
            return true;
        }

        public boolean visit(FieldsDeclaration fieldsDeclaration) {
            Expression type = fieldsDeclaration.getFieldsType();
            this.highlightIdentifier((ASTNode)type, false);
            return true;
        }

        public boolean visit(Attribute attribute) {
            this.highlightIdentifier((ASTNode)attribute.getAttributeName(), false);
            return true;
        }

        public boolean visit(FunctionDeclaration functionDeclaration) {
            if (functionDeclaration.getReturnType() == null) {
                return true;
            }
            Identifier type = functionDeclaration.getReturnType();
            this.highlightIdentifier((ASTNode)type, false);
            return true;
        }

        public boolean visit(TraitUseStatement node) {
            List traitList = node.getTraitList();
            for (NamespaceName namespaceName : traitList) {
                this.highlightIdentifier((ASTNode)namespaceName, false);
            }
            List tsList = node.getTsList();
            for (TraitStatement traitStatement : tsList) {
                FullyQualifiedTraitMethodReference reference;
                TraitAliasStatement statement;
                if (traitStatement instanceof TraitAliasStatement) {
                    statement = (TraitAliasStatement)traitStatement;
                    if (!(statement.getAlias().getTraitMethod() instanceof FullyQualifiedTraitMethodReference)) continue;
                    reference = (FullyQualifiedTraitMethodReference)statement.getAlias().getTraitMethod();
                    this.highlightIdentifier((ASTNode)reference.getClassName(), false);
                    continue;
                }
                if (!(traitStatement instanceof TraitPrecedenceStatement)) continue;
                statement = (TraitPrecedenceStatement)traitStatement;
                reference = statement.getPrecedence().getMethodReference();
                this.highlightIdentifier((ASTNode)reference.getClassName(), false);
                traitList = statement.getPrecedence().getTrList();
                for (NamespaceName namespaceName : traitList) {
                    this.highlightIdentifier((ASTNode)namespaceName, false);
                }
            }
            return false;
        }

        public boolean visit(CatchClause catchStatement) {
            catchStatement.getClassNames().stream().forEach(e -> this.highlightIdentifier((ASTNode)e, false));
            return true;
        }

        public boolean visit(StaticConstantAccess classConstant) {
            this.highlightStatic((StaticDispatch)classConstant);
            return true;
        }

        public boolean visit(StaticFieldAccess staticMember) {
            this.highlightStatic((StaticDispatch)staticMember);
            return true;
        }

        public boolean visit(StaticMethodInvocation staticMethodInvocation) {
            this.highlightStatic((StaticDispatch)staticMethodInvocation);
            return true;
        }

        private void highlightStatic(StaticDispatch dispatch) {
            Expression className = dispatch.getClassName();
            this.highlightIdentifier((ASTNode)className, false);
        }

        private void highlightNamespaceType(NamespaceName name, boolean excludeSelf) {
            List segments = name.segments();
            if (segments.size() > 0) {
                Identifier segment = (Identifier)segments.get(segments.size() - 1);
                if (segments.size() > 1 || name.isGlobal() || !PHPSimpleTypes.isHintable((String)segment.getName(), (PHPVersion)name.getAST().apiLevel()) && (!ClassHighlighting.SELF.equalsIgnoreCase(segment.getName()) || excludeSelf) && !ClassHighlighting.PARENT.equalsIgnoreCase(segment.getName())) {
                    ClassHighlighting.this.highlight((ASTNode)segment);
                }
            }
        }

        private void highlightIdentifier(ASTNode node, boolean excludeSelf) {
            if (!(node instanceof Identifier)) {
                return;
            }
            Identifier identifier = (Identifier)node;
            if (identifier instanceof DNFType) {
                this.highlightDNF((DNFType)identifier, excludeSelf);
            } else if (identifier instanceof NamespaceName) {
                this.highlightNamespaceType((NamespaceName)identifier, excludeSelf);
            } else if (!(!excludeSelf && ClassHighlighting.SELF.equalsIgnoreCase(identifier.getName()) || PHPSimpleTypes.isHintable((String)identifier.getName(), (PHPVersion)identifier.getAST().apiLevel()) || ClassHighlighting.PARENT.equalsIgnoreCase(identifier.getName()) || ClassHighlighting.CLASS.equalsIgnoreCase(identifier.getName()))) {
                ClassHighlighting.this.highlight((ASTNode)identifier);
            }
        }

        private void highlightDNF(DNFType type, boolean excludeSelf) {
            for (Identifier i : type.elements()) {
                this.highlightIdentifier((ASTNode)i, excludeSelf);
            }
        }
    }
}

