/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation;

import org.eclipse.datatools.enablement.sybase.asa.models.sybaseasabasesqlmodel.SybaseASADefaultWrapper;
import org.eclipse.datatools.enablement.sybase.asa.schemaobjecteditor.examples.model.validation.Messages;
import org.eclipse.datatools.modelbase.sql.datatypes.DataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DateDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.DistinctUserDefinedType;
import org.eclipse.datatools.modelbase.sql.datatypes.PredefinedDataType;
import org.eclipse.datatools.modelbase.sql.datatypes.TimeDataType;
import org.eclipse.datatools.sqltools.core.modelvalidity.DefaultSQLDataOfflineValidator;

public class ASASQLDataOfflineValidator
extends DefaultSQLDataOfflineValidator {
    protected boolean isContained(String value, String[] values) {
        if (values == null) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            if (value.equals(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String validateCharacterStringDataType(DataType type, String strValue) {
        String error = super.validateCharacterStringDataType(type, strValue);
        if (error != null) {
            return error;
        }
        if (this.isContained(strValue, SybaseASADefaultWrapper.STRING_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (this.isContained(strValue, SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS) || strValue.startsWith("global autoincrement")) {
            return String.valueOf(Messages.ASASQLDataOfflineValidator_invalid_default_value) + strValue;
        }
        return null;
    }

    public String validateNumberDataType(DataType type, String strValue) {
        if (this.isContained(strValue, SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (strValue.startsWith("global autoincrement")) {
            try {
                Integer.parseInt(strValue.substring("global autoincrement".length() + 1, strValue.length() - 1));
                return null;
            }
            catch (Exception exception) {
                return String.valueOf(Messages.ASASQLDataOfflineValidator_invalid_default_value) + strValue;
            }
        }
        String error = super.validateNumberDataType(type, strValue);
        if (error != null) {
            return error;
        }
        return null;
    }

    public String validateNumericalDataType(DataType type, String strValue) {
        if (this.isContained(strValue, SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (strValue.startsWith("global autoincrement")) {
            try {
                Integer.parseInt(strValue.substring("global autoincrement".length() + 1, strValue.length() - 1));
                return null;
            }
            catch (Exception exception) {
                return String.valueOf(Messages.ASASQLDataOfflineValidator_invalid_default_value) + strValue;
            }
        }
        String error = super.validateNumericalDataType(type, strValue);
        if (error != null) {
            return error;
        }
        return null;
    }

    public String validateDateDataType(DataType type, String strValue) {
        if (this.isContained(strValue, SybaseASADefaultWrapper.DATE_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (this.isContained(strValue, SybaseASADefaultWrapper.STRING_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.TIME_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.TS_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.BINARY_TYPE_SYSTEM_DEFAULTS)) {
            return String.valueOf(Messages.ASASQLDataOfflineValidator_invalid_default_value) + strValue;
        }
        return null;
    }

    public String validateTimeDataType(DataType type, String strValue) {
        if (this.isContained(strValue, SybaseASADefaultWrapper.TIME_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (type.getName().equalsIgnoreCase("timestamp") && this.isContained(strValue, SybaseASADefaultWrapper.TS_TYPE_SYSTEM_DEFAULTS)) {
            return null;
        }
        if (this.isContained(strValue, SybaseASADefaultWrapper.STRING_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.DATE_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.NUMERIC_TYPE_SYSTEM_DEFAULTS) || this.isContained(strValue, SybaseASADefaultWrapper.BINARY_TYPE_SYSTEM_DEFAULTS)) {
            return String.valueOf(Messages.ASASQLDataOfflineValidator_invalid_default_value) + strValue;
        }
        return null;
    }

    public String validateDistinctUserDefinedType(DataType type, String strValue) {
        String error;
        DistinctUserDefinedType dudt = (DistinctUserDefinedType)type;
        PredefinedDataType pType = dudt.getPredefinedRepresentation();
        if (pType != null && (pType instanceof TimeDataType || pType instanceof DateDataType)) {
            if (pType instanceof TimeDataType && (error = this.validateTimeDataType((DataType)pType, strValue)) != null) {
                return error;
            }
            if (pType instanceof DateDataType && (error = this.validateDateDataType((DataType)pType, strValue)) != null) {
                return error;
            }
        }
        if ((error = super.validateDistinctUserDefinedType(type, strValue)) != null) {
            return error;
        }
        return null;
    }
}

