/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.xcore.ui.folding;

import com.google.inject.Inject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xcore.XImportDirective;
import org.eclipse.emf.ecore.xcore.XPackage;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.ui.editor.folding.DefaultFoldingRegionProvider;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptor;
import org.eclipse.xtext.ui.editor.folding.IFoldingRegionAcceptorExtension;
import org.eclipse.xtext.util.ITextRegion;

public class XcoreFoldingRegionProvider
extends DefaultFoldingRegionProvider {
    @Inject
    private ILocationInFileProvider locationInFileProvider;

    protected void computeObjectFolding(EObject eObject, IFoldingRegionAcceptor<ITextRegion> foldingRegionAcceptor, boolean initiallyFolded) {
        if (eObject instanceof XPackage) {
            XPackage xPackage = (XPackage)eObject;
            EList importDirectives = xPackage.getImportDirectives();
            if (importDirectives.size() > 1) {
                XImportDirective first = (XImportDirective)importDirectives.get(0);
                XImportDirective last = (XImportDirective)importDirectives.get(importDirectives.size() - 1);
                ITextRegion firstFullTextRegion = this.locationInFileProvider.getFullTextRegion((EObject)first);
                ITextRegion firstSignificantTextRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)first);
                ITextRegion lastFullTextRegion = this.locationInFileProvider.getFullTextRegion((EObject)last);
                ITextRegion lastSignificantTextRegion = this.locationInFileProvider.getSignificantTextRegion((EObject)last);
                ITextRegion fullTextRegion = firstFullTextRegion.merge(lastFullTextRegion);
                ITextRegion significantTextRegion = firstSignificantTextRegion.merge(lastSignificantTextRegion);
                int offset = fullTextRegion.getOffset();
                ((IFoldingRegionAcceptorExtension)foldingRegionAcceptor).accept(offset, fullTextRegion.getLength(), true, (Object)significantTextRegion);
            }
        } else {
            super.computeObjectFolding(eObject, foldingRegionAcceptor, initiallyFolded);
        }
    }

    protected boolean isHandled(EObject eObject) {
        return super.isHandled(eObject) || eObject instanceof XPackage;
    }
}

