/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;

public class IsCompletelySelected
implements Predicate<IPackageFragment> {
    private final Set<IPackageFragment> completelySelectedPackages;

    public IsCompletelySelected(Collection<IPackageFragment> selectedPackages) throws JavaModelException {
        this(selectedPackages, (IProgressMonitor)new NullProgressMonitor());
    }

    IsCompletelySelected(Collection<IPackageFragment> selectedPackages, IProgressMonitor monitor) throws JavaModelException {
        this.completelySelectedPackages = IsCompletelySelected.completelySelectedPackages(selectedPackages, monitor);
    }

    private static Set<IPackageFragment> completelySelectedPackages(Collection<IPackageFragment> selectedPackages, IProgressMonitor monitor) throws JavaModelException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)selectedPackages.size());
        Map<IPackageFragmentRoot, Set<IPackageFragment>> packagesByRoot = IsCompletelySelected.groupByPackageRoot(selectedPackages, (IProgressMonitor)subMonitor);
        HashSet<IPackageFragment> completelySelectedPackages = new HashSet<IPackageFragment>(selectedPackages.size());
        for (Map.Entry<IPackageFragmentRoot, Set<IPackageFragment>> packages : packagesByRoot.entrySet()) {
            subMonitor.checkCanceled();
            IPackageFragmentRoot root = packages.getKey();
            Set<IPackageFragment> selectedInRoot = packages.getValue();
            Set<IPackageFragment> completelySelectedPackagesOfRoot = IsCompletelySelected.completelySelectedPackages(root, selectedInRoot, subMonitor);
            completelySelectedPackages.addAll(completelySelectedPackagesOfRoot);
            subMonitor.worked(1);
        }
        return completelySelectedPackages;
    }

    private static Map<IPackageFragmentRoot, Set<IPackageFragment>> groupByPackageRoot(Collection<IPackageFragment> packages, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)packages.size());
        HashMap<IPackageFragmentRoot, Set<IPackageFragment>> packageRoots = new HashMap<IPackageFragmentRoot, Set<IPackageFragment>>();
        for (IPackageFragment packageFragment : packages) {
            subMonitor.checkCanceled();
            IPackageFragmentRoot root = (IPackageFragmentRoot)packageFragment.getParent();
            HashSet<IPackageFragment> packagesOfRoot = (HashSet<IPackageFragment>)packageRoots.get(root);
            if (packagesOfRoot == null) {
                packagesOfRoot = new HashSet<IPackageFragment>();
                packageRoots.put(root, packagesOfRoot);
            }
            packagesOfRoot.add(packageFragment);
            subMonitor.worked(1);
        }
        return packageRoots;
    }

    private static Set<IPackageFragment> completelySelectedPackages(IPackageFragmentRoot root, Set<IPackageFragment> selectedPackages, SubMonitor subMonitor) throws JavaModelException {
        subMonitor.checkCanceled();
        Set<IPackageFragment> allPackages = IsCompletelySelected.allPackages(root);
        int numberOfPackages = allPackages.size();
        subMonitor.checkCanceled();
        Set<IPackageFragment> unselectedPackages = allPackages;
        unselectedPackages.removeAll(selectedPackages);
        subMonitor.checkCanceled();
        HashSet<IPackageFragment> completelySelectedPackages = new HashSet<IPackageFragment>(selectedPackages);
        HashSet<IPackageFragment> visited = new HashSet<IPackageFragment>(numberOfPackages);
        LinkedList<IPackageFragment> queue = new LinkedList<IPackageFragment>(unselectedPackages);
        while (!queue.isEmpty()) {
            IPackageFragment parentPackage;
            subMonitor.checkCanceled();
            IPackageFragment unselectedOrPartiallySelectedFragment = (IPackageFragment)queue.removeLast();
            completelySelectedPackages.remove(unselectedOrPartiallySelectedFragment);
            boolean notVisited = visited.add(unselectedOrPartiallySelectedFragment);
            if (!notVisited || (parentPackage = JavaElementUtil.getParentSubpackage(unselectedOrPartiallySelectedFragment)) == null) continue;
            queue.add(parentPackage);
        }
        return completelySelectedPackages;
    }

    private static Set<IPackageFragment> allPackages(IPackageFragmentRoot root) throws JavaModelException {
        return Arrays.stream(root.getChildren()).map(x -> (IPackageFragment)x).collect(Collectors.toSet());
    }

    @Override
    public boolean test(IPackageFragment packageFragment) {
        return this.completelySelectedPackages.contains(packageFragment);
    }
}

