/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.common.internal.modulecore;

import org.eclipse.emf.common.util.URI;
import org.eclipse.jst.common.internal.modulecore.ClasspathContainerVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.ComponentcorePackage;
import org.eclipse.wst.common.componentcore.internal.DependencyType;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resolvers.IReferenceResolver;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

public class ClasspathContainerReferenceResolver
implements IReferenceResolver {
    public static final String PROTOCOL = "module:/classpath/con/";

    public boolean canResolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        URI uri = referencedComponent.getHandle();
        return uri.segmentCount() > 2 && uri.segment(0).equals("classpath") && uri.segment(1).equals("con");
    }

    public IVirtualReference resolve(IVirtualComponent context, ReferencedComponent referencedComponent) {
        URI uri = referencedComponent.getHandle();
        if (uri.segmentCount() > 2 && uri.segment(0).equals("classpath") && uri.segment(1).equals("con")) {
            String path = uri.toString().substring(PROTOCOL.length());
            VirtualReference ref = new VirtualReference(context, (IVirtualComponent)new ClasspathContainerVirtualComponent(context.getProject(), context, path));
            ref.setArchiveName(referencedComponent.getArchiveName());
            ref.setRuntimePath(referencedComponent.getRuntimePath());
            ref.setDependencyType(referencedComponent.getDependencyType().getValue());
            return ref;
        }
        return null;
    }

    public boolean canResolve(IVirtualReference reference) {
        return reference.getReferencedComponent() instanceof ClasspathContainerVirtualComponent;
    }

    public ReferencedComponent resolve(IVirtualReference reference) {
        ClasspathContainerVirtualComponent vc = (ClasspathContainerVirtualComponent)reference.getReferencedComponent();
        ReferencedComponent rc = ComponentcorePackage.eINSTANCE.getComponentcoreFactory().createReferencedComponent();
        rc.setArchiveName(reference.getArchiveName());
        rc.setRuntimePath(reference.getRuntimePath());
        rc.setHandle(URI.createURI((String)(PROTOCOL + vc.getClasspathContainerPath())));
        rc.setDependencyType(DependencyType.CONSUMES_LITERAL);
        return rc;
    }
}

