/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.emf.util.ui.provider;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class EmfModelContentProvider
implements ITreeContentProvider {
    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof Node) {
            return ((Node)parentElement).getChildren();
        }
        return new Object[0];
    }

    public Object getParent(Object element) {
        if (element instanceof Node) {
            return ((Node)element).getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof Node) {
            return ((Node)element).hasChildren();
        }
        return true;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public static EObjectNode makeEObjectNode(EObject obj, Object root) {
        EObject container = obj.eContainer();
        if (container == null) {
            return new EObjectNode(obj, root);
        }
        return new EObjectNode(obj, EmfModelContentProvider.makeEReferenceNode(container, (EReference)obj.eContainingFeature(), root));
    }

    public static Node makeEReferenceNode(EObject container, EReference ref, Object root) {
        return new EReferenceNode(ref, EmfModelContentProvider.makeEObjectNode(container, root));
    }

    public static class EObjectNode
    extends Node
    implements IUriNode {
        public final EObject myObj;

        public EObjectNode(EObject obj, Object parent) {
            super(parent);
            this.myObj = obj;
        }

        @Override
        public URI getUri() {
            return EcoreUtil.getURI((EObject)this.myObj);
        }

        @Override
        public Object getData() {
            return this.getObject();
        }

        public EObject getObject() {
            return this.myObj;
        }

        @Override
        public Object[] getChildren() {
            ArrayList<EReferenceNode> children = new ArrayList<EReferenceNode>();
            for (EReference ref : this.myObj.eClass().getEAllContainments()) {
                EReferenceNode node;
                if (ref.isDerived() || !(node = new EReferenceNode(ref, this)).hasChildren()) continue;
                children.add(node);
            }
            return children.toArray();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof EObjectNode)) {
                return false;
            }
            EObjectNode node = (EObjectNode)obj;
            return this.getUri() == null ? node.getUri() == null : this.getUri().equals(node.getUri());
        }

        @Override
        public int hashCode() {
            return this.getUri() == null ? 0 : this.getUri().hashCode();
        }
    }

    public static class EReferenceNode
    extends Node {
        private final EReference myRef;

        public EReferenceNode(EReference ref, EObjectNode parent) {
            super(parent);
            this.myRef = ref;
        }

        @Override
        public Object getData() {
            return this.myRef;
        }

        @Override
        public Object[] getChildren() {
            EObjectNode parent = (EObjectNode)this.getParent();
            EObject obj = parent.getObject();
            Object value = obj.eGet((EStructuralFeature)this.myRef);
            ArrayList<EObjectNode> children = new ArrayList<EObjectNode>();
            if (value instanceof List) {
                for (EObject child : (List)value) {
                    children.add(new EObjectNode(child, this));
                }
            } else if (value instanceof EObject) {
                children.add(new EObjectNode((EObject)value, this));
            }
            return children.toArray();
        }
    }

    public static interface IUriNode {
        public URI getUri();
    }

    public static abstract class Node {
        private final Object myParent;

        public Node(Object parent) {
            this.myParent = parent;
        }

        public Object getParent() {
            return this.myParent;
        }

        public boolean hasChildren() {
            return this.getChildren().length > 0;
        }

        public abstract Object getData();

        public abstract Object[] getChildren();

        public boolean equals(Object obj) {
            if (!(obj instanceof Node)) {
                return false;
            }
            Node node = (Node)obj;
            boolean eq = this.getData() == null ? node.getData() == null : this.getData().equals(node.getData());
            return eq;
        }

        public int hashCode() {
            return this.getData() == null ? 0 : this.getData().hashCode();
        }
    }

    public static class ResourceNode
    extends Node
    implements IUriNode {
        private final Resource myResource;

        public ResourceNode(Resource resource) {
            super(null);
            this.myResource = resource;
        }

        @Override
        public URI getUri() {
            return this.myResource.getURI();
        }

        @Override
        public Object getData() {
            return this.getResource();
        }

        public Resource getResource() {
            return this.myResource;
        }

        @Override
        public Object[] getChildren() {
            ArrayList<EObjectNode> children = new ArrayList<EObjectNode>();
            for (EObject child : this.myResource.getContents()) {
                children.add(new EObjectNode(child, this));
            }
            return children.toArray();
        }

        @Override
        public boolean equals(Object obj) {
            if (!(obj instanceof ResourceNode)) {
                return false;
            }
            ResourceNode other = (ResourceNode)obj;
            boolean eq = this.myResource.getURI() == null ? other.myResource.getURI() == null : this.myResource.getURI().equals(other.myResource.getURI());
            return eq;
        }

        @Override
        public int hashCode() {
            return this.myResource == null ? 0 : this.myResource.hashCode();
        }
    }
}

