/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.evaluator;

import org.eclipse.m2m.qvt.oml.ExecutionStackTraceElement;

public final class QVTStackTraceElement
implements ExecutionStackTraceElement {
    private String fModuleName;
    private String fOperationName;
    private String fUnitName;
    private int fLineNum;

    public QVTStackTraceElement(String moduleName, String operationName, String unitQName, int lineNumber) {
        if (moduleName == null) {
            throw new NullPointerException("Module name is null");
        }
        if (operationName == null) {
            throw new NullPointerException("operation name is null");
        }
        this.fModuleName = moduleName;
        this.fOperationName = operationName;
        this.fUnitName = unitQName;
        this.fLineNum = lineNumber > 0 ? lineNumber : -1;
    }

    @Override
    public String getUnitName() {
        return this.fUnitName;
    }

    @Override
    public int getLineNumber() {
        return this.fLineNum;
    }

    @Override
    public String getModuleName() {
        return this.fModuleName;
    }

    @Override
    public String getOperationName() {
        return this.fOperationName;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getModuleName()).append("::").append(this.getOperationName());
        if (this.fUnitName != null) {
            buf.append('(').append(this.fUnitName).append(':');
            if (this.fLineNum > 0) {
                buf.append(this.fLineNum);
            } else {
                buf.append("<Unknown>");
            }
            buf.append(')');
        } else {
            buf.append("(Unknown Source)");
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof QVTStackTraceElement)) {
            return false;
        }
        QVTStackTraceElement e = (QVTStackTraceElement)obj;
        return e.fModuleName.equals(this.fModuleName) && e.fLineNum == this.fLineNum && QVTStackTraceElement.eq(this.fOperationName, e.fOperationName) && QVTStackTraceElement.eq(this.fUnitName, e.fUnitName);
    }

    public int hashCode() {
        int result = 31 * this.fModuleName.hashCode() + this.fOperationName.hashCode();
        result = 31 * result + (this.fUnitName == null ? 0 : this.fUnitName.hashCode());
        result = 31 * result + this.fLineNum;
        return result;
    }

    private static boolean eq(Object a, Object b) {
        return a == b || a != null && a.equals(b);
    }
}

