/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.snapshot;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.HistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.util.IProgressListener;

public class ClassHistogramRecord
extends HistogramRecord {
    private static final long serialVersionUID = 1L;
    private int classId;
    private int[] objectIds;

    ClassHistogramRecord() {
    }

    public ClassHistogramRecord(String label, int classId, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        super(label, numberOfObjects, usedHeapSize, retainedHeapSize);
        this.classId = classId;
        this.objectIds = new int[0];
    }

    public ClassHistogramRecord(String label, int classId, int[] objectIds, long usedHeapSize, long retainedHeapSize) {
        super(label, objectIds.length, usedHeapSize, retainedHeapSize);
        this.classId = classId;
        this.objectIds = objectIds;
    }

    public int getClassId() {
        return this.classId;
    }

    public int[] getObjectIds() {
        return this.objectIds;
    }

    public long calculateRetainedSize(ISnapshot snapshot, boolean calculateIfNotAvailable, boolean approximation, IProgressListener listener) throws SnapshotException {
        if (this.retainedHeapSize > 0L || !calculateIfNotAvailable) {
            return this.retainedHeapSize;
        }
        if (this.retainedHeapSize < 0L && approximation) {
            return this.retainedHeapSize;
        }
        if (approximation) {
            this.retainedHeapSize = snapshot.getMinRetainedSize(this.objectIds, listener);
            this.retainedHeapSize = -this.retainedHeapSize;
        } else {
            this.retainedHeapSize = snapshot.getHeapSize(snapshot.getRetainedSet(this.objectIds, listener));
        }
        return this.retainedHeapSize;
    }

    public String toString() {
        StringBuilder summary = new StringBuilder();
        summary.append("Class Histogram ");
        summary.append(this.label);
        summary.append(" [");
        summary.append(this.classId);
        summary.append("] with ");
        summary.append(this.numberOfObjects);
        summary.append(" objects, ");
        summary.append(this.usedHeapSize);
        summary.append(" used heap bytes.");
        return summary.toString();
    }
}

