/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.factory;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.OM;
import org.eclipse.net4j.internal.util.factory.AnnotationFactoryDescriptor;
import org.eclipse.net4j.internal.util.factory.ConstantFactory;
import org.eclipse.net4j.internal.util.factory.FactoryDescriptor;
import org.eclipse.net4j.internal.util.factory.MarkupNames;
import org.eclipse.net4j.internal.util.factory.SimpleFactory;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.factory.IFactory;
import org.eclipse.net4j.util.factory.IFactoryKey;
import org.eclipse.net4j.util.factory.IFactoryKeyAware;
import org.eclipse.net4j.util.registry.HashMapRegistry;

public class PluginFactoryRegistry
extends HashMapRegistry<IFactoryKey, IFactory>
implements MarkupNames {
    public static final String NAMESPACE = "org.eclipse.net4j.util";
    public static final String EXT_POINT = "factories";
    private final IManagedContainer container;
    private Object extensionRegistryListener;

    public PluginFactoryRegistry(IManagedContainer container) {
        this.container = container;
    }

    @Override
    public IFactory get(Object key) {
        IFactoryDescriptor descriptor;
        IFactory factory = (IFactory)super.get(key);
        if (factory instanceof IFactoryDescriptor && (factory = (descriptor = (IFactoryDescriptor)factory).createFactory()) != null && factory != descriptor) {
            if (factory instanceof IFactoryKeyAware) {
                IFactoryKeyAware keyAware = (IFactoryKeyAware)((Object)factory);
                keyAware.setFactoryKey(descriptor.getKey());
            }
            if (factory instanceof IManagedContainer.ContainerAware) {
                IManagedContainer.ContainerAware containerAware = (IManagedContainer.ContainerAware)((Object)factory);
                containerAware.setManagedContainer(this.container);
            }
            this.put(factory.getKey(), factory);
        }
        return factory;
    }

    public void registerFactory(IFactory factory) {
        this.put(factory.getKey(), factory);
    }

    @Override
    protected void doActivate() throws Exception {
        super.doActivate();
        try {
            this.doActivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
    }

    @Override
    protected void doDeactivate() throws Exception {
        try {
            this.doDeactivateOSGi();
        }
        catch (Throwable t) {
            OM.LOG.warn(t);
        }
        this.clear();
        super.doDeactivate();
    }

    protected final IManagedContainer getManagedContainer() {
        return this.container;
    }

    private void doActivateOSGi() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(NAMESPACE, EXT_POINT);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            String name = element.getName();
            try {
                if ("simpleFactory".equals(name)) {
                    this.registerFactory(new SimpleFactory(element));
                } else if ("constantFactory".equals(name)) {
                    this.registerFactory(new ConstantFactory(element));
                } else if ("annotationFactory".equals(name)) {
                    this.registerFactory(new AnnotationFactoryDescriptor(element));
                } else if ("factory".equals(name)) {
                    this.registerFactory(new FactoryDescriptor(element));
                } else if (EXT_POINT.equals(name)) {
                    IConfigurationElement[] iConfigurationElementArray2 = element.getChildren();
                    int n3 = iConfigurationElementArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IConfigurationElement child = iConfigurationElementArray2[n4];
                        this.registerFactory(new FactoryDescriptor(child));
                        ++n4;
                    }
                }
            }
            catch (Throwable t) {
                OM.LOG.warn(t);
            }
            ++n2;
        }
        IRegistryChangeListener listener = new IRegistryChangeListener(){

            public void registryChanged(IRegistryChangeEvent event) {
                IExtensionDelta[] deltas;
                IExtensionDelta[] iExtensionDeltaArray = deltas = event.getExtensionDeltas(PluginFactoryRegistry.NAMESPACE, PluginFactoryRegistry.EXT_POINT);
                int n = deltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IExtensionDelta delta = iExtensionDeltaArray[n2];
                    OM.LOG.warn("ExtensionDelta not handled: " + delta);
                    ++n2;
                }
            }
        };
        extensionRegistry.addRegistryChangeListener(listener, NAMESPACE);
        this.extensionRegistryListener = listener;
    }

    private void doDeactivateOSGi() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        if (extensionRegistry == null) {
            return;
        }
        extensionRegistry.removeRegistryChangeListener((IRegistryChangeListener)this.extensionRegistryListener);
    }

    public static interface IFactoryDescriptor
    extends IFactory {
        public IFactory createFactory();

        @Override
        default public Object create(String description) {
            throw new UnsupportedOperationException();
        }

        @Override
        default public String getDescriptionFor(Object product) {
            throw new UnsupportedOperationException();
        }
    }
}

