/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.editor.welcome.internationalization.modelelements;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.editor.welcome.internationalization.Activator;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForResourceSet;
import org.eclipse.papyrus.infra.internationalization.commands.InternationalizationPreferenceCommandFactory;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.infra.internationalization.modelresource.InternationalizationPreferenceModel;
import org.eclipse.papyrus.infra.internationalization.utils.InternationalizationPreferenceModelUtils;
import org.eclipse.papyrus.infra.ui.editor.IMultiDiagramEditor;

public class PrivateInternationalizationPreferenceObservableValue
extends AbstractObservableValue<Boolean>
implements PropertyChangeListener {
    private InternationalizationPreferenceModel internationalizationPrefModel;
    protected final EditingDomain domain;

    public PrivateInternationalizationPreferenceObservableValue(EditingDomain domain) {
        this(Realm.getDefault(), domain);
    }

    public PrivateInternationalizationPreferenceObservableValue(Realm realm, EditingDomain domain) {
        super(realm);
        this.domain = domain;
        this.internationalizationPrefModel = InternationalizationPreferenceModelUtils.getInternationalizationPreferenceModel((ModelSet)((ModelSet)domain.getResourceSet()));
        if (this.internationalizationPrefModel != null) {
            this.internationalizationPrefModel.addPropertyChangeListener("legacyMode", (PropertyChangeListener)this);
        }
    }

    public synchronized void dispose() {
        if (this.internationalizationPrefModel != null) {
            this.internationalizationPrefModel.removePropertyChangeListener("legacyMode", (PropertyChangeListener)this);
            this.internationalizationPrefModel = null;
        }
        super.dispose();
    }

    protected Boolean doGetValue() {
        if (!InternationalizationPreferencesUtils.isInternationalizationNeedToBeLoaded()) {
            return false;
        }
        return this.internationalizationPrefModel.isLegacyMode();
    }

    protected Command getToggleCommand(InternationalizationPreferenceCommandFactory factory) {
        return factory.createTogglePrivateStorageCommand();
    }

    public Object getValueType() {
        return Boolean.class;
    }

    protected void doSetValue(Boolean value) {
        Boolean oldValue = (Boolean)this.getValue();
        if (!Objects.equals(oldValue, value)) {
            try {
                IMultiDiagramEditor editor = (IMultiDiagramEditor)ServiceUtilsForResourceSet.getInstance().getService(IMultiDiagramEditor.class, (Object)this.domain.getResourceSet());
                ModelSet modelSet = (ModelSet)((EditingDomain)editor.getAdapter(EditingDomain.class)).getResourceSet();
                Command command = this.getToggleCommand(new InternationalizationPreferenceCommandFactory(modelSet));
                if (command.canExecute()) {
                    try {
                        this.domain.getCommandStack().execute(command);
                        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
                    }
                    catch (Exception e) {
                        Activator.log.error("Failed to toggle editor page layout option", (Throwable)e);
                    }
                }
            }
            catch (ServiceException e) {
                throw new IllegalStateException("No editor available in the service registry", e);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        block7: {
            if (evt.getSource() != this.internationalizationPrefModel) break block7;
            switch (evt.getPropertyName()) {
                case "legacyMode": {
                    this.fireValueChange(Diffs.createValueDiff((Object)((Boolean)evt.getOldValue() == false ? 1 : 0), (Object)((Boolean)evt.getNewValue() == false ? 1 : 0)));
                }
            }
        }
    }
}

