/*****************************************************************************
 * Copyright (c) 2025 CEA LIST and others.
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *  Vincent Lorenzo (CEA LIST) vincent.lorenzo@cea.fr - Initial API and implementation
 *
 *****************************************************************************/

package org.eclipse.papyrus.infra.widgets.editors.richtext;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.nebula.widgets.richtext.RichTextEditorConfiguration;
import org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton;
import org.eclipse.swt.browser.BrowserFunction;

/**
 * Default Papyrus configuration for Richtext
 * This class replaces {@link GenericToolbarConfiguration}
 */
public class GenericRichTextEditorConfiguration extends RichTextEditorConfiguration {

	/**
	 * the button to initialize when the editor will be created
	 */
	private List<AbstractToolbarButton> buttons = new ArrayList<>();

	/**
	 * Constructor.
	 *
	 */
	public GenericRichTextEditorConfiguration() {
		removeDefaultToolbarButton();

		// we add default button
		registerDefaultButton();
	}

	protected void removeDefaultToolbarButton() {
		removeDefaultToolbarButton(RichTextUtils.ITEM_FLASH);
		removeDefaultToolbarButton(RichTextUtils.ITEM_TABLE);
		removeDefaultToolbarButton(RichTextUtils.ITEM_HORIZONTALRULE);
		removeDefaultToolbarButton(RichTextUtils.ITEM_SMILEY);
		removeDefaultToolbarButton(RichTextUtils.ITEM_SPECIALCHAR);
		removeDefaultToolbarButton(RichTextUtils.ITEM_PAGEBREAK);
		removeDefaultToolbarButton(RichTextUtils.ITEM_IFRAME);
	}

	/**
	 * this method allows to register default Papyrus button
	 */
	protected void registerDefaultButton() {
		addSpellCheckToolbarButton();
	}

	/**
	 * create and add the spell check button
	 */
	protected void addSpellCheckToolbarButton() {
		SpellCheckToolbarButton action = new SpellCheckToolbarButton();
		addToolbarButton(action);
	}

	/**
	 * @see org.eclipse.nebula.widgets.richtext.toolbar.ToolbarConfiguration#addToolbarButton(org.eclipse.nebula.widgets.richtext.toolbar.ToolbarButton, org.eclipse.swt.browser.BrowserFunction)
	 *
	 * @param button
	 * @param function
	 */
	@Override
	public void addToolbarButton(ToolbarButton button, BrowserFunction function) {
		if (button instanceof AbstractToolbarButton) {
			this.buttons.add((AbstractToolbarButton) button);
		}
		super.addToolbarButton(button, function);
	}


	/**
	 *
	 * @param editor
	 *            the instantiated generic richtext editor
	 */
	public void setRichTextEditor(GenericRichTextEditor editor) {
		for (AbstractToolbarButton current : this.buttons) {
			current.setRichTextEditor(editor);
		}
	}



}
