/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.uml.decoratormodel.internal.resource.DecoratorModelIndex;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.Activator;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.messages.Messages;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.providers.ProfileResourceLabelProvider;
import org.eclipse.papyrus.uml.decoratormodel.internal.ui.wizards.AbstractNewDecoratorModelPage;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.ProfileApplication;
import org.eclipse.uml2.uml.UMLPackage;

public class DuplicateDecoratorModelPage
extends AbstractNewDecoratorModelPage<Object, URI> {
    private final ResourceSet resourceSet;

    public DuplicateDecoratorModelPage(ResourceSet resourceSet) {
        super("duplicate", Messages.DuplicateDecoratorModelPage_0, null, URI.class);
        this.resourceSet = resourceSet;
        this.setMessage(Messages.DuplicateDecoratorModelPage_1);
    }

    @Override
    protected void checkInitialSelections(CheckboxTableViewer table, Collection<URI> initialSelections) {
        table.setAllChecked(true);
    }

    @Override
    protected void browseResource() {
        this.browseResource(Messages.DuplicateDecoratorModelPage_2, Messages.DuplicateDecoratorModelPage_3);
    }

    @Override
    protected IBaseLabelProvider createProfilesLabelProvider() {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new ProfileResourceLabelProvider(this.resourceSet));
    }

    @Override
    protected IStructuredContentProvider createProfilesContentProvider() {
        return new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                LinkedHashSet result;
                block7: {
                    block6: {
                        result = Sets.newLinkedHashSet();
                        if (!(inputElement instanceof Resource)) break block6;
                        Resource decoratorModelResource = (Resource)inputElement;
                        TreeIterator iter = EcoreUtil.getAllContents((Collection)DuplicateDecoratorModelPage.this.getRoot(decoratorModelResource).getNestedPackages());
                        while (iter.hasNext()) {
                            EObject next = (EObject)iter.next();
                            if (next instanceof ProfileApplication) {
                                EObject profile = (EObject)next.eGet((EStructuralFeature)UMLPackage.Literals.PROFILE_APPLICATION__APPLIED_PROFILE, false);
                                if (profile != null) {
                                    result.add(EcoreUtil.getURI((EObject)profile).trimFragment());
                                }
                                iter.prune();
                                continue;
                            }
                            if (next instanceof Package) continue;
                            iter.prune();
                        }
                        break block7;
                    }
                    if (!(inputElement instanceof URI)) break block7;
                    URI decoratorModelURI = (URI)inputElement;
                    try {
                        for (URI next : DecoratorModelIndex.getInstance().getAppliedProfilesByPackage(decoratorModelURI).values()) {
                            result.add(next.trimFragment());
                        }
                    }
                    catch (CoreException e) {
                        StatusManager.getManager().handle(e.getStatus(), 3);
                    }
                }
                return result.toArray();
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        };
    }

    Package getRoot(Resource resource) {
        return (Package)Iterables.getFirst((Iterable)Iterables.filter((Iterable)resource.getContents(), Package.class), null);
    }

    @Override
    protected String validateExistingFile(IFile file) {
        return NLS.bind((String)Messages.DuplicateDecoratorModelPage_4, (Object)file.getFullPath());
    }

    @Override
    protected String defaultModelName(Object input) {
        String result = null;
        if (input instanceof Resource) {
            Resource resource = (Resource)input;
            result = NLS.bind((String)Messages.DuplicateDecoratorModelPage_5, (Object)this.getRoot(resource).getName());
        } else {
            try {
                result = NLS.bind((String)Messages.DuplicateDecoratorModelPage_5, (Object)DecoratorModelIndex.getInstance().getDecoratorModelName((URI)input));
            }
            catch (CoreException e) {
                Activator.getDefault().getLog().log(e.getStatus());
                result = Messages.DuplicateDecoratorModelPage_7;
            }
        }
        return result;
    }

    @Override
    protected String defaultResource(Object input) {
        URI result;
        if (input instanceof Resource) {
            Resource resource = (Resource)input;
            result = resource.getURI();
        } else {
            result = (URI)input;
        }
        String baseName = result.lastSegment();
        String ext = "";
        int dot = baseName.indexOf(46);
        if (dot >= 0) {
            ext = baseName.substring(dot);
            baseName = baseName.substring(0, dot);
        }
        result = result.trimSegments(1).appendSegment(NLS.bind((String)Messages.DuplicateDecoratorModelPage_6, (Object)baseName, (Object)ext));
        return result.toPlatformString(true);
    }
}

