/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.internal.helpers;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.uml2.uml.DurationConstraint;
import org.eclipse.uml2.uml.DurationObservation;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.TimeConstraint;
import org.eclipse.uml2.uml.TimeObservation;
import org.eclipse.uml2.uml.UMLPackage;

public class UMLTemporalHelper {
    private static final UMLPackage UML = UMLPackage.eINSTANCE;

    public static List<DurationConstraint> getDurationConstraints(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.durationConstraint.getRelatedElements(element, crossRef);
    }

    public static List<TimeConstraint> getTimeConstraints(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.timeConstraint.getRelatedElements(element, crossRef);
    }

    public static List<DurationObservation> getDurationObservations(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.durationObservation.getRelatedElements(element, crossRef);
    }

    public static List<TimeObservation> getTimeObservations(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.timeObservation.getRelatedElements(element, crossRef);
    }

    public static List<PackageableElement> getTemporalElements(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.all.getRelatedElements(element, crossRef);
    }

    public static List<PackageableElement> getTimeElements(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.timeElement.getRelatedElements(element, crossRef);
    }

    public static List<PackageableElement> getDurationElements(NamedElement element, ECrossReferenceAdapter crossRef) {
        return TemporalRelation.durationElement.getRelatedElements(element, crossRef);
    }

    private static enum TemporalRelation {
        timeObservation(TimeObservation.class, UML.getTimeObservation_Event()),
        durationObservation(DurationObservation.class, UML.getDurationObservation_Event()),
        timeConstraint(TimeConstraint.class, UML.getConstraint_ConstrainedElement()),
        durationConstraint(DurationConstraint.class, UML.getConstraint_ConstrainedElement()),
        timeElement(List.of(TimeConstraint.class, TimeObservation.class), UML.getConstraint_ConstrainedElement(), UML.getTimeObservation_Event()),
        durationElement(List.of(DurationConstraint.class, DurationObservation.class), UML.getConstraint_ConstrainedElement(), UML.getTimeObservation_Event()),
        all(List.of(TimeConstraint.class, DurationConstraint.class, TimeObservation.class, DurationObservation.class), UML.getConstraint_ConstrainedElement(), UML.getDurationObservation_Event(), UML.getTimeObservation_Event());

        private Predicate<EObject> typeFilter;
        private final Predicate<EStructuralFeature.Setting> referencefilter;

        private TemporalRelation(Class<? extends PackageableElement> type, EReference reference) {
            this(Collections.singletonList(type), reference);
        }

        private TemporalRelation(List<? extends Class<? extends PackageableElement>> subTypes, EReference ... references) {
            List<EReference> refs = Arrays.asList(references);
            this.referencefilter = setting -> refs.contains(setting.getEStructuralFeature());
            this.typeFilter = value -> {
                for (Class subType : subTypes) {
                    if (!subType.isInstance(value)) continue;
                    return true;
                }
                return false;
            };
        }

        private <R extends PackageableElement> List<R> getRelatedElements(NamedElement element, ECrossReferenceAdapter crossRef) {
            return crossRef.getInverseReferences((EObject)element, false).stream().filter(this.referencefilter).map(EStructuralFeature.Setting::getEObject).filter(this.typeFilter).collect(Collectors.toList());
        }
    }
}

