/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.profile;

import java.util.Optional;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.papyrus.uml.domain.services.profile.ProfileVersion;

public class ProfileDefinition {
    public static final ProfileDefinition UNDEFINED_ANNOTATION = new ProfileDefinition(ProfileVersion.EMPTY_VERSION, "<undefined>", "", "", "<undefined>");
    private ProfileVersion version = ProfileVersion.EMPTY_VERSION;
    private String comment = "";
    private String copyright = "";
    private String date = "";
    private String author = "";

    public ProfileDefinition(ProfileVersion version, String comment, String copyright, String date, String author) {
        this.version = version;
        this.comment = comment;
        this.copyright = copyright;
        this.author = author;
        this.date = date;
    }

    public EAnnotation convertToEAnnotation() {
        EAnnotation annotation = EcoreFactory.eINSTANCE.createEAnnotation();
        annotation.setSource("PapyrusVersion");
        annotation.getDetails().put((Object)"Version", (Object)this.version.toString());
        annotation.getDetails().put((Object)"Comment", (Object)this.comment);
        annotation.getDetails().put((Object)"Copyright", (Object)this.copyright);
        annotation.getDetails().put((Object)"Date", (Object)this.date);
        annotation.getDetails().put((Object)"Author", (Object)this.author);
        return annotation;
    }

    public static ProfileDefinition parseEAnnotation(EAnnotation annotation) {
        ProfileVersion version;
        String versionValue = (String)annotation.getDetails().get((Object)"Version");
        try {
            version = ProfileVersion.parseVersion(versionValue);
        }
        catch (IllegalArgumentException e) {
            version = ProfileVersion.EMPTY_VERSION;
        }
        String comment = Optional.of((String)annotation.getDetails().get((Object)"Comment")).orElse("");
        String copyright = Optional.of((String)annotation.getDetails().get((Object)"Copyright")).orElse("");
        String date = Optional.of((String)annotation.getDetails().get((Object)"Date")).orElse("");
        String author = Optional.of((String)annotation.getDetails().get((Object)"Author")).orElse("");
        return new ProfileDefinition(version, comment, copyright, date, author);
    }

    public ProfileVersion getVersion() {
        return this.version;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCopyright() {
        return this.copyright;
    }

    public String getDate() {
        return this.date;
    }

    public String getAuthor() {
        return this.author;
    }
}

