/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.http.servlet.internal.servlet;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import jakarta.servlet.http.HttpSessionEvent;
import jakarta.servlet.http.HttpSessionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.List;
import org.eclipse.rap.http.servlet.internal.context.ContextController;

public class HttpSessionAdaptor
implements HttpSession,
Serializable {
    private static final long serialVersionUID = 3418610936889860782L;
    private final transient ContextController controller;
    private final transient HttpSession session;
    private final transient ServletContext servletContext;
    private final transient String attributePrefix;
    private String string;
    private static final String SIMPLE_NAME = HttpSessionAdaptor.class.getSimpleName();

    public static HttpSessionAdaptor createHttpSessionAdaptor(HttpSession session, ServletContext servletContext, ContextController controller) {
        return new HttpSessionAdaptor(session, servletContext, controller);
    }

    private HttpSessionAdaptor(HttpSession session, ServletContext servletContext, ContextController controller) {
        this.session = session;
        this.servletContext = servletContext;
        this.controller = controller;
        this.attributePrefix = "equinox.http." + controller.getContextName();
    }

    public ContextController getController() {
        return this.controller;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public Object getAttribute(String arg0) {
        return this.session.getAttribute(this.attributePrefix.concat(arg0));
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeNames0());
    }

    private Collection<String> getAttributeNames0() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration containerSessionAttributes = this.session.getAttributeNames();
        while (containerSessionAttributes.hasMoreElements()) {
            String attribute = (String)containerSessionAttributes.nextElement();
            if (!attribute.startsWith(this.attributePrefix)) continue;
            result.add(attribute.substring(this.attributePrefix.length()));
        }
        return result;
    }

    public Object getValue(String arg0) {
        return this.getAttribute(arg0);
    }

    public String[] getValueNames() {
        Collection<String> result = this.getAttributeNames0();
        return result.toArray(new String[0]);
    }

    public void invalidate() {
        HttpSessionEvent httpSessionEvent = new HttpSessionEvent((HttpSession)this);
        for (HttpSessionListener listener : this.controller.getEventListeners().get(HttpSessionListener.class)) {
            try {
                listener.sessionDestroyed(httpSessionEvent);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        try {
            for (String attribute : this.getAttributeNames0()) {
                this.removeAttribute(attribute);
            }
        }
        catch (IllegalStateException illegalStateException) {}
        this.controller.removeActiveSession(this.session);
    }

    public void invokeSessionListeners(List<Class<? extends EventListener>> classes, EventListener listener) {
        if (classes == null) {
            return;
        }
        for (Class<? extends EventListener> clazz : classes) {
            if (clazz.equals(HttpSessionListener.class)) {
                HttpSessionEvent sessionEvent = new HttpSessionEvent((HttpSession)this);
                HttpSessionListener httpSessionListener = (HttpSessionListener)listener;
                httpSessionListener.sessionDestroyed(sessionEvent);
            }
            if (!clazz.equals(HttpSessionBindingListener.class) && !clazz.equals(HttpSessionAttributeListener.class)) continue;
            Enumeration<String> attributeNames = this.getAttributeNames();
            while (attributeNames.hasMoreElements()) {
                String attributeName = attributeNames.nextElement();
                HttpSessionBindingEvent sessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, attributeName);
                if (clazz.equals(HttpSessionBindingListener.class)) {
                    HttpSessionBindingListener httpSessionBindingListener = (HttpSessionBindingListener)listener;
                    httpSessionBindingListener.valueUnbound(sessionBindingEvent);
                }
                if (!clazz.equals(HttpSessionAttributeListener.class)) continue;
                HttpSessionAttributeListener httpSessionAttributeListener = (HttpSessionAttributeListener)listener;
                httpSessionAttributeListener.attributeRemoved(sessionBindingEvent);
            }
        }
    }

    public void putValue(String arg0, Object arg1) {
        this.setAttribute(arg0, arg1);
    }

    public void removeAttribute(String arg0) {
        String newName = this.attributePrefix.concat(arg0);
        Object value = this.session.getAttribute(newName);
        this.session.removeAttribute(newName);
        if (value == null) {
            return;
        }
        List<HttpSessionAttributeListener> listeners = this.controller.getEventListeners().get(HttpSessionAttributeListener.class);
        if (listeners.isEmpty()) {
            return;
        }
        HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, newName);
        for (HttpSessionAttributeListener listener : listeners) {
            listener.attributeRemoved(httpSessionBindingEvent);
        }
    }

    public void removeValue(String arg0) {
        this.removeAttribute(arg0);
    }

    public void setAttribute(String name, Object value) {
        String newName = this.attributePrefix.concat(name);
        if (value == null) {
            this.session.setAttribute(newName, null);
            return;
        }
        boolean added = this.session.getAttribute(newName) == null;
        this.session.setAttribute(newName, value);
        List<HttpSessionAttributeListener> listeners = this.controller.getEventListeners().get(HttpSessionAttributeListener.class);
        if (!listeners.isEmpty()) {
            HttpSessionBindingEvent httpSessionBindingEvent = new HttpSessionBindingEvent((HttpSession)this, newName, value);
            for (HttpSessionAttributeListener listener : listeners) {
                if (added) {
                    listener.attributeAdded(httpSessionBindingEvent);
                    continue;
                }
                listener.attributeReplaced(httpSessionBindingEvent);
            }
        }
    }

    public void setMaxInactiveInterval(int arg0) {
        this.session.setMaxInactiveInterval(arg0);
    }

    public long getCreationTime() {
        return this.session.getCreationTime();
    }

    public String getId() {
        return this.session.getId();
    }

    public long getLastAccessedTime() {
        return this.session.getLastAccessedTime();
    }

    public int getMaxInactiveInterval() {
        return this.session.getMaxInactiveInterval();
    }

    public boolean isNew() {
        return this.session.isNew();
    }

    public String toString() {
        String value = this.string;
        if (value == null) {
            this.string = value = String.valueOf(SIMPLE_NAME) + '[' + this.session.getId() + ", " + this.attributePrefix + ']';
        }
        return value;
    }
}

