/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.migrator.metadata;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.viatra.query.tooling.ui.migrator.MigratorConstants;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.xbase.lib.Pair;

public class NatureUpdaterJob
extends Job {
    private final IProject project;
    private final EclipseOutputConfigurationProvider outputConfigurationProvider;

    public NatureUpdaterJob(IProject project, EclipseOutputConfigurationProvider outputConfigurationProvider) {
        super(String.format("Updating project %s", project.getName()));
        this.project = project;
        this.outputConfigurationProvider = outputConfigurationProvider;
    }

    private void repairErroneousBuilderEntry(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (MigratorConstants.isIncorrectBuilderID(commands[i].getBuilderName())) {
                commands[i].setBuilderName("org.eclipse.viatra.query.tooling.ui.projectbuilder");
            }
            ++i;
        }
        desc.setBuildSpec(commands);
        project.setDescription(desc, null);
    }

    private void reorderBuilderEntries(IProject project) throws CoreException {
        IProjectDescription desc = project.getDescription();
        ICommand[] commands = desc.getBuildSpec();
        int xtextIndex = -1;
        ICommand xtextCommand = null;
        int iqIndex = -1;
        ICommand iqCommand = null;
        int commandListSize = commands.length;
        int i = 0;
        while (i < commandListSize) {
            String id = commands[i].getBuilderName();
            if ("org.eclipse.viatra.query.tooling.ui.projectbuilder".equals(id)) {
                iqIndex = i;
                iqCommand = commands[i];
            } else if ("org.eclipse.xtext.ui.shared.xtextBuilder".equals(id)) {
                xtextIndex = i;
                xtextCommand = commands[i];
            }
            ++i;
        }
        if (iqIndex < 0) {
            ++commandListSize;
            iqCommand = desc.newCommand();
            iqCommand.setBuilderName("org.eclipse.viatra.query.tooling.ui.projectbuilder");
        }
        if (xtextIndex < 0) {
            ++commandListSize;
            xtextCommand = desc.newCommand();
            xtextCommand.setBuilderName("org.eclipse.xtext.ui.shared.xtextBuilder");
        }
        ICommand[] newCommands = new ICommand[commandListSize];
        newCommands[0] = iqCommand;
        newCommands[1] = xtextCommand;
        int commandIndex = 2;
        int i2 = 0;
        while (i2 < commands.length) {
            if (i2 != xtextIndex && i2 != iqIndex) {
                newCommands[commandIndex] = commands[i2];
                ++commandIndex;
            }
            ++i2;
        }
        desc.setBuildSpec(newCommands);
        project.setDescription(desc, null);
    }

    private void renamePatternDefinitionFiles(IProject project) throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        project.accept(new IResourceVisitor((IProgressMonitor)monitor){
            private final /* synthetic */ IProgressMonitor val$monitor;
            {
                this.val$monitor = iProgressMonitor;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && "eiq".equals(resource.getFileExtension())) {
                    ((IFile)resource).move(resource.getFullPath().removeFileExtension().addFileExtension("vql"), false, this.val$monitor);
                } else if (resource instanceof IFile && "eiqgen".equals(resource.getFileExtension())) {
                    ((IFile)resource).move(resource.getFullPath().removeFileExtension().addFileExtension("vqgen"), false, this.val$monitor);
                }
                return true;
            }
        });
    }

    private void removeGlobalEiq(IProject project) throws CoreException {
        IResource globalEiqFile = project.findMember("queries/globalEiqModel.xmi");
        if (globalEiqFile != null) {
            NullProgressMonitor monitor = new NullProgressMonitor();
            IContainer parent = globalEiqFile.getParent();
            globalEiqFile.delete(true, (IProgressMonitor)monitor);
            if (parent.members().length == 0) {
                parent.delete(true, (IProgressMonitor)monitor);
            }
        }
    }

    public void removeExpressionExtensions(IProject project) throws CoreException {
        ArrayList removableExtensions = Lists.newArrayList();
        removableExtensions.add(new Pair((Object)"", (Object)"org.eclipse.incquery.runtime.queryspecification"));
        removableExtensions.add(new Pair((Object)"", (Object)"org.eclipse.incquery.runtime.xexpressionevaluator"));
        ProjectGenerationHelper.removeAllExtension((IProject)project, (Collection)removableExtensions);
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            this.project.refreshLocal(2, monitor);
            this.repairErroneousBuilderEntry(this.project);
            this.reorderBuilderEntries(this.project);
            ArrayList<String> newIDs = new ArrayList<String>();
            if (!this.project.hasNature("org.eclipse.viatra.query.projectnature")) {
                newIDs.add("org.eclipse.viatra.query.projectnature");
            }
            if (!this.project.hasNature("org.eclipse.xtext.ui.shared.xtextNature")) {
                newIDs.add("org.eclipse.xtext.ui.shared.xtextNature");
            }
            ArrayList<String> oldIDs = new ArrayList<String>();
            for (String ID : MigratorConstants.INCORRECT_NATURE_IDS) {
                if (!this.project.hasNature(ID)) continue;
                oldIDs.add(ID);
            }
            if (newIDs.size() + oldIDs.size() > 0) {
                ProjectGenerationHelper.updateNatures((IProject)this.project, newIDs, oldIDs, (IProgressMonitor)monitor);
            }
            this.removeGlobalEiq(this.project);
            this.renamePatternDefinitionFiles(this.project);
            if (ProjectGenerationHelper.isOpenPDEProject((IProject)this.project)) {
                ProjectGenerationHelper.ensureSourceFolder((IProject)this.project, (Collection)this.outputConfigurationProvider.getOutputConfigurations(), (IProgressMonitor)monitor);
                ProjectGenerationHelper.ensureSingletonDeclaration((IProject)this.project);
                this.removeExpressionExtensions(this.project);
                ProjectGenerationHelper.ensureBundleDependenciesAndPackageImports((IProject)this.project, (List)ProjectGenerationHelper.DEFAULT_VIATRA_BUNDLE_REQUIREMENTS, (List)ProjectGenerationHelper.DEFAULT_VIATRA_IMPORT_PACKAGES, (IProgressMonitor)monitor);
            }
            this.project.build(15, monitor);
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.viatra.query.patternlanguage.emf.ui", "Error updating project natures", (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

