/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.DeviceContext;
import org.eclipse.gmf.runtime.draw2d.ui.render.awt.internal.svg.metafile.NullStroke;

public class GdiPen {
    public static final int PS_SOLID = 0;
    public static final int PS_DASH = 1;
    public static final int PS_DOT = 2;
    public static final int PS_DASHDOT = 3;
    public static final int PS_DASHDOTDOT = 4;
    public static final int PS_NULL = 5;
    public static final int PS_INSIDEFRAME = 6;
    public static final int PS_USERSTYLE = 7;
    public static final int PS_ALTERNATE = 8;
    public static final int PS_STYLE_MASK = 15;
    public static final int PS_ENDCAP_ROUND = 0;
    public static final int PS_ENDCAP_SQUARE = 256;
    public static final int PS_ENDCAP_FLAT = 512;
    public static final int PS_ENDCAP_MASK = 3840;
    public static final int PS_JOIN_ROUND = 0;
    public static final int PS_JOIN_BEVEL = 4096;
    public static final int PS_JOIN_MITER = 8192;
    public static final int PS_JOIN_MASK = 61440;
    private int m_style = 0;
    private int m_width = 1;
    private Color m_color = new Color(0);
    private static final float[] DASH = new float[]{5.0f, 3.0f};
    private static final float[] DOT = new float[]{1.0f, 3.0f};
    private static final float[] DASH_DOT = new float[]{5.0f, 3.0f, 1.0f, 3.0f};
    private static final float[] DASH_DOT_DOT = new float[]{5.0f, 3.0f, 1.0f, 3.0f, 1.0f, 3.0f};

    public GdiPen() {
    }

    public GdiPen(int style, int width, Color color) {
        this.m_style = style;
        this.m_width = width;
        this.m_color = color;
    }

    GdiPen(GdiPen pen) {
        this.m_style = pen.m_style;
        this.m_width = pen.m_width;
        this.m_color = new Color(pen.m_color.getRGB());
    }

    public void apply(Graphics2D g, DeviceContext context) {
        g.setColor(this.m_color);
        int width = context.scaleX(this.m_width);
        if (width <= 0) {
            width = 1;
        }
        boolean bNullStroke = false;
        float[] dotPattern = null;
        switch (this.m_style & 0xF) {
            case 5: {
                bNullStroke = true;
                break;
            }
            default: {
                break;
            }
            case 1: {
                dotPattern = DASH;
                break;
            }
            case 2: {
                dotPattern = DOT;
                break;
            }
            case 3: {
                dotPattern = DASH_DOT;
                break;
            }
            case 4: {
                dotPattern = DASH_DOT_DOT;
            }
        }
        int endcap = switch (this.m_style & 0xF00) {
            default -> 1;
            case 256 -> 2;
            case 512 -> 0;
        };
        int miter = switch (this.m_style & 0xF000) {
            case 0 -> 1;
            case 4096 -> 2;
            default -> 0;
        };
        if (!bNullStroke) {
            BasicStroke stroke = dotPattern != null ? new BasicStroke(width, endcap, miter, context.getMiterLimit(), dotPattern, 0.0f) : new BasicStroke(width, endcap, miter, context.getMiterLimit());
            g.setStroke(stroke);
        } else {
            g.setStroke(new NullStroke());
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Pen: width=" + this.m_width);
        sb.append(", color=" + this.m_color.toString());
        sb.append(", style: ");
        switch (this.m_style & 0xF) {
            case 5: {
                sb.append("nullStroke");
                break;
            }
            default: {
                sb.append("solid");
                break;
            }
            case 1: {
                sb.append("dash");
                break;
            }
            case 2: {
                sb.append("dot");
                break;
            }
            case 3: {
                sb.append("dashDot");
                break;
            }
            case 4: {
                sb.append("dashDotDot");
            }
        }
        switch (this.m_style & 0xF00) {
            default: {
                sb.append(" roundCap");
                break;
            }
            case 256: {
                sb.append(" squareCap");
                break;
            }
            case 512: {
                sb.append(" buttCap");
            }
        }
        switch (this.m_style & 0xF000) {
            case 0: {
                sb.append(" roundJoin");
                break;
            }
            case 4096: {
                sb.append(" bevelJoin");
                break;
            }
            default: {
                sb.append(" miterJoin");
            }
        }
        return sb.toString();
    }
}

