/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gcov.parser;

import java.io.Serializable;
import java.util.ArrayList;
import org.eclipse.linuxtools.internal.gcov.parser.Arc;

public class Block
implements Serializable {
    private static final long serialVersionUID = -7665287885679756014L;
    private final ArrayList<Arc> entryArcs = new ArrayList();
    private ArrayList<Arc> exitArcs = new ArrayList();
    private final long flag;
    private long numSuccs = 0L;
    private long numPreds = 0L;
    private long count = 0L;
    private boolean isCallSite = false;
    private boolean isCallReturn = false;
    private boolean isNonLocalReturn = false;
    private boolean validChain = false;
    private boolean invalidChain = false;
    private boolean countValid = false;
    private final BlkLine blkline = new BlkLine();

    public Block(long flag) {
        this.flag = flag;
    }

    public long getFlag() {
        return this.flag;
    }

    public ArrayList<Arc> getEntryArcs() {
        return this.entryArcs;
    }

    public ArrayList<Arc> getExitArcs() {
        return this.exitArcs;
    }

    public void setExitArcs(ArrayList<Arc> exitArcs) {
        this.exitArcs = exitArcs;
    }

    public boolean isCallSite() {
        return this.isCallSite;
    }

    public boolean isCallReturn() {
        return this.isCallReturn;
    }

    public boolean isNonLocalReturn() {
        return this.isNonLocalReturn;
    }

    public void addEntryArcs(Arc arcEntry) {
        this.entryArcs.add(arcEntry);
    }

    public void addExitArcs(Arc arcExit) {
        this.exitArcs.add(arcExit);
    }

    public void setCallSite(boolean isCallSite) {
        this.isCallSite = isCallSite;
    }

    public void setCallReturn(boolean isCallReturn) {
        this.isCallReturn = isCallReturn;
    }

    public void setNonLocalReturn(boolean isNonLocalReturn) {
        this.isNonLocalReturn = isNonLocalReturn;
    }

    public void decNumSuccs() {
        --this.numSuccs;
    }

    public void decNumPreds() {
        --this.numPreds;
    }

    public void incNumPreds() {
        ++this.numPreds;
    }

    public void incNumSuccs() {
        ++this.numSuccs;
    }

    public boolean isValidChain() {
        return this.validChain;
    }

    public void setValidChain(boolean validChain) {
        this.validChain = validChain;
    }

    public boolean isInvalidChain() {
        return this.invalidChain;
    }

    public void setInvalidChain(boolean invalidChain) {
        this.invalidChain = invalidChain;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public void setCountValid(boolean countValid) {
        this.countValid = countValid;
    }

    public boolean isCountValid() {
        return this.countValid;
    }

    public long getNumSuccs() {
        return this.numSuccs;
    }

    public long getNumPreds() {
        return this.numPreds;
    }

    public void setNumSuccs(long numSuccs) {
        this.numSuccs = numSuccs;
    }

    public void setNumPreds(long numPreds) {
        this.numPreds = numPreds;
    }

    public long[] getEncoding() {
        return this.blkline.encoding;
    }

    public void setEncoding(long[] lineNos) {
        this.blkline.encoding = lineNos;
    }

    public int getLineNum() {
        return this.blkline.num;
    }

    public void setNumLine(int numline) {
        this.blkline.num = numline;
    }

    static class BlkLine
    implements Serializable {
        private static final long serialVersionUID = 2757557929188979686L;
        public long[] encoding;
        public int num;

        BlkLine() {
        }
    }
}

