/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.resolution;

import aQute.bnd.osgi.resource.ResourceUtils;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.pde.bnd.ui.model.resolution.RequirementWrapper;
import org.eclipse.pde.bnd.ui.model.resource.R5LabelFormatter;
import org.osgi.framework.Version;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;

public class CapReqComparator
implements Comparator<Object> {
    @Override
    public int compare(Object o1, Object o2) {
        if (o1 instanceof Requirement) {
            return this.compareReqToObj((Requirement)o1, o2);
        }
        if (o1 instanceof RequirementWrapper) {
            return this.compareReqToObj(((RequirementWrapper)o1).requirement, o2);
        }
        if (o1 instanceof Capability) {
            return this.compareCapToObj((Capability)o1, o2);
        }
        return 0;
    }

    private int compareReqToObj(Requirement r1, Object o2) {
        if (o2 instanceof Requirement) {
            return this.compareReqToReq(r1, (Requirement)o2);
        }
        if (o2 instanceof RequirementWrapper) {
            return this.compareReqToReq(r1, ((RequirementWrapper)o2).requirement);
        }
        return -1;
    }

    private int compareCapToObj(Capability c1, Object o2) {
        if (o2 instanceof Capability) {
            return this.compareCapToCap(c1, (Capability)o2);
        }
        return 1;
    }

    private int compareCapToCap(Capability c1, Capability c2) {
        int attribDiff;
        String ns2;
        String ns1 = c1.getNamespace();
        int nsDiff = ns1.compareTo(ns2 = c2.getNamespace());
        if (nsDiff != 0) {
            return nsDiff;
        }
        String attribName = R5LabelFormatter.getMainAttributeName(ns1);
        Object attrib1 = c1.getAttributes().get(attribName);
        Object attrib2 = c2.getAttributes().get(attribName);
        if (attrib1 != null && attrib2 != null && (attribDiff = attrib1.toString().compareTo(attrib2.toString())) != 0) {
            return attribDiff;
        }
        String versionAttribName = R5LabelFormatter.getVersionAttributeName(ns1);
        if (versionAttribName == null) {
            return 0;
        }
        Version v1 = CapReqComparator.highestVersion(c1.getAttributes().get(versionAttribName));
        Version v2 = CapReqComparator.highestVersion(c2.getAttributes().get(versionAttribName));
        return v1.compareTo(v2);
    }

    private static Version highestVersion(Object attr) {
        if (attr instanceof Version) {
            Version v = (Version)attr;
            return v;
        }
        if (attr instanceof Collection) {
            Collection col = (Collection)attr;
            return col.stream().filter(Version.class::isInstance).map(Version.class::cast).max(Version::compareTo).orElse(Version.emptyVersion);
        }
        return Version.emptyVersion;
    }

    private int compareReqToReq(Requirement r1, Requirement r2) {
        return ResourceUtils.REQUIREMENT_COMPARATOR.compare(r1, r2);
    }
}

