/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.launching;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.StateObjectFactory;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.ISharedPluginModel;
import org.eclipse.pde.internal.core.NLResourceHelper;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.osgi.framework.BundleException;

class ExtraBundleModel
extends AbstractPluginModelBase {
    private static final long serialVersionUID = 1L;
    private final Path path;

    public ExtraBundleModel(Path path, Map<String, String> manifest) throws BundleException {
        this.path = path;
        BundleDescription bundleDescription = StateObjectFactory.defaultFactory.createBundleDescription(null, ExtraBundleModel.manifestToProperties(manifest), path.toString(), 0L);
        this.setBundleDescription(bundleDescription);
    }

    private static Dictionary<String, String> manifestToProperties(Map<String, String> d) {
        Hashtable<String, String> result = new Hashtable<String, String>();
        for (String key : d.keySet()) {
            ((Dictionary)result).put(key, d.get(key));
        }
        return result;
    }

    public BundleDescription getBundleDescription() {
        return super.getBundleDescription();
    }

    public void load() throws CoreException {
    }

    public boolean isEditable() {
        return false;
    }

    public String getInstallLocation() {
        return this.path.toString();
    }

    public IPluginBase createPluginBase() {
        PluginBase pluginBase = new PluginBase(true){
            private static final long serialVersionUID = 1L;

            public void write(String indent, PrintWriter writer) {
            }

            public String getId() {
                return ExtraBundleModel.this.getBundleDescription().getSymbolicName();
            }

            public String getVersion() {
                return ExtraBundleModel.this.getBundleDescription().getVersion().toString();
            }
        };
        pluginBase.setModel((ISharedPluginModel)this);
        return pluginBase;
    }

    protected NLResourceHelper createNLResourceHelper() {
        return null;
    }
}

