/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ptp.rdt.sync.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IResource;

public abstract class AbstractSyncFileFilter {
    protected final List<AbstractIgnoreRule> rules = new ArrayList<AbstractIgnoreRule>();

    public List<AbstractIgnoreRule> getRules() {
        return this.rules;
    }

    public void addPattern(String pattern, boolean exclude) {
        this.addPattern(pattern, exclude, this.rules.size());
    }

    public void addPattern(IResource resource, boolean exclude) {
        this.addPattern(resource, exclude, this.rules.size());
    }

    public abstract void addPattern(String var1, boolean var2, int var3);

    public abstract void addPattern(IResource var1, boolean var2, int var3);

    public boolean demote(AbstractIgnoreRule pattern) {
        int oldIndex = this.rules.indexOf(pattern);
        if (oldIndex > -1 && oldIndex < this.rules.size() - 1) {
            Collections.swap(this.rules, oldIndex, oldIndex + 1);
            return true;
        }
        return false;
    }

    public List<AbstractIgnoreRule> getPatterns() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean promote(AbstractIgnoreRule pattern) {
        int oldIndex = this.rules.indexOf(pattern);
        if (oldIndex > 0) {
            Collections.swap(this.rules, oldIndex, oldIndex - 1);
            return true;
        }
        return false;
    }

    public void removePattern(AbstractIgnoreRule pattern) {
        this.rules.remove(pattern);
    }

    public boolean replacePattern(AbstractIgnoreRule oldRule, String newPattern, boolean exclude) {
        int index = this.rules.indexOf(oldRule);
        if (index == -1) {
            return false;
        }
        this.rules.remove(index);
        this.addPattern(newPattern, exclude, index);
        return true;
    }

    public boolean shouldIgnore(IResource r) {
        int i = this.rules.size() - 1;
        while (i > -1) {
            if (this.rules.get(i).isMatch(r)) {
                return this.rules.get(i).getResult();
            }
            --i;
        }
        return false;
    }

    public boolean shouldIgnore(String path, boolean isFolder) {
        int i = this.rules.size() - 1;
        while (i > -1) {
            if (this.rules.get(i).isMatch(path, isFolder)) {
                return this.rules.get(i).getResult();
            }
            --i;
        }
        return false;
    }

    public abstract void saveFilter() throws IOException;

    public abstract AbstractSyncFileFilter clone();

    public abstract class AbstractIgnoreRule {
        public abstract boolean isMatch(IResource var1);

        public abstract boolean isMatch(String var1, boolean var2);

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o != null && o.getClass() == this.getClass() && this.toString().equals(o.toString());
        }

        public abstract boolean getResult();

        public abstract String toString();

        public abstract String getPattern();
    }
}

