/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.sequence.ui.tool.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.sirius.diagram.sequence.business.api.util.Range;
import org.eclipse.sirius.diagram.sequence.business.internal.RangeHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.AbstractNodeEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.CombinedFragment;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Execution;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.ISequenceEvent;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Lifeline;
import org.eclipse.sirius.diagram.sequence.business.internal.elements.Message;
import org.eclipse.sirius.diagram.sequence.business.internal.ordering.EventEndHelper;
import org.eclipse.sirius.diagram.sequence.business.internal.query.ISequenceEventQuery;
import org.eclipse.sirius.diagram.sequence.business.internal.util.EventFinder;
import org.eclipse.sirius.diagram.sequence.ui.tool.internal.util.RequestQuery;
import org.eclipse.sirius.ext.base.Option;

public class FinalParentHelper {
    private final AbstractNodeEvent self;
    private final RequestQuery request;
    private Range expansionZone;
    private ISequenceEvent globalFinalParent;

    public FinalParentHelper(AbstractNodeEvent host, RequestQuery resizeRequest) {
        this.self = Objects.requireNonNull(host);
        this.request = Objects.requireNonNull(resizeRequest);
        Preconditions.checkArgument((boolean)resizeRequest.isResize());
    }

    public void computeFinalParent() {
        Range fullFinalRange = this.getFullFinalRange();
        if (fullFinalRange != null && this.request.isResize()) {
            this.globalFinalParent = this.getFinalParentOnResize(fullFinalRange);
        }
    }

    public ISequenceEvent getFinalParent() {
        return this.globalFinalParent;
    }

    public Range getRequiredExpansion() {
        return this.expansionZone;
    }

    private Range getFullFinalRange() {
        Rectangle newBounds = this.request.getLogicalTransformedRectangle(this.self.getProperLogicalBounds());
        if (newBounds.width < 0 || newBounds.height < 0) {
            return null;
        }
        Range fullFinalRange = RangeHelper.verticalRange((Rectangle)newBounds);
        if (this.self instanceof Execution) {
            Option endMessage;
            Execution execution = (Execution)this.self;
            Option startMessage = execution.getStartMessage();
            if (startMessage.some() && !((Message)startMessage.get()).surroundsEventOnSameLifeline() && !((Message)startMessage.get()).isOblique()) {
                int startY = fullFinalRange.getLowerBound() - ((Message)startMessage.get()).getVerticalRange().width();
                fullFinalRange = new Range(startY, fullFinalRange.getUpperBound());
            }
            if ((endMessage = execution.getEndMessage()).some() && !((Message)endMessage.get()).surroundsEventOnSameLifeline() && !((Message)endMessage.get()).isOblique()) {
                int finishY = fullFinalRange.getUpperBound() + ((Message)endMessage.get()).getVerticalRange().width();
                fullFinalRange = new Range(fullFinalRange.getLowerBound(), finishY);
            }
        }
        return fullFinalRange;
    }

    private ISequenceEvent getFinalParentOnResize(final Range fullFinalRange) {
        Preconditions.checkArgument((boolean)this.request.isResize());
        HashSet<ISequenceEvent> remoteErrors = new HashSet<ISequenceEvent>();
        ISequenceEvent finalParent = this.self.getParentEvent();
        ArrayList<ISequenceEvent> linkedSiblings = FinalParentHelper.computeLinkedSiblings(this.request);
        Iterable finalSiblings = EventEndHelper.getIndependantEvents((ISequenceEvent)this.self, (Collection)finalParent.getSubEvents());
        Option selfLifeline = this.self.getLifeline();
        SameLifelinePredicate sameLifeline = new SameLifelinePredicate((Option<Lifeline>)selfLifeline);
        IntersectsFinalBoundsPredicate intersectsFinalBounds = new IntersectsFinalBoundsPredicate(remoteErrors, fullFinalRange, linkedSiblings);
        Predicate<ISequenceEvent> notParentCombinedFragment = new Predicate<ISequenceEvent>(){

            public boolean apply(ISequenceEvent input) {
                if (input instanceof CombinedFragment && FinalParentHelper.this.self.getLifeline().some()) {
                    CombinedFragment combinedFragment = (CombinedFragment)input;
                    return !combinedFragment.computeCoveredLifelines().contains(FinalParentHelper.this.self.getLifeline().get()) || !combinedFragment.getVerticalRange().includes(fullFinalRange);
                }
                return true;
            }
        };
        Iterable invalids = Iterables.filter((Iterable)finalSiblings, (Predicate)Predicates.and((Predicate[])new Predicate[]{sameLifeline, notParentCombinedFragment, intersectsFinalBounds}));
        if (!Iterables.isEmpty((Iterable)invalids)) {
            finalParent = null;
            for (ISequenceEvent ise : Iterables.concat((Iterable)invalids, remoteErrors)) {
                Range verticalRange = ise.getVerticalRange();
                if (ise instanceof Message && ((Message)ise).isReflective() && verticalRange.includes(this.self.getVerticalRange())) {
                    verticalRange = new Range(verticalRange.getUpperBound(), verticalRange.getUpperBound());
                }
                if (!this.request.isResizeFromBottom()) continue;
                Range errorRange = new Range(verticalRange.getLowerBound() - 1, Math.max(verticalRange.getLowerBound(), fullFinalRange.getUpperBound()));
                Range range = this.expansionZone = this.expansionZone == null ? errorRange : errorRange.union(this.expansionZone);
            }
        }
        return finalParent;
    }

    public static ArrayList<ISequenceEvent> computeLinkedSiblings(RequestQuery request) {
        ArrayList<ISequenceEvent> linkedSiblings = new ArrayList<ISequenceEvent>();
        Set<Execution> parts = request.getExecutions();
        for (Execution execution : parts) {
            linkedSiblings.add((ISequenceEvent)execution);
            linkedSiblings.addAll(execution.findLinkedExecutions(true));
            linkedSiblings.addAll(new ISequenceEventQuery((ISequenceEvent)execution).getAllDescendants());
        }
        return linkedSiblings;
    }

    public static ISequenceEvent getFinalRemoteParent(AbstractNodeEvent self, Message smep, int deltaY, int deltaHeight) {
        Option remoteLifeline;
        Range finalMessageRange = smep.getVerticalRange().shifted(deltaY);
        if (deltaHeight != 0) {
            finalMessageRange = new Range(finalMessageRange.getLowerBound(), finalMessageRange.getUpperBound() + deltaHeight);
        }
        Set allMovedElements = new ISequenceEventQuery((ISequenceEvent)self).getAllDescendants();
        allMovedElements.add(self);
        ISequenceEvent sourceParent = smep.getSourceElement() instanceof ISequenceEvent ? (ISequenceEvent)smep.getSourceElement() : null;
        ISequenceEvent targetParent = smep.getTargetElement() instanceof ISequenceEvent ? (ISequenceEvent)smep.getTargetElement() : null;
        ISequenceEvent remoteParent = allMovedElements.contains(sourceParent) ? targetParent : sourceParent;
        ISequenceEvent finalRemoteParent = null;
        if (remoteParent != null && (remoteLifeline = remoteParent.getLifeline()).some()) {
            EventFinder remoteFinder = new EventFinder((Lifeline)remoteLifeline.get());
            remoteFinder.setEventsToIgnore(Predicates.in((Collection)Lists.newArrayList((Iterable)allMovedElements)));
            finalRemoteParent = remoteFinder.findMostSpecificEvent(finalMessageRange);
        }
        return finalRemoteParent;
    }

    private final class IntersectsFinalBoundsPredicate
    implements Predicate<ISequenceEvent> {
        private final Collection<ISequenceEvent> remoteErrors;
        private final Range fullFinalRange;
        private final Collection<ISequenceEvent> linkedSiblings;

        private IntersectsFinalBoundsPredicate(Collection<ISequenceEvent> remoteErrors, Range fullFinalRange, Collection<ISequenceEvent> linkedSiblings) {
            this.remoteErrors = remoteErrors;
            this.fullFinalRange = fullFinalRange;
            this.linkedSiblings = linkedSiblings;
        }

        public boolean apply(ISequenceEvent input) {
            boolean includedInput;
            Range inputRange = input.getVerticalRange();
            boolean intersection = inputRange.intersects(this.fullFinalRange) && !this.linkedSiblings.contains(input);
            boolean bl = includedInput = !FinalParentHelper.this.self.getValidSubEventsRange().isEmpty() && this.fullFinalRange.includes(inputRange.grown(1));
            if (input instanceof Message) {
                Execution remoteExec;
                Iterable compoundEvents;
                Message msg = (Message)input;
                if (msg.isOblique()) {
                    boolean bl2 = includedInput = !FinalParentHelper.this.self.getValidSubEventsRange().isEmpty() && this.fullFinalRange.includesAtLeastOneBound(inputRange.grown(1));
                }
                if (msg.isReflective() && !includedInput) {
                    intersection = inputRange.intersects(this.fullFinalRange) && !inputRange.includes(this.fullFinalRange);
                    includedInput = inputRange.includes(this.fullFinalRange);
                }
                if (intersection && msg.isCompoundMessage() && !Iterables.isEmpty((Iterable)(compoundEvents = Iterables.filter((Iterable)EventEndHelper.getCompoundEvents((ISequenceEvent)input), Execution.class))) && (remoteExec = (Execution)compoundEvents.iterator().next()) != null && remoteExec.getEndMessage().some() && !this.fullFinalRange.includes(remoteExec.getExtendedVerticalRange())) {
                    includedInput = false;
                    this.remoteErrors.add((ISequenceEvent)remoteExec);
                }
            }
            return intersection && !includedInput;
        }
    }

    private final class SameLifelinePredicate
    implements Predicate<ISequenceEvent> {
        private final Option<Lifeline> selfLifeline;

        private SameLifelinePredicate(Option<Lifeline> selfLifeline) {
            this.selfLifeline = selfLifeline;
        }

        public boolean apply(ISequenceEvent input) {
            boolean same;
            Option inputLifeline = input.getLifeline();
            boolean bl = same = !inputLifeline.some() || this.selfLifeline.some() && inputLifeline.get() == this.selfLifeline.get();
            if (input instanceof Message) {
                Option sourceLifeline = ((Message)input).getSourceLifeline();
                same = same || !sourceLifeline.some() || this.selfLifeline.some() && sourceLifeline.get() == this.selfLifeline.get();
                Option tgtLifeline = ((Message)input).getTargetLifeline();
                same = same || !tgtLifeline.some() || this.selfLifeline.some() && tgtLifeline.get() == this.selfLifeline.get();
            }
            return same;
        }
    }
}

