/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.provider.remoteservice.generic;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.core.sharedobject.SharedObjectMsg;
import org.eclipse.ecf.core.util.reflection.ClassUtil;
import org.eclipse.ecf.provider.remoteservice.generic.RegistrySharedObject;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteCallImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceReferenceImpl;
import org.eclipse.ecf.provider.remoteservice.generic.RemoteServiceRegistryImpl;
import org.eclipse.ecf.remoteservice.IRemoteServiceID;
import org.eclipse.ecf.remoteservice.IRemoteServiceReference;
import org.eclipse.ecf.remoteservice.IRemoteServiceRegistration;

public class RemoteServiceRegistrationImpl
implements IRemoteServiceRegistration,
Serializable {
    private static final long serialVersionUID = -3206899332723536545L;
    transient Object service;
    protected String[] clazzes;
    protected Properties properties;
    protected int serviceranking;
    protected transient Object registrationLock = new Object();
    protected int state = 0;
    public static final int REGISTERED = 0;
    public static final int UNREGISTERING = 1;
    public static final int UNREGISTERED = 2;
    protected transient RemoteServiceReferenceImpl reference = null;
    protected transient RegistrySharedObject sharedObject = null;
    protected IRemoteServiceID remoteServiceID;
    private transient ClassLoader classLoader = RemoteServiceRegistrationImpl.class.getClassLoader();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (!o.getClass().equals(this.getClass())) {
            return false;
        }
        return this.getID().equals((Object)((RemoteServiceRegistrationImpl)o).getID());
    }

    public int hashCode() {
        return this.getID().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(RegistrySharedObject sharedObject1, RemoteServiceRegistryImpl registry, Object svc, String[] clzzes, Dictionary props) {
        this.sharedObject = sharedObject1;
        this.service = svc;
        this.clazzes = clzzes;
        this.reference = new RemoteServiceReferenceImpl(this);
        this.setClassLoader(svc.getClass().getClassLoader());
        RemoteServiceRegistryImpl remoteServiceRegistryImpl = registry;
        synchronized (remoteServiceRegistryImpl) {
            ID containerID = registry.getContainerID();
            if (containerID == null) {
                throw new NullPointerException("Local containerID must be non-null to register remote services");
            }
            this.remoteServiceID = registry.createRemoteServiceID(registry.getNextServiceId());
            this.properties = this.createProperties(props);
            registry.publishService(this);
        }
    }

    public Object getService() {
        return this.service;
    }

    public ID getContainerID() {
        return this.remoteServiceID == null ? null : this.remoteServiceID.getContainerID();
    }

    protected String[] getClasses() {
        return this.clazzes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRemoteServiceReference getReference() {
        if (this.reference == null) {
            RemoteServiceRegistrationImpl remoteServiceRegistrationImpl = this;
            synchronized (remoteServiceRegistrationImpl) {
                this.reference = new RemoteServiceReferenceImpl(this);
            }
        }
        return this.reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProperties(Dictionary properties) {
        Object object = this.registrationLock;
        synchronized (object) {
            if (this.state != 0) {
                throw new IllegalStateException("Service already registered");
            }
            this.properties = this.createProperties(properties);
        }
    }

    public void unregister() {
        if (this.sharedObject != null) {
            this.sharedObject.sendUnregister(this);
        }
        this.classLoader = null;
    }

    protected Properties createProperties(Dictionary props) {
        Properties resultProps = new Properties(props);
        resultProps.setProperty("ecf.robjectClass", this.clazzes);
        resultProps.setProperty("ecf.rsvc.id", new Long(this.getID().getContainerRelativeID()));
        Object ranking = props == null ? null : props.get("ecf.rsvc.ranking");
        this.serviceranking = ranking instanceof Integer ? (Integer)ranking : 0;
        return resultProps;
    }

    public Object getProperty(String key) {
        return this.properties.getProperty(key);
    }

    public String[] getPropertyKeys() {
        return this.properties.getPropertyKeys();
    }

    public long getServiceId() {
        IRemoteServiceID rsID = this.getID();
        if (rsID == null) {
            return 0L;
        }
        return rsID.getContainerRelativeID();
    }

    public Object callService(RemoteCallImpl call) throws Exception {
        Object[] args = call.getParameters() == null ? SharedObjectMsg.nullArgs : call.getParameters();
        final Method method = ClassUtil.getMethod(this.service.getClass(), (String)call.getMethod(), (Class[])SharedObjectMsg.getTypesForParameters((Object[])args));
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                if (!method.isAccessible()) {
                    method.setAccessible(true);
                }
                return null;
            }
        });
        return method.invoke(this.service, args);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("RemoteServiceRegistrationImpl[");
        buf.append("remoteServiceID=").append(this.getID()).append(";");
        buf.append("rserviceranking=").append(this.serviceranking).append(";");
        buf.append("classes=").append(Arrays.asList(this.clazzes)).append(";");
        buf.append("state=").append(this.state).append(";");
        buf.append("properties=").append(this.properties).append("]");
        return buf.toString();
    }

    public IRemoteServiceID getID() {
        return this.remoteServiceID;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    void setClassLoader(ClassLoader cl) {
        this.classLoader = cl;
    }

    static class Properties
    extends Dictionary
    implements Serializable {
        private static final long serialVersionUID = -3684607010228779249L;
        Map storedProps;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Properties(int size, Dictionary props) {
            this.storedProps = new HashMap(size);
            if (props != null) {
                Dictionary dictionary = props;
                synchronized (dictionary) {
                    Enumeration keysEnum = props.keys();
                    while (keysEnum.hasMoreElements()) {
                        Object key = keysEnum.nextElement();
                        if (!(key instanceof String)) continue;
                        String header = (String)key;
                        this.setProperty(header, props.get(header));
                    }
                }
            }
        }

        public Properties() {
            this(null);
        }

        protected Properties(Dictionary props) {
            this(props == null ? 2 : Math.max(2, props.size()), props);
        }

        protected Object getProperty(String key) {
            return this.storedProps.get(key);
        }

        protected synchronized String[] getPropertyKeys() {
            int size = this.storedProps.size();
            String[] keynames = new String[size];
            Iterator iter = this.storedProps.keySet().iterator();
            int i = 0;
            while (i < size) {
                keynames[i] = (String)iter.next();
                ++i;
            }
            return keynames;
        }

        protected synchronized Object setProperty(String key, Object value) {
            return this.storedProps.put(key, value);
        }

        protected static Object cloneValue(Object value) {
            block7: {
                if (value == null) {
                    return null;
                }
                if (value instanceof String) {
                    return value;
                }
                Class<?> clazz = value.getClass();
                if (clazz.isArray()) {
                    Class<?> type = clazz.getComponentType();
                    int len = Array.getLength(value);
                    Object clonedArray = Array.newInstance(type, len);
                    System.arraycopy(value, 0, clonedArray, 0, len);
                    return clonedArray;
                }
                try {
                    return clazz.getMethod("clone", null).invoke(value, null);
                }
                catch (Exception type) {
                }
                catch (Error e) {
                    if (value instanceof Vector) {
                        return ((Vector)value).clone();
                    }
                    if (!(value instanceof Hashtable)) break block7;
                    return ((Hashtable)value).clone();
                }
            }
            return value;
        }

        public synchronized String toString() {
            String[] keys = this.getPropertyKeys();
            int size = keys.length;
            StringBuffer sb = new StringBuffer(20 * size);
            sb.append('{');
            int n = 0;
            int i = 0;
            while (i < size) {
                String key = keys[i];
                if (!key.equals("ecf.robjectClass")) {
                    if (n > 0) {
                        sb.append(", ");
                    }
                    sb.append(key);
                    sb.append('=');
                    Object value = this.storedProps.get(key);
                    if (value.getClass().isArray()) {
                        sb.append('[');
                        int length = Array.getLength(value);
                        int j = 0;
                        while (j < length) {
                            if (j > 0) {
                                sb.append(',');
                            }
                            sb.append(Array.get(value, j));
                            ++j;
                        }
                        sb.append(']');
                    } else {
                        sb.append(value);
                    }
                    ++n;
                }
                ++i;
            }
            sb.append('}');
            return sb.toString();
        }

        @Override
        public int size() {
            return this.storedProps.size();
        }

        @Override
        public boolean isEmpty() {
            return this.storedProps.isEmpty();
        }

        public Enumeration keys() {
            final Iterator i = this.storedProps.keySet().iterator();
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return i.hasNext();
                }

                public Object nextElement() {
                    return i.next();
                }
            };
        }

        public Enumeration elements() {
            final Iterator i = this.storedProps.values().iterator();
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return i.hasNext();
                }

                public Object nextElement() {
                    return i.next();
                }
            };
        }

        public Object get(Object key) {
            return this.storedProps.get(key);
        }

        public Object put(Object key, Object value) {
            return this.storedProps.put(key, value);
        }

        public Object remove(Object key) {
            return this.storedProps.remove(key);
        }
    }
}

